/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.utils.internal.RandomUtils;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class RetryStrategies {
    private RetryStrategies() {
    }

    public static BiIntFunction<Throwable, Completable> retryWithConstantBackoffFullJitter(int maxRetries, Predicate<Throwable> causeFilter, Duration delay, Executor timerExecutor) {
        RetryStrategies.checkMaxRetries(maxRetries);
        Objects.requireNonNull(timerExecutor);
        Objects.requireNonNull(causeFilter);
        long jitterNanos = delay.toNanos();
        RetryStrategies.checkFullJitter(jitterNanos);
        return (retryCount, cause) -> retryCount <= maxRetries && causeFilter.test((Throwable)cause) ? timerExecutor.timer(RandomUtils.nextLongInclusive(0L, jitterNanos), TimeUnit.NANOSECONDS) : Completable.failed(cause);
    }

    public static BiIntFunction<Throwable, Completable> retryWithConstantBackoffFullJitter(Predicate<Throwable> causeFilter, Duration delay, Executor timerExecutor) {
        Objects.requireNonNull(timerExecutor);
        Objects.requireNonNull(causeFilter);
        long jitterNanos = delay.toNanos();
        RetryStrategies.checkFullJitter(jitterNanos);
        return (retryCount, cause) -> causeFilter.test((Throwable)cause) ? timerExecutor.timer(RandomUtils.nextLongInclusive(0L, jitterNanos), TimeUnit.NANOSECONDS) : Completable.failed(cause);
    }

    public static BiIntFunction<Throwable, Completable> retryWithConstantBackoffDeltaJitter(Predicate<Throwable> causeFilter, Duration delay, Duration jitter, Executor timerExecutor) {
        Objects.requireNonNull(timerExecutor);
        Objects.requireNonNull(causeFilter);
        long delayNanos = delay.toNanos();
        long jitterNanos = jitter.toNanos();
        RetryStrategies.checkJitterDelta(jitterNanos, delayNanos);
        long lowerBound = delayNanos - jitterNanos;
        long upperBound = FlowControlUtils.addWithOverflowProtection(delayNanos, jitterNanos);
        return (retryCount, cause) -> causeFilter.test((Throwable)cause) ? timerExecutor.timer(RandomUtils.nextLongInclusive(lowerBound, upperBound), TimeUnit.NANOSECONDS) : Completable.failed(cause);
    }

    public static BiIntFunction<Throwable, Completable> retryWithConstantBackoffDeltaJitter(int maxRetries, Predicate<Throwable> causeFilter, Duration delay, Duration jitter, Executor timerExecutor) {
        RetryStrategies.checkMaxRetries(maxRetries);
        Objects.requireNonNull(timerExecutor);
        Objects.requireNonNull(causeFilter);
        long delayNanos = delay.toNanos();
        long jitterNanos = jitter.toNanos();
        RetryStrategies.checkJitterDelta(jitterNanos, delayNanos);
        long lowerBound = delayNanos - jitterNanos;
        long upperBound = FlowControlUtils.addWithOverflowProtection(delayNanos, jitterNanos);
        return (retryCount, cause) -> retryCount <= maxRetries && causeFilter.test((Throwable)cause) ? timerExecutor.timer(RandomUtils.nextLongInclusive(lowerBound, upperBound), TimeUnit.NANOSECONDS) : Completable.failed(cause);
    }

    public static BiIntFunction<Throwable, Completable> retryWithExponentialBackoffFullJitter(Predicate<Throwable> causeFilter, Duration initialDelay, Duration maxDelay, Executor timerExecutor) {
        Objects.requireNonNull(timerExecutor);
        Objects.requireNonNull(causeFilter);
        long initialDelayNanos = initialDelay.toNanos();
        long maxDelayNanos = maxDelay.toNanos();
        long maxInitialShift = RetryStrategies.maxShift(initialDelayNanos);
        return (retryCount, cause) -> causeFilter.test((Throwable)cause) ? timerExecutor.timer(RandomUtils.nextLongInclusive(0L, RetryStrategies.baseDelayNanos(initialDelayNanos, maxDelayNanos, maxInitialShift, retryCount)), TimeUnit.NANOSECONDS) : Completable.failed(cause);
    }

    public static BiIntFunction<Throwable, Completable> retryWithExponentialBackoffFullJitter(int maxRetries, Predicate<Throwable> causeFilter, Duration initialDelay, Duration maxDelay, Executor timerExecutor) {
        RetryStrategies.checkMaxRetries(maxRetries);
        Objects.requireNonNull(timerExecutor);
        Objects.requireNonNull(causeFilter);
        long initialDelayNanos = initialDelay.toNanos();
        long maxDelayNanos = maxDelay.toNanos();
        long maxInitialShift = RetryStrategies.maxShift(initialDelayNanos);
        return (retryCount, cause) -> retryCount <= maxRetries && causeFilter.test((Throwable)cause) ? timerExecutor.timer(RandomUtils.nextLongInclusive(0L, RetryStrategies.baseDelayNanos(initialDelayNanos, maxDelayNanos, maxInitialShift, retryCount)), TimeUnit.NANOSECONDS) : Completable.failed(cause);
    }

    public static BiIntFunction<Throwable, Completable> retryWithExponentialBackoffDeltaJitter(Predicate<Throwable> causeFilter, Duration initialDelay, Duration jitter, Duration maxDelay, Executor timerExecutor) {
        Objects.requireNonNull(timerExecutor);
        Objects.requireNonNull(causeFilter);
        long initialDelayNanos = initialDelay.toNanos();
        long jitterNanos = jitter.toNanos();
        long maxDelayNanos = maxDelay.toNanos();
        long maxInitialShift = RetryStrategies.maxShift(initialDelayNanos);
        return (retryCount, cause) -> {
            if (!causeFilter.test((Throwable)cause)) {
                return Completable.failed(cause);
            }
            long baseDelayNanos = RetryStrategies.baseDelayNanos(initialDelayNanos, maxDelayNanos, maxInitialShift, retryCount);
            long lowerBound = Math.max(0L, baseDelayNanos - jitterNanos);
            long upperBound = Math.min(maxDelayNanos, FlowControlUtils.addWithOverflowProtection(baseDelayNanos, jitterNanos));
            return timerExecutor.timer(RandomUtils.nextLongInclusive(lowerBound, upperBound), TimeUnit.NANOSECONDS);
        };
    }

    public static BiIntFunction<Throwable, Completable> retryWithExponentialBackoffDeltaJitter(int maxRetries, Predicate<Throwable> causeFilter, Duration initialDelay, Duration jitter, Duration maxDelay, Executor timerExecutor) {
        RetryStrategies.checkMaxRetries(maxRetries);
        Objects.requireNonNull(timerExecutor);
        Objects.requireNonNull(causeFilter);
        long initialDelayNanos = initialDelay.toNanos();
        long jitterNanos = jitter.toNanos();
        long maxDelayNanos = maxDelay.toNanos();
        long maxInitialShift = RetryStrategies.maxShift(initialDelayNanos);
        return (retryCount, cause) -> {
            if (retryCount > maxRetries || !causeFilter.test((Throwable)cause)) {
                return Completable.failed(cause);
            }
            long baseDelayNanos = RetryStrategies.baseDelayNanos(initialDelayNanos, maxDelayNanos, maxInitialShift, retryCount);
            return timerExecutor.timer(RandomUtils.nextLongInclusive(Math.max(0L, baseDelayNanos - jitterNanos), Math.min(maxDelayNanos, FlowControlUtils.addWithOverflowProtection(baseDelayNanos, jitterNanos))), TimeUnit.NANOSECONDS);
        };
    }

    static long baseDelayNanos(long initialDelayNanos, long maxDelayNanos, long maxInitialShift, int count) {
        return Math.min(maxDelayNanos, initialDelayNanos << (int)Math.min(maxInitialShift, (long)(count - 1)));
    }

    static void checkMaxRetries(int maxRetries) {
        if (maxRetries <= 0) {
            throw new IllegalArgumentException("maxRetries: " + maxRetries + " (expected: >0)");
        }
    }

    static void checkJitterDelta(long jitterNanos, long delayNanos) {
        if (jitterNanos >= delayNanos || Long.MAX_VALUE - delayNanos < jitterNanos) {
            throw new IllegalArgumentException("jitter " + jitterNanos + "ns would result in [under|over]flow as a delta to delay " + delayNanos + "ns");
        }
    }

    static void checkFullJitter(long jitterNanos) {
        if (jitterNanos <= 0L) {
            throw new IllegalArgumentException("jitter " + jitterNanos + "ns must be >=0.");
        }
    }

    static long maxShift(long v) {
        return Long.numberOfLeadingZeros(v) - 1;
    }
}

