/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ReplayAccumulator;
import io.servicetalk.concurrent.api.ReplayStrategy;
import io.servicetalk.utils.internal.NumberUtils;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public final class ReplayStrategyBuilder<T> {
    private int minSubscribers = 1;
    private final Supplier<ReplayAccumulator<T>> accumulatorSupplier;
    private boolean cancelUpstream;
    private int queueLimitHint = 64;
    private Function<Throwable, Completable> terminalResubscribe = t -> Completable.never();

    public ReplayStrategyBuilder(Supplier<ReplayAccumulator<T>> accumulatorSupplier) {
        this.accumulatorSupplier = Objects.requireNonNull(accumulatorSupplier);
    }

    public ReplayStrategyBuilder<T> minSubscribers(int minSubscribers) {
        this.minSubscribers = NumberUtils.ensurePositive(minSubscribers, "minSubscribers");
        return this;
    }

    public ReplayStrategyBuilder<T> cancelUpstream(boolean cancelUpstream) {
        this.cancelUpstream = cancelUpstream;
        return this;
    }

    public ReplayStrategyBuilder<T> queueLimitHint(int queueLimitHint) {
        if (queueLimitHint < 1) {
            throw new IllegalArgumentException("maxQueueSize: " + queueLimitHint + " (expected >1)");
        }
        this.queueLimitHint = queueLimitHint;
        return this;
    }

    public ReplayStrategyBuilder<T> terminalResubscribe(Function<Throwable, Completable> terminalResubscribe) {
        this.terminalResubscribe = Objects.requireNonNull(terminalResubscribe);
        return this;
    }

    public ReplayStrategy<T> build() {
        return new DefaultReplayStrategy(this.minSubscribers, this.accumulatorSupplier, this.cancelUpstream, this.queueLimitHint, this.terminalResubscribe);
    }

    private static final class DefaultReplayStrategy<T>
    implements ReplayStrategy<T> {
        private final int minSubscribers;
        private final Supplier<ReplayAccumulator<T>> accumulatorSupplier;
        private final boolean cancelUpstream;
        private final int queueLimitHint;
        private final Function<Throwable, Completable> terminalResubscribe;

        private DefaultReplayStrategy(int minSubscribers, Supplier<ReplayAccumulator<T>> accumulatorSupplier, boolean cancelUpstream, int queueLimitHint, Function<Throwable, Completable> terminalResubscribe) {
            this.minSubscribers = minSubscribers;
            this.accumulatorSupplier = accumulatorSupplier;
            this.cancelUpstream = cancelUpstream;
            this.queueLimitHint = queueLimitHint;
            this.terminalResubscribe = terminalResubscribe;
        }

        @Override
        public int minSubscribers() {
            return this.minSubscribers;
        }

        @Override
        public Supplier<ReplayAccumulator<T>> accumulatorSupplier() {
            return this.accumulatorSupplier;
        }

        @Override
        public boolean cancelUpstream() {
            return this.cancelUpstream;
        }

        @Override
        public int queueLimitHint() {
            return this.queueLimitHint;
        }

        @Override
        public Function<Throwable, Completable> terminalResubscribe() {
            return this.terminalResubscribe;
        }
    }
}

