/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractAsynchronousPublisherOperator;
import io.servicetalk.concurrent.api.CompositeExceptionUtils;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.SequentialSubscription;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.internal.ConcurrentSubscription;
import io.servicetalk.concurrent.internal.EmptySubscriptions;
import io.servicetalk.concurrent.internal.TerminalNotification;
import io.servicetalk.utils.internal.NumberUtils;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PublisherSwitchMap<T, R>
extends AbstractAsynchronousPublisherOperator<T, R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublisherSwitchMap.class);
    private final int maxDelayedErrors;
    private final Function<? super T, ? extends Publisher<? extends R>> mapper;

    PublisherSwitchMap(Publisher<T> original, boolean delayError, Function<? super T, ? extends Publisher<? extends R>> mapper) {
        this(original, CompositeExceptionUtils.maxDelayedErrors(delayError), mapper);
    }

    PublisherSwitchMap(Publisher<T> original, int maxDelayedErrors, Function<? super T, ? extends Publisher<? extends R>> mapper) {
        super(original);
        this.maxDelayedErrors = NumberUtils.ensureNonNegative(maxDelayedErrors, "maxDelayedErrors");
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super R> subscriber) {
        return new SwitchSubscriber(subscriber, this);
    }

    private static final class SwitchSubscriber<T, R>
    implements PublisherSource.Subscriber<T>,
    PublisherSource.Subscription {
        private static final AtomicIntegerFieldUpdater<RSubscriber> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(RSubscriber.class, "state");
        private static final AtomicIntegerFieldUpdater<SwitchSubscriber> pendingErrorCountUpdater = AtomicIntegerFieldUpdater.newUpdater(SwitchSubscriber.class, "pendingErrorCount");
        private static final AtomicReferenceFieldUpdater<SwitchSubscriber, Throwable> pendingErrorUpdater = AtomicReferenceFieldUpdater.newUpdater(SwitchSubscriber.class, Throwable.class, "pendingError");
        private static final int INNER_STATE_IDLE = 0;
        private static final int INNER_STATE_EMITTING = 1;
        private static final int INNER_STATE_DISPOSED = 2;
        private static final int INNER_STATE_COMPLETE = 3;
        private static final int INNER_STATE_ERROR = 4;
        private static final int OUTER_STATE_SHIFT = 3;
        private static final int OUTER_STATE_MASK = -8;
        private static final int INNER_STATE_MASK = 7;
        private static final int OUTER_STATE_COMPLETE = 1;
        private static final int OUTER_STATE_ERROR = 2;
        private final SequentialSubscription rSubscription = new SequentialSubscription();
        private final PublisherSwitchMap<T, R> parent;
        private final PublisherSource.Subscriber<? super R> target;
        @Nullable
        private PublisherSource.Subscription tSubscription;
        @Nullable
        private RSubscriber currPublisher;
        private volatile int pendingErrorCount;
        @Nullable
        private volatile Throwable pendingError;

        private SwitchSubscriber(PublisherSource.Subscriber<? super R> target, PublisherSwitchMap<T, R> parent) {
            this.target = target;
            this.parent = parent;
        }

        @Override
        public void cancel() {
            try {
                this.rSubscription.cancel();
            }
            finally {
                assert (this.tSubscription != null);
                this.tSubscription.cancel();
            }
        }

        @Override
        public void request(long n) {
            this.rSubscription.request(n);
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription subscription) {
            this.tSubscription = ConcurrentSubscription.wrap(subscription);
            this.target.onSubscribe(this);
            this.tSubscription.request(1L);
        }

        @Override
        public void onNext(@Nullable T t) {
            Publisher nextPub = (Publisher)Objects.requireNonNull(((PublisherSwitchMap)this.parent).mapper.apply(t), () -> "Mapper " + ((PublisherSwitchMap)this.parent).mapper + " returned null");
            this.currPublisher = new RSubscriber(this.currPublisher);
            SourceAdapters.toSource(nextPub).subscribe(this.currPublisher);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onError(Throwable t) {
            if (this.currPublisher != null) {
                try {
                    if (((PublisherSwitchMap)this.parent).maxDelayedErrors > 0) return;
                    this.currPublisher.dispose(EmptySubscriptions.EMPTY_SUBSCRIPTION, false);
                    return;
                }
                finally {
                    Throwable cause = this.outerErrorUpdateState(t);
                    if (cause != null) {
                        this.target.onError(cause);
                    }
                }
            } else {
                this.target.onError(t);
            }
        }

        @Override
        public void onComplete() {
            TerminalNotification terminalNotification = TerminalNotification.complete();
            if (this.currPublisher == null || (terminalNotification = this.outerCompleteUpdateState()) != null) {
                terminalNotification.terminate(this.target);
            }
        }

        @Nullable
        private Throwable outerErrorUpdateState(Throwable t) {
            int cState;
            assert (this.currPublisher != null);
            t = CompositeExceptionUtils.addPendingError(pendingErrorUpdater, pendingErrorCountUpdater, this, ((PublisherSwitchMap)this.parent).maxDelayedErrors, t);
            while (!stateUpdater.compareAndSet(this.currPublisher, cState = this.currPublisher.state, SwitchSubscriber.setOuterState(cState, 2))) {
            }
            int innerState = SwitchSubscriber.getInnerState(cState);
            return ((PublisherSwitchMap)this.parent).maxDelayedErrors <= 0 && innerState != 4 && innerState != 1 || ((PublisherSwitchMap)this.parent).maxDelayedErrors > 0 && (innerState == 4 || innerState == 3) ? t : null;
        }

        @Nullable
        private TerminalNotification outerCompleteUpdateState() {
            int cState;
            assert (this.currPublisher != null);
            while (!stateUpdater.compareAndSet(this.currPublisher, cState = this.currPublisher.state, SwitchSubscriber.setOuterState(cState, 1))) {
            }
            int innerState = SwitchSubscriber.getInnerState(cState);
            if (((PublisherSwitchMap)this.parent).maxDelayedErrors <= 0) {
                return innerState == 3 ? TerminalNotification.complete() : null;
            }
            if (innerState == 4 || innerState == 3) {
                Throwable cPendingError = this.pendingError;
                return cPendingError != null ? TerminalNotification.error(cPendingError) : TerminalNotification.complete();
            }
            return null;
        }

        private static int setOuterState(int currState, int newState) {
            return newState << 3 | currState & 7;
        }

        private static int setInnerState(int currState, int newState) {
            return currState & 0xFFFFFFF8 | newState;
        }

        private static int getOuterState(int state) {
            return state >> 3;
        }

        private static int getInnerState(int state) {
            return state & 7;
        }

        private final class RSubscriber
        implements PublisherSource.Subscriber<R> {
            volatile int state;
            @Nullable
            private RSubscriber prevPublisher;
            @Nullable
            private PublisherSource.Subscription localSubscription;
            @Nullable
            private PublisherSource.Subscription nextSubscriptionIfDisposePending;

            private RSubscriber(RSubscriber prevPublisher) {
                this.prevPublisher = prevPublisher;
            }

            @Override
            public void onSubscribe(PublisherSource.Subscription subscription) {
                this.localSubscription = ConcurrentSubscription.wrap(subscription);
                if (this.prevPublisher != null) {
                    RSubscriber prevPub = this.prevPublisher;
                    this.prevPublisher = null;
                    prevPub.dispose(this.localSubscription, true);
                } else {
                    this.switchTo(this.localSubscription);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(@Nullable R result) {
                int cState;
                int innerState;
                block16: {
                    while ((innerState = SwitchSubscriber.getInnerState(cState = this.state)) == 0) {
                        if (!stateUpdater.compareAndSet(this, cState, SwitchSubscriber.setInnerState(cState, 1))) continue;
                        break block16;
                    }
                    if (innerState != 1) {
                        LOGGER.debug("Disposed Subscriber ignoring signal state={} subscriber='{}' onNext='{}'", cState, SwitchSubscriber.this, result);
                        return;
                    }
                }
                try {
                    SwitchSubscriber.this.rSubscription.itemReceived();
                    SwitchSubscriber.this.target.onNext(result);
                }
                finally {
                    if (innerState == 0) {
                        do {
                            cState = this.state;
                            innerState = SwitchSubscriber.getInnerState(cState);
                            int outerState = SwitchSubscriber.getOuterState(cState);
                            if (outerState == 2 && SwitchSubscriber.this.parent.maxDelayedErrors <= 0) {
                                this.state = SwitchSubscriber.setInnerState(cState, 4);
                                try {
                                    if (innerState != 4 && innerState != 3) {
                                        SwitchSubscriber.this.rSubscription.cancel();
                                    }
                                    break;
                                }
                                finally {
                                    this.terminateTargetWithPendingError();
                                }
                            }
                            if (innerState != 2) continue;
                            assert (this.nextSubscriptionIfDisposePending != null);
                            assert (this.localSubscription != null);
                            this.switchWhenDisposed(this.localSubscription, this.nextSubscriptionIfDisposePending);
                            break;
                        } while (innerState != 4 && innerState != 3 && !stateUpdater.compareAndSet(this, cState, SwitchSubscriber.setInnerState(cState, 0)));
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable t) {
                int cState;
                int innerState;
                Throwable currPendingError = null;
                while ((innerState = SwitchSubscriber.getInnerState(cState = this.state)) != 2) {
                    if (SwitchSubscriber.this.parent.maxDelayedErrors <= 0) {
                        if (!stateUpdater.compareAndSet(this, cState, SwitchSubscriber.setInnerState(cState, 4))) continue;
                        int outerState = SwitchSubscriber.getOuterState(cState);
                        if (outerState == 2) break;
                        try {
                            if (outerState == 1) break;
                            this.cancelTSubscription();
                            break;
                        }
                        finally {
                            SwitchSubscriber.this.target.onError(t);
                        }
                    }
                    if (currPendingError == null) {
                        currPendingError = CompositeExceptionUtils.addPendingError(pendingErrorUpdater, pendingErrorCountUpdater, SwitchSubscriber.this, SwitchSubscriber.this.parent.maxDelayedErrors, t);
                    }
                    if (!stateUpdater.compareAndSet(this, cState, SwitchSubscriber.setInnerState(cState, 4))) continue;
                    int outerState = SwitchSubscriber.getOuterState(cState);
                    if (outerState == 2 || outerState == 1) {
                        SwitchSubscriber.this.target.onError(currPendingError);
                        break;
                    }
                    this.requestTSubscription();
                    break;
                }
            }

            @Override
            public void onComplete() {
                int cState;
                int innerState;
                while ((innerState = SwitchSubscriber.getInnerState(cState = this.state)) != 2) {
                    if (!stateUpdater.compareAndSet(this, cState, SwitchSubscriber.setInnerState(cState, 3))) continue;
                    int outerState = SwitchSubscriber.getOuterState(cState);
                    if (outerState == 1) {
                        SwitchSubscriber.this.target.onComplete();
                        break;
                    }
                    if (outerState == 2 && SwitchSubscriber.this.parent.maxDelayedErrors > 0) {
                        this.terminateTargetWithPendingError();
                        break;
                    }
                    if (outerState == 2) break;
                    this.requestTSubscription();
                    break;
                }
            }

            void dispose(PublisherSource.Subscription nextSubscription, boolean disposeIfEmitting) {
                int cState;
                int innerState;
                this.nextSubscriptionIfDisposePending = nextSubscription;
                while (!((innerState = SwitchSubscriber.getInnerState(cState = this.state)) == 2 || innerState == 4 && SwitchSubscriber.this.parent.maxDelayedErrors <= 0 || innerState == 1 && !disposeIfEmitting)) {
                    if (!stateUpdater.compareAndSet(this, cState, SwitchSubscriber.setInnerState(cState, 2))) continue;
                    if (innerState == 1) break;
                    assert (this.localSubscription != null);
                    this.switchWhenDisposed(this.localSubscription, nextSubscription);
                    break;
                }
            }

            private void switchWhenDisposed(PublisherSource.Subscription mySubscription, PublisherSource.Subscription nextSubscription) {
                try {
                    mySubscription.cancel();
                }
                finally {
                    this.switchTo(nextSubscription);
                }
            }

            private void switchTo(PublisherSource.Subscription nextSubscription) {
                try {
                    SwitchSubscriber.this.rSubscription.switchTo(nextSubscription);
                }
                finally {
                    this.requestTSubscription();
                }
            }

            private void cancelTSubscription() {
                assert (SwitchSubscriber.this.tSubscription != null);
                SwitchSubscriber.this.tSubscription.cancel();
            }

            private void requestTSubscription() {
                assert (SwitchSubscriber.this.tSubscription != null);
                SwitchSubscriber.this.tSubscription.request(1L);
            }

            private void terminateTargetWithPendingError() {
                Throwable cause = SwitchSubscriber.this.pendingError;
                assert (cause != null);
                SwitchSubscriber.this.target.onError(cause);
            }
        }
    }
}

