/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.ProcessorBufferUtils;
import io.servicetalk.concurrent.api.ProcessorSignalsConsumer;
import io.servicetalk.concurrent.api.PublisherProcessorSignalsHolder;
import io.servicetalk.concurrent.api.SubscriberApiUtils;
import io.servicetalk.concurrent.internal.QueueFullException;
import io.servicetalk.concurrent.internal.TerminalNotification;
import io.servicetalk.utils.internal.NumberUtils;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nullable;

abstract class AbstractPublisherProcessorSignalsHolder<T, Q extends Queue<Object>>
implements PublisherProcessorSignalsHolder<T> {
    private static final AtomicIntegerFieldUpdater<AbstractPublisherProcessorSignalsHolder> bufferedUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractPublisherProcessorSignalsHolder.class, "buffered");
    private final int maxBuffer;
    private final Q signals;
    private volatile int buffered;

    AbstractPublisherProcessorSignalsHolder(int maxBuffer, Q signals) {
        this.maxBuffer = NumberUtils.ensurePositive(maxBuffer, "maxBuffer");
        this.signals = (Queue)Objects.requireNonNull(signals);
    }

    @Override
    public void add(@Nullable T item) {
        if (bufferedUpdater.getAndAccumulate(this, 1, (prev, next) -> prev == this.maxBuffer ? this.maxBuffer : prev + next) == this.maxBuffer) {
            this.offerPastBufferSize(SubscriberApiUtils.wrapNull(item), this.signals);
        } else {
            this.offerSignal(SubscriberApiUtils.wrapNull(item));
        }
    }

    @Override
    public void terminate() {
        this.offerSignal(TerminalNotification.complete());
    }

    @Override
    public void terminate(Throwable cause) {
        this.offerSignal(TerminalNotification.error(cause));
    }

    @Override
    public boolean tryConsume(ProcessorSignalsConsumer<T> consumer) {
        Object signal = this.signals.poll();
        if (ProcessorBufferUtils.consumeIfTerminal(consumer, signal)) {
            return true;
        }
        if (ProcessorBufferUtils.consumeNextItem(consumer, signal)) {
            bufferedUpdater.decrementAndGet(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean tryConsumeTerminal(ProcessorSignalsConsumer<T> consumer) {
        return ProcessorBufferUtils.consumeIfTerminal(consumer, this.signals.peek());
    }

    abstract void offerPastBufferSize(Object var1, Q var2);

    private void offerSignal(Object signal) {
        if (!this.signals.offer((Object)signal)) {
            throw new QueueFullException("publisher-processor-signals");
        }
    }
}

