/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.channel.uring;

import io.netty.incubator.channel.uring.Native;
import io.netty.incubator.channel.uring.RingBuffer;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;

public final class IOUring {
    private static final Throwable UNAVAILABILITY_CAUSE;

    public static boolean isAvailable() {
        return UNAVAILABILITY_CAUSE == null;
    }

    public static boolean isTcpFastOpenClientSideAvailable() {
        return IOUring.isAvailable() && Native.IS_SUPPORTING_TCP_FASTOPEN_CLIENT;
    }

    public static boolean isTcpFastOpenServerSideAvailable() {
        return IOUring.isAvailable() && Native.IS_SUPPORTING_TCP_FASTOPEN_SERVER;
    }

    public static void ensureAvailability() {
        if (UNAVAILABILITY_CAUSE != null) {
            throw (Error)new UnsatisfiedLinkError("failed to load the required native library").initCause(UNAVAILABILITY_CAUSE);
        }
    }

    public static Throwable unavailabilityCause() {
        return UNAVAILABILITY_CAUSE;
    }

    private IOUring() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Throwable cause;
        block12: {
            cause = null;
            try {
                if (SystemPropertyUtil.getBoolean("io.netty.transport.noNative", false)) {
                    cause = new UnsupportedOperationException("Native transport was explicit disabled with -Dio.netty.transport.noNative=true");
                    break block12;
                }
                String kernelVersion = Native.kernelVersion();
                Native.checkKernelVersion(kernelVersion);
                Throwable unsafeCause = PlatformDependent.getUnsafeUnavailabilityCause();
                if (unsafeCause == null) {
                    RingBuffer ringBuffer = null;
                    try {
                        ringBuffer = Native.createRingBuffer();
                        Native.checkAllIOSupported(ringBuffer.fd());
                        break block12;
                    }
                    finally {
                        if (ringBuffer != null) {
                            try {
                                ringBuffer.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                cause = new UnsupportedOperationException("Unsafe is not supported", unsafeCause);
            }
            catch (Throwable t) {
                cause = t;
            }
        }
        UNAVAILABILITY_CAUSE = cause;
    }
}

