/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.profile.PausesProfiler;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.profile.ProfilerOptionFormatter;
import org.openjdk.jmh.profile.ProfilerUtils;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ScalarResult;
import org.openjdk.jmh.runner.options.IntegerValueConverter;
import org.openjdk.jmh.util.HashMultiset;
import org.openjdk.jmh.util.Multiset;

public class GCProfiler
implements InternalProfiler {
    private long beforeTime;
    private long beforeGCCount;
    private long beforeGCTime;
    private HotspotAllocationSnapshot beforeAllocated;
    private boolean churnEnabled;
    private boolean allocEnabled;
    private long churnWait;

    @Override
    public String getDescription() {
        return "GC profiling via standard MBeans";
    }

    public GCProfiler(String initLine) throws ProfilerException {
        OptionParser parser = new OptionParser();
        parser.formatHelpWith(new ProfilerOptionFormatter(PausesProfiler.class.getCanonicalName()));
        ArgumentAcceptingOptionSpec<Boolean> optAllocEnable = parser.accepts("alloc", "Enable GC allocation measurement.").withRequiredArg().ofType(Boolean.class).describedAs("bool").defaultsTo(true, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<Boolean> optChurnEnable = parser.accepts("churn", "Enable GC churn measurement.").withRequiredArg().ofType(Boolean.class).describedAs("bool").defaultsTo(false, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<Integer> optChurnWait = parser.accepts("churnWait", "Time to wait for churn notifications to arrive.").withRequiredArg().withValuesConvertedBy(IntegerValueConverter.POSITIVE).describedAs("ms").defaultsTo(500, (Integer[])new Integer[0]);
        OptionSet set = ProfilerUtils.parseInitLine(initLine, parser);
        try {
            this.churnWait = set.valueOf(optChurnWait).intValue();
            this.churnEnabled = set.valueOf(optChurnEnable);
            this.allocEnabled = set.valueOf(optAllocEnable);
        }
        catch (OptionException e) {
            throw new ProfilerException(e.getMessage());
        }
        if (this.churnEnabled && !VMSupport.tryInitChurn()) {
            this.churnEnabled = false;
        }
        if (this.allocEnabled && !VMSupport.tryInitAlloc()) {
            this.allocEnabled = false;
        }
    }

    @Override
    public void beforeIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        if (this.churnEnabled) {
            VMSupport.startChurnProfile();
        }
        long gcTime = 0L;
        long gcCount = 0L;
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            gcCount += bean.getCollectionCount();
            gcTime += bean.getCollectionTime();
        }
        this.beforeGCCount = gcCount;
        this.beforeGCTime = gcTime;
        if (this.allocEnabled) {
            this.beforeAllocated = VMSupport.getSnapshot();
        }
        this.beforeTime = System.nanoTime();
    }

    @Override
    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams, IterationResult iResult) {
        long afterTime = System.nanoTime();
        if (this.churnEnabled) {
            VMSupport.finishChurnProfile(this.churnWait);
        }
        ArrayList<ScalarResult> results = new ArrayList<ScalarResult>();
        long gcTime = 0L;
        long gcCount = 0L;
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            gcCount += bean.getCollectionCount();
            gcTime += bean.getCollectionTime();
        }
        results.add(new ScalarResult("\u00b7gc.count", gcCount - this.beforeGCCount, "counts", AggregationPolicy.SUM));
        if (gcCount != this.beforeGCCount || gcTime != this.beforeGCTime) {
            results.add(new ScalarResult("\u00b7gc.time", gcTime - this.beforeGCTime, "ms", AggregationPolicy.SUM));
        }
        if (this.allocEnabled) {
            if (this.beforeAllocated != HotspotAllocationSnapshot.EMPTY) {
                HotspotAllocationSnapshot newSnapshot = VMSupport.getSnapshot();
                long allocated = newSnapshot.subtract(this.beforeAllocated);
                results.add(new ScalarResult("\u00b7gc.alloc.rate", afterTime != this.beforeTime ? 1.0 * (double)allocated / 1024.0 / 1024.0 * (double)TimeUnit.SECONDS.toNanos(1L) / (double)(afterTime - this.beforeTime) : Double.NaN, "MB/sec", AggregationPolicy.AVG));
                if (allocated != 0L) {
                    long allOps = iResult.getMetadata().getAllOps();
                    results.add(new ScalarResult("\u00b7gc.alloc.rate.norm", allOps != 0L ? 1.0 * (double)allocated / (double)allOps : Double.NaN, "B/op", AggregationPolicy.AVG));
                }
            } else {
                results.add(new ScalarResult("\u00b7gc.alloc.rate", Double.NaN, "MB/sec", AggregationPolicy.AVG));
            }
        }
        if (this.churnEnabled) {
            Multiset<String> churn = VMSupport.getChurn();
            for (String space : churn.keys()) {
                double churnRate = afterTime != this.beforeTime ? 1.0 * (double)churn.count(space) * (double)TimeUnit.SECONDS.toNanos(1L) / (double)(afterTime - this.beforeTime) / 1024.0 / 1024.0 : Double.NaN;
                double churnNorm = 1.0 * (double)churn.count(space) / (double)iResult.getMetadata().getAllOps();
                String spaceName = space.replaceAll(" ", "_");
                results.add(new ScalarResult("\u00b7gc.churn." + spaceName + "", churnRate, "MB/sec", AggregationPolicy.AVG));
                results.add(new ScalarResult("\u00b7gc.churn." + spaceName + ".norm", churnNorm, "B/op", AggregationPolicy.AVG));
            }
        }
        return results;
    }

    static class VMSupport {
        private static ThreadMXBean ALLOC_MX_BEAN;
        private static Method ALLOC_MX_BEAN_GETTER;
        private static NotificationListener LISTENER;
        private static Multiset<String> CHURN;

        VMSupport() {
        }

        private static boolean tryInitAlloc() {
            try {
                Class<?> internalIntf = Class.forName("com.sun.management.ThreadMXBean");
                ThreadMXBean bean = ManagementFactory.getThreadMXBean();
                if (!internalIntf.isAssignableFrom(bean.getClass())) {
                    Class<?> pmo = Class.forName("java.lang.management.PlatformManagedObject");
                    Method m = ManagementFactory.class.getMethod("getPlatformMXBean", Class.class, pmo);
                    bean = (ThreadMXBean)m.invoke(null, internalIntf);
                    if (bean == null) {
                        throw new UnsupportedOperationException("No way to access private ThreadMXBean");
                    }
                }
                ALLOC_MX_BEAN = bean;
                ALLOC_MX_BEAN_GETTER = internalIntf.getMethod("getThreadAllocatedBytes", long[].class);
                VMSupport.getAllocatedBytes(bean.getAllThreadIds());
                return true;
            }
            catch (Throwable e) {
                System.out.println("Allocation profiling is not available: " + e.getMessage());
                return false;
            }
        }

        private static boolean tryInitChurn() {
            try {
                for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
                    if (bean instanceof NotificationEmitter) continue;
                    throw new UnsupportedOperationException("GarbageCollectorMXBean cannot notify");
                }
                CHURN = new HashMultiset<String>();
                LISTENER = VMSupport.newListener();
                return true;
            }
            catch (Throwable e) {
                System.out.println("Churn profiling is not available: " + e.getMessage());
                return false;
            }
        }

        private static long[] getAllocatedBytes(long[] threadIds) {
            try {
                return (long[])ALLOC_MX_BEAN_GETTER.invoke((Object)ALLOC_MX_BEAN, new Object[]{threadIds});
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }

        private static NotificationListener newListener() {
            try {
                Class<?> infoKlass = Class.forName("com.sun.management.GarbageCollectionNotificationInfo");
                Field notifNameField = infoKlass.getField("GARBAGE_COLLECTION_NOTIFICATION");
                Method infoMethod = infoKlass.getMethod("from", CompositeData.class);
                Method getGcInfo = infoKlass.getMethod("getGcInfo", new Class[0]);
                Method getMemoryUsageBeforeGc = getGcInfo.getReturnType().getMethod("getMemoryUsageBeforeGc", new Class[0]);
                Method getMemoryUsageAfterGc = getGcInfo.getReturnType().getMethod("getMemoryUsageAfterGc", new Class[0]);
                return (n, o) -> {
                    try {
                        if (n.getType().equals(notifNameField.get(null))) {
                            Object info = infoMethod.invoke(null, n.getUserData());
                            Object gcInfo = getGcInfo.invoke(info, new Object[0]);
                            Map mapBefore = (Map)getMemoryUsageBeforeGc.invoke(gcInfo, new Object[0]);
                            Map mapAfter = (Map)getMemoryUsageAfterGc.invoke(gcInfo, new Object[0]);
                            for (Map.Entry entry : mapAfter.entrySet()) {
                                String name = (String)entry.getKey();
                                MemoryUsage after = (MemoryUsage)entry.getValue();
                                MemoryUsage before = (MemoryUsage)mapBefore.get(name);
                                long c = before.getUsed() - after.getUsed();
                                if (c <= 0L) continue;
                                CHURN.add(name, c);
                            }
                        }
                    }
                    catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                        // empty catch block
                    }
                };
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        }

        public static HotspotAllocationSnapshot getSnapshot() {
            long[] threadIds = ALLOC_MX_BEAN.getAllThreadIds();
            long[] allocatedBytes = VMSupport.getAllocatedBytes(threadIds);
            return new HotspotAllocationSnapshot(threadIds, allocatedBytes);
        }

        public static synchronized void startChurnProfile() {
            CHURN.clear();
            try {
                for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
                    ((NotificationEmitter)((Object)bean)).addNotificationListener(LISTENER, null, null);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Should not be here");
            }
        }

        public static synchronized void finishChurnProfile(long churnWait) {
            try {
                Thread.sleep(churnWait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
                try {
                    ((NotificationEmitter)((Object)bean)).removeNotificationListener(LISTENER);
                }
                catch (ListenerNotFoundException listenerNotFoundException) {}
            }
        }

        public static synchronized Multiset<String> getChurn() {
            return CHURN != null ? CHURN : new HashMultiset();
        }
    }

    static class HotspotAllocationSnapshot {
        public static final HotspotAllocationSnapshot EMPTY = new HotspotAllocationSnapshot(new long[0], new long[0]);
        private final long[] threadIds;
        private final long[] allocatedBytes;

        private HotspotAllocationSnapshot(long[] threadIds, long[] allocatedBytes) {
            this.threadIds = threadIds;
            this.allocatedBytes = allocatedBytes;
        }

        public long subtract(HotspotAllocationSnapshot other) {
            HashMap<Long, Integer> prevIndex = new HashMap<Long, Integer>();
            for (int i = 0; i < other.threadIds.length; ++i) {
                long id = other.threadIds[i];
                prevIndex.put(id, i);
            }
            long currentThreadId = Thread.currentThread().getId();
            long allocated = 0L;
            for (int i = 0; i < this.threadIds.length; ++i) {
                long id = this.threadIds[i];
                if (id == currentThreadId) continue;
                allocated += this.allocatedBytes[i];
                Integer prev = (Integer)prevIndex.get(id);
                if (prev == null) continue;
                allocated -= other.allocatedBytes[prev];
            }
            return allocated;
        }
    }
}

