/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.SocketChannel;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.transport.netty.internal.LoggingCloseHandler;
import io.servicetalk.transport.netty.internal.NonPipelinedCloseHandler;
import io.servicetalk.transport.netty.internal.RequestResponseCloseHandler;
import java.nio.channels.ClosedChannelException;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CloseHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloseHandler.class);
    @Nullable
    private static final LogLevel CLOSE_HANDLER_LOG_LEVEL;
    public static final CloseHandler UNSUPPORTED_PROTOCOL_CLOSE_HANDLER;

    public static CloseHandler forPipelinedRequestResponse(boolean client, ChannelConfig config) {
        config.setOption(ChannelOption.ALLOW_HALF_CLOSURE, Boolean.TRUE);
        config.setAutoClose(false);
        return CloseHandler.wrapWithLogger(new RequestResponseCloseHandler(client));
    }

    public static CloseHandler forNonPipelined(boolean isClient, ChannelConfig config) {
        config.setAutoClose(false);
        return CloseHandler.wrapWithLogger(new NonPipelinedCloseHandler(isClient));
    }

    public abstract void protocolPayloadBeginInbound(ChannelHandlerContext var1);

    public abstract void protocolPayloadEndInbound(ChannelHandlerContext var1);

    public abstract void protocolPayloadBeginOutbound(ChannelHandlerContext var1);

    public abstract void protocolPayloadEndOutbound(ChannelHandlerContext var1, @Nullable ChannelPromise var2);

    public abstract void protocolClosingInbound(ChannelHandlerContext var1);

    public abstract void protocolClosingOutbound(ChannelHandlerContext var1);

    abstract void registerEventHandler(Channel var1, Consumer<CloseEvent> var2);

    abstract void channelClosedInbound(ChannelHandlerContext var1);

    abstract void channelClosedOutbound(ChannelHandlerContext var1);

    abstract void channelCloseNotify(ChannelHandlerContext var1);

    void channelClose(Channel channel) {
    }

    abstract void closeChannelInbound(Channel var1);

    abstract void closeChannelOutbound(Channel var1);

    abstract void gracefulUserClosing(Channel var1);

    static void setSocketResetOnClose(SocketChannel channel) {
        try {
            channel.config().setSoLinger(0);
        }
        catch (Exception e) {
            LOGGER.trace("{} set SO_LINGER=0 failed (expected when IN+OUT or IN+RST closed channel): {}", (Object)channel, (Object)e.getMessage());
        }
    }

    private static CloseHandler wrapWithLogger(CloseHandler closeHandler) {
        return CLOSE_HANDLER_LOG_LEVEL == null ? closeHandler : new LoggingCloseHandler(closeHandler, LOGGER.getName(), CLOSE_HANDLER_LOG_LEVEL);
    }

    static {
        UNSUPPORTED_PROTOCOL_CLOSE_HANDLER = new UnsupportedProtocolHandler();
        LogLevel logLevel = null;
        String logLevelPropertyStr = "io.servicetalk.transport.netty.internal.CloseHandler.LogLevel";
        String logLevelProperty = System.getProperty("io.servicetalk.transport.netty.internal.CloseHandler.LogLevel");
        if (logLevelProperty != null) {
            try {
                logLevel = LogLevel.valueOf(logLevelProperty);
            }
            catch (Throwable cause) {
                LOGGER.info("Error while parsing {}", (Object)"io.servicetalk.transport.netty.internal.CloseHandler.LogLevel", (Object)cause);
            }
        }
        LOGGER.debug("{}={}", (Object)"io.servicetalk.transport.netty.internal.CloseHandler.LogLevel", (Object)logLevel);
        CLOSE_HANDLER_LOG_LEVEL = logLevel;
    }

    public static final class DiscardFurtherInboundEvent
    extends NettyUserEvent {
        static final DiscardFurtherInboundEvent INSTANCE = new DiscardFurtherInboundEvent();

        private DiscardFurtherInboundEvent() {
        }
    }

    static final class AbortWritesEvent
    extends NettyUserEvent {
        static final AbortWritesEvent INSTANCE = new AbortWritesEvent();

        private AbortWritesEvent() {
        }
    }

    static final class InboundDataEndEvent
    extends NettyUserEvent {
        static final InboundDataEndEvent INSTANCE = new InboundDataEndEvent();

        private InboundDataEndEvent() {
        }
    }

    static final class OutboundDataEndEvent
    extends NettyUserEvent {
        static final OutboundDataEndEvent INSTANCE = new OutboundDataEndEvent();

        private OutboundDataEndEvent() {
        }
    }

    private static abstract class NettyUserEvent {
        private NettyUserEvent() {
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    private static final class UnsupportedProtocolHandler
    extends CloseHandler {
        private UnsupportedProtocolHandler() {
        }

        @Override
        void registerEventHandler(Channel channel, Consumer<CloseEvent> eventHandler) {
        }

        @Override
        void channelClosedInbound(ChannelHandlerContext ctx) {
        }

        @Override
        void channelClosedOutbound(ChannelHandlerContext ctx) {
        }

        @Override
        void channelCloseNotify(ChannelHandlerContext ctx) {
        }

        @Override
        void closeChannelInbound(Channel channel) {
            channel.close();
        }

        @Override
        void closeChannelOutbound(Channel channel) {
            channel.close();
        }

        @Override
        void gracefulUserClosing(Channel channel) {
            channel.close();
        }

        @Override
        void channelClose(Channel channel) {
        }

        @Override
        public void protocolPayloadBeginInbound(ChannelHandlerContext ctx) {
        }

        @Override
        public void protocolPayloadEndInbound(ChannelHandlerContext ctx) {
            ctx.pipeline().fireUserEventTriggered(InboundDataEndEvent.INSTANCE);
        }

        @Override
        public void protocolPayloadBeginOutbound(ChannelHandlerContext ctx) {
        }

        @Override
        public void protocolPayloadEndOutbound(ChannelHandlerContext ctx, @Nullable ChannelPromise promise) {
        }

        @Override
        public void protocolClosingInbound(ChannelHandlerContext ctx) {
        }

        @Override
        public void protocolClosingOutbound(ChannelHandlerContext ctx) {
        }
    }

    public static final class CloseEventObservedException
    extends ClosedChannelException {
        private static final long serialVersionUID = -4181001701486049092L;
        private final CloseEvent event;
        private final String channelDetails;

        private CloseEventObservedException(@Nullable Throwable cause, CloseEvent closeEvent, Channel channel) {
            this.event = closeEvent;
            this.channelDetails = channel.toString();
            this.initCause(cause);
        }

        public CloseEvent event() {
            return this.event;
        }

        @Override
        public String getMessage() {
            return this.event.name() + "(" + this.event.description + ") " + this.channelDetails;
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    public static enum CloseEvent {
        PROTOCOL_CLOSING_OUTBOUND("The application protocol closed the write side of this connection. This maybe the result of sending an HTTP header such as Connection: close."),
        PROTOCOL_CLOSING_INBOUND("The application protocol closed the read side of this connection. This maybe the result of sending an HTTP header such as Connection: close."),
        GRACEFUL_USER_CLOSING("The graceful close* method was called in the local application."),
        CHANNEL_CLOSED_OUTBOUND("The transport backing this connection has been shutdown (write)"),
        CHANNEL_CLOSED_INBOUND("The transport backing this connection has been shutdown (read)");

        private final String description;

        private CloseEvent(String description) {
            this.description = description;
        }

        CloseEventObservedException wrapError(@Nullable Throwable cause, Channel channel) {
            return new CloseEventObservedException(cause, this, channel);
        }
    }
}

