/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.api;

import io.servicetalk.transport.api.AbstractSslConfig;
import io.servicetalk.transport.api.AbstractSslConfigBuilder;
import io.servicetalk.transport.api.CertificateCompressionAlgorithm;
import io.servicetalk.transport.api.ServerSslConfig;
import io.servicetalk.transport.api.SslClientAuthMode;
import io.servicetalk.transport.api.SslProvider;
import java.io.InputStream;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public final class ServerSslConfigBuilder
extends AbstractSslConfigBuilder<ServerSslConfigBuilder> {
    private SslClientAuthMode clientAuthMode = SslClientAuthMode.NONE;

    public ServerSslConfigBuilder(KeyManagerFactory kmf) {
        this.keyManager(kmf);
    }

    public ServerSslConfigBuilder(Supplier<InputStream> keyCertChainSupplier, Supplier<InputStream> keySupplier) {
        this.keyManager(keyCertChainSupplier, keySupplier);
    }

    public ServerSslConfigBuilder(Supplier<InputStream> keyCertChainSupplier, Supplier<InputStream> keySupplier, @Nullable String keyPassword) {
        this.keyManager(keyCertChainSupplier, keySupplier, keyPassword);
    }

    public ServerSslConfigBuilder clientAuthMode(SslClientAuthMode clientAuthMode) {
        this.clientAuthMode = Objects.requireNonNull(clientAuthMode);
        return this;
    }

    public ServerSslConfig build() {
        return new DefaultServerSslConfig(this.clientAuthMode, this.trustManager(), this.trustCertChainSupplier(), this.keyManager(), this.keyCertChainSupplier(), this.keySupplier(), this.keyPassword(), this.sslProtocols(), this.alpnProtocols(), this.ciphers(), this.sessionCacheSize(), this.sessionTimeout(), this.provider(), this.certificateCompressionAlgorithms(), this.handshakeTimeout());
    }

    @Override
    protected ServerSslConfigBuilder thisT() {
        return this;
    }

    private static final class DefaultServerSslConfig
    extends AbstractSslConfig
    implements ServerSslConfig {
        private final SslClientAuthMode clientAuthMode;

        DefaultServerSslConfig(SslClientAuthMode clientAuthMode, @Nullable TrustManagerFactory trustManagerFactory, @Nullable Supplier<InputStream> trustCertChainSupplier, @Nullable KeyManagerFactory keyManagerFactory, @Nullable Supplier<InputStream> keyCertChainSupplier, @Nullable Supplier<InputStream> keySupplier, @Nullable String keyPassword, @Nullable List<String> sslProtocols, @Nullable List<String> alpnProtocols, @Nullable List<String> ciphers, long sessionCacheSize, long sessionTimeout, @Nullable SslProvider provider, @Nullable List<CertificateCompressionAlgorithm> certificateCompressionAlgorithms, Duration handshakeTimeout) {
            super(trustManagerFactory, trustCertChainSupplier, keyManagerFactory, keyCertChainSupplier, keySupplier, keyPassword, sslProtocols, alpnProtocols, ciphers, sessionCacheSize, sessionTimeout, provider, certificateCompressionAlgorithms, handshakeTimeout);
            this.clientAuthMode = clientAuthMode;
        }

        @Override
        public SslClientAuthMode clientAuthMode() {
            return this.clientAuthMode;
        }
    }
}

