/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.api;

import io.servicetalk.transport.api.ConnectionInfo;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.api.NoopTransportObserver;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.utils.internal.ThrowableUtils;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CatchAllTransportObserver
implements TransportObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(CatchAllTransportObserver.class);
    private final TransportObserver observer;

    CatchAllTransportObserver(TransportObserver observer) {
        this.observer = Objects.requireNonNull(observer);
    }

    @Override
    public ConnectionObserver onNewConnection(@Nullable Object localAddress, Object remoteAddress) {
        return CatchAllTransportObserver.safeReport(() -> this.observer.onNewConnection(localAddress, remoteAddress), this.observer, "new connection", x$0 -> new CatchAllConnectionObserver((ConnectionObserver)x$0), NoopTransportObserver.NoopConnectionObserver.INSTANCE);
    }

    private static <T> T safeReport(Supplier<T> supplier, Object observer, String eventName, UnaryOperator<T> catchAllWrapper, T defaultValue) {
        try {
            return (T)catchAllWrapper.apply(Objects.requireNonNull(supplier.get()));
        }
        catch (Throwable unexpected) {
            LOGGER.warn("Unexpected exception from {} while reporting a {} event", observer, eventName, unexpected);
            return defaultValue;
        }
    }

    private static void safeReport(Runnable runnable, Object observer, String eventName) {
        try {
            runnable.run();
        }
        catch (Throwable unexpected) {
            LOGGER.warn("Unexpected exception from {} while reporting a {} event", observer, eventName, unexpected);
        }
    }

    private static void safeReport(Runnable runnable, Object observer, String eventName, Throwable original) {
        try {
            runnable.run();
        }
        catch (Throwable unexpected) {
            ThrowableUtils.addSuppressed(unexpected, original);
            LOGGER.warn("Unexpected exception from {} while reporting a {} event", observer, eventName, unexpected);
        }
    }

    private static final class CatchAllWriteObserver
    implements ConnectionObserver.WriteObserver {
        private final ConnectionObserver.WriteObserver observer;

        private CatchAllWriteObserver(ConnectionObserver.WriteObserver observer) {
            this.observer = observer;
        }

        @Override
        public void requestedToWrite(long n) {
            CatchAllTransportObserver.safeReport(() -> this.observer.requestedToWrite(n), this.observer, "requested to write");
        }

        @Override
        public void itemReceived(@Nullable Object item) {
            CatchAllTransportObserver.safeReport(() -> this.observer.itemReceived(item), this.observer, "item received");
        }

        @Override
        public void onFlushRequest() {
            CatchAllTransportObserver.safeReport(this.observer::onFlushRequest, this.observer, "flush request");
        }

        @Override
        public void itemWritten(@Nullable Object item) {
            CatchAllTransportObserver.safeReport(() -> this.observer.itemWritten(item), this.observer, "item written");
        }

        @Override
        public void itemFlushed() {
            CatchAllTransportObserver.safeReport(this.observer::itemFlushed, this.observer, "item flushed");
        }

        @Override
        public void writeFailed(Throwable cause) {
            CatchAllTransportObserver.safeReport(() -> this.observer.writeFailed(cause), this.observer, "write failed", cause);
        }

        @Override
        public void writeComplete() {
            CatchAllTransportObserver.safeReport(this.observer::writeComplete, this.observer, "write complete");
        }

        @Override
        public void writeCancelled() {
            CatchAllTransportObserver.safeReport(this.observer::writeCancelled, this.observer, "write cancelled");
        }
    }

    private static final class CatchAllReadObserver
    implements ConnectionObserver.ReadObserver {
        private final ConnectionObserver.ReadObserver observer;

        private CatchAllReadObserver(ConnectionObserver.ReadObserver observer) {
            this.observer = observer;
        }

        @Override
        public void requestedToRead(long n) {
            CatchAllTransportObserver.safeReport(() -> this.observer.requestedToRead(n), this.observer, "requested to read");
        }

        @Override
        public void itemRead(@Nullable Object item) {
            CatchAllTransportObserver.safeReport(() -> this.observer.itemRead(item), this.observer, "item read");
        }

        @Override
        public void readFailed(Throwable cause) {
            CatchAllTransportObserver.safeReport(() -> this.observer.readFailed(cause), this.observer, "read failed", cause);
        }

        @Override
        public void readComplete() {
            CatchAllTransportObserver.safeReport(this.observer::readComplete, this.observer, "read complete");
        }

        @Override
        public void readCancelled() {
            CatchAllTransportObserver.safeReport(this.observer::readCancelled, this.observer, "read cancelled");
        }
    }

    private static final class CatchAllStreamObserver
    implements ConnectionObserver.StreamObserver {
        private final ConnectionObserver.StreamObserver observer;

        private CatchAllStreamObserver(ConnectionObserver.StreamObserver observer) {
            this.observer = observer;
        }

        @Override
        public void streamIdAssigned(long streamId) {
            CatchAllTransportObserver.safeReport(() -> this.observer.streamIdAssigned(streamId), this.observer, "streamId assigned");
        }

        @Override
        public ConnectionObserver.DataObserver streamEstablished() {
            return (ConnectionObserver.DataObserver)CatchAllTransportObserver.safeReport(this.observer::streamEstablished, this.observer, "stream established", x$0 -> new CatchAllDataObserver((ConnectionObserver.DataObserver)x$0), NoopTransportObserver.NoopDataObserver.INSTANCE);
        }

        @Override
        public void streamClosed(Throwable error) {
            CatchAllTransportObserver.safeReport(() -> this.observer.streamClosed(error), this.observer, "stream closed", error);
        }

        @Override
        public void streamClosed() {
            CatchAllTransportObserver.safeReport(this.observer::streamClosed, this.observer, "stream closed");
        }
    }

    private static final class CatchAllMultiplexedObserver
    implements ConnectionObserver.MultiplexedObserver {
        private final ConnectionObserver.MultiplexedObserver observer;

        private CatchAllMultiplexedObserver(ConnectionObserver.MultiplexedObserver observer) {
            this.observer = observer;
        }

        @Override
        public ConnectionObserver.StreamObserver onNewStream() {
            return (ConnectionObserver.StreamObserver)CatchAllTransportObserver.safeReport(this.observer::onNewStream, this.observer, "connection established", x$0 -> new CatchAllStreamObserver((ConnectionObserver.StreamObserver)x$0), NoopTransportObserver.NoopStreamObserver.INSTANCE);
        }
    }

    private static final class CatchAllDataObserver
    implements ConnectionObserver.DataObserver {
        private final ConnectionObserver.DataObserver observer;

        private CatchAllDataObserver(ConnectionObserver.DataObserver observer) {
            this.observer = observer;
        }

        @Override
        public ConnectionObserver.ReadObserver onNewRead() {
            return (ConnectionObserver.ReadObserver)CatchAllTransportObserver.safeReport(this.observer::onNewRead, this.observer, "new read", x$0 -> new CatchAllReadObserver((ConnectionObserver.ReadObserver)x$0), NoopTransportObserver.NoopReadObserver.INSTANCE);
        }

        @Override
        public ConnectionObserver.WriteObserver onNewWrite() {
            return (ConnectionObserver.WriteObserver)CatchAllTransportObserver.safeReport(this.observer::onNewWrite, this.observer, "new read", x$0 -> new CatchAllWriteObserver((ConnectionObserver.WriteObserver)x$0), NoopTransportObserver.NoopWriteObserver.INSTANCE);
        }
    }

    private static final class CatchAllSecurityHandshakeObserver
    implements ConnectionObserver.SecurityHandshakeObserver {
        private final ConnectionObserver.SecurityHandshakeObserver observer;

        private CatchAllSecurityHandshakeObserver(ConnectionObserver.SecurityHandshakeObserver observer) {
            this.observer = observer;
        }

        @Override
        public void handshakeFailed(Throwable cause) {
            CatchAllTransportObserver.safeReport(() -> this.observer.handshakeFailed(cause), this.observer, "handshake failed", cause);
        }

        @Override
        public void handshakeComplete(SSLSession sslSession) {
            CatchAllTransportObserver.safeReport(() -> this.observer.handshakeComplete(sslSession), this.observer, "handshake complete");
        }
    }

    private static final class CatchAllConnectionObserver
    implements ConnectionObserver {
        private final ConnectionObserver observer;

        private CatchAllConnectionObserver(ConnectionObserver observer) {
            this.observer = observer;
        }

        @Override
        public void onDataRead(int size) {
            CatchAllTransportObserver.safeReport(() -> this.observer.onDataRead(size), this.observer, "data read");
        }

        @Override
        public void onDataWrite(int size) {
            CatchAllTransportObserver.safeReport(() -> this.observer.onDataWrite(size), this.observer, "data write");
        }

        @Override
        public void onFlush() {
            CatchAllTransportObserver.safeReport(this.observer::onFlush, this.observer, "flush");
        }

        @Override
        public void onTransportHandshakeComplete() {
            CatchAllTransportObserver.safeReport(this.observer::onTransportHandshakeComplete, this.observer, "flush");
        }

        @Override
        public ConnectionObserver.SecurityHandshakeObserver onSecurityHandshake() {
            return (ConnectionObserver.SecurityHandshakeObserver)CatchAllTransportObserver.safeReport(this.observer::onSecurityHandshake, this.observer, "security handshake", x$0 -> new CatchAllSecurityHandshakeObserver((ConnectionObserver.SecurityHandshakeObserver)x$0), NoopTransportObserver.NoopSecurityHandshakeObserver.INSTANCE);
        }

        @Override
        public ConnectionObserver.DataObserver connectionEstablished(ConnectionInfo info) {
            return (ConnectionObserver.DataObserver)CatchAllTransportObserver.safeReport(() -> this.observer.connectionEstablished(info), this.observer, "connection established", x$0 -> new CatchAllDataObserver((ConnectionObserver.DataObserver)x$0), NoopTransportObserver.NoopDataObserver.INSTANCE);
        }

        @Override
        public ConnectionObserver.MultiplexedObserver multiplexedConnectionEstablished(ConnectionInfo info) {
            return (ConnectionObserver.MultiplexedObserver)CatchAllTransportObserver.safeReport(() -> this.observer.multiplexedConnectionEstablished(info), this.observer, "multiplexed connection established", x$0 -> new CatchAllMultiplexedObserver((ConnectionObserver.MultiplexedObserver)x$0), NoopTransportObserver.NoopMultiplexedObserver.INSTANCE);
        }

        @Override
        public void connectionWritabilityChanged(boolean isWritable) {
            CatchAllTransportObserver.safeReport(() -> this.observer.connectionWritabilityChanged(isWritable), this.observer, "connection writability changed");
        }

        @Override
        public void connectionClosed(Throwable error) {
            CatchAllTransportObserver.safeReport(() -> this.observer.connectionClosed(error), this.observer, "connection closed", error);
        }

        @Override
        public void connectionClosed() {
            CatchAllTransportObserver.safeReport(this.observer::connectionClosed, this.observer, "connection closed");
        }
    }
}

