/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.api;

import io.servicetalk.transport.api.CertificateCompressionAlgorithm;
import io.servicetalk.transport.api.SslProvider;
import io.servicetalk.utils.internal.DurationUtils;
import java.io.InputStream;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

abstract class AbstractSslConfigBuilder<T extends AbstractSslConfigBuilder<T>> {
    static final Duration DEFAULT_HANDSHAKE_TIMEOUT = Duration.ofSeconds(10L);
    @Nullable
    private TrustManagerFactory trustManagerFactory;
    @Nullable
    private Supplier<InputStream> trustCertChainSupplier;
    @Nullable
    private KeyManagerFactory keyManagerFactory;
    @Nullable
    private Supplier<InputStream> keyCertChainSupplier;
    @Nullable
    private Supplier<InputStream> keySupplier;
    @Nullable
    private String keyPassword;
    @Nullable
    private List<String> sslProtocols;
    @Nullable
    private List<String> alpnProtocols;
    @Nullable
    private List<String> ciphers;
    private long sessionCacheSize;
    private long sessionTimeout;
    @Nullable
    private SslProvider provider;
    @Nullable
    private List<CertificateCompressionAlgorithm> certificateCompressionAlgorithms;
    private Duration handshakeTimeout = DEFAULT_HANDSHAKE_TIMEOUT;

    AbstractSslConfigBuilder() {
    }

    public final T trustManager(TrustManagerFactory tmf) {
        this.trustManagerFactory = Objects.requireNonNull(tmf);
        this.trustCertChainSupplier = null;
        return this.thisT();
    }

    @Nullable
    final TrustManagerFactory trustManager() {
        return this.trustManagerFactory;
    }

    public final T trustManager(Supplier<InputStream> trustCertChainSupplier) {
        this.trustCertChainSupplier = Objects.requireNonNull(trustCertChainSupplier);
        this.trustManagerFactory = null;
        return this.thisT();
    }

    @Nullable
    final Supplier<InputStream> trustCertChainSupplier() {
        return this.trustCertChainSupplier;
    }

    public final T keyManager(KeyManagerFactory kmf) {
        this.keyManagerFactory = Objects.requireNonNull(kmf);
        this.keyCertChainSupplier = null;
        this.keySupplier = null;
        this.keyPassword = null;
        return this.thisT();
    }

    @Nullable
    final KeyManagerFactory keyManager() {
        return this.keyManagerFactory;
    }

    public final T keyManager(Supplier<InputStream> keyCertChainSupplier, Supplier<InputStream> keySupplier) {
        this.keyCertChainSupplier = Objects.requireNonNull(keyCertChainSupplier);
        this.keySupplier = Objects.requireNonNull(keySupplier);
        this.keyPassword = null;
        this.keyManagerFactory = null;
        return this.thisT();
    }

    public final T keyManager(Supplier<InputStream> keyCertChainSupplier, Supplier<InputStream> keySupplier, @Nullable String keyPassword) {
        this.keyCertChainSupplier = Objects.requireNonNull(keyCertChainSupplier);
        this.keySupplier = Objects.requireNonNull(keySupplier);
        this.keyPassword = keyPassword;
        this.keyManagerFactory = null;
        return this.thisT();
    }

    @Nullable
    final Supplier<InputStream> keyCertChainSupplier() {
        return this.keyCertChainSupplier;
    }

    @Nullable
    final Supplier<InputStream> keySupplier() {
        return this.keySupplier;
    }

    @Nullable
    final String keyPassword() {
        return this.keyPassword;
    }

    public final T sslProtocols(List<String> protocols) {
        if (protocols.isEmpty()) {
            throw new IllegalArgumentException("protocols cannot be empty");
        }
        this.sslProtocols = protocols;
        return this.thisT();
    }

    public final T sslProtocols(String ... protocols) {
        return this.sslProtocols(Arrays.asList(protocols));
    }

    @Nullable
    final List<String> sslProtocols() {
        return this.sslProtocols;
    }

    public final T alpnProtocols(List<String> protocols) {
        if (protocols.isEmpty()) {
            throw new IllegalArgumentException("protocols cannot be empty");
        }
        this.alpnProtocols = protocols;
        return this.thisT();
    }

    public final T alpnProtocols(String ... protocols) {
        return this.alpnProtocols(Arrays.asList(protocols));
    }

    @Nullable
    final List<String> alpnProtocols() {
        return this.alpnProtocols;
    }

    public final T ciphers(List<String> ciphers) {
        if (ciphers.isEmpty()) {
            throw new IllegalArgumentException("ciphers cannot be empty");
        }
        this.ciphers = ciphers;
        return this.thisT();
    }

    public final T ciphers(String ... ciphers) {
        return this.ciphers(Arrays.asList(ciphers));
    }

    @Nullable
    final List<String> ciphers() {
        return this.ciphers;
    }

    public final T sessionCacheSize(long sessionCacheSize) {
        if (sessionCacheSize < 0L) {
            throw new IllegalArgumentException("sessionCacheSize: " + sessionCacheSize + " (expected >=0)");
        }
        this.sessionCacheSize = sessionCacheSize;
        return this.thisT();
    }

    final long sessionCacheSize() {
        return this.sessionCacheSize;
    }

    public final T sessionTimeout(long sessionTimeout) {
        if (sessionTimeout < 0L) {
            throw new IllegalArgumentException("sessionTimeout: " + sessionTimeout + " (expected >=0)");
        }
        this.sessionTimeout = sessionTimeout;
        return this.thisT();
    }

    final long sessionTimeout() {
        return this.sessionTimeout;
    }

    public final T provider(SslProvider provider) {
        this.provider = Objects.requireNonNull(provider);
        return this.thisT();
    }

    @Nullable
    final SslProvider provider() {
        return this.provider;
    }

    public final T certificateCompressionAlgorithms(List<CertificateCompressionAlgorithm> algorithms) {
        if (algorithms.isEmpty()) {
            throw new IllegalArgumentException("algorithms cannot be empty");
        }
        this.certificateCompressionAlgorithms = algorithms;
        return this.thisT();
    }

    public final T certificateCompressionAlgorithms(CertificateCompressionAlgorithm ... algorithms) {
        return this.certificateCompressionAlgorithms(Arrays.asList(algorithms));
    }

    @Nullable
    final List<CertificateCompressionAlgorithm> certificateCompressionAlgorithms() {
        return this.certificateCompressionAlgorithms;
    }

    public final T handshakeTimeout(Duration handshakeTimeout) {
        this.handshakeTimeout = DurationUtils.ensureNonNegative(handshakeTimeout, "handshakeTimeout");
        return this.thisT();
    }

    final Duration handshakeTimeout() {
        return this.handshakeTimeout;
    }

    abstract T thisT();
}

