/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.tcp.netty.internal;

import io.netty.channel.ChannelOption;
import io.servicetalk.tcp.netty.internal.AbstractTcpConfig;
import io.servicetalk.tcp.netty.internal.ReadOnlyTcpServerConfig;
import io.servicetalk.transport.api.ServerSslConfig;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.netty.internal.NoopTransportObserver;
import io.servicetalk.transport.netty.internal.SocketOptionUtils;
import io.servicetalk.utils.internal.DurationUtils;
import java.net.SocketOption;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TcpServerConfig
extends AbstractTcpConfig<ServerSslConfig> {
    private static final int MAX_CLIENT_HELLO_LENGTH = 0xFFFFFF;
    private static final Duration DEFAULT_CLIENT_HELLO_TIMEOUT = Duration.ofSeconds(10L);
    @Nullable
    private Map<ChannelOption, Object> listenOptions;
    private TransportObserver transportObserver = NoopTransportObserver.INSTANCE;
    @Nullable
    private Map<String, ServerSslConfig> sniConfig;
    private int sniMaxClientHelloLength = 0xFFFFFF;
    private Duration sniClientHelloTimeout = DEFAULT_CLIENT_HELLO_TIMEOUT;

    @Nullable
    Map<ChannelOption, Object> listenOptions() {
        return this.listenOptions;
    }

    TransportObserver transportObserver() {
        return this.transportObserver;
    }

    @Nullable
    public Map<String, ServerSslConfig> sniConfig() {
        return this.sniConfig;
    }

    int sniMaxClientHelloLength() {
        return this.sniMaxClientHelloLength;
    }

    Duration sniClientHelloTimeout() {
        return this.sniClientHelloTimeout;
    }

    public void transportObserver(TransportObserver transportObserver) {
        this.transportObserver = Objects.requireNonNull(transportObserver);
    }

    public TcpServerConfig sslConfig(ServerSslConfig defaultSslConfig, Map<String, ServerSslConfig> sniConfig) {
        this.sslConfig(defaultSslConfig);
        this.sniConfig = Objects.requireNonNull(sniConfig);
        return this;
    }

    public TcpServerConfig sslConfig(ServerSslConfig defaultSslConfig, Map<String, ServerSslConfig> sniConfig, int maxClientHelloLength, Duration clientHelloTimeout) {
        this.sslConfig(defaultSslConfig, sniConfig);
        if (maxClientHelloLength < 0 || maxClientHelloLength > 0xFFFFFF) {
            throw new IllegalArgumentException("maxClientHelloLength: " + maxClientHelloLength + "(expected [0, " + 0xFFFFFF + ']');
        }
        this.sniMaxClientHelloLength = maxClientHelloLength;
        this.sniClientHelloTimeout = DurationUtils.ensureNonNegative(clientHelloTimeout, "clientHelloTimeout");
        return this;
    }

    public <T> void listenSocketOption(SocketOption<T> option, T value) {
        if (this.listenOptions == null) {
            this.listenOptions = new HashMap<ChannelOption, Object>();
        }
        SocketOptionUtils.addOption(this.listenOptions, option, value);
    }

    public ReadOnlyTcpServerConfig asReadOnly() {
        return new ReadOnlyTcpServerConfig(this);
    }
}

