/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.client.api.LoadBalancer;
import io.servicetalk.client.api.RequestConcurrencyController;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.TerminalSignalConsumer;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpLoadBalancedConnection;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpContextKeys;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.ReservedStreamingHttpConnection;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.netty.AbstractLifecycleObserverHttpFilter;
import io.servicetalk.http.netty.AbstractStreamingHttpConnection;
import io.servicetalk.http.utils.BeforeFinallyHttpOperator;
import io.servicetalk.transport.api.ConnectionInfo;
import io.servicetalk.transport.api.IoThreadFactory;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LoadBalancedStreamingHttpClient
implements FilterableStreamingHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadBalancedStreamingHttpClient.class);
    private static final Predicate<FilterableStreamingHttpLoadBalancedConnection> SELECTOR_FOR_REQUEST = conn -> conn.tryRequest() == RequestConcurrencyController.Result.Accepted;
    private static final Predicate<FilterableStreamingHttpLoadBalancedConnection> SELECTOR_FOR_RESERVE = LoadBalancedConnection::tryReserve;
    private static boolean onStreamClosedWarningLogged;
    private final HttpExecutionContext executionContext;
    private final LoadBalancer<FilterableStreamingHttpLoadBalancedConnection> loadBalancer;
    private final StreamingHttpRequestResponseFactory reqRespFactory;

    LoadBalancedStreamingHttpClient(HttpExecutionContext executionContext, LoadBalancer<FilterableStreamingHttpLoadBalancedConnection> loadBalancer, StreamingHttpRequestResponseFactory reqRespFactory) {
        this.executionContext = Objects.requireNonNull(executionContext);
        this.loadBalancer = Objects.requireNonNull(loadBalancer);
        this.reqRespFactory = Objects.requireNonNull(reqRespFactory);
    }

    @Override
    public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
        return this.loadBalancer.selectConnection(SELECTOR_FOR_REQUEST, request.context()).flatMap(c -> {
            OnStreamClosedRunnable onStreamClosed;
            LoadBalancedStreamingHttpClient.notifyConnectionSelected(request, c);
            OnStreamClosedRunnable onStreamClosedRunnable = OnStreamClosedRunnable.areStreamsSupported(c.connectionContext()) ? new OnStreamClosedRunnable(c::requestFinished) : (onStreamClosed = null);
            if (onStreamClosed != null) {
                request.context().put(OnStreamClosedRunnable.KEY, onStreamClosed);
            }
            return c.request(request).liftSync(new BeforeFinallyHttpOperator(new TerminalSignalConsumer((FilterableStreamingHttpLoadBalancedConnection)c){
                final /* synthetic */ FilterableStreamingHttpLoadBalancedConnection val$c;
                {
                    this.val$c = filterableStreamingHttpLoadBalancedConnection;
                }

                @Override
                public void onComplete() {
                    if (onStreamClosed == null || onStreamClosed.own()) {
                        this.val$c.requestFinished();
                    }
                }

                @Override
                public void onError(Throwable throwable) {
                    if (onStreamClosed == null || onStreamClosed.own()) {
                        this.val$c.requestFinished();
                    }
                }

                @Override
                public void cancel() {
                    if (onStreamClosed != null && onStreamClosed.own()) {
                        if (!onStreamClosedWarningLogged) {
                            onStreamClosedWarningLogged = true;
                            LOGGER.warn("HttpRequestMetaData#context() was cleared by one of the user-defined connection filters. This may result in incorrect control of the maximum concurrent streams. Double-check that none of the custom filters clear the request.context() or contact support for assistance.");
                        }
                        this.val$c.requestFinished();
                    }
                }
            })).shareContextOnSubscribe();
        });
    }

    private static void notifyConnectionSelected(HttpRequestMetaData requestMetaData, FilterableStreamingHttpLoadBalancedConnection c) {
        Consumer<ConnectionInfo> onConnectionSelected = requestMetaData.context().get(AbstractLifecycleObserverHttpFilter.ON_CONNECTION_SELECTED_CONSUMER);
        if (onConnectionSelected != null) {
            onConnectionSelected.accept(c.connectionContext());
        }
    }

    public Single<ReservedStreamingHttpConnection> reserveConnection(HttpRequestMetaData metaData) {
        return Single.defer(() -> {
            ContextMap context = metaData.context();
            boolean forceNew = Boolean.TRUE.equals(context.get(HttpContextKeys.HTTP_FORCE_NEW_CONNECTION));
            Single<FilterableStreamingHttpLoadBalancedConnection> connection = forceNew ? this.loadBalancer.newConnection(context) : this.loadBalancer.selectConnection(SELECTOR_FOR_RESERVE, context);
            HttpExecutionStrategy strategy = AbstractStreamingHttpConnection.requestExecutionStrategy(metaData, this.executionContext().executionStrategy());
            return (strategy.isMetadataReceiveOffloaded() || strategy.isDataReceiveOffloaded() ? connection.publishOn(this.executionContext.executor(), IoThreadFactory.IoThread::currentThreadIsIoThread) : connection).shareContextOnSubscribe();
        });
    }

    @Override
    public HttpExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public StreamingHttpResponseFactory httpResponseFactory() {
        return this.reqRespFactory;
    }

    @Override
    public Completable onClose() {
        return this.loadBalancer.onClose();
    }

    @Override
    public Completable onClosing() {
        return this.loadBalancer.onClosing();
    }

    @Override
    public Completable closeAsync() {
        return this.loadBalancer.closeAsync();
    }

    @Override
    public Completable closeAsyncGracefully() {
        return this.loadBalancer.closeAsyncGracefully();
    }

    @Override
    public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
        return this.reqRespFactory.newRequest(method, requestTarget);
    }

    static final class OnStreamClosedRunnable
    implements Runnable {
        static final ContextMap.Key<OnStreamClosedRunnable> KEY = ContextMap.Key.newKey(OnStreamClosedRunnable.class.getName(), OnStreamClosedRunnable.class);
        private static final AtomicIntegerFieldUpdater<OnStreamClosedRunnable> ownedUpdater = AtomicIntegerFieldUpdater.newUpdater(OnStreamClosedRunnable.class, "owned");
        private volatile int owned;
        private final Runnable runnable;

        OnStreamClosedRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            this.runnable.run();
        }

        boolean own() {
            return ownedUpdater.compareAndSet(this, 0, 1);
        }

        static boolean areStreamsSupported(HttpConnectionContext ctx) {
            return ctx.protocol().major() >= 2;
        }
    }
}

