/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.BlockingHttpService;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpApiConversions;
import io.servicetalk.http.api.HttpExceptionMapperServiceFilter;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpLifecycleObserver;
import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.api.HttpServerBuilder;
import io.servicetalk.http.api.HttpServerContext;
import io.servicetalk.http.api.HttpService;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilter;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.http.netty.ClearAsyncContextHttpServiceFilter;
import io.servicetalk.http.netty.DeferredServerChannelBinder;
import io.servicetalk.http.netty.H2ServerParentConnectionContext;
import io.servicetalk.http.netty.HttpExecutionContextBuilder;
import io.servicetalk.http.netty.HttpKeepAlive;
import io.servicetalk.http.netty.HttpLifecycleObserverServiceFilter;
import io.servicetalk.http.netty.HttpServerConfig;
import io.servicetalk.http.netty.NettyHttpServer;
import io.servicetalk.http.netty.OffloadingFilter;
import io.servicetalk.http.netty.ReadOnlyHttpServerConfig;
import io.servicetalk.http.netty.StrategyInfluencerAwareConversions;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.transport.api.ConnectExecutionStrategy;
import io.servicetalk.transport.api.ConnectionAcceptor;
import io.servicetalk.transport.api.ConnectionAcceptorFactory;
import io.servicetalk.transport.api.ConnectionInfo;
import io.servicetalk.transport.api.EarlyConnectionAcceptor;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.ExecutionStrategyInfluencer;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.api.LateConnectionAcceptor;
import io.servicetalk.transport.api.ServerSslConfig;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.netty.internal.InfluencerConnectionAcceptor;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultHttpServerBuilder
implements HttpServerBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHttpServerBuilder.class);
    private static final HttpExecutionStrategy REQRESP_OFFLOADS = HttpExecutionStrategies.customStrategyBuilder().offloadReceiveMetadata().offloadReceiveData().offloadSend().build();
    @Nullable
    private ConnectionAcceptorFactory connectionAcceptorFactory;
    private final List<StreamingHttpServiceFilterFactory> noOffloadServiceFilters = new ArrayList<StreamingHttpServiceFilterFactory>();
    private final List<StreamingHttpServiceFilterFactory> serviceFilters = new ArrayList<StreamingHttpServiceFilterFactory>();
    private final List<EarlyConnectionAcceptor> earlyConnectionAcceptors = new ArrayList<EarlyConnectionAcceptor>();
    private final List<LateConnectionAcceptor> lateConnectionAcceptors = new ArrayList<LateConnectionAcceptor>();
    private HttpExecutionStrategy strategy = HttpExecutionStrategies.defaultStrategy();
    private boolean drainRequestPayloadBody = true;
    private final HttpServerConfig config = new HttpServerConfig();
    private final HttpExecutionContextBuilder executionContextBuilder = new HttpExecutionContextBuilder();
    private final SocketAddress address;

    DefaultHttpServerBuilder(SocketAddress address) {
        this.appendNonOffloadingServiceFilter(ClearAsyncContextHttpServiceFilter.CLEAR_ASYNC_CONTEXT_HTTP_SERVICE_FILTER);
        this.address = address;
    }

    private static StreamingHttpServiceFilterFactory buildFactory(List<StreamingHttpServiceFilterFactory> filters) {
        return filters.stream().reduce((prev, filter) -> service -> prev.create(filter.create(service))).orElse(StreamingHttpServiceFilter::new);
    }

    private static StreamingHttpService buildService(Stream<StreamingHttpServiceFilterFactory> filters, StreamingHttpService service) {
        return filters.reduce((prev, filter) -> svc -> prev.create(filter.create(svc))).map(factory -> factory.create(service)).orElse(service);
    }

    private static HttpExecutionStrategy computeRequiredStrategy(List<StreamingHttpServiceFilterFactory> filters, HttpExecutionStrategy serviceStrategy) {
        HttpExecutionStrategy current = serviceStrategy;
        for (StreamingHttpServiceFilterFactory filter : filters) {
            HttpExecutionStrategy next = current.merge(filter.requiredOffloads());
            if (current == next) continue;
            LOGGER.debug("{} '{}' changes execution strategy from '{}' to '{}'", StreamingHttpServiceFilterFactory.class, filter, current, next);
            current = next;
        }
        return current;
    }

    private static <T> T checkNonOffloading(String what, ExecutionStrategy fallbackValue, T obj) {
        ExecutionStrategy requires;
        ExecutionStrategy executionStrategy = requires = obj instanceof ExecutionStrategyInfluencer ? ((ExecutionStrategyInfluencer)obj).requiredOffloads() : fallbackValue;
        if (requires.hasOffloads()) {
            throw new IllegalArgumentException(what + " '" + obj.getClass().getName() + "' requires offloading: " + requires + ". Therefore, it cannot be used with 'appendNonOffloadingServiceFilter(...)', use 'appendServiceFilter(...)' instead.");
        }
        return obj;
    }

    @Override
    public HttpServerBuilder drainRequestPayloadBody(boolean enable) {
        this.drainRequestPayloadBody = enable;
        return this;
    }

    @Override
    public HttpServerBuilder appendConnectionAcceptorFilter(ConnectionAcceptorFactory factory) {
        this.connectionAcceptorFactory = this.connectionAcceptorFactory == null ? factory : this.connectionAcceptorFactory.append(factory);
        return this;
    }

    @Override
    public HttpServerBuilder appendEarlyConnectionAcceptor(EarlyConnectionAcceptor acceptor) {
        this.earlyConnectionAcceptors.add(Objects.requireNonNull(acceptor));
        return this;
    }

    @Override
    public HttpServerBuilder appendLateConnectionAcceptor(LateConnectionAcceptor acceptor) {
        this.lateConnectionAcceptors.add(Objects.requireNonNull(acceptor));
        return this;
    }

    @Override
    public HttpServerBuilder appendNonOffloadingServiceFilter(StreamingHttpServiceFilterFactory factory) {
        this.noOffloadServiceFilters.add(DefaultHttpServerBuilder.checkNonOffloading("Filter", HttpExecutionStrategies.defaultStrategy(), factory));
        return this;
    }

    @Override
    public HttpServerBuilder appendNonOffloadingServiceFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpServiceFilterFactory factory) {
        DefaultHttpServerBuilder.checkNonOffloading("Predicate", HttpExecutionStrategies.offloadNone(), predicate);
        DefaultHttpServerBuilder.checkNonOffloading("Filter", HttpExecutionStrategies.defaultStrategy(), factory);
        this.noOffloadServiceFilters.add(StrategyInfluencerAwareConversions.toConditionalServiceFilterFactory(predicate, factory));
        return this;
    }

    @Override
    public HttpServerBuilder appendServiceFilter(StreamingHttpServiceFilterFactory factory) {
        Objects.requireNonNull(factory);
        this.serviceFilters.add(factory);
        return this;
    }

    @Override
    public HttpServerBuilder appendServiceFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpServiceFilterFactory factory) {
        this.appendServiceFilter(StrategyInfluencerAwareConversions.toConditionalServiceFilterFactory(predicate, factory));
        return this;
    }

    @Override
    public HttpServerBuilder protocols(HttpProtocolConfig ... protocols) {
        this.config.httpConfig().protocols(protocols);
        return this;
    }

    @Override
    public HttpServerBuilder sslConfig(ServerSslConfig config) {
        this.config.tcpConfig().sslConfig(config);
        return this;
    }

    @Override
    public HttpServerBuilder sslConfig(ServerSslConfig defaultConfig, Map<String, ServerSslConfig> sniMap) {
        this.config.tcpConfig().sslConfig(defaultConfig, sniMap);
        return this;
    }

    @Override
    public HttpServerBuilder sslConfig(ServerSslConfig defaultConfig, Map<String, ServerSslConfig> sniMap, int maxClientHelloLength, Duration clientHelloTimeout) {
        this.config.tcpConfig().sslConfig(defaultConfig, sniMap, maxClientHelloLength, clientHelloTimeout);
        return this;
    }

    @Override
    public <T> HttpServerBuilder socketOption(SocketOption<T> option, T value) {
        this.config.tcpConfig().socketOption(option, value);
        return this;
    }

    @Override
    public <T> HttpServerBuilder listenSocketOption(SocketOption<T> option, T value) {
        this.config.tcpConfig().listenSocketOption(option, value);
        return this;
    }

    @Override
    public HttpServerBuilder enableWireLogging(String loggerName, LogLevel logLevel, BooleanSupplier logUserData) {
        this.config.tcpConfig().enableWireLogging(loggerName, logLevel, logUserData);
        return this;
    }

    @Override
    public HttpServerBuilder transportObserver(TransportObserver transportObserver) {
        this.config.tcpConfig().transportObserver(transportObserver);
        return this;
    }

    @Override
    public HttpServerBuilder lifecycleObserver(HttpLifecycleObserver lifecycleObserver) {
        this.config.lifecycleObserver(lifecycleObserver);
        return this;
    }

    @Override
    public HttpServerBuilder allowDropRequestTrailers(boolean allowDrop) {
        this.config.httpConfig().allowDropTrailersReadFromTransport(allowDrop);
        return this;
    }

    @Override
    public HttpServerBuilder executor(Executor executor) {
        this.executionContextBuilder.executor(executor);
        return this;
    }

    @Override
    public HttpServerBuilder executionStrategy(HttpExecutionStrategy strategy) {
        this.strategy = Objects.requireNonNull(strategy);
        return this;
    }

    @Override
    public HttpServerBuilder ioExecutor(IoExecutor ioExecutor) {
        this.executionContextBuilder.ioExecutor(ioExecutor);
        return this;
    }

    @Override
    public HttpServerBuilder bufferAllocator(BufferAllocator allocator) {
        this.executionContextBuilder.bufferAllocator(allocator);
        return this;
    }

    @Override
    public Single<HttpServerContext> listen(HttpService service) {
        StreamingHttpService streamingService = HttpApiConversions.toStreamingHttpService(this.computeServiceStrategy(HttpService.class, service), service);
        return this.listenForService(streamingService, streamingService.requiredOffloads());
    }

    @Override
    public Single<HttpServerContext> listenStreaming(StreamingHttpService service) {
        return this.listenForService(service, this.computeServiceStrategy(StreamingHttpService.class, service));
    }

    @Override
    public Single<HttpServerContext> listenBlocking(BlockingHttpService service) {
        StreamingHttpService streamingService = HttpApiConversions.toStreamingHttpService(this.computeServiceStrategy(BlockingHttpService.class, service), service);
        return this.listenForService(streamingService, streamingService.requiredOffloads());
    }

    @Override
    public Single<HttpServerContext> listenBlockingStreaming(BlockingStreamingHttpService service) {
        StreamingHttpService streamingService = HttpApiConversions.toStreamingHttpService(this.computeServiceStrategy(BlockingStreamingHttpService.class, service), service);
        return this.listenForService(streamingService, streamingService.requiredOffloads());
    }

    private HttpExecutionContext buildExecutionContext(HttpExecutionStrategy strategy) {
        this.executionContextBuilder.executionStrategy(strategy);
        return this.executionContextBuilder.build();
    }

    private Single<HttpServerContext> listenForService(StreamingHttpService rawService, HttpExecutionStrategy computedStrategy) {
        HttpExecutionContext executionContext;
        StreamingHttpService filteredService;
        InfluencerConnectionAcceptor connectionAcceptor = this.connectionAcceptorFactory == null ? null : InfluencerConnectionAcceptor.withStrategy(this.connectionAcceptorFactory.create(ConnectionAcceptor.ACCEPT_ALL), this.connectionAcceptorFactory.requiredOffloads());
        EarlyConnectionAcceptor earlyConnectionAcceptor = DefaultHttpServerBuilder.buildEarlyConnectionAcceptor(this.earlyConnectionAcceptors);
        LateConnectionAcceptor lateConnectionAcceptor = DefaultHttpServerBuilder.buildLateConnectionAcceptor(this.lateConnectionAcceptors);
        if (this.noOffloadServiceFilters.isEmpty()) {
            filteredService = this.serviceFilters.isEmpty() ? rawService : DefaultHttpServerBuilder.buildService(this.serviceFilters.stream(), rawService);
            executionContext = this.buildExecutionContext(computedStrategy);
        } else {
            Stream<StreamingHttpServiceFilterFactory> nonOffloadingFilters = this.noOffloadServiceFilters.stream();
            if (computedStrategy.isRequestResponseOffloaded()) {
                executionContext = this.buildExecutionContext(REQRESP_OFFLOADS.missing(computedStrategy));
                BooleanSupplier shouldOffload = executionContext.ioExecutor().shouldOffloadSupplier();
                OffloadingFilter offloadingFilter = new OffloadingFilter(computedStrategy, DefaultHttpServerBuilder.buildFactory(this.serviceFilters), shouldOffload);
                nonOffloadingFilters = Stream.concat(nonOffloadingFilters, Stream.of(offloadingFilter));
            } else {
                nonOffloadingFilters = Stream.concat(nonOffloadingFilters, this.serviceFilters.stream());
                executionContext = this.buildExecutionContext(computedStrategy);
            }
            filteredService = DefaultHttpServerBuilder.buildService(nonOffloadingFilters, rawService);
        }
        HttpExecutionStrategy builderStrategy = this.strategy;
        return this.doBind(executionContext, connectionAcceptor, filteredService, earlyConnectionAcceptor, lateConnectionAcceptor).afterOnSuccess(serverContext -> {
            if (builderStrategy != HttpExecutionStrategies.defaultStrategy() && builderStrategy.missing(computedStrategy) != HttpExecutionStrategies.offloadNone()) {
                LOGGER.info("Server for address {} created with the builder strategy {} but resulting computed strategy is {}. One of the filters or a final service enforce additional offloading. To find out what filter or service is it, enable debug level logging for {}.", serverContext.listenAddress(), builderStrategy, computedStrategy, DefaultHttpServerBuilder.class);
            } else if (builderStrategy == computedStrategy) {
                LOGGER.debug("Server for address {} created with the execution strategy {}.", (Object)serverContext.listenAddress(), (Object)computedStrategy);
            } else {
                LOGGER.debug("Server for address {} created with the builder strategy {}, resulting computed strategy is {}.", serverContext.listenAddress(), builderStrategy, computedStrategy);
            }
        });
    }

    private Single<HttpServerContext> doBind(HttpExecutionContext executionContext, @Nullable InfluencerConnectionAcceptor connectionAcceptor, StreamingHttpService service, @Nullable EarlyConnectionAcceptor earlyConnectionAcceptor, @Nullable LateConnectionAcceptor lateConnectionAcceptor) {
        ReadOnlyHttpServerConfig roConfig = this.config.asReadOnly();
        StreamingHttpService filteredService = DefaultHttpServerBuilder.applyInternalFilters(service, roConfig.lifecycleObserver());
        if (roConfig.tcpConfig().isAlpnConfigured()) {
            return DeferredServerChannelBinder.bind(executionContext, roConfig, this.address, connectionAcceptor, filteredService, this.drainRequestPayloadBody, false, earlyConnectionAcceptor, lateConnectionAcceptor);
        }
        if (roConfig.tcpConfig().sniMapping() != null) {
            return DeferredServerChannelBinder.bind(executionContext, roConfig, this.address, connectionAcceptor, filteredService, this.drainRequestPayloadBody, true, earlyConnectionAcceptor, lateConnectionAcceptor);
        }
        if (roConfig.isH2PriorKnowledge()) {
            return H2ServerParentConnectionContext.bind(executionContext, roConfig, this.address, connectionAcceptor, filteredService, this.drainRequestPayloadBody, earlyConnectionAcceptor, lateConnectionAcceptor);
        }
        return NettyHttpServer.bind(executionContext, roConfig, this.address, connectionAcceptor, filteredService, this.drainRequestPayloadBody, earlyConnectionAcceptor, lateConnectionAcceptor);
    }

    private <T extends HttpExecutionStrategyInfluencer> HttpExecutionStrategy computeServiceStrategy(Class<T> clazz, T service) {
        HttpExecutionStrategy serviceStrategy = service.requiredOffloads();
        LOGGER.debug("{} '{}' requires {} strategy.", clazz.getSimpleName(), service, serviceStrategy);
        HttpExecutionStrategy builderStrategy = this.strategy;
        HttpExecutionStrategy computedStrategy = DefaultHttpServerBuilder.computeRequiredStrategy(this.serviceFilters, serviceStrategy);
        return HttpExecutionStrategies.defaultStrategy() == builderStrategy ? computedStrategy : (builderStrategy.hasOffloads() ? builderStrategy.merge(computedStrategy) : builderStrategy);
    }

    @Nullable
    private static EarlyConnectionAcceptor buildEarlyConnectionAcceptor(List<EarlyConnectionAcceptor> acceptors) {
        return acceptors.stream().reduce((prev, acceptor) -> new EarlyConnectionAcceptor((EarlyConnectionAcceptor)prev, (EarlyConnectionAcceptor)acceptor){
            final /* synthetic */ EarlyConnectionAcceptor val$prev;
            final /* synthetic */ EarlyConnectionAcceptor val$acceptor;
            {
                this.val$prev = earlyConnectionAcceptor;
                this.val$acceptor = earlyConnectionAcceptor2;
            }

            @Override
            public Completable accept(ConnectionInfo info) {
                return this.val$prev.accept(info).concat(Completable.defer(() -> this.val$acceptor.accept(info)));
            }

            @Override
            public ConnectExecutionStrategy requiredOffloads() {
                return this.val$prev.requiredOffloads().merge(this.val$acceptor.requiredOffloads());
            }
        }).orElse(null);
    }

    @Nullable
    private static LateConnectionAcceptor buildLateConnectionAcceptor(List<LateConnectionAcceptor> acceptors) {
        return acceptors.stream().reduce((prev, acceptor) -> new LateConnectionAcceptor((LateConnectionAcceptor)prev, (LateConnectionAcceptor)acceptor){
            final /* synthetic */ LateConnectionAcceptor val$prev;
            final /* synthetic */ LateConnectionAcceptor val$acceptor;
            {
                this.val$prev = lateConnectionAcceptor;
                this.val$acceptor = lateConnectionAcceptor2;
            }

            @Override
            public Completable accept(ConnectionInfo info) {
                return this.val$prev.accept(info).concat(Completable.defer(() -> this.val$acceptor.accept(info)));
            }

            @Override
            public ConnectExecutionStrategy requiredOffloads() {
                return this.val$prev.requiredOffloads().merge(this.val$acceptor.requiredOffloads());
            }
        }).orElse(null);
    }

    private static StreamingHttpService applyInternalFilters(StreamingHttpService service, @Nullable HttpLifecycleObserver lifecycleObserver) {
        service = HttpExceptionMapperServiceFilter.INSTANCE.create(service);
        service = KeepAliveServiceFilter.INSTANCE.create(service);
        if (lifecycleObserver != null) {
            service = new HttpLifecycleObserverServiceFilter(lifecycleObserver).create(service);
        }
        return service;
    }

    private static final class KeepAliveServiceFilter
    implements StreamingHttpServiceFilterFactory {
        static final StreamingHttpServiceFilterFactory INSTANCE = new KeepAliveServiceFilter();

        private KeepAliveServiceFilter() {
        }

        @Override
        public StreamingHttpServiceFilter create(StreamingHttpService service) {
            return new StreamingHttpServiceFilter(service){

                @Override
                public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory) {
                    HttpKeepAlive keepAlive = HttpKeepAlive.responseKeepAlive(request);
                    return this.delegate().handle(ctx, request, responseFactory).map(response -> {
                        keepAlive.addConnectionHeaderIfNecessary((StreamingHttpResponse)response);
                        return response;
                    });
                }
            };
        }

        @Override
        public HttpExecutionStrategy requiredOffloads() {
            return HttpExecutionStrategies.offloadNone();
        }
    }
}

