/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.PayloadTooLargeException;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilter;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.serializer.api.SerializationException;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpExceptionMapperServiceFilter
implements StreamingHttpServiceFilterFactory {
    public static final StreamingHttpServiceFilterFactory INSTANCE = new HttpExceptionMapperServiceFilter();
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpExceptionMapperServiceFilter.class);

    private HttpExceptionMapperServiceFilter() {
    }

    @Override
    public StreamingHttpServiceFilter create(StreamingHttpService service) {
        return new StreamingHttpServiceFilter(service){

            @Override
            public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory) {
                Single<StreamingHttpResponse> respSingle;
                try {
                    respSingle = this.delegate().handle(ctx, request, responseFactory);
                }
                catch (Throwable cause2) {
                    respSingle = Single.failed(cause2);
                }
                return respSingle.onErrorReturn(cause -> HttpExceptionMapperServiceFilter.newErrorResponse(cause, ctx, request, responseFactory));
            }
        };
    }

    private static StreamingHttpResponse newErrorResponse(Throwable cause, HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory) {
        HttpResponseStatus status;
        if (cause instanceof RejectedExecutionException) {
            status = HttpResponseStatus.SERVICE_UNAVAILABLE;
            LOGGER.error("Task rejected by service processing for connection='{}', request='{} {} {}'. Returning: {}", ctx, request.method(), request.requestTarget(), request.version(), status, cause);
        } else if (cause instanceof SerializationException) {
            status = HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE;
            LOGGER.error("Failed to deserialize or serialize for connection='{}', request='{} {} {}'. Returning: {}", ctx, request.method(), request.requestTarget(), request.version(), status, cause);
        } else if (cause instanceof PayloadTooLargeException) {
            status = HttpResponseStatus.PAYLOAD_TOO_LARGE;
        } else {
            status = HttpResponseStatus.INTERNAL_SERVER_ERROR;
            LOGGER.error("Unexpected exception during service processing for connection='{}', request='{} {} {}'. Trying to return: {}", ctx, request.method(), request.requestTarget(), request.version(), status, cause);
        }
        return responseFactory.newResponse(status).setHeader(HttpHeaderNames.CONTENT_LENGTH, HttpHeaderValues.ZERO);
    }

    @Override
    public HttpExecutionStrategy requiredOffloads() {
        return HttpExecutionStrategies.offloadNone();
    }
}

