/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.context.api.ContextMap;
import io.servicetalk.encoding.api.BufferEncoder;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.http.api.AbstractHttpMetaData;
import io.servicetalk.http.api.HttpAuthorityFormUri;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpQuery;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.Uri;
import io.servicetalk.http.api.Uri3986;
import io.servicetalk.http.api.UriComponentType;
import io.servicetalk.http.api.UriUtils;
import io.servicetalk.transport.api.HostAndPort;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

class DefaultHttpRequestMetaData
extends AbstractHttpMetaData
implements HttpRequestMetaData {
    private static final Charset REQUEST_TARGET_CHARSET = StandardCharsets.UTF_8;
    static final int DEFAULT_MAX_QUERY_PARAMS = 1024;
    private HttpRequestMethod method;
    private String requestTarget;
    @Nullable
    private HttpQuery httpQuery;
    @Nullable
    private Uri requestTargetUri;
    @Nullable
    private String pathDecoded;
    @Nullable
    private String queryDecoded;
    @Nullable
    private BufferEncoder encoder;

    DefaultHttpRequestMetaData(HttpRequestMethod method, String requestTarget, HttpProtocolVersion version, HttpHeaders headers, @Nullable ContextMap context) {
        super(version, headers, context);
        this.method = Objects.requireNonNull(method);
        this.requestTarget = Objects.requireNonNull(requestTarget);
    }

    @Override
    public HttpRequestMetaData version(HttpProtocolVersion version) {
        super.version(version);
        return this;
    }

    @Override
    @Deprecated
    public HttpRequestMetaData encoding(ContentCodec encoding) {
        super.encoding(encoding);
        return this;
    }

    @Override
    @Nullable
    public BufferEncoder contentEncoding() {
        return this.encoder;
    }

    @Override
    public HttpRequestMetaData contentEncoding(@Nullable BufferEncoder encoder) {
        this.encoder = encoder;
        return this;
    }

    @Override
    public HttpRequestMetaData context(ContextMap context) {
        super.context(context);
        return this;
    }

    @Override
    public final HttpRequestMethod method() {
        return this.method;
    }

    @Override
    public HttpRequestMetaData method(HttpRequestMethod method) {
        this.method = Objects.requireNonNull(method);
        return this;
    }

    @Override
    public final String requestTarget() {
        this.checkDirtyQuery();
        return this.requestTarget;
    }

    @Override
    public String requestTarget(Charset encoding) {
        return HttpRequestMethod.CONNECT.equals(this.method) ? HttpAuthorityFormUri.decode(this.requestTarget(), encoding) : Uri3986.decode(this.requestTarget(), encoding);
    }

    @Override
    public HttpRequestMetaData requestTarget(String requestTarget) {
        this.requestTarget = Objects.requireNonNull(requestTarget);
        this.invalidateParsedUri();
        return this;
    }

    @Override
    public HttpRequestMetaData requestTarget(String requestTarget, Charset encoding) {
        return this.requestTarget(HttpRequestMethod.CONNECT.equals(this.method) ? HttpAuthorityFormUri.encode(requestTarget, encoding) : Uri3986.encode(requestTarget, encoding, true));
    }

    @Override
    @Nullable
    public final String scheme() {
        return this.lazyParseRequestTarget().scheme();
    }

    @Override
    @Nullable
    public final String userInfo() {
        return this.lazyParseRequestTarget().userInfo();
    }

    @Override
    @Nullable
    public final String host() {
        return this.lazyParseRequestTarget().host();
    }

    @Override
    public final int port() {
        return this.lazyParseRequestTarget().port();
    }

    @Override
    public final String rawPath() {
        return this.lazyParseRequestTarget().path();
    }

    @Override
    public HttpRequestMetaData rawPath(String path) {
        Uri httpUri = this.lazyParseRequestTarget();
        DefaultHttpRequestMetaData.validateFirstPathSegment(httpUri, path);
        StringBuilder sb = new StringBuilder(httpUri.uri().length() + path.length());
        DefaultHttpRequestMetaData.appendScheme(sb, httpUri);
        DefaultHttpRequestMetaData.appendAuthority(sb, httpUri);
        String host = httpUri.host();
        if (host != null && !host.isEmpty() && !path.isEmpty() && path.charAt(0) != '/') {
            sb.append('/');
        }
        sb.append(path);
        DefaultHttpRequestMetaData.appendQuery(sb, httpUri);
        DefaultHttpRequestMetaData.appendFragment(sb, httpUri);
        return this.requestTarget(sb.toString());
    }

    @Override
    public final String path() {
        if (this.pathDecoded != null) {
            return this.pathDecoded;
        }
        this.pathDecoded = this.lazyParseRequestTarget().path(REQUEST_TARGET_CHARSET);
        return this.pathDecoded;
    }

    @Override
    public HttpRequestMetaData path(String path) {
        return this.rawPath(UriUtils.encodeComponent(UriComponentType.PATH, path, REQUEST_TARGET_CHARSET, true));
    }

    @Override
    public HttpRequestMetaData appendPathSegments(String ... segments) {
        if (segments.length == 0) {
            throw new IllegalArgumentException("At least one path segment must be provided");
        }
        Uri httpUri = this.lazyParseRequestTarget();
        StringBuilder sb = new StringBuilder(httpUri.uri().length() + segments.length * 8);
        DefaultHttpRequestMetaData.appendScheme(sb, httpUri);
        DefaultHttpRequestMetaData.appendAuthority(sb, httpUri);
        String path = httpUri.path();
        String segment = UriUtils.encodeComponent(UriComponentType.PATH_SEGMENT, segments[0], REQUEST_TARGET_CHARSET, false);
        if (path.isEmpty() || path.length() == 1 && path.charAt(0) == '/') {
            DefaultHttpRequestMetaData.validateFirstPathSegment(httpUri, segment);
        }
        sb.append(path);
        if ((path.isEmpty() || path.charAt(path.length() - 1) != '/') && sb.length() != 0) {
            sb.append('/');
        }
        sb.append(segment);
        for (int i = 1; i < segments.length; ++i) {
            sb.append('/').append(UriUtils.encodeComponent(UriComponentType.PATH_SEGMENT, segments[i], REQUEST_TARGET_CHARSET, false));
        }
        DefaultHttpRequestMetaData.appendQuery(sb, httpUri);
        DefaultHttpRequestMetaData.appendFragment(sb, httpUri);
        return this.requestTarget(sb.toString());
    }

    @Override
    public final String rawQuery() {
        this.checkDirtyQuery();
        return this.lazyParseRequestTarget().query();
    }

    @Override
    public HttpRequestMetaData rawQuery(@Nullable String query) {
        Uri httpUri = this.lazyParseRequestTarget();
        StringBuilder sb = query != null ? new StringBuilder(httpUri.uri().length() + query.length() + 1) : new StringBuilder(httpUri.uri().length());
        DefaultHttpRequestMetaData.appendScheme(sb, httpUri);
        DefaultHttpRequestMetaData.appendAuthority(sb, httpUri);
        sb.append(httpUri.path());
        if (query != null) {
            sb.append('?').append(query);
        }
        DefaultHttpRequestMetaData.appendFragment(sb, httpUri);
        return this.requestTarget(sb.toString());
    }

    @Override
    public String query() {
        this.checkDirtyQuery();
        if (this.queryDecoded != null) {
            return this.queryDecoded;
        }
        this.queryDecoded = this.lazyParseRequestTarget().query(REQUEST_TARGET_CHARSET);
        return this.queryDecoded;
    }

    @Override
    public HttpRequestMetaData query(@Nullable String query) {
        return this.rawQuery(query == null ? null : UriUtils.encodeComponent(UriComponentType.QUERY, query, REQUEST_TARGET_CHARSET, true));
    }

    @Override
    @Nullable
    public String queryParameter(String key) {
        return this.lazyParseQueryString().get(key);
    }

    @Override
    public Iterable<Map.Entry<String, String>> queryParameters() {
        return this.lazyParseQueryString();
    }

    @Override
    public Iterable<String> queryParameters(String key) {
        return this.lazyParseQueryString().values(key);
    }

    @Override
    public Iterator<String> queryParametersIterator(String key) {
        return this.lazyParseQueryString().valuesIterator(key);
    }

    @Override
    public Set<String> queryParametersKeys() {
        return this.lazyParseQueryString().keys();
    }

    @Override
    public boolean hasQueryParameter(String key, String value) {
        return this.lazyParseQueryString().contains(key, value);
    }

    @Override
    public int queryParametersSize() {
        return this.lazyParseQueryString().size();
    }

    @Override
    public HttpRequestMetaData addQueryParameter(String key, String value) {
        this.lazyParseQueryString().add(key, value);
        return this;
    }

    @Override
    public HttpRequestMetaData addQueryParameters(String key, Iterable<String> values) {
        this.lazyParseQueryString().add(key, values);
        return this;
    }

    @Override
    public HttpRequestMetaData addQueryParameters(String key, String ... values) {
        this.lazyParseQueryString().add(key, values);
        return this;
    }

    @Override
    public HttpRequestMetaData setQueryParameter(String key, String value) {
        this.lazyParseQueryString().set(key, value);
        return this;
    }

    @Override
    public HttpRequestMetaData setQueryParameters(String key, Iterable<String> values) {
        this.lazyParseQueryString().set(key, values);
        return this;
    }

    @Override
    public HttpRequestMetaData setQueryParameters(String key, String ... values) {
        this.lazyParseQueryString().set(key, values);
        return this;
    }

    @Override
    public boolean removeQueryParameters(String key) {
        return this.lazyParseQueryString().remove(key);
    }

    @Override
    public boolean removeQueryParameters(String key, String value) {
        return this.lazyParseQueryString().remove(key, value);
    }

    @Override
    public HostAndPort effectiveHostAndPort() {
        Uri effectiveRequestUri = this.lazyParseRequestTarget();
        String effectiveRequestUriHost = effectiveRequestUri.host();
        if (effectiveRequestUriHost != null) {
            return HostAndPort.of(effectiveRequestUriHost, effectiveRequestUri.port());
        }
        CharSequence hostHeader = this.headers().get(HttpHeaderNames.HOST);
        if (hostHeader != null) {
            return DefaultHttpRequestMetaData.parseHostHeader(hostHeader.toString());
        }
        return null;
    }

    private void checkDirtyQuery() {
        if (this.httpQuery != null && this.httpQuery.isDirty()) {
            this.httpQuery.resetDirty();
            this.query(this.httpQuery.queryParameters());
        }
    }

    private HttpQuery lazyParseQueryString() {
        if (this.httpQuery == null) {
            this.httpQuery = new HttpQuery(UriUtils.decodeQueryParams(this.lazyParseRequestTarget().query(), REQUEST_TARGET_CHARSET, 1024));
        }
        return this.httpQuery;
    }

    private Uri lazyParseRequestTarget() {
        if (this.requestTargetUri == null) {
            this.requestTargetUri = HttpRequestMethod.CONNECT.equals(this.method) ? new HttpAuthorityFormUri(this.requestTarget()) : new Uri3986(this.requestTarget());
        }
        return this.requestTargetUri;
    }

    private void query(Map<String, List<String>> params) {
        Uri httpUri = this.lazyParseRequestTarget();
        StringBuilder sb = new StringBuilder(httpUri.uri().length() + params.size() * 8);
        DefaultHttpRequestMetaData.appendScheme(sb, httpUri);
        DefaultHttpRequestMetaData.appendAuthority(sb, httpUri);
        sb.append(httpUri.path());
        Iterator<Map.Entry<String, List<String>>> itr = params.entrySet().iterator();
        int prefixChar = 63;
        while (itr.hasNext()) {
            Iterator<String> valuesItr;
            Map.Entry<String, List<String>> next = itr.next();
            String encodedKey = UriUtils.encodeComponent(UriComponentType.QUERY, next.getKey(), REQUEST_TARGET_CHARSET, true);
            sb.append((char)prefixChar).append(encodedKey);
            List<String> values = next.getValue();
            if (values != null && (valuesItr = values.iterator()).hasNext()) {
                String value = valuesItr.next();
                sb.append('=').append(UriUtils.encodeComponent(UriComponentType.QUERY_VALUE, value, REQUEST_TARGET_CHARSET, true));
                while (valuesItr.hasNext()) {
                    value = valuesItr.next();
                    sb.append('&').append(encodedKey).append('=').append(UriUtils.encodeComponent(UriComponentType.QUERY_VALUE, value, REQUEST_TARGET_CHARSET, true));
                }
            }
            prefixChar = 38;
        }
        DefaultHttpRequestMetaData.appendFragment(sb, httpUri);
        this.requestTarget(sb.toString());
    }

    @Override
    @Nullable
    public String fragment() {
        return this.lazyParseRequestTarget().fragment();
    }

    @Override
    public HttpRequestMetaData fragment(@Nullable String fragment) {
        String origFragment = this.fragment();
        if (fragment == null && origFragment == null || Objects.equals(origFragment, fragment)) {
            return this;
        }
        String originalRequestTarget = this.requestTarget();
        if (origFragment != null) {
            int fragmentLength = origFragment.length() + 1;
            originalRequestTarget = originalRequestTarget.substring(0, originalRequestTarget.length() - fragmentLength);
        }
        return this.requestTarget(fragment == null ? originalRequestTarget : originalRequestTarget + "#" + fragment);
    }

    private void invalidateParsedUri() {
        this.requestTargetUri = null;
        this.httpQuery = null;
        this.pathDecoded = null;
        this.queryDecoded = null;
    }

    @Override
    public final String toString() {
        return this.method().toString() + " " + this.requestTarget() + " " + this.version();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultHttpRequestMetaData that = (DefaultHttpRequestMetaData)o;
        return this.method.equals(that.method) && this.requestTarget().equals(that.requestTarget());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.method.hashCode();
        result = 31 * result + this.requestTarget().hashCode();
        return result;
    }

    private static void validateFirstPathSegment(Uri httpUri, String path) {
        String scheme = httpUri.scheme();
        if (scheme == null || scheme.isEmpty()) {
            char c;
            for (int i = 0; i < path.length() && (c = path.charAt(i)) != '/'; ++i) {
                if (c != ':') continue;
                throw new IllegalArgumentException("relative-path cannot contain `:` in first segment");
            }
        }
        if (httpUri.host() == null && path.length() >= 2 && path.charAt(0) == '/' && path.charAt(1) == '/') {
            throw new IllegalArgumentException("No authority component, path cannot start with '//'");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static HostAndPort parseHostHeader(String parsedHostHeader) {
        String parsedHost;
        if (parsedHostHeader.isEmpty()) {
            return null;
        }
        int parsedPort = -1;
        if (parsedHostHeader.charAt(0) == '[') {
            int x = parsedHostHeader.lastIndexOf(93);
            if (x <= 0) {
                throw new IllegalArgumentException("IPv6 address should be in square brackets, and not empty");
            }
            parsedHost = parsedHostHeader.substring(0, x + 1);
            if (parsedHostHeader.length() - 1 <= x) return HostAndPort.of(parsedHost, parsedPort);
            if (parsedHostHeader.charAt(x + 1) != ':') throw new IllegalArgumentException("Unexpected content after IPv6 address");
            parsedPort = UriUtils.parsePort(parsedHostHeader, x + 2, parsedHostHeader.length());
            return HostAndPort.of(parsedHost, parsedPort);
        } else {
            int x = parsedHostHeader.lastIndexOf(58);
            if (x < 0) {
                parsedHost = parsedHostHeader;
                return HostAndPort.of(parsedHost, parsedPort);
            } else {
                parsedHost = parsedHostHeader.substring(0, x);
                parsedPort = UriUtils.parsePort(parsedHostHeader, x + 1, parsedHostHeader.length());
            }
        }
        return HostAndPort.of(parsedHost, parsedPort);
    }

    private static void appendScheme(StringBuilder sb, Uri httpUri) {
        if (httpUri.scheme() != null) {
            sb.append(httpUri.scheme()).append(':');
        }
    }

    private static void appendAuthority(StringBuilder sb, Uri httpUri) {
        if (httpUri.host() != null) {
            sb.append("//");
            if (httpUri.userInfo() != null) {
                sb.append(httpUri.userInfo()).append('@');
            }
            sb.append(httpUri.host());
            if (httpUri.port() >= 0) {
                sb.append(':').append(httpUri.port());
            }
        }
    }

    private static void appendQuery(StringBuilder sb, Uri httpUri) {
        String query = httpUri.query();
        if (query != null) {
            sb.append('?').append(query);
        }
    }

    private static void appendFragment(StringBuilder sb, Uri httpUri) {
        String fragment = httpUri.fragment();
        if (fragment != null) {
            sb.append('#').append(fragment);
        }
    }
}

