/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.internal.CloseableIteratorBufferAsInputStream;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.http.api.HttpCookiePair;
import io.servicetalk.http.api.HttpDeserializer;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpMessageBodyIterable;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.HttpSetCookie;
import io.servicetalk.http.api.HttpStreamingDeserializer;
import io.servicetalk.http.api.HttpStreamingSerializer;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.TrailersTransformer;
import java.io.InputStream;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public interface BlockingStreamingHttpResponse
extends HttpResponseMetaData {
    public BlockingIterable<Buffer> payloadBody();

    default public InputStream payloadBodyInputStream() {
        return new CloseableIteratorBufferAsInputStream(this.payloadBody().iterator());
    }

    @Deprecated
    default public <T> BlockingIterable<T> payloadBody(HttpDeserializer<T> deserializer) {
        return deserializer.deserialize(this.headers(), this.payloadBody());
    }

    public <T> BlockingIterable<T> payloadBody(HttpStreamingDeserializer<T> var1);

    public HttpMessageBodyIterable<Buffer> messageBody();

    public <T> HttpMessageBodyIterable<T> messageBody(HttpStreamingDeserializer<T> var1);

    public BlockingStreamingHttpResponse payloadBody(Iterable<Buffer> var1);

    public BlockingStreamingHttpResponse payloadBody(InputStream var1);

    public BlockingStreamingHttpResponse messageBody(HttpMessageBodyIterable<Buffer> var1);

    @Deprecated
    default public <T> BlockingStreamingHttpResponse payloadBody(Iterable<T> payloadBody, HttpSerializer<T> serializer) {
        throw new UnsupportedOperationException("BlockingStreamingHttpResponse#payloadBody(Iterable, HttpSerializer) is not supported by " + this.getClass() + ". This method is deprecated, consider migrating to BlockingStreamingHttpResponse#payloadBody(Iterable, HttpStreamingSerializer) or implement this method if it's required temporarily.");
    }

    public <T> BlockingStreamingHttpResponse payloadBody(Iterable<T> var1, HttpStreamingSerializer<T> var2);

    public <T> BlockingStreamingHttpResponse messageBody(HttpMessageBodyIterable<T> var1, HttpStreamingSerializer<T> var2);

    @Deprecated
    default public <T> BlockingStreamingHttpResponse transformPayloadBody(Function<BlockingIterable<Buffer>, BlockingIterable<T>> transformer, HttpSerializer<T> serializer) {
        throw new UnsupportedOperationException("BlockingStreamingHttpResponse#transformPayloadBody(Function, HttpSerializer) is not supported by " + this.getClass() + ". This method is deprecated, consider migrating to alternative methods or implement this method if it's required temporarily.");
    }

    @Deprecated
    default public <T, R> BlockingStreamingHttpResponse transformPayloadBody(Function<BlockingIterable<T>, BlockingIterable<R>> transformer, HttpDeserializer<T> deserializer, HttpSerializer<R> serializer) {
        return this.transformPayloadBody(buffers -> (BlockingIterable)transformer.apply(this.payloadBody(deserializer)), serializer);
    }

    @Deprecated
    default public BlockingStreamingHttpResponse transformPayloadBody(UnaryOperator<BlockingIterable<Buffer>> transformer) {
        throw new UnsupportedOperationException("BlockingStreamingHttpResponse#transformPayloadBody(UnaryOperator) is not supported by " + this.getClass() + ". This method is deprecated, consider migrating to alternative methods or implement this method if it's required temporarily.");
    }

    @Deprecated
    default public <T> BlockingStreamingHttpResponse transform(TrailersTransformer<T, Buffer> trailersTransformer) {
        throw new UnsupportedOperationException("BlockingStreamingHttpResponse#transform(TrailersTransformer) is not supported by " + this.getClass() + ". This method is deprecated, consider migrating to alternative methods or implement this method if it's required temporarily.");
    }

    public Single<HttpResponse> toResponse();

    public StreamingHttpResponse toStreamingResponse();

    @Override
    public BlockingStreamingHttpResponse version(HttpProtocolVersion var1);

    @Override
    public BlockingStreamingHttpResponse status(HttpResponseStatus var1);

    @Override
    @Deprecated
    default public BlockingStreamingHttpResponse encoding(ContentCodec encoding) {
        throw new UnsupportedOperationException("BlockingStreamingHttpResponse#encoding(ContentCodec) is not supported by " + this.getClass() + ". This method is deprecated, consider migrating to provided alternatives or implement this method if it's required temporarily.");
    }

    @Override
    default public BlockingStreamingHttpResponse addHeader(CharSequence name, CharSequence value) {
        HttpResponseMetaData.super.addHeader(name, value);
        return this;
    }

    @Override
    default public BlockingStreamingHttpResponse addHeaders(HttpHeaders headers) {
        HttpResponseMetaData.super.addHeaders(headers);
        return this;
    }

    @Override
    default public BlockingStreamingHttpResponse setHeader(CharSequence name, CharSequence value) {
        HttpResponseMetaData.super.setHeader(name, value);
        return this;
    }

    @Override
    default public BlockingStreamingHttpResponse setHeaders(HttpHeaders headers) {
        HttpResponseMetaData.super.setHeaders(headers);
        return this;
    }

    @Override
    default public BlockingStreamingHttpResponse addCookie(HttpCookiePair cookie) {
        HttpResponseMetaData.super.addCookie(cookie);
        return this;
    }

    @Override
    default public BlockingStreamingHttpResponse addCookie(CharSequence name, CharSequence value) {
        HttpResponseMetaData.super.addCookie(name, value);
        return this;
    }

    @Override
    default public BlockingStreamingHttpResponse addSetCookie(HttpSetCookie cookie) {
        HttpResponseMetaData.super.addSetCookie(cookie);
        return this;
    }

    @Override
    default public BlockingStreamingHttpResponse addSetCookie(CharSequence name, CharSequence value) {
        HttpResponseMetaData.super.addSetCookie(name, value);
        return this;
    }

    @Override
    public BlockingStreamingHttpResponse context(ContextMap var1);
}

