/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.data.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.async.ByteArrayFeeder;
import com.fasterxml.jackson.core.async.ByteBufferFeeder;
import com.fasterxml.jackson.core.async.NonBlockingInputFeeder;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.PublisherOperator;
import io.servicetalk.concurrent.internal.ConcurrentSubscription;
import io.servicetalk.concurrent.internal.EmptySubscriptions;
import io.servicetalk.data.jackson.JacksonSerializer;
import io.servicetalk.serializer.api.SerializationException;
import io.servicetalk.serializer.api.StreamingSerializerDeserializer;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.function.Function;
import javax.annotation.Nullable;

final class JacksonStreamingSerializer<T>
implements StreamingSerializerDeserializer<T> {
    private final ObjectWriter writer;
    private final ObjectReader reader;

    JacksonStreamingSerializer(ObjectMapper mapper, Class<T> clazz) {
        this.writer = mapper.writerFor(clazz);
        this.reader = mapper.readerFor(clazz);
    }

    JacksonStreamingSerializer(ObjectMapper mapper, TypeReference<T> typeRef) {
        this.writer = mapper.writerFor(typeRef);
        this.reader = mapper.readerFor(typeRef);
    }

    JacksonStreamingSerializer(ObjectMapper mapper, JavaType type) {
        this.writer = mapper.writerFor(type);
        this.reader = mapper.readerFor(type);
    }

    @Override
    public Publisher<Buffer> serialize(Publisher<T> toSerialize, BufferAllocator allocator) {
        return toSerialize.map(t -> {
            Buffer buffer = allocator.newBuffer();
            JacksonSerializer.doSerialize(this.writer, t, buffer);
            return buffer;
        });
    }

    @Override
    public Publisher<T> deserialize(Publisher<Buffer> serializedData, BufferAllocator allocator) {
        return serializedData.liftSync(new DeserializeOperator(this.reader)).flatMapConcatIterable(Function.identity());
    }

    private static final class DeserializeOperator<T>
    implements PublisherOperator<Buffer, Iterable<T>> {
        private final ObjectReader reader;

        private DeserializeOperator(ObjectReader reader) {
            this.reader = reader;
        }

        @Override
        public PublisherSource.Subscriber<? super Buffer> apply(PublisherSource.Subscriber<? super Iterable<T>> subscriber) {
            JsonParser parser;
            try {
                parser = this.reader.getFactory().createNonBlockingByteArrayParser();
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
            NonBlockingInputFeeder feeder = parser.getNonBlockingInputFeeder();
            if (feeder instanceof ByteBufferFeeder) {
                return new ByteBufferDeserializeSubscriber(subscriber, this.reader, parser, (ByteBufferFeeder)feeder);
            }
            if (feeder instanceof ByteArrayFeeder) {
                return new ByteArrayDeserializeSubscriber(subscriber, this.reader, parser, (ByteArrayFeeder)feeder);
            }
            return new FailedSubscriber(subscriber, new SerializationException("unsupported feeder type: " + feeder));
        }

        private static final class FailedSubscriber<T>
        implements PublisherSource.Subscriber<Buffer> {
            private final SerializationException exception;
            private final PublisherSource.Subscriber<? super Iterable<T>> subscriber;

            private FailedSubscriber(PublisherSource.Subscriber<? super Iterable<T>> subscriber, SerializationException exception) {
                this.subscriber = subscriber;
                this.exception = exception;
            }

            @Override
            public void onSubscribe(PublisherSource.Subscription subscription) {
                try {
                    this.subscriber.onSubscribe(EmptySubscriptions.EMPTY_SUBSCRIPTION);
                }
                catch (Throwable cause) {
                    this.subscriber.onError(cause);
                    return;
                }
                this.subscriber.onError(this.exception);
            }

            @Override
            public void onNext(@Nullable Buffer buffer) {
            }

            @Override
            public void onError(Throwable t) {
            }

            @Override
            public void onComplete() {
            }
        }

        private static abstract class DeserializeSubscriber<T>
        implements PublisherSource.Subscriber<Buffer> {
            private final JsonParser parser;
            private final ObjectReader reader;
            private final NonBlockingInputFeeder feeder;
            private final Deque<JsonNode> tokenStack = new ArrayDeque<JsonNode>(8);
            private final PublisherSource.Subscriber<? super Iterable<T>> subscriber;
            @Nullable
            private PublisherSource.Subscription subscription;
            @Nullable
            private String fieldName;

            private DeserializeSubscriber(PublisherSource.Subscriber<? super Iterable<T>> subscriber, ObjectReader reader, JsonParser parser, NonBlockingInputFeeder feeder) {
                this.reader = reader;
                this.parser = parser;
                this.subscriber = subscriber;
                this.feeder = feeder;
            }

            abstract boolean consumeOnNext(Buffer var1) throws IOException;

            @Override
            public final void onSubscribe(PublisherSource.Subscription subscription) {
                this.subscription = ConcurrentSubscription.wrap(subscription);
                this.subscriber.onSubscribe(this.subscription);
            }

            @Override
            public final void onNext(@Nullable Buffer buffer) {
                assert (this.subscription != null);
                try {
                    if (buffer == null || this.consumeOnNext(buffer)) {
                        this.subscription.request(1L);
                    } else {
                        JsonToken token;
                        ArrayList values = null;
                        Object value = null;
                        while ((token = this.parser.nextToken()) != JsonToken.NOT_AVAILABLE) {
                            JsonNode nextRoot = this.push(token, this.parser);
                            if (nextRoot == null) continue;
                            if (values != null) {
                                values.add(this.reader.readValue(nextRoot));
                                continue;
                            }
                            if (value == null) {
                                value = this.reader.readValue(nextRoot);
                                continue;
                            }
                            values = new ArrayList(3);
                            values.add(value);
                            value = null;
                            values.add(this.reader.readValue(nextRoot));
                        }
                        if (values != null) {
                            this.subscriber.onNext(values);
                        } else if (value != null) {
                            this.subscriber.onNext(Collections.singletonList(value));
                        } else {
                            this.subscription.request(1L);
                        }
                    }
                }
                catch (IOException e) {
                    throw new SerializationException(e);
                }
            }

            @Override
            public void onError(Throwable t) {
                this.feeder.endOfInput();
                this.subscriber.onError(t);
            }

            @Override
            public void onComplete() {
                this.feeder.endOfInput();
                if (this.tokenStack.isEmpty()) {
                    this.subscriber.onComplete();
                } else {
                    this.subscriber.onError(new SerializationException("completed with " + this.tokenStack.size() + " tokens pending"));
                }
            }

            @Nullable
            private JsonNode push(JsonToken event, JsonParser parser) throws IOException {
                switch (event) {
                    case START_OBJECT: {
                        this.tokenStack.push(this.createObject(this.tokenStack.peek()));
                        return null;
                    }
                    case START_ARRAY: {
                        this.tokenStack.push(this.createArray(this.tokenStack.peek()));
                        return null;
                    }
                    case END_OBJECT: 
                    case END_ARRAY: {
                        JsonNode top = this.tokenStack.pop();
                        return this.tokenStack.isEmpty() ? top : null;
                    }
                    case FIELD_NAME: {
                        assert (!this.tokenStack.isEmpty());
                        this.fieldName = parser.getCurrentName();
                        return null;
                    }
                    case VALUE_STRING: {
                        if (this.tokenStack.isEmpty()) {
                            return new TextNode(parser.getValueAsString());
                        }
                        this.addValue(this.tokenStack.peek(), parser.getValueAsString());
                        return null;
                    }
                    case VALUE_NUMBER_INT: {
                        this.addValue(this.peekNonNull(), parser.getLongValue());
                        return null;
                    }
                    case VALUE_NUMBER_FLOAT: {
                        this.addValue(this.peekNonNull(), parser.getDoubleValue());
                        return null;
                    }
                    case VALUE_TRUE: {
                        if (this.tokenStack.isEmpty()) {
                            return BooleanNode.TRUE;
                        }
                        this.addValue(this.tokenStack.peek(), true);
                        return null;
                    }
                    case VALUE_FALSE: {
                        if (this.tokenStack.isEmpty()) {
                            return BooleanNode.FALSE;
                        }
                        this.addValue(this.tokenStack.peek(), false);
                        return null;
                    }
                    case VALUE_NULL: {
                        if (this.tokenStack.isEmpty()) {
                            return NullNode.getInstance();
                        }
                        this.addNull(this.tokenStack.peek());
                        return null;
                    }
                }
                throw new IllegalArgumentException("unsupported event: " + (Object)((Object)event));
            }

            private JsonNode peekNonNull() {
                JsonNode node = this.tokenStack.peek();
                assert (node != null);
                return node;
            }

            private JsonNode createObject(@Nullable JsonNode current) {
                if (current instanceof ObjectNode) {
                    return ((ObjectNode)current).putObject(this.fieldName);
                }
                if (current instanceof ArrayNode) {
                    return ((ArrayNode)current).addObject();
                }
                return JsonNodeFactory.instance.objectNode();
            }

            private JsonNode createArray(@Nullable JsonNode current) {
                if (current instanceof ObjectNode) {
                    return ((ObjectNode)current).putArray(this.fieldName);
                }
                if (current instanceof ArrayNode) {
                    return ((ArrayNode)current).addArray();
                }
                return JsonNodeFactory.instance.arrayNode();
            }

            private void addValue(JsonNode current, String s) {
                if (current instanceof ObjectNode) {
                    ((ObjectNode)current).put(this.fieldName, s);
                } else {
                    ((ArrayNode)current).add(s);
                }
            }

            private void addValue(JsonNode current, long v) {
                if (current instanceof ObjectNode) {
                    ((ObjectNode)current).put(this.fieldName, v);
                } else {
                    ((ArrayNode)current).add(v);
                }
            }

            private void addValue(JsonNode current, double v) {
                if (current instanceof ObjectNode) {
                    ((ObjectNode)current).put(this.fieldName, v);
                } else {
                    ((ArrayNode)current).add(v);
                }
            }

            private void addValue(JsonNode current, boolean v) {
                if (current instanceof ObjectNode) {
                    ((ObjectNode)current).put(this.fieldName, v);
                } else {
                    ((ArrayNode)current).add(v);
                }
            }

            private void addNull(JsonNode current) {
                if (current instanceof ObjectNode) {
                    ((ObjectNode)current).putNull(this.fieldName);
                } else {
                    ((ArrayNode)current).addNull();
                }
            }
        }

        private static final class ByteBufferDeserializeSubscriber<T>
        extends DeserializeSubscriber<T> {
            private final ByteBufferFeeder feeder;

            private ByteBufferDeserializeSubscriber(PublisherSource.Subscriber<? super Iterable<T>> subscriber, ObjectReader reader, JsonParser parser, ByteBufferFeeder feeder) {
                super(subscriber, reader, parser, feeder);
                this.feeder = feeder;
            }

            @Override
            boolean consumeOnNext(Buffer buffer) throws IOException {
                this.feeder.feedInput(buffer.toNioBuffer());
                return this.feeder.needMoreInput();
            }
        }

        private static final class ByteArrayDeserializeSubscriber<T>
        extends DeserializeSubscriber<T> {
            private final ByteArrayFeeder feeder;

            private ByteArrayDeserializeSubscriber(PublisherSource.Subscriber<? super Iterable<T>> subscriber, ObjectReader reader, JsonParser parser, ByteArrayFeeder feeder) {
                super(subscriber, reader, parser, feeder);
                this.feeder = feeder;
            }

            @Override
            boolean consumeOnNext(Buffer buffer) throws IOException {
                if (buffer.hasArray()) {
                    int start = buffer.arrayOffset() + buffer.readerIndex();
                    this.feeder.feedInput(buffer.array(), start, start + buffer.readableBytes());
                } else {
                    int readableBytes = buffer.readableBytes();
                    if (readableBytes != 0) {
                        byte[] copy = new byte[readableBytes];
                        buffer.readBytes(copy);
                        this.feeder.feedInput(copy, 0, copy.length);
                    }
                }
                return this.feeder.needMoreInput();
            }
        }
    }
}

