/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AfterFinallyPublisher;
import io.servicetalk.concurrent.api.AfterSubscriberPublisher;
import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.BeforeFinallyPublisher;
import io.servicetalk.concurrent.api.BeforeSubscriberPublisher;
import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.BiIntPredicate;
import io.servicetalk.concurrent.api.BufferStrategy;
import io.servicetalk.concurrent.api.CloseableIteratorAsInputStream;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ConcatPublisher;
import io.servicetalk.concurrent.api.EmptyPublisher;
import io.servicetalk.concurrent.api.ErrorPublisher;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.FilterPublisher;
import io.servicetalk.concurrent.api.ForEachSubscriber;
import io.servicetalk.concurrent.api.FromArrayPublisher;
import io.servicetalk.concurrent.api.FromBlockingIterablePublisher;
import io.servicetalk.concurrent.api.FromInputStreamPublisher;
import io.servicetalk.concurrent.api.FromIterablePublisher;
import io.servicetalk.concurrent.api.FromNPublisher;
import io.servicetalk.concurrent.api.FromSingleItemPublisher;
import io.servicetalk.concurrent.api.GroupedPublisher;
import io.servicetalk.concurrent.api.LiftAsynchronousPublisherOperator;
import io.servicetalk.concurrent.api.LiftSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.LiftSynchronousPublisherToSingle;
import io.servicetalk.concurrent.api.LongBinaryConsumer;
import io.servicetalk.concurrent.api.MapPublisher;
import io.servicetalk.concurrent.api.MulticastPublisher;
import io.servicetalk.concurrent.api.NeverPublisher;
import io.servicetalk.concurrent.api.OnErrorCompletePublisher;
import io.servicetalk.concurrent.api.OnErrorMapPublisher;
import io.servicetalk.concurrent.api.OnErrorResumePublisher;
import io.servicetalk.concurrent.api.PubCompletableOrError;
import io.servicetalk.concurrent.api.PubFirstOrError;
import io.servicetalk.concurrent.api.PubToCompletableIgnore;
import io.servicetalk.concurrent.api.PubToSingleFirstOrElse;
import io.servicetalk.concurrent.api.PublishAndSubscribeOnPublishers;
import io.servicetalk.concurrent.api.PublisherAsBlockingIterable;
import io.servicetalk.concurrent.api.PublisherBuffer;
import io.servicetalk.concurrent.api.PublisherConcatMapIterable;
import io.servicetalk.concurrent.api.PublisherConcatWithCompletable;
import io.servicetalk.concurrent.api.PublisherConcatWithSingle;
import io.servicetalk.concurrent.api.PublisherDefer;
import io.servicetalk.concurrent.api.PublisherDoOnUtils;
import io.servicetalk.concurrent.api.PublisherFlatMapConcatUtils;
import io.servicetalk.concurrent.api.PublisherFlatMapMerge;
import io.servicetalk.concurrent.api.PublisherFlatMapSingle;
import io.servicetalk.concurrent.api.PublisherGroupBy;
import io.servicetalk.concurrent.api.PublisherGroupToMany;
import io.servicetalk.concurrent.api.PublisherOperator;
import io.servicetalk.concurrent.api.PublisherShareContextOnSubscribe;
import io.servicetalk.concurrent.api.PublisherToSingleOperator;
import io.servicetalk.concurrent.api.RangeIntPublisher;
import io.servicetalk.concurrent.api.RedoPublisher;
import io.servicetalk.concurrent.api.RedoWhenPublisher;
import io.servicetalk.concurrent.api.ReduceSingle;
import io.servicetalk.concurrent.api.RunnableTerminalSignalConsumer;
import io.servicetalk.concurrent.api.ScanWithLifetimeMapper;
import io.servicetalk.concurrent.api.ScanWithLifetimePublisher;
import io.servicetalk.concurrent.api.ScanWithMapper;
import io.servicetalk.concurrent.api.ScanWithPublisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.TakeNPublisher;
import io.servicetalk.concurrent.api.TakeUntilPublisher;
import io.servicetalk.concurrent.api.TakeWhilePublisher;
import io.servicetalk.concurrent.api.TerminalSignalConsumer;
import io.servicetalk.concurrent.api.TimeoutDemandPublisher;
import io.servicetalk.concurrent.api.TimeoutPublisher;
import io.servicetalk.concurrent.api.ValidateDemandPublisher;
import io.servicetalk.concurrent.api.WhenSubscriptionPublisher;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.utils.internal.DurationUtils;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.ObjLongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Publisher<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Publisher.class);

    protected Publisher() {
    }

    public final <R> Publisher<R> map(Function<? super T, ? extends R> mapper) {
        return new MapPublisher<R, T>(this, mapper);
    }

    public final <R> Publisher<R> cast(Class<R> clazz) {
        return this.map(clazz::cast);
    }

    public final Publisher<T> filter(Predicate<? super T> predicate) {
        return this.filter(() -> predicate);
    }

    public final <R> Publisher<R> ofType(Class<R> clazz) {
        return this.filter(clazz::isInstance).cast(clazz);
    }

    final Publisher<T> filter(Supplier<? extends Predicate<? super T>> filterSupplier) {
        return new FilterPublisher(this, filterSupplier);
    }

    public final Publisher<T> distinct() {
        return this.filter(FilterPublisher.newDistinctSupplier());
    }

    public final <R> Publisher<R> scanWith(Supplier<R> initial, BiFunction<R, ? super T, R> accumulator) {
        return new ScanWithPublisher<T, R>(this, initial, accumulator);
    }

    public final <R> Publisher<R> scanWith(Supplier<? extends ScanWithMapper<? super T, ? extends R>> mapperSupplier) {
        return new ScanWithPublisher(this, mapperSupplier);
    }

    public final <R> Publisher<R> scanWithLifetime(Supplier<? extends ScanWithLifetimeMapper<? super T, ? extends R>> mapperSupplier) {
        return new ScanWithLifetimePublisher(this, mapperSupplier);
    }

    public final Publisher<T> onErrorComplete() {
        return this.onErrorComplete((? super Throwable t) -> true);
    }

    public final <E extends Throwable> Publisher<T> onErrorComplete(Class<E> type) {
        return this.onErrorComplete(type::isInstance);
    }

    public final Publisher<T> onErrorComplete(Predicate<? super Throwable> predicate) {
        return new OnErrorCompletePublisher(this, predicate);
    }

    public final Publisher<T> onErrorReturn(Function<? super Throwable, ? extends T> itemSupplier) {
        return this.onErrorReturn((? super Throwable t) -> true, itemSupplier);
    }

    public final <E extends Throwable> Publisher<T> onErrorReturn(Class<E> type, Function<? super E, ? extends T> itemSupplier) {
        Function<? super E, ? extends T> rawSupplier = itemSupplier;
        return this.onErrorReturn(type::isInstance, rawSupplier);
    }

    public final Publisher<T> onErrorReturn(Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends T> itemSupplier) {
        Objects.requireNonNull(itemSupplier);
        return this.onErrorResume(predicate, (? super Throwable t) -> Publisher.from(itemSupplier.apply((Throwable)t)));
    }

    public final Publisher<T> onErrorMap(Function<? super Throwable, ? extends Throwable> mapper) {
        return this.onErrorMap((? super Throwable t) -> true, mapper);
    }

    public final <E extends Throwable> Publisher<T> onErrorMap(Class<E> type, Function<? super E, ? extends Throwable> mapper) {
        Function<? super E, ? extends Throwable> rawMapper = mapper;
        return this.onErrorMap(type::isInstance, rawMapper);
    }

    public final Publisher<T> onErrorMap(Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends Throwable> mapper) {
        return new OnErrorMapPublisher(this, predicate, mapper);
    }

    public final Publisher<T> onErrorResume(Function<? super Throwable, ? extends Publisher<? extends T>> nextFactory) {
        return this.onErrorResume((? super Throwable t) -> true, nextFactory);
    }

    public final <E extends Throwable> Publisher<T> onErrorResume(Class<E> type, Function<? super E, ? extends Publisher<? extends T>> nextFactory) {
        Function<? super E, ? extends Publisher<? extends T>> rawNextFactory = nextFactory;
        return this.onErrorResume(type::isInstance, rawNextFactory);
    }

    public final Publisher<T> onErrorResume(Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends Publisher<? extends T>> nextFactory) {
        return new OnErrorResumePublisher(this, predicate, nextFactory);
    }

    public final <R> Publisher<R> flatMapMerge(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return new PublisherFlatMapMerge(this, mapper, false);
    }

    public final <R> Publisher<R> flatMapMerge(Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency) {
        return new PublisherFlatMapMerge(this, mapper, false, maxConcurrency);
    }

    public final <R> Publisher<R> flatMapMergeDelayError(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return new PublisherFlatMapMerge(this, mapper, true);
    }

    public final <R> Publisher<R> flatMapMergeDelayError(Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency) {
        return new PublisherFlatMapMerge(this, mapper, true, maxConcurrency);
    }

    public final <R> Publisher<R> flatMapMergeDelayError(Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, int maxDelayedErrorsHint) {
        if (maxDelayedErrorsHint <= 0) {
            throw new IllegalArgumentException("maxDelayedErrorsHint " + maxDelayedErrorsHint + " (expected >0)");
        }
        return new PublisherFlatMapMerge(this, mapper, maxDelayedErrorsHint, maxConcurrency);
    }

    public final <R> Publisher<R> flatMapMergeSingle(Function<? super T, ? extends Single<? extends R>> mapper) {
        return new PublisherFlatMapSingle(this, mapper, false);
    }

    public final <R> Publisher<R> flatMapMergeSingle(Function<? super T, ? extends Single<? extends R>> mapper, int maxConcurrency) {
        return new PublisherFlatMapSingle(this, mapper, false, maxConcurrency);
    }

    public final <R> Publisher<R> flatMapMergeSingleDelayError(Function<? super T, ? extends Single<? extends R>> mapper) {
        return new PublisherFlatMapSingle(this, mapper, true);
    }

    public final <R> Publisher<R> flatMapMergeSingleDelayError(Function<? super T, ? extends Single<? extends R>> mapper, int maxConcurrency) {
        return new PublisherFlatMapSingle(this, mapper, true, maxConcurrency);
    }

    public final <R> Publisher<R> flatMapMergeSingleDelayError(Function<? super T, ? extends Single<? extends R>> mapper, int maxConcurrency, int maxDelayedErrorsHint) {
        if (maxDelayedErrorsHint <= 0) {
            throw new IllegalArgumentException("maxDelayedErrorsHint " + maxDelayedErrorsHint + " (expected >0)");
        }
        return new PublisherFlatMapSingle(this, mapper, maxDelayedErrorsHint, maxConcurrency);
    }

    public final Completable flatMapCompletable(Function<? super T, ? extends Completable> mapper) {
        return this.flatMapMergeSingle(t -> ((Completable)mapper.apply(t)).toSingle()).ignoreElements();
    }

    public final Completable flatMapCompletable(Function<? super T, ? extends Completable> mapper, int maxConcurrency) {
        return this.flatMapMergeSingle(t -> ((Completable)mapper.apply(t)).toSingle(), maxConcurrency).ignoreElements();
    }

    public final Completable flatMapCompletableDelayError(Function<? super T, ? extends Completable> mapper) {
        return this.flatMapMergeSingleDelayError(t -> ((Completable)mapper.apply(t)).toSingle()).ignoreElements();
    }

    public final Completable flatMapCompletableDelayError(Function<? super T, ? extends Completable> mapper, int maxConcurrency) {
        return this.flatMapMergeSingleDelayError(t -> ((Completable)mapper.apply(t)).toSingle(), maxConcurrency).ignoreElements();
    }

    public final Completable flatMapCompletableDelayError(Function<? super T, ? extends Completable> mapper, int maxConcurrency, int maxDelayedErrorsHint) {
        return this.flatMapMergeSingleDelayError(t -> ((Completable)mapper.apply(t)).toSingle(), maxConcurrency, maxDelayedErrorsHint).ignoreElements();
    }

    public final <R> Publisher<R> flatMapConcatSingle(Function<? super T, ? extends Single<? extends R>> mapper) {
        return PublisherFlatMapConcatUtils.flatMapConcatSingle(this, mapper);
    }

    public final <R> Publisher<R> flatMapConcatSingle(Function<? super T, ? extends Single<? extends R>> mapper, int maxConcurrency) {
        return PublisherFlatMapConcatUtils.flatMapConcatSingle(this, mapper, maxConcurrency);
    }

    public final <R> Publisher<R> flatMapConcatSingleDelayError(Function<? super T, ? extends Single<? extends R>> mapper) {
        return PublisherFlatMapConcatUtils.flatMapConcatSingleDelayError(this, mapper);
    }

    public final <R> Publisher<R> flatMapConcatSingleDelayError(Function<? super T, ? extends Single<? extends R>> mapper, int maxConcurrency) {
        return PublisherFlatMapConcatUtils.flatMapConcatSingleDelayError(this, mapper, maxConcurrency);
    }

    public final <R> Publisher<R> flatMapConcatIterable(Function<? super T, ? extends Iterable<? extends R>> mapper) {
        return new PublisherConcatMapIterable(this, mapper);
    }

    public final Publisher<T> merge(Publisher<? extends T> other) {
        return Publisher.from(this, other).flatMapMerge(Function.identity(), 2);
    }

    public final Publisher<T> mergeDelayError(Publisher<? extends T> other) {
        return Publisher.from(this, other).flatMapMergeDelayError(Function.identity(), 2, 2);
    }

    public final Publisher<T> whenOnSubscribe(Consumer<? super PublisherSource.Subscription> onSubscribe) {
        return this.beforeOnSubscribe(onSubscribe);
    }

    public final Publisher<T> whenOnNext(Consumer<? super T> onNext) {
        return this.beforeOnNext(onNext);
    }

    public final Publisher<T> whenOnComplete(Runnable onComplete) {
        return this.beforeOnComplete(onComplete);
    }

    public final Publisher<T> whenOnError(Consumer<Throwable> onError) {
        return this.beforeOnError(onError);
    }

    public final Publisher<T> whenFinally(Runnable doFinally) {
        return this.beforeFinally(doFinally);
    }

    public final Publisher<T> whenFinally(TerminalSignalConsumer doFinally) {
        return this.beforeFinally(doFinally);
    }

    public final Publisher<T> whenRequest(LongConsumer onRequest) {
        return this.beforeRequest(onRequest);
    }

    public final Publisher<T> whenCancel(Runnable onCancel) {
        return this.beforeCancel(onCancel);
    }

    public final Publisher<T> validateOutstandingDemand() {
        return this.validateOutstandingDemand((next, demand) -> {}, (n, demand) -> {});
    }

    public final Publisher<T> validateOutstandingDemand(ObjLongConsumer<T> onNextConsumer, LongBinaryConsumer requestConsumer) {
        return new ValidateDemandPublisher<T>(this, onNextConsumer, requestConsumer);
    }

    public final Publisher<T> timeout(long duration, TimeUnit unit) {
        return this.timeout(duration, unit, Executors.global());
    }

    public final Publisher<T> timeout(Duration duration) {
        return this.timeout(duration, Executors.global());
    }

    public final Publisher<T> timeout(long duration, TimeUnit unit, Executor timeoutExecutor) {
        return new TimeoutPublisher(this, duration, unit, true, timeoutExecutor);
    }

    public final Publisher<T> timeout(Duration duration, Executor timeoutExecutor) {
        return this.timeout(DurationUtils.toNanos(duration), TimeUnit.NANOSECONDS, timeoutExecutor);
    }

    public final Publisher<T> timeoutTerminal(Duration duration) {
        return this.timeoutTerminal(duration, Executors.global());
    }

    public final Publisher<T> timeoutTerminal(Duration duration, Executor timeoutExecutor) {
        return this.timeoutTerminal(DurationUtils.toNanos(duration), TimeUnit.NANOSECONDS, timeoutExecutor);
    }

    public final Publisher<T> timeoutTerminal(long duration, TimeUnit unit) {
        return this.timeoutTerminal(duration, unit, Executors.global());
    }

    public final Publisher<T> timeoutTerminal(long duration, TimeUnit unit, Executor timeoutExecutor) {
        return new TimeoutPublisher(this, duration, unit, false, timeoutExecutor);
    }

    public final Publisher<T> timeoutDemand(long duration, TimeUnit unit) {
        return this.timeoutDemand(duration, unit, Executors.global());
    }

    public final Publisher<T> timeoutDemand(long duration, TimeUnit unit, Executor executor) {
        return new TimeoutDemandPublisher(this, duration, unit, executor);
    }

    public final Publisher<T> timeoutDemand(Duration duration) {
        return this.timeout(duration, Executors.global());
    }

    public final Publisher<T> timeoutDemand(Duration duration, Executor executor) {
        return new TimeoutDemandPublisher(this, DurationUtils.toNanos(duration), TimeUnit.NANOSECONDS, executor);
    }

    public final Publisher<T> concat(Publisher<? extends T> next) {
        return new ConcatPublisher<T>(this, next);
    }

    public final Publisher<T> concat(Single<? extends T> next) {
        return new PublisherConcatWithSingle<T>(this, next);
    }

    public final Publisher<T> concat(Completable next) {
        return new PublisherConcatWithCompletable(this, next, false);
    }

    public final Publisher<T> concatPropagateCancel(Completable next) {
        return new PublisherConcatWithCompletable(this, next, true);
    }

    public final Publisher<T> retry(BiIntPredicate<Throwable> shouldRetry) {
        return new RedoPublisher(this, (retryCount, terminalNotification) -> terminalNotification.cause() != null && shouldRetry.test((int)retryCount, terminalNotification.cause()));
    }

    public final Publisher<T> retryWhen(BiIntFunction<Throwable, ? extends Completable> retryWhen) {
        return new RedoWhenPublisher(this, (retryCount, notification) -> {
            if (notification.cause() == null) {
                return Completable.completed();
            }
            return (Completable)retryWhen.apply((int)retryCount, notification.cause());
        }, true);
    }

    public final Publisher<T> repeat(IntPredicate shouldRepeat) {
        return new RedoPublisher(this, (repeatCount, terminalNotification) -> terminalNotification.cause() == null && shouldRepeat.test((int)repeatCount));
    }

    public final Publisher<T> repeatWhen(IntFunction<? extends Completable> repeatWhen) {
        return new RedoWhenPublisher(this, (retryCount, notification) -> {
            if (notification.cause() != null) {
                return Completable.completed();
            }
            return (Completable)repeatWhen.apply((int)retryCount);
        }, false);
    }

    public final Publisher<T> skipWhile(Predicate<? super T> predicate) {
        return this.filter(FilterPublisher.skipWhileSupplier(predicate));
    }

    public final Publisher<T> takeAtMost(long numElements) {
        return new TakeNPublisher(this, numElements);
    }

    public final Publisher<T> takeWhile(Predicate<? super T> predicate) {
        return new TakeWhilePublisher<T>(this, predicate);
    }

    public final Publisher<T> takeUntil(Completable until) {
        return new TakeUntilPublisher(this, until);
    }

    public final <Key> Publisher<GroupedPublisher<Key, T>> groupBy(Function<? super T, ? extends Key> keySelector) {
        return this.groupBy(keySelector, 64);
    }

    public final <Key> Publisher<GroupedPublisher<Key, T>> groupBy(Function<? super T, ? extends Key> keySelector, int queueLimit) {
        return new PublisherGroupBy<Key, T>(this, keySelector, queueLimit);
    }

    public final <Key> Publisher<GroupedPublisher<Key, T>> groupBy(Function<? super T, ? extends Key> keySelector, int queueLimit, int expectedGroupCountHint) {
        return new PublisherGroupBy<Key, T>(this, keySelector, queueLimit, expectedGroupCountHint);
    }

    public final <Key> Publisher<GroupedPublisher<Key, T>> groupToMany(Function<? super T, ? extends Iterator<? extends Key>> keySelector, int queueLimit) {
        return new PublisherGroupToMany(this, keySelector, queueLimit);
    }

    public final <Key> Publisher<GroupedPublisher<Key, T>> groupToMany(Function<? super T, ? extends Iterator<? extends Key>> keySelector, int queueLimit, int expectedGroupCountHint) {
        return new PublisherGroupToMany(this, keySelector, queueLimit, expectedGroupCountHint);
    }

    @Deprecated
    public final Publisher<T> multicastToExactly(int expectedSubscribers) {
        return this.multicastToExactly(expectedSubscribers, 64);
    }

    @Deprecated
    public final Publisher<T> multicastToExactly(int expectedSubscribers, int queueLimit) {
        return new MulticastPublisher(this, expectedSubscribers, true, true, queueLimit, t -> Completable.completed());
    }

    public final Publisher<T> multicast(int minSubscribers) {
        return this.multicast(minSubscribers, true);
    }

    public final Publisher<T> multicast(int minSubscribers, boolean cancelUpstream) {
        return this.multicast(minSubscribers, 64, cancelUpstream);
    }

    public final Publisher<T> multicast(int minSubscribers, int queueLimit) {
        return this.multicast(minSubscribers, queueLimit, true);
    }

    public final Publisher<T> multicast(int minSubscribers, int queueLimit, boolean cancelUpstream) {
        return this.multicast(minSubscribers, queueLimit, cancelUpstream, t -> Completable.completed());
    }

    public final Publisher<T> multicast(int minSubscribers, int queueLimit, Function<Throwable, Completable> terminalResubscribe) {
        return this.multicast(minSubscribers, queueLimit, true, terminalResubscribe);
    }

    public final Publisher<T> multicast(int minSubscribers, int queueLimit, boolean cancelUpstream, Function<Throwable, Completable> terminalResubscribe) {
        return new MulticastPublisher(this, minSubscribers, false, cancelUpstream, queueLimit, terminalResubscribe);
    }

    public final <BC extends BufferStrategy.Accumulator<T, B>, B> Publisher<B> buffer(BufferStrategy<T, BC, B> strategy) {
        return new PublisherBuffer<T, B>(this, strategy);
    }

    public final Publisher<T> beforeOnSubscribe(Consumer<? super PublisherSource.Subscription> onSubscribe) {
        return this.beforeSubscriber(PublisherDoOnUtils.doOnSubscribeSupplier(onSubscribe));
    }

    public final Publisher<T> beforeOnNext(Consumer<? super T> onNext) {
        return this.beforeSubscriber(PublisherDoOnUtils.doOnNextSupplier(onNext));
    }

    public final Publisher<T> beforeOnError(Consumer<Throwable> onError) {
        return this.beforeSubscriber(PublisherDoOnUtils.doOnErrorSupplier(onError));
    }

    public final Publisher<T> beforeOnComplete(Runnable onComplete) {
        return this.beforeSubscriber(PublisherDoOnUtils.doOnCompleteSupplier(onComplete));
    }

    public final Publisher<T> beforeRequest(LongConsumer onRequest) {
        return this.beforeSubscription(PublisherDoOnUtils.doOnRequestSupplier(onRequest));
    }

    public final Publisher<T> beforeCancel(Runnable onCancel) {
        return this.beforeSubscription(PublisherDoOnUtils.doOnCancelSupplier(onCancel));
    }

    public final Publisher<T> beforeFinally(Runnable doFinally) {
        return this.beforeFinally(new RunnableTerminalSignalConsumer(doFinally));
    }

    public final Publisher<T> beforeFinally(TerminalSignalConsumer doFinally) {
        return new BeforeFinallyPublisher(this, doFinally);
    }

    public final Publisher<T> beforeSubscriber(Supplier<? extends PublisherSource.Subscriber<? super T>> subscriberSupplier) {
        return new BeforeSubscriberPublisher(this, subscriberSupplier);
    }

    public final Publisher<T> beforeSubscription(Supplier<? extends PublisherSource.Subscription> subscriptionSupplier) {
        return new WhenSubscriptionPublisher(this, subscriptionSupplier, true);
    }

    public final Publisher<T> afterOnSubscribe(Consumer<? super PublisherSource.Subscription> onSubscribe) {
        return this.afterSubscriber(PublisherDoOnUtils.doOnSubscribeSupplier(onSubscribe));
    }

    public final Publisher<T> afterOnNext(Consumer<? super T> onNext) {
        return this.afterSubscriber(PublisherDoOnUtils.doOnNextSupplier(onNext));
    }

    public final Publisher<T> afterOnError(Consumer<Throwable> onError) {
        return this.afterSubscriber(PublisherDoOnUtils.doOnErrorSupplier(onError));
    }

    public final Publisher<T> afterOnComplete(Runnable onComplete) {
        return this.afterSubscriber(PublisherDoOnUtils.doOnCompleteSupplier(onComplete));
    }

    public final Publisher<T> afterRequest(LongConsumer onRequest) {
        return this.afterSubscription(PublisherDoOnUtils.doOnRequestSupplier(onRequest));
    }

    public final Publisher<T> afterCancel(Runnable onCancel) {
        return this.afterSubscription(PublisherDoOnUtils.doOnCancelSupplier(onCancel));
    }

    public final Publisher<T> afterFinally(Runnable doFinally) {
        return this.afterFinally(new RunnableTerminalSignalConsumer(doFinally));
    }

    public final Publisher<T> afterFinally(TerminalSignalConsumer doFinally) {
        return new AfterFinallyPublisher(this, doFinally);
    }

    public final Publisher<T> afterSubscriber(Supplier<? extends PublisherSource.Subscriber<? super T>> subscriberSupplier) {
        return new AfterSubscriberPublisher(this, subscriberSupplier);
    }

    public final Publisher<T> whenSubscriber(Supplier<? extends PublisherSource.Subscriber<? super T>> subscriberSupplier) {
        return this.beforeSubscriber(subscriberSupplier);
    }

    public final Publisher<T> afterSubscription(Supplier<? extends PublisherSource.Subscription> subscriptionSupplier) {
        return new WhenSubscriptionPublisher(this, subscriptionSupplier, false);
    }

    public final Publisher<T> whenSubscription(Supplier<? extends PublisherSource.Subscription> subscriptionSupplier) {
        return this.beforeSubscription(subscriptionSupplier);
    }

    public final Cancellable forEach(Consumer<? super T> forEach) {
        ForEachSubscriber<? super T> subscriber = new ForEachSubscriber<T>(forEach);
        this.subscribeInternal(subscriber);
        return subscriber;
    }

    public final Publisher<T> publishOn(Executor executor) {
        return PublishAndSubscribeOnPublishers.publishOn(this, Boolean.TRUE::booleanValue, executor);
    }

    public final Publisher<T> publishOn(Executor executor, BooleanSupplier shouldOffload) {
        return PublishAndSubscribeOnPublishers.publishOn(this, shouldOffload, executor);
    }

    public final Publisher<T> subscribeOn(Executor executor) {
        return PublishAndSubscribeOnPublishers.subscribeOn(this, Boolean.TRUE::booleanValue, executor);
    }

    public final Publisher<T> subscribeOn(Executor executor, BooleanSupplier shouldOffload) {
        return PublishAndSubscribeOnPublishers.subscribeOn(this, shouldOffload, executor);
    }

    public final Publisher<T> shareContextOnSubscribe() {
        return new PublisherShareContextOnSubscribe(this);
    }

    public final <R> Publisher<R> liftSync(PublisherOperator<? super T, ? extends R> operator) {
        return new LiftSynchronousPublisherOperator<T, R>(this, operator);
    }

    public final <R> Single<R> liftSyncToSingle(PublisherToSingleOperator<? super T, ? extends R> operator) {
        return new LiftSynchronousPublisherToSingle<T, R>(this, operator);
    }

    public final <R> Publisher<R> liftAsync(PublisherOperator<? super T, ? extends R> operator) {
        return new LiftAsynchronousPublisherOperator<T, R>(this, operator);
    }

    public final Single<T> firstOrElse(Supplier<T> defaultValueSupplier) {
        return new PubToSingleFirstOrElse<T>(this, defaultValueSupplier);
    }

    public final Single<T> firstOrError() {
        return new PubFirstOrError(this);
    }

    public final Completable ignoreElements() {
        return new PubToCompletableIgnore(this);
    }

    public final Completable completableOrError() {
        return new PubCompletableOrError(this);
    }

    public final <R> Single<R> collect(Supplier<? extends R> resultFactory, BiFunction<? super R, ? super T, R> collector) {
        return new ReduceSingle<R, T>(this, resultFactory, collector);
    }

    public final Future<Collection<T>> toFuture() {
        return this.toFuture(ArrayList::new, (list, next) -> {
            list.add(next);
            return list;
        });
    }

    public final <R> Future<R> toFuture(Supplier<? extends R> resultFactory, BiFunction<? super R, ? super T, R> reducer) {
        return this.collect(resultFactory, reducer).toFuture();
    }

    public final CompletionStage<Collection<T>> toCompletionStage() {
        return this.toCompletionStage(ArrayList::new, (list, next) -> {
            list.add(next);
            return list;
        });
    }

    public final <R> CompletionStage<R> toCompletionStage(Supplier<? extends R> resultFactory, BiFunction<? super R, ? super T, R> reducer) {
        return this.collect(resultFactory, reducer).toCompletionStage();
    }

    public final InputStream toInputStream(Function<? super T, byte[]> serializer) {
        return new CloseableIteratorAsInputStream<T>(new PublisherAsBlockingIterable(this).iterator(), serializer);
    }

    public final InputStream toInputStream(Function<? super T, byte[]> serializer, int queueCapacity) {
        return new CloseableIteratorAsInputStream<T>(new PublisherAsBlockingIterable(this, queueCapacity).iterator(), serializer);
    }

    public final BlockingIterable<T> toIterable() {
        return new PublisherAsBlockingIterable(this);
    }

    public final BlockingIterable<T> toIterable(int queueCapacityHint) {
        return new PublisherAsBlockingIterable(this, queueCapacityHint);
    }

    ContextMap contextForSubscribe(AsyncContextProvider provider) {
        return provider.context().copy();
    }

    protected void subscribeInternal(PublisherSource.Subscriber<? super T> subscriber) {
        AsyncContextProvider contextProvider = AsyncContext.provider();
        ContextMap contextMap = this.contextForSubscribe(contextProvider);
        this.subscribeWithContext(subscriber, contextProvider, contextMap);
    }

    protected abstract void handleSubscribe(PublisherSource.Subscriber<? super T> var1);

    public static <T> Publisher<T> from(@Nullable T value) {
        return new FromSingleItemPublisher<T>(value);
    }

    public static <T> Publisher<T> from(@Nullable T v1, @Nullable T v2) {
        return new FromNPublisher<T>(v1, v2);
    }

    public static <T> Publisher<T> from(@Nullable T v1, @Nullable T v2, @Nullable T v3) {
        return new FromNPublisher<T>(v1, v2, v3);
    }

    @SafeVarargs
    public static <T> Publisher<T> from(T ... values) {
        return new FromArrayPublisher<T>(values);
    }

    public static <T> Publisher<T> fromIterable(Iterable<? extends T> iterable) {
        return FromIterablePublisher.fromIterable0(iterable);
    }

    public static <T> Publisher<T> fromBlockingIterable(BlockingIterable<? extends T> iterable, LongSupplier timeoutSupplier, TimeUnit unit) {
        return FromBlockingIterablePublisher.fromBlockingIterable0(iterable, timeoutSupplier, unit);
    }

    public static Publisher<byte[]> fromInputStream(InputStream stream) {
        return new FromInputStreamPublisher(stream);
    }

    public static Publisher<byte[]> fromInputStream(InputStream stream, int readChunkSize) {
        return new FromInputStreamPublisher(stream, readChunkSize);
    }

    public static Publisher<Integer> range(int begin, int end) {
        return new RangeIntPublisher(begin, end);
    }

    public static Publisher<Integer> range(int begin, int end, int stride) {
        return new RangeIntPublisher(begin, end, stride);
    }

    public static <T> Publisher<T> empty() {
        return EmptyPublisher.emptyPublisher();
    }

    public static <T> Publisher<T> never() {
        return NeverPublisher.neverPublisher();
    }

    public static <T> Publisher<T> failed(Throwable cause) {
        return new ErrorPublisher(cause);
    }

    public static <T> Publisher<T> defer(Supplier<? extends Publisher<? extends T>> publisherSupplier) {
        return new PublisherDefer(publisherSupplier);
    }

    @SafeVarargs
    public static <T> Publisher<T> mergeAll(Publisher<? extends T> ... publishers) {
        return Publisher.from(publishers).flatMapMerge(Function.identity());
    }

    @SafeVarargs
    public static <T> Publisher<T> mergeAll(int maxConcurrency, Publisher<? extends T> ... publishers) {
        return Publisher.from(publishers).flatMapMerge(Function.identity(), maxConcurrency);
    }

    @SafeVarargs
    public static <T> Publisher<T> mergeAllDelayError(Publisher<? extends T> ... publishers) {
        return Publisher.from(publishers).flatMapMergeDelayError(Function.identity());
    }

    @SafeVarargs
    public static <T> Publisher<T> mergeAllDelayError(int maxConcurrency, Publisher<? extends T> ... publishers) {
        return Publisher.from(publishers).flatMapMergeDelayError(Function.identity(), maxConcurrency);
    }

    final void delegateSubscribe(PublisherSource.Subscriber<? super T> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
        this.handleSubscribe(subscriber, contextMap, contextProvider);
    }

    private void subscribeWithContext(PublisherSource.Subscriber<? super T> subscriber, AsyncContextProvider provider, ContextMap contextMap) {
        Objects.requireNonNull(subscriber);
        PublisherSource.Subscriber<? super T> wrapped = provider.wrapSubscription(subscriber, contextMap);
        if (provider.context() == contextMap) {
            this.handleSubscribe(wrapped, contextMap, provider);
        } else {
            provider.wrapRunnable(() -> this.handleSubscribe(wrapped, contextMap, provider), contextMap).run();
        }
    }

    void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
        try {
            PublisherSource.Subscriber<? super T> wrapped = contextProvider.wrapPublisherSubscriber(subscriber, contextMap);
            this.handleSubscribe(wrapped);
        }
        catch (Throwable t) {
            LOGGER.warn("Unexpected exception from subscribe(), assuming no interaction with the Subscriber.", t);
            SubscriberUtils.deliverErrorFromSource(subscriber, t);
        }
    }

    static {
        AsyncContext.autoEnable();
    }
}

