/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.client.api;

import io.servicetalk.client.api.ClientGroup;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.SourceAdapters;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultClientGroup<Key, Client extends ListenableAsyncCloseable>
implements ClientGroup<Key, Client> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClientGroup.class);
    private static final String CLOSED_EXCEPTION_MSG = "This group has been closed";
    private static final ListenableAsyncCloseable PLACEHOLDER_CLIENT = new ListenableAsyncCloseable(){
        private static final String PLACEHOLDER_EXCEPTION_MSG = "This placeholder Client should never be returned from the ClientGroup)";

        @Override
        public Completable onClose() {
            return Completable.failed(new UnsupportedOperationException(PLACEHOLDER_EXCEPTION_MSG));
        }

        @Override
        public Completable closeAsync() {
            return Completable.failed(new UnsupportedOperationException(PLACEHOLDER_EXCEPTION_MSG));
        }
    };
    private volatile boolean closed;
    private final ConcurrentMap<Key, ListenableAsyncCloseable> clientMap = new ConcurrentHashMap<Key, ListenableAsyncCloseable>();
    private final Function<Key, Client> clientFactory;
    private final ListenableAsyncCloseable asyncCloseable = AsyncCloseables.toAsyncCloseable(graceful -> {
        this.closed = true;
        return Completable.completed().mergeDelayError(this.clientMap.keySet().stream().map(this.clientMap::remove).filter(client -> client != null && client != PLACEHOLDER_CLIENT).map(closeable -> graceful ? closeable.closeAsyncGracefully() : closeable.closeAsync()).collect(Collectors.toList()));
    });

    DefaultClientGroup(Function<Key, Client> factory) {
        this.clientFactory = Objects.requireNonNull(factory);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Client get(Key key) {
        block10: {
            do lbl-1000:
            // 3 sources

            {
                if ((client = (ListenableAsyncCloseable)this.clientMap.get(key)) != null && client != DefaultClientGroup.PLACEHOLDER_CLIENT) {
                    return (Client)client;
                }
                if (client == DefaultClientGroup.PLACEHOLDER_CLIENT) ** GOTO lbl-1000
                client = this.clientMap.putIfAbsent(key, DefaultClientGroup.PLACEHOLDER_CLIENT);
                if (client == null) break block10;
            } while (client == DefaultClientGroup.PLACEHOLDER_CLIENT);
            return (Client)client;
        }
        if (this.closed) {
            removed = this.clientMap.remove(key, DefaultClientGroup.PLACEHOLDER_CLIENT);
            if (!DefaultClientGroup.$assertionsDisabled && !removed) {
                throw new AssertionError((Object)"Expected to remove PLACEHOLDER_CLIENT");
            }
            throw new IllegalStateException("This group has been closed");
        }
        try {
            client = (ListenableAsyncCloseable)Objects.requireNonNull(this.clientFactory.apply(key), "Newly created client can not be null");
        }
        catch (Throwable t) {
            removed = this.clientMap.remove(key, DefaultClientGroup.PLACEHOLDER_CLIENT);
            if (!DefaultClientGroup.$assertionsDisabled && !removed) {
                throw new AssertionError((Object)"Expected to remove PLACEHOLDER_CLIENT");
            }
            throw new IllegalArgumentException("Failed to create new client", t);
        }
        replaced = this.clientMap.replace(key, DefaultClientGroup.PLACEHOLDER_CLIENT, client);
        if (!DefaultClientGroup.$assertionsDisabled && !replaced) {
            throw new AssertionError((Object)"Expected to replace PLACEHOLDER_CLIENT");
        }
        SourceAdapters.toSource(client.onClose()).subscribe(new RemoveClientOnClose(key, client));
        DefaultClientGroup.LOGGER.debug("A new client {} was created", (Object)client);
        if (this.closed) {
            if (this.clientMap.remove(key, client)) {
                client.closeAsync().subscribe();
                DefaultClientGroup.LOGGER.debug("Recently created client {} was removed and closed, group {} closed", (Object)client, (Object)this);
            }
            throw new IllegalStateException("This group has been closed");
        }
        return (Client)client;
    }

    @Override
    public Completable onClose() {
        return this.asyncCloseable.onClose();
    }

    @Override
    public Completable onClosing() {
        return this.asyncCloseable.onClosing();
    }

    @Override
    public Completable closeAsync() {
        return this.asyncCloseable.closeAsync();
    }

    @Override
    public Completable closeAsyncGracefully() {
        return this.asyncCloseable.closeAsyncGracefully();
    }

    private final class RemoveClientOnClose
    implements CompletableSource.Subscriber {
        private final Key key;
        private final ListenableAsyncCloseable newClient;

        RemoveClientOnClose(Key key, ListenableAsyncCloseable newClient) {
            this.key = key;
            this.newClient = newClient;
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
        }

        @Override
        public void onComplete() {
            DefaultClientGroup.this.clientMap.remove(this.key, this.newClient);
        }

        @Override
        public void onError(Throwable t) {
            DefaultClientGroup.this.clientMap.remove(this.key, this.newClient);
        }
    }
}

