/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.buffer.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.ByteProcessor;
import io.servicetalk.buffer.netty.BufferUtils;
import io.servicetalk.buffer.netty.ReadOnlyBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

class NettyBuffer<T extends ByteBuf>
implements Buffer {
    final T buffer;

    NettyBuffer(T buffer) {
        this.buffer = buffer;
    }

    @Override
    public int capacity() {
        return ((ByteBuf)this.buffer).capacity();
    }

    @Override
    public Buffer capacity(int newCapacity) {
        ((ByteBuf)this.buffer).capacity(newCapacity);
        return this;
    }

    @Override
    public int maxCapacity() {
        return ((ByteBuf)this.buffer).maxCapacity();
    }

    @Override
    public int readerIndex() {
        return ((ByteBuf)this.buffer).readerIndex();
    }

    @Override
    public Buffer readerIndex(int readerIndex) {
        ((ByteBuf)this.buffer).readerIndex(readerIndex);
        return this;
    }

    @Override
    public int writerIndex() {
        return ((ByteBuf)this.buffer).writerIndex();
    }

    @Override
    public Buffer writerIndex(int writerIndex) {
        ((ByteBuf)this.buffer).writerIndex(writerIndex);
        return this;
    }

    @Override
    public int readableBytes() {
        return ((ByteBuf)this.buffer).readableBytes();
    }

    @Override
    public int writableBytes() {
        return ((ByteBuf)this.buffer).writableBytes();
    }

    @Override
    public int maxWritableBytes() {
        return ((ByteBuf)this.buffer).maxWritableBytes();
    }

    @Override
    public Buffer ensureWritable(int minWritableBytes) {
        ((ByteBuf)this.buffer).ensureWritable(minWritableBytes);
        return this;
    }

    @Override
    public int ensureWritable(int minWritableBytes, boolean force) {
        return ((ByteBuf)this.buffer).ensureWritable(minWritableBytes, force);
    }

    @Override
    public Buffer clear() {
        ((ByteBuf)this.buffer).clear();
        return this;
    }

    @Override
    public boolean getBoolean(int index) {
        return ((ByteBuf)this.buffer).getBoolean(index);
    }

    @Override
    public byte getByte(int index) {
        return ((ByteBuf)this.buffer).getByte(index);
    }

    @Override
    public short getUnsignedByte(int index) {
        return ((ByteBuf)this.buffer).getUnsignedByte(index);
    }

    @Override
    public short getShort(int index) {
        return ((ByteBuf)this.buffer).getShort(index);
    }

    @Override
    public short getShortLE(int index) {
        return ((ByteBuf)this.buffer).getShortLE(index);
    }

    @Override
    public int getUnsignedShort(int index) {
        return ((ByteBuf)this.buffer).getUnsignedShort(index);
    }

    @Override
    public int getUnsignedShortLE(int index) {
        return ((ByteBuf)this.buffer).getUnsignedShortLE(index);
    }

    @Override
    public int getMedium(int index) {
        return ((ByteBuf)this.buffer).getMedium(index);
    }

    @Override
    public int getMediumLE(int index) {
        return ((ByteBuf)this.buffer).getMediumLE(index);
    }

    @Override
    public int getUnsignedMedium(int index) {
        return ((ByteBuf)this.buffer).getUnsignedMedium(index);
    }

    @Override
    public int getUnsignedMediumLE(int index) {
        return ((ByteBuf)this.buffer).getUnsignedMediumLE(index);
    }

    @Override
    public int getInt(int index) {
        return ((ByteBuf)this.buffer).getInt(index);
    }

    @Override
    public int getIntLE(int index) {
        return ((ByteBuf)this.buffer).getIntLE(index);
    }

    @Override
    public long getUnsignedInt(int index) {
        return ((ByteBuf)this.buffer).getUnsignedInt(index);
    }

    @Override
    public long getUnsignedIntLE(int index) {
        return ((ByteBuf)this.buffer).getUnsignedIntLE(index);
    }

    @Override
    public long getLong(int index) {
        return ((ByteBuf)this.buffer).getLong(index);
    }

    @Override
    public long getLongLE(int index) {
        return ((ByteBuf)this.buffer).getLongLE(index);
    }

    @Override
    public char getChar(int index) {
        return ((ByteBuf)this.buffer).getChar(index);
    }

    @Override
    public float getFloat(int index) {
        return ((ByteBuf)this.buffer).getFloat(index);
    }

    @Override
    public double getDouble(int index) {
        return ((ByteBuf)this.buffer).getDouble(index);
    }

    @Override
    public Buffer getBytes(int index, Buffer dst) {
        return this.getBytes(index, dst, dst.writableBytes());
    }

    @Override
    public Buffer getBytes(int index, Buffer dst, int length) {
        this.getBytes(index, dst, dst.writerIndex(), length);
        dst.writerIndex(dst.writerIndex() + length);
        return this;
    }

    @Override
    public Buffer getBytes(int index, Buffer dst, int dstIndex, int length) {
        ByteBuf dstByteBuf = BufferUtils.toByteBufNoThrow(dst);
        if (dstByteBuf != null) {
            ((ByteBuf)this.buffer).getBytes(index, dstByteBuf, dstIndex, length);
        } else if (dst.hasArray()) {
            ((ByteBuf)this.buffer).getBytes(index, dst.array(), dst.arrayOffset() + dstIndex, length);
        } else {
            ByteBuffer nioBuffer = dst.toNioBuffer(dstIndex, length);
            ((ByteBuf)this.buffer).getBytes(index, nioBuffer);
        }
        return this;
    }

    @Override
    public Buffer getBytes(int index, byte[] dst) {
        return this.getBytes(index, dst, 0, dst.length);
    }

    @Override
    public Buffer getBytes(int index, byte[] dst, int dstIndex, int length) {
        ((ByteBuf)this.buffer).getBytes(index, dst, dstIndex, length);
        return this;
    }

    @Override
    public Buffer getBytes(int index, ByteBuffer dst) {
        ((ByteBuf)this.buffer).getBytes(index, dst);
        return this;
    }

    @Override
    public Buffer setBoolean(int index, boolean value) {
        ((ByteBuf)this.buffer).setBoolean(index, value);
        return this;
    }

    @Override
    public Buffer setByte(int index, int value) {
        ((ByteBuf)this.buffer).setByte(index, value);
        return this;
    }

    @Override
    public Buffer setShort(int index, int value) {
        ((ByteBuf)this.buffer).setShort(index, value);
        return this;
    }

    @Override
    public Buffer setShortLE(int index, int value) {
        ((ByteBuf)this.buffer).setShortLE(index, value);
        return this;
    }

    @Override
    public Buffer setMedium(int index, int value) {
        ((ByteBuf)this.buffer).setMedium(index, value);
        return this;
    }

    @Override
    public Buffer setMediumLE(int index, int value) {
        ((ByteBuf)this.buffer).setMediumLE(index, value);
        return this;
    }

    @Override
    public Buffer setInt(int index, int value) {
        ((ByteBuf)this.buffer).setInt(index, value);
        return this;
    }

    @Override
    public Buffer setIntLE(int index, int value) {
        ((ByteBuf)this.buffer).setIntLE(index, value);
        return this;
    }

    @Override
    public Buffer setLong(int index, long value) {
        ((ByteBuf)this.buffer).setLong(index, value);
        return this;
    }

    @Override
    public Buffer setLongLE(int index, long value) {
        ((ByteBuf)this.buffer).setLongLE(index, value);
        return this;
    }

    @Override
    public Buffer setChar(int index, int value) {
        ((ByteBuf)this.buffer).setChar(index, value);
        return this;
    }

    @Override
    public Buffer setFloat(int index, float value) {
        ((ByteBuf)this.buffer).setFloat(index, value);
        return this;
    }

    @Override
    public Buffer setDouble(int index, double value) {
        ((ByteBuf)this.buffer).setDouble(index, value);
        return this;
    }

    @Override
    public Buffer setBytes(int index, Buffer src) {
        return this.setBytes(index, src, src.readableBytes());
    }

    @Override
    public Buffer setBytes(int index, Buffer src, int length) {
        this.setBytes(index, src, src.readerIndex(), length);
        src.readerIndex(src.readerIndex() + length);
        return this;
    }

    @Override
    public Buffer setBytes(int index, Buffer src, int srcIndex, int length) {
        ByteBuf srcByteBuf = BufferUtils.toByteBufNoThrow(src);
        if (srcByteBuf != null) {
            ((ByteBuf)this.buffer).setBytes(index, srcByteBuf, srcIndex, length);
        } else if (src.hasArray()) {
            ((ByteBuf)this.buffer).setBytes(index, src.array(), src.arrayOffset() + srcIndex, length);
        } else {
            ByteBuffer nioBuffer = src.toNioBuffer(srcIndex, length);
            ((ByteBuf)this.buffer).setBytes(index, nioBuffer);
        }
        return this;
    }

    @Override
    public Buffer setBytes(int index, byte[] src) {
        return this.setBytes(index, src, 0, src.length);
    }

    @Override
    public Buffer setBytes(int index, byte[] src, int srcIndex, int length) {
        ((ByteBuf)this.buffer).setBytes(index, src, srcIndex, length);
        return this;
    }

    @Override
    public Buffer setBytes(int index, ByteBuffer src) {
        ((ByteBuf)this.buffer).setBytes(index, src);
        return this;
    }

    @Override
    public int setBytes(int index, InputStream src, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        int totalWritten = 0;
        int bytesWritten = 0;
        while (length > 0 && (bytesWritten = ((ByteBuf)this.buffer).setBytes(index, src, length)) >= 0) {
            totalWritten += bytesWritten;
            length -= bytesWritten;
            index += bytesWritten;
        }
        return bytesWritten < 0 && totalWritten == 0 ? -1 : totalWritten;
    }

    @Override
    public int setBytesUntilEndStream(int index, InputStream src, int chunkSize) throws IOException {
        int i = index;
        int writableBytes = chunkSize;
        while (true) {
            ((ByteBuf)this.buffer).ensureWritable(writableBytes);
            int result = ((ByteBuf)this.buffer).setBytes(i, src, chunkSize);
            if (result == -1) break;
            i += result;
            writableBytes += chunkSize;
        }
        return i - index;
    }

    @Override
    public boolean readBoolean() {
        return ((ByteBuf)this.buffer).readBoolean();
    }

    @Override
    public byte readByte() {
        return ((ByteBuf)this.buffer).readByte();
    }

    @Override
    public short readUnsignedByte() {
        return ((ByteBuf)this.buffer).readUnsignedByte();
    }

    @Override
    public short readShort() {
        return ((ByteBuf)this.buffer).readShort();
    }

    @Override
    public short readShortLE() {
        return ((ByteBuf)this.buffer).readShortLE();
    }

    @Override
    public int readUnsignedShort() {
        return ((ByteBuf)this.buffer).readUnsignedShort();
    }

    @Override
    public int readUnsignedShortLE() {
        return ((ByteBuf)this.buffer).readUnsignedShortLE();
    }

    @Override
    public int readMedium() {
        return ((ByteBuf)this.buffer).readMedium();
    }

    @Override
    public int readMediumLE() {
        return ((ByteBuf)this.buffer).readMediumLE();
    }

    @Override
    public int readUnsignedMedium() {
        return ((ByteBuf)this.buffer).readUnsignedMedium();
    }

    @Override
    public int readUnsignedMediumLE() {
        return ((ByteBuf)this.buffer).readUnsignedMediumLE();
    }

    @Override
    public int readInt() {
        return ((ByteBuf)this.buffer).readInt();
    }

    @Override
    public int readIntLE() {
        return ((ByteBuf)this.buffer).readIntLE();
    }

    @Override
    public long readUnsignedInt() {
        return ((ByteBuf)this.buffer).readUnsignedInt();
    }

    @Override
    public long readUnsignedIntLE() {
        return ((ByteBuf)this.buffer).readUnsignedIntLE();
    }

    @Override
    public long readLong() {
        return ((ByteBuf)this.buffer).readLong();
    }

    @Override
    public long readLongLE() {
        return ((ByteBuf)this.buffer).readLongLE();
    }

    @Override
    public char readChar() {
        return ((ByteBuf)this.buffer).readChar();
    }

    @Override
    public float readFloat() {
        return ((ByteBuf)this.buffer).readFloat();
    }

    @Override
    public double readDouble() {
        return ((ByteBuf)this.buffer).readDouble();
    }

    @Override
    public Buffer readSlice(int length) {
        return new NettyBuffer<ByteBuf>(((ByteBuf)this.buffer).readSlice(length));
    }

    @Override
    public Buffer readBytes(int length) {
        return new NettyBuffer<ByteBuf>(((ByteBuf)this.buffer).readBytes(length));
    }

    @Override
    public Buffer readBytes(Buffer dst) {
        return this.readBytes(dst, dst.writableBytes());
    }

    @Override
    public Buffer readBytes(Buffer dst, int length) {
        this.readBytes(dst, dst.writerIndex(), length);
        dst.writerIndex(dst.writerIndex() + length);
        return this;
    }

    @Override
    public Buffer readBytes(Buffer dst, int dstIndex, int length) {
        ByteBuf dstByteBuf = BufferUtils.toByteBufNoThrow(dst);
        if (dstByteBuf != null) {
            ((ByteBuf)this.buffer).readBytes(dstByteBuf, dstIndex, length);
        } else if (dst.hasArray()) {
            ((ByteBuf)this.buffer).readBytes(dst.array(), dst.arrayOffset() + dstIndex, length);
        } else {
            ByteBuffer nioBuffer = dst.toNioBuffer(dstIndex, length);
            ((ByteBuf)this.buffer).readBytes(nioBuffer);
        }
        return this;
    }

    @Override
    public Buffer readBytes(byte[] dst) {
        return this.readBytes(dst, 0, dst.length);
    }

    @Override
    public Buffer readBytes(byte[] dst, int dstIndex, int length) {
        ((ByteBuf)this.buffer).readBytes(dst, dstIndex, length);
        return this;
    }

    @Override
    public Buffer readBytes(ByteBuffer dst) {
        ((ByteBuf)this.buffer).readBytes(dst);
        return this;
    }

    @Override
    public Buffer skipBytes(int length) {
        ((ByteBuf)this.buffer).skipBytes(length);
        return this;
    }

    @Override
    public Buffer writeBoolean(boolean value) {
        ((ByteBuf)this.buffer).writeBoolean(value);
        return this;
    }

    @Override
    public Buffer writeByte(int value) {
        ((ByteBuf)this.buffer).writeByte(value);
        return this;
    }

    @Override
    public Buffer writeShort(int value) {
        ((ByteBuf)this.buffer).writeShort(value);
        return this;
    }

    @Override
    public Buffer writeShortLE(int value) {
        ((ByteBuf)this.buffer).writeShortLE(value);
        return this;
    }

    @Override
    public Buffer writeMedium(int value) {
        ((ByteBuf)this.buffer).writeMedium(value);
        return this;
    }

    @Override
    public Buffer writeMediumLE(int value) {
        ((ByteBuf)this.buffer).writeMediumLE(value);
        return this;
    }

    @Override
    public Buffer writeInt(int value) {
        ((ByteBuf)this.buffer).writeInt(value);
        return this;
    }

    @Override
    public Buffer writeIntLE(int value) {
        ((ByteBuf)this.buffer).writeIntLE(value);
        return this;
    }

    @Override
    public Buffer writeLong(long value) {
        ((ByteBuf)this.buffer).writeLong(value);
        return this;
    }

    @Override
    public Buffer writeLongLE(long value) {
        ((ByteBuf)this.buffer).writeLongLE(value);
        return this;
    }

    @Override
    public Buffer writeChar(int value) {
        ((ByteBuf)this.buffer).writeChar(value);
        return this;
    }

    @Override
    public Buffer writeFloat(float value) {
        ((ByteBuf)this.buffer).writeFloat(value);
        return this;
    }

    @Override
    public Buffer writeDouble(double value) {
        ((ByteBuf)this.buffer).writeDouble(value);
        return this;
    }

    @Override
    public Buffer writeBytes(Buffer src) {
        return this.writeBytes(src, src.readableBytes());
    }

    @Override
    public Buffer writeBytes(Buffer src, int length) {
        this.writeBytes(src, src.readerIndex(), length);
        src.readerIndex(src.readerIndex() + length);
        return this;
    }

    @Override
    public Buffer writeBytes(Buffer src, int srcIndex, int length) {
        ByteBuf srcByteBuf = BufferUtils.toByteBufNoThrow(src);
        if (srcByteBuf != null) {
            ((ByteBuf)this.buffer).writeBytes(srcByteBuf, srcIndex, length);
        } else if (src.hasArray()) {
            ((ByteBuf)this.buffer).writeBytes(src.array(), src.arrayOffset() + srcIndex, length);
        } else {
            ByteBuffer nioBuffer = src.toNioBuffer(srcIndex, length);
            ((ByteBuf)this.buffer).writeBytes(nioBuffer);
        }
        return this;
    }

    @Override
    public Buffer writeBytes(byte[] src) {
        return this.writeBytes(src, 0, src.length);
    }

    @Override
    public Buffer writeBytes(byte[] src, int srcIndex, int length) {
        ((ByteBuf)this.buffer).writeBytes(src, srcIndex, length);
        return this;
    }

    @Override
    public Buffer writeBytes(ByteBuffer src) {
        ((ByteBuf)this.buffer).writeBytes(src);
        return this;
    }

    @Override
    public int writeBytes(InputStream src, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        int totalWritten = 0;
        int bytesWritten = 0;
        while (length > 0 && (bytesWritten = ((ByteBuf)this.buffer).writeBytes(src, length)) >= 0) {
            totalWritten += bytesWritten;
            length -= bytesWritten;
        }
        return bytesWritten < 0 && totalWritten == 0 ? -1 : totalWritten;
    }

    @Override
    public int writeBytesUntilEndStream(InputStream src, int chunkSize) throws IOException {
        int amountRead = this.setBytesUntilEndStream(((ByteBuf)this.buffer).writerIndex(), src, chunkSize);
        if (amountRead > 0) {
            ((ByteBuf)this.buffer).writerIndex(((ByteBuf)this.buffer).writerIndex() + amountRead);
        }
        return amountRead;
    }

    @Override
    public Buffer writeAscii(CharSequence seq) {
        ByteBufUtil.writeAscii(this.buffer, seq);
        return this;
    }

    @Override
    public Buffer writeUtf8(CharSequence seq) {
        ByteBufUtil.writeUtf8(this.buffer, seq);
        return this;
    }

    @Override
    public Buffer writeUtf8(CharSequence seq, int ensureWritable) {
        ByteBufUtil.reserveAndWriteUtf8(this.buffer, seq, ensureWritable);
        return this;
    }

    @Override
    public Buffer writeCharSequence(CharSequence seq, Charset charset) {
        ((ByteBuf)this.buffer).writeCharSequence(seq, charset);
        return this;
    }

    @Override
    public int indexOf(int fromIndex, int toIndex, byte value) {
        return ((ByteBuf)this.buffer).indexOf(fromIndex, toIndex, value);
    }

    @Override
    public int bytesBefore(byte value) {
        return ((ByteBuf)this.buffer).bytesBefore(value);
    }

    @Override
    public int bytesBefore(int length, byte value) {
        return ((ByteBuf)this.buffer).bytesBefore(length, value);
    }

    @Override
    public int bytesBefore(int index, int length, byte value) {
        return ((ByteBuf)this.buffer).bytesBefore(index, length, value);
    }

    @Override
    public Buffer copy() {
        return new NettyBuffer<ByteBuf>(((ByteBuf)this.buffer).copy());
    }

    @Override
    public Buffer copy(int index, int length) {
        return new NettyBuffer<ByteBuf>(((ByteBuf)this.buffer).copy(index, length));
    }

    @Override
    public Buffer slice() {
        return new NettyBuffer<ByteBuf>(((ByteBuf)this.buffer).slice());
    }

    @Override
    public Buffer slice(int index, int length) {
        return new NettyBuffer<ByteBuf>(((ByteBuf)this.buffer).slice(index, length));
    }

    @Override
    public Buffer duplicate() {
        return new NettyBuffer<ByteBuf>(((ByteBuf)this.buffer).duplicate());
    }

    @Override
    public int nioBufferCount() {
        return ((ByteBuf)this.buffer).nioBufferCount();
    }

    @Override
    public ByteBuffer toNioBuffer() {
        return ((ByteBuf)this.buffer).nioBuffer();
    }

    @Override
    public ByteBuffer toNioBuffer(int index, int length) {
        return ((ByteBuf)this.buffer).nioBuffer(index, length);
    }

    @Override
    public ByteBuffer[] toNioBuffers() {
        return ((ByteBuf)this.buffer).nioBuffers();
    }

    @Override
    public ByteBuffer[] toNioBuffers(int index, int length) {
        return ((ByteBuf)this.buffer).nioBuffers(index, length);
    }

    @Override
    public boolean isReadOnly() {
        return ((ByteBuf)this.buffer).isReadOnly();
    }

    @Override
    public Buffer asReadOnly() {
        return new ReadOnlyBuffer(this);
    }

    @Override
    public boolean isDirect() {
        return ((ByteBuf)this.buffer).isDirect();
    }

    @Override
    public boolean hasArray() {
        return ((ByteBuf)this.buffer).hasArray();
    }

    @Override
    public byte[] array() {
        return ((ByteBuf)this.buffer).array();
    }

    @Override
    public int arrayOffset() {
        return ((ByteBuf)this.buffer).arrayOffset();
    }

    @Override
    public int forEachByte(ByteProcessor processor) {
        return ((ByteBuf)this.buffer).forEachByte(processor::process);
    }

    @Override
    public int forEachByte(int index, int length, ByteProcessor processor) {
        return ((ByteBuf)this.buffer).forEachByte(index, length, processor::process);
    }

    @Override
    public int forEachByteDesc(ByteProcessor processor) {
        return ((ByteBuf)this.buffer).forEachByteDesc(processor::process);
    }

    @Override
    public int forEachByteDesc(int index, int length, ByteProcessor processor) {
        return ((ByteBuf)this.buffer).forEachByteDesc(index, length, processor::process);
    }

    @Override
    public int hashCode() {
        return ((ByteBuf)this.buffer).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Buffer) {
            Buffer other = (Buffer)obj;
            ByteBuf byteBuf = BufferUtils.toByteBufNoThrow(other);
            return byteBuf != null ? ((ByteBuf)this.buffer).equals(byteBuf) : ((ByteBuf)this.buffer).nioBuffer().equals(other.toNioBuffer());
        }
        return false;
    }

    @Override
    public String toString() {
        return "NettyBuffer{buffer=" + this.buffer + '}';
    }

    @Override
    public String toString(Charset charset) {
        return ((ByteBuf)this.buffer).toString(charset);
    }

    @Override
    public String toString(int index, int length, Charset charset) {
        return ((ByteBuf)this.buffer).toString(index, length, charset);
    }
}

