/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.channel.uring;

import io.netty.channel.Channel;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ServerChannel;
import io.netty.channel.unix.Buffer;
import io.netty.channel.unix.Errors;
import io.netty.incubator.channel.uring.AbstractIOUringChannel;
import io.netty.incubator.channel.uring.IOUringRecvByteAllocatorHandle;
import io.netty.incubator.channel.uring.IOUringSubmissionQueue;
import io.netty.incubator.channel.uring.LinuxSocket;
import io.netty.incubator.channel.uring.Native;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

abstract class AbstractIOUringServerChannel
extends AbstractIOUringChannel
implements ServerChannel {
    private final ByteBuffer acceptedAddressMemory = Buffer.allocateDirectWithNativeOrder(Native.SIZEOF_SOCKADDR_STORAGE);
    private final ByteBuffer acceptedAddressLengthMemory;
    private final long acceptedAddressMemoryAddress = Buffer.memoryAddress(this.acceptedAddressMemory);
    private final long acceptedAddressLengthMemoryAddress;

    protected AbstractIOUringServerChannel(LinuxSocket socket, boolean active) {
        super(null, socket, active);
        this.acceptedAddressLengthMemory = Buffer.allocateDirectWithNativeOrder(8);
        this.acceptedAddressLengthMemory.putLong(0, Native.SIZEOF_SOCKADDR_STORAGE);
        this.acceptedAddressLengthMemoryAddress = Buffer.memoryAddress(this.acceptedAddressLengthMemory);
    }

    @Override
    protected void doClose() throws Exception {
        super.doClose();
        Buffer.free(this.acceptedAddressMemory);
        Buffer.free(this.acceptedAddressLengthMemory);
    }

    @Override
    protected AbstractIOUringChannel.AbstractUringUnsafe newUnsafe() {
        return new UringServerChannelUnsafe();
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer in) {
        throw new UnsupportedOperationException();
    }

    public AbstractIOUringChannel getChannel() {
        return this;
    }

    abstract Channel newChildChannel(int var1, long var2, long var4) throws Exception;

    final class UringServerChannelUnsafe
    extends AbstractIOUringChannel.AbstractUringUnsafe {
        UringServerChannelUnsafe() {
            super(AbstractIOUringServerChannel.this);
        }

        @Override
        protected int scheduleWriteMultiple(ChannelOutboundBuffer in) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected int scheduleWriteSingle(Object msg) {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean writeComplete0(int res, int data, int outstanding) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected int scheduleRead0() {
            IOUringRecvByteAllocatorHandle allocHandle = this.recvBufAllocHandle();
            allocHandle.attemptedBytesRead(1);
            IOUringSubmissionQueue submissionQueue = AbstractIOUringServerChannel.this.submissionQueue();
            submissionQueue.addAccept(AbstractIOUringServerChannel.this.fd().intValue(), AbstractIOUringServerChannel.this.acceptedAddressMemoryAddress, AbstractIOUringServerChannel.this.acceptedAddressLengthMemoryAddress, (short)0);
            return 1;
        }

        @Override
        protected void readComplete0(int res, int data, int outstanding) {
            block6: {
                IOUringRecvByteAllocatorHandle allocHandle = (IOUringRecvByteAllocatorHandle)AbstractIOUringServerChannel.this.unsafe().recvBufAllocHandle();
                ChannelPipeline pipeline = AbstractIOUringServerChannel.this.pipeline();
                allocHandle.lastBytesRead(res);
                if (res >= 0) {
                    allocHandle.incMessagesRead(1);
                    try {
                        Channel channel = AbstractIOUringServerChannel.this.newChildChannel(res, AbstractIOUringServerChannel.this.acceptedAddressMemoryAddress, AbstractIOUringServerChannel.this.acceptedAddressLengthMemoryAddress);
                        pipeline.fireChannelRead(channel);
                        if (allocHandle.continueReading()) {
                            this.scheduleRead();
                            break block6;
                        }
                        allocHandle.readComplete();
                        pipeline.fireChannelReadComplete();
                    }
                    catch (Throwable cause) {
                        allocHandle.readComplete();
                        pipeline.fireChannelReadComplete();
                        pipeline.fireExceptionCaught(cause);
                    }
                } else {
                    allocHandle.readComplete();
                    pipeline.fireChannelReadComplete();
                    if (res != Errors.ERRNO_EAGAIN_NEGATIVE && res != Errors.ERRNO_EWOULDBLOCK_NEGATIVE) {
                        pipeline.fireExceptionCaught(Errors.newIOException("io_uring accept", res));
                    }
                }
            }
        }

        @Override
        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            promise.setFailure(new UnsupportedOperationException());
        }
    }
}

