/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.LoadBalancer;
import io.servicetalk.client.api.internal.RequestConcurrencyController;
import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.TerminalSignalConsumer;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.ReservedStreamingHttpConnection;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.netty.AbstractLifecycleObserverHttpFilter;
import io.servicetalk.http.netty.AbstractStreamingHttpConnection;
import io.servicetalk.http.netty.LoadBalancedStreamingHttpConnection;
import io.servicetalk.http.netty.StreamingHttpRequestWithContext;
import io.servicetalk.http.utils.BeforeFinallyHttpOperator;
import io.servicetalk.transport.api.ConnectionInfo;
import io.servicetalk.transport.api.IoThreadFactory;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

final class LoadBalancedStreamingHttpClient
implements FilterableStreamingHttpClient {
    private static final Predicate<LoadBalancedStreamingHttpConnection> SELECTOR_FOR_REQUEST = conn -> conn.tryRequest() == RequestConcurrencyController.Result.Accepted;
    private static final Predicate<LoadBalancedStreamingHttpConnection> SELECTOR_FOR_RESERVE = LoadBalancedStreamingHttpConnection::tryReserve;
    private final HttpExecutionContext executionContext;
    private final LoadBalancer<LoadBalancedStreamingHttpConnection> loadBalancer;
    private final StreamingHttpRequestResponseFactory reqRespFactory;

    LoadBalancedStreamingHttpClient(HttpExecutionContext executionContext, LoadBalancer<LoadBalancedStreamingHttpConnection> loadBalancer, StreamingHttpRequestResponseFactory reqRespFactory) {
        this.executionContext = Objects.requireNonNull(executionContext);
        this.loadBalancer = Objects.requireNonNull(loadBalancer);
        this.reqRespFactory = Objects.requireNonNull(reqRespFactory);
    }

    @Override
    public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
        return this.loadBalancer.selectConnection(SELECTOR_FOR_REQUEST).flatMap(c -> {
            Consumer<ConnectionInfo> onConnectionSelected = AsyncContext.get(AbstractLifecycleObserverHttpFilter.ON_CONNECTION_SELECTED_CONSUMER);
            if (onConnectionSelected != null) {
                onConnectionSelected.accept(c.connectionContext());
            }
            final OwnedRunnable ownedRunnable = c.connectionContext().protocol().major() <= 1 ? null : new OwnedRunnable(c::requestFinished);
            return c.request(ownedRunnable == null ? request : new StreamingHttpRequestWithContext(request, ownedRunnable)).liftSync(new BeforeFinallyHttpOperator(new TerminalSignalConsumer((LoadBalancedStreamingHttpConnection)c){
                final /* synthetic */ LoadBalancedStreamingHttpConnection val$c;
                {
                    this.val$c = loadBalancedStreamingHttpConnection;
                }

                @Override
                public void onComplete() {
                    if (ownedRunnable == null || ownedRunnable.own()) {
                        this.val$c.requestFinished();
                    }
                }

                @Override
                public void onError(Throwable throwable) {
                    if (ownedRunnable == null || ownedRunnable.own()) {
                        this.val$c.requestFinished();
                    }
                }

                @Override
                public void cancel() {
                    if (ownedRunnable == null) {
                        this.val$c.closeAsync().subscribe();
                    } else if (ownedRunnable.own()) {
                        this.val$c.requestFinished();
                    }
                }
            })).shareContextOnSubscribe();
        });
    }

    public Single<ReservedStreamingHttpConnection> reserveConnection(HttpRequestMetaData metaData) {
        return Single.defer(() -> {
            Single connection = this.loadBalancer.selectConnection(SELECTOR_FOR_RESERVE).map(Function.identity());
            HttpExecutionStrategy strategy = AbstractStreamingHttpConnection.requestExecutionStrategy(metaData, this.executionContext().executionStrategy());
            return (strategy.isMetadataReceiveOffloaded() || strategy.isDataReceiveOffloaded() ? connection.publishOn(this.executionContext.executor(), IoThreadFactory.IoThread::currentThreadIsIoThread) : connection).shareContextOnSubscribe();
        });
    }

    @Override
    public HttpExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public StreamingHttpResponseFactory httpResponseFactory() {
        return this.reqRespFactory;
    }

    @Override
    public Completable onClose() {
        return this.loadBalancer.onClose();
    }

    @Override
    public Completable closeAsync() {
        return this.loadBalancer.closeAsync();
    }

    @Override
    public Completable closeAsyncGracefully() {
        return this.loadBalancer.closeAsyncGracefully();
    }

    @Override
    public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
        return this.reqRespFactory.newRequest(method, requestTarget);
    }

    static final class OwnedRunnable
    implements Runnable {
        private static final AtomicIntegerFieldUpdater<OwnedRunnable> ownedUpdater = AtomicIntegerFieldUpdater.newUpdater(OwnedRunnable.class, "owned");
        private volatile int owned;
        private final Runnable runnable;

        OwnedRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            this.runnable.run();
        }

        boolean own() {
            return ownedUpdater.compareAndSet(this, 0, 1);
        }
    }
}

