/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.BlockingHttpService;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpApiConversions;
import io.servicetalk.http.api.HttpExceptionMapperServiceFilter;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpLifecycleObserver;
import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.api.HttpServerBuilder;
import io.servicetalk.http.api.HttpServerContext;
import io.servicetalk.http.api.HttpService;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilter;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.http.netty.ClearAsyncContextHttpServiceFilter;
import io.servicetalk.http.netty.DeferredServerChannelBinder;
import io.servicetalk.http.netty.H2ServerParentConnectionContext;
import io.servicetalk.http.netty.HttpExecutionContextBuilder;
import io.servicetalk.http.netty.HttpKeepAlive;
import io.servicetalk.http.netty.HttpLifecycleObserverServiceFilter;
import io.servicetalk.http.netty.HttpServerConfig;
import io.servicetalk.http.netty.NettyHttpServer;
import io.servicetalk.http.netty.OffloadingFilter;
import io.servicetalk.http.netty.ReadOnlyHttpServerConfig;
import io.servicetalk.http.netty.StrategyInfluencerAwareConversions;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.transport.api.ConnectionAcceptor;
import io.servicetalk.transport.api.ConnectionAcceptorFactory;
import io.servicetalk.transport.api.ExecutionStrategyInfluencer;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.api.ServerSslConfig;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.netty.internal.InfluencerConnectionAcceptor;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultHttpServerBuilder
implements HttpServerBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHttpServerBuilder.class);
    private static final HttpExecutionStrategy REQRESP_OFFLOADS = HttpExecutionStrategies.customStrategyBuilder().offloadReceiveMetadata().offloadReceiveData().offloadSend().build();
    @Nullable
    private ConnectionAcceptorFactory connectionAcceptorFactory;
    private final List<StreamingHttpServiceFilterFactory> noOffloadServiceFilters = new ArrayList<StreamingHttpServiceFilterFactory>();
    private final List<StreamingHttpServiceFilterFactory> serviceFilters = new ArrayList<StreamingHttpServiceFilterFactory>();
    private HttpExecutionStrategy strategy = HttpExecutionStrategies.defaultStrategy();
    private boolean drainRequestPayloadBody = true;
    private final HttpServerConfig config = new HttpServerConfig();
    private final HttpExecutionContextBuilder executionContextBuilder = new HttpExecutionContextBuilder();
    private final SocketAddress address;

    DefaultHttpServerBuilder(SocketAddress address) {
        this.appendNonOffloadingServiceFilter(ClearAsyncContextHttpServiceFilter.CLEAR_ASYNC_CONTEXT_HTTP_SERVICE_FILTER);
        this.address = address;
    }

    private static StreamingHttpServiceFilterFactory buildFactory(List<StreamingHttpServiceFilterFactory> filters) {
        return filters.stream().reduce((prev, filter) -> strategy -> prev.create(filter.create(strategy))).orElse(StreamingHttpServiceFilter::new);
    }

    private static StreamingHttpService buildService(Stream<StreamingHttpServiceFilterFactory> filters, StreamingHttpService service) {
        return filters.reduce((prev, filter) -> svc -> prev.create(filter.create(svc))).map(factory -> factory.create(service)).orElse(service);
    }

    private static HttpExecutionStrategy computeRequiredStrategy(List<StreamingHttpServiceFilterFactory> filters, HttpExecutionStrategy defaultStrategy) {
        return filters.stream().map(ExecutionStrategyInfluencer::requiredOffloads).map(HttpExecutionStrategy::from).reduce(defaultStrategy, HttpExecutionStrategy::merge);
    }

    private static <T> T checkNonOffloading(String desc, HttpExecutionStrategy assumeStrategy, T obj) {
        HttpExecutionStrategy requires;
        HttpExecutionStrategy httpExecutionStrategy = requires = obj instanceof ExecutionStrategyInfluencer ? HttpExecutionStrategy.from(((ExecutionStrategyInfluencer)obj).requiredOffloads()) : assumeStrategy;
        if (requires.hasOffloads()) {
            throw new IllegalArgumentException(desc + " required offloading : " + requires);
        }
        return obj;
    }

    private static HttpExecutionStrategy requiredOffloads(Object anything, HttpExecutionStrategy defaultOffloads) {
        if (anything instanceof ExecutionStrategyInfluencer) {
            Object requiredOffloads = ((ExecutionStrategyInfluencer)anything).requiredOffloads();
            return HttpExecutionStrategy.from(requiredOffloads);
        }
        return defaultOffloads;
    }

    @Override
    public HttpServerBuilder drainRequestPayloadBody(boolean enable) {
        this.drainRequestPayloadBody = enable;
        return this;
    }

    @Override
    public HttpServerBuilder appendConnectionAcceptorFilter(ConnectionAcceptorFactory factory) {
        this.connectionAcceptorFactory = this.connectionAcceptorFactory == null ? factory : this.connectionAcceptorFactory.append(factory);
        return this;
    }

    @Override
    public HttpServerBuilder appendNonOffloadingServiceFilter(StreamingHttpServiceFilterFactory factory) {
        this.noOffloadServiceFilters.add(DefaultHttpServerBuilder.checkNonOffloading("Non-offloading filter", HttpExecutionStrategies.defaultStrategy(), factory));
        return this;
    }

    @Override
    public HttpServerBuilder appendNonOffloadingServiceFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpServiceFilterFactory factory) {
        DefaultHttpServerBuilder.checkNonOffloading("Non-offloading predicate", HttpExecutionStrategies.offloadNever(), predicate);
        DefaultHttpServerBuilder.checkNonOffloading("Non-offloading filter", HttpExecutionStrategies.defaultStrategy(), factory);
        this.noOffloadServiceFilters.add(StrategyInfluencerAwareConversions.toConditionalServiceFilterFactory(predicate, factory));
        return this;
    }

    @Override
    public HttpServerBuilder appendServiceFilter(StreamingHttpServiceFilterFactory factory) {
        Objects.requireNonNull(factory);
        this.serviceFilters.add(factory);
        return this;
    }

    @Override
    public HttpServerBuilder appendServiceFilter(Predicate<StreamingHttpRequest> predicate, StreamingHttpServiceFilterFactory factory) {
        this.appendServiceFilter(StrategyInfluencerAwareConversions.toConditionalServiceFilterFactory(predicate, factory));
        return this;
    }

    @Override
    public HttpServerBuilder protocols(HttpProtocolConfig ... protocols) {
        this.config.httpConfig().protocols(protocols);
        return this;
    }

    @Override
    public HttpServerBuilder sslConfig(ServerSslConfig config) {
        this.config.tcpConfig().sslConfig(config);
        return this;
    }

    @Override
    public HttpServerBuilder sslConfig(ServerSslConfig defaultConfig, Map<String, ServerSslConfig> sniMap) {
        this.config.tcpConfig().sslConfig(defaultConfig, sniMap);
        return this;
    }

    @Override
    public <T> HttpServerBuilder socketOption(SocketOption<T> option, T value) {
        this.config.tcpConfig().socketOption(option, value);
        return this;
    }

    @Override
    public <T> HttpServerBuilder listenSocketOption(SocketOption<T> option, T value) {
        this.config.tcpConfig().listenSocketOption(option, value);
        return this;
    }

    @Override
    public HttpServerBuilder enableWireLogging(String loggerName, LogLevel logLevel, BooleanSupplier logUserData) {
        this.config.tcpConfig().enableWireLogging(loggerName, logLevel, logUserData);
        return this;
    }

    @Override
    public HttpServerBuilder transportObserver(TransportObserver transportObserver) {
        this.config.tcpConfig().transportObserver(transportObserver);
        return this;
    }

    @Override
    public HttpServerBuilder lifecycleObserver(HttpLifecycleObserver lifecycleObserver) {
        this.config.lifecycleObserver(lifecycleObserver);
        return this;
    }

    @Override
    public HttpServerBuilder allowDropRequestTrailers(boolean allowDrop) {
        this.config.httpConfig().allowDropTrailersReadFromTransport(allowDrop);
        return this;
    }

    @Override
    public HttpServerBuilder executor(Executor executor) {
        this.executionContextBuilder.executor(executor);
        return this;
    }

    @Override
    public HttpServerBuilder executionStrategy(HttpExecutionStrategy strategy) {
        this.strategy = Objects.requireNonNull(strategy);
        return this;
    }

    @Override
    public HttpServerBuilder ioExecutor(IoExecutor ioExecutor) {
        this.executionContextBuilder.ioExecutor(ioExecutor);
        return this;
    }

    @Override
    public HttpServerBuilder bufferAllocator(BufferAllocator allocator) {
        this.executionContextBuilder.bufferAllocator(allocator);
        return this;
    }

    @Override
    public Single<HttpServerContext> listen(HttpService service) {
        return this.listenForAdapter(HttpApiConversions.toStreamingHttpService(service, this.computeServiceStrategy(service)));
    }

    @Override
    public Single<HttpServerContext> listenStreaming(StreamingHttpService service) {
        return this.listenForService(service, this.strategy);
    }

    @Override
    public Single<HttpServerContext> listenBlocking(BlockingHttpService service) {
        return this.listenForAdapter(HttpApiConversions.toStreamingHttpService(service, this.computeServiceStrategy(service)));
    }

    @Override
    public Single<HttpServerContext> listenBlockingStreaming(BlockingStreamingHttpService service) {
        return this.listenForAdapter(HttpApiConversions.toStreamingHttpService(service, this.computeServiceStrategy(service)));
    }

    private HttpExecutionContext buildExecutionContext(HttpExecutionStrategy strategy) {
        this.executionContextBuilder.executionStrategy(strategy);
        return this.executionContextBuilder.build();
    }

    private Single<HttpServerContext> listenForAdapter(HttpApiConversions.ServiceAdapterHolder adapterHolder) {
        return this.listenForService(adapterHolder.adaptor(), adapterHolder.serviceInvocationStrategy());
    }

    private Single<HttpServerContext> listenForService(StreamingHttpService rawService, HttpExecutionStrategy strategy) {
        HttpExecutionContext executionContext;
        StreamingHttpService filteredService;
        InfluencerConnectionAcceptor connectionAcceptor;
        InfluencerConnectionAcceptor influencerConnectionAcceptor = connectionAcceptor = this.connectionAcceptorFactory == null ? null : InfluencerConnectionAcceptor.withStrategy(this.connectionAcceptorFactory.create(ConnectionAcceptor.ACCEPT_ALL), this.connectionAcceptorFactory.requiredOffloads());
        if (this.noOffloadServiceFilters.isEmpty()) {
            filteredService = this.serviceFilters.isEmpty() ? rawService : DefaultHttpServerBuilder.buildService(this.serviceFilters.stream(), rawService);
            executionContext = this.buildExecutionContext(strategy);
        } else {
            Stream<StreamingHttpServiceFilterFactory> nonOffloadingFilters = this.noOffloadServiceFilters.stream();
            if (strategy.isRequestResponseOffloaded()) {
                executionContext = this.buildExecutionContext(REQRESP_OFFLOADS.missing(strategy));
                BooleanSupplier shouldOffload = executionContext.ioExecutor().shouldOffloadSupplier();
                OffloadingFilter offloadingFilter = new OffloadingFilter(strategy, DefaultHttpServerBuilder.buildFactory(this.serviceFilters), shouldOffload);
                nonOffloadingFilters = Stream.concat(nonOffloadingFilters, Stream.of(offloadingFilter));
            } else {
                nonOffloadingFilters = Stream.concat(nonOffloadingFilters, this.serviceFilters.stream());
                executionContext = this.buildExecutionContext(strategy);
            }
            filteredService = DefaultHttpServerBuilder.buildService(nonOffloadingFilters, rawService);
        }
        return this.doBind(executionContext, connectionAcceptor, filteredService).afterOnSuccess(serverContext -> LOGGER.debug("Server for address {} uses strategy {}", (Object)serverContext.listenAddress(), (Object)strategy));
    }

    private Single<HttpServerContext> doBind(HttpExecutionContext executionContext, @Nullable InfluencerConnectionAcceptor connectionAcceptor, StreamingHttpService service) {
        ReadOnlyHttpServerConfig roConfig = this.config.asReadOnly();
        StreamingHttpService filteredService = DefaultHttpServerBuilder.applyInternalFilters(service, roConfig.lifecycleObserver());
        if (roConfig.tcpConfig().isAlpnConfigured()) {
            return DeferredServerChannelBinder.bind(executionContext, roConfig, this.address, connectionAcceptor, filteredService, this.drainRequestPayloadBody, false);
        }
        if (roConfig.tcpConfig().sniMapping() != null) {
            return DeferredServerChannelBinder.bind(executionContext, roConfig, this.address, connectionAcceptor, filteredService, this.drainRequestPayloadBody, true);
        }
        if (roConfig.isH2PriorKnowledge()) {
            return H2ServerParentConnectionContext.bind(executionContext, roConfig, this.address, connectionAcceptor, filteredService, this.drainRequestPayloadBody);
        }
        return NettyHttpServer.bind(executionContext, roConfig, this.address, connectionAcceptor, filteredService, this.drainRequestPayloadBody);
    }

    private HttpExecutionStrategy computeServiceStrategy(Object service) {
        HttpExecutionStrategy serviceStrategy = DefaultHttpServerBuilder.requiredOffloads(service, HttpExecutionStrategies.defaultStrategy());
        HttpExecutionStrategy filterStrategy = DefaultHttpServerBuilder.computeRequiredStrategy(this.serviceFilters, serviceStrategy);
        return HttpExecutionStrategies.defaultStrategy() == this.strategy ? filterStrategy : this.strategy.merge(filterStrategy);
    }

    private static StreamingHttpService applyInternalFilters(StreamingHttpService service, @Nullable HttpLifecycleObserver lifecycleObserver) {
        service = HttpExceptionMapperServiceFilter.INSTANCE.create(service);
        service = KeepAliveServiceFilter.INSTANCE.create(service);
        if (lifecycleObserver != null) {
            service = new HttpLifecycleObserverServiceFilter(lifecycleObserver).create(service);
        }
        return service;
    }

    private static final class KeepAliveServiceFilter
    implements StreamingHttpServiceFilterFactory {
        static final StreamingHttpServiceFilterFactory INSTANCE = new KeepAliveServiceFilter();

        private KeepAliveServiceFilter() {
        }

        @Override
        public StreamingHttpServiceFilter create(StreamingHttpService service) {
            return new StreamingHttpServiceFilter(service){

                @Override
                public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory) {
                    HttpKeepAlive keepAlive = HttpKeepAlive.responseKeepAlive(request);
                    return this.delegate().handle(ctx, request, responseFactory).map(response -> {
                        keepAlive.addConnectionHeaderIfNecessary((StreamingHttpResponse)response);
                        return response;
                    });
                }
            };
        }

        @Override
        public HttpExecutionStrategy requiredOffloads() {
            return HttpExecutionStrategies.offloadNone();
        }
    }
}

