/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.Channel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.servicetalk.transport.api.ClientSslConfig;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import io.servicetalk.transport.netty.internal.CopyByteBufHandlerChannelInitializer;
import io.servicetalk.transport.netty.internal.DeferSslHandler;
import io.servicetalk.transport.netty.internal.SslUtils;
import java.util.Objects;

public class SslClientChannelInitializer
implements ChannelInitializer {
    private final SslContext sslContext;
    private final ClientSslConfig sslConfig;
    private final boolean deferSslHandler;

    public SslClientChannelInitializer(SslContext sslContext, ClientSslConfig sslConfig, boolean deferSslHandler) {
        this.sslContext = Objects.requireNonNull(sslContext);
        this.sslConfig = Objects.requireNonNull(sslConfig);
        this.deferSslHandler = deferSslHandler;
    }

    @Override
    public void init(Channel channel) {
        SslHandler sslHandler = SslUtils.newHandler(this.sslContext, CopyByteBufHandlerChannelInitializer.POOLED_ALLOCATOR, this.sslConfig);
        channel.pipeline().addLast(this.deferSslHandler ? new DeferSslHandler(channel, sslHandler) : sslHandler);
    }
}

