/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.transport.netty.internal.FlushStrategy;
import io.servicetalk.transport.netty.internal.FlushStrategyHolder;
import io.servicetalk.transport.netty.internal.NettyConnectionContext;
import io.servicetalk.transport.netty.internal.NoopWriteEventsListener;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

public final class SplittingFlushStrategy
implements FlushStrategy {
    private static final AtomicReferenceFieldUpdater<SplittingFlushStrategy, SplittingWriteEventsListener> listenerUpdater = AtomicReferenceFieldUpdater.newUpdater(SplittingFlushStrategy.class, SplittingWriteEventsListener.class, "listener");
    private final FlushBoundaryProvider flushBoundaryProvider;
    private final FlushStrategyHolder flushStrategyHolder;
    @Nullable
    private volatile SplittingWriteEventsListener listener;

    public SplittingFlushStrategy(FlushStrategy delegate, FlushBoundaryProvider boundaryProvider) {
        this.flushBoundaryProvider = Objects.requireNonNull(boundaryProvider);
        this.flushStrategyHolder = new FlushStrategyHolder(delegate);
    }

    @Override
    public FlushStrategy.WriteEventsListener apply(FlushStrategy.FlushSender sender) {
        SplittingWriteEventsListener cListener = this.listener;
        if (cListener != null) {
            return cListener;
        }
        SplittingWriteEventsListener l = listenerUpdater.updateAndGet(this, existing -> existing != null ? existing : new SplittingWriteEventsListener(sender, this.flushBoundaryProvider, this.flushStrategyHolder));
        assert (l != null);
        return l;
    }

    @Override
    public boolean shouldFlushOnUnwritable() {
        return this.flushStrategyHolder.currentStrategy().shouldFlushOnUnwritable();
    }

    public Cancellable updateFlushStrategy(NettyConnectionContext.FlushStrategyProvider strategyProvider) {
        return this.flushStrategyHolder.updateFlushStrategy(strategyProvider);
    }

    public void updateFlushStrategy(NettyConnectionContext.FlushStrategyProvider strategyProvider, int boundariesTillCancel) {
        CountingFlushStrategyProvider countingProvider = new CountingFlushStrategyProvider(strategyProvider, boundariesTillCancel);
        countingProvider.nextCancellable(this.flushStrategyHolder.updateFlushStrategy(countingProvider));
    }

    private static final class CountingFlushStrategyProvider
    extends SequentialCancellable
    implements NettyConnectionContext.FlushStrategyProvider {
        private static final AtomicIntegerFieldUpdater<CountingFlushStrategyProvider> boundariesLeftUpdater = AtomicIntegerFieldUpdater.newUpdater(CountingFlushStrategyProvider.class, "boundariesLeft");
        private final NettyConnectionContext.FlushStrategyProvider strategyProvider;
        private volatile int boundariesLeft;

        CountingFlushStrategyProvider(NettyConnectionContext.FlushStrategyProvider strategyProvider, int boundariesTillCancel) {
            this.strategyProvider = strategyProvider;
            this.boundariesLeft = boundariesTillCancel;
        }

        @Override
        public FlushStrategy computeFlushStrategy(FlushStrategy current, boolean isCurrentOriginal) {
            FlushStrategy flushStrategy = this.strategyProvider.computeFlushStrategy(current, isCurrentOriginal);
            return sender -> {
                FlushStrategy.WriteEventsListener actual = flushStrategy.apply(sender);
                return new BoundaryCountingWriteListener(actual);
            };
        }

        private final class BoundaryCountingWriteListener
        implements FlushStrategy.WriteEventsListener {
            private final FlushStrategy.WriteEventsListener delegate;

            BoundaryCountingWriteListener(FlushStrategy.WriteEventsListener delegate) {
                this.delegate = delegate;
            }

            @Override
            public void writeStarted() {
                this.delegate.writeStarted();
            }

            @Override
            public void itemWritten(@Nullable Object written) {
                this.delegate.itemWritten(written);
            }

            @Override
            public void writeTerminated() {
                try {
                    this.delegate.writeTerminated();
                }
                finally {
                    if (boundariesLeftUpdater.decrementAndGet(CountingFlushStrategyProvider.this) == 0) {
                        CountingFlushStrategyProvider.this.cancel();
                    }
                }
            }

            @Override
            public void writeCancelled() {
                this.delegate.writeCancelled();
            }
        }
    }

    private static final class SplittingWriteEventsListener
    implements FlushStrategy.WriteEventsListener {
        private static final FlushStrategy.WriteEventsListener NOOP_LISTENER = new NoopWriteEventsListener(){};
        private final FlushStrategy.FlushSender flushSender;
        private final FlushBoundaryProvider flushBoundaryProvider;
        private final FlushStrategyHolder flushStrategyHolder;
        private FlushStrategy.WriteEventsListener delegate = NOOP_LISTENER;
        @Nullable
        private FlushBoundaryProvider.FlushBoundary previousBoundary;

        SplittingWriteEventsListener(FlushStrategy.FlushSender flushSender, FlushBoundaryProvider flushBoundaryProvider, FlushStrategyHolder flushStrategyHolder) {
            this.flushSender = flushSender;
            this.flushBoundaryProvider = flushBoundaryProvider;
            this.flushStrategyHolder = flushStrategyHolder;
        }

        @Override
        public void writeStarted() {
            this.delegate.writeStarted();
        }

        @Override
        public void itemWritten(@Nullable Object written) {
            FlushBoundaryProvider.FlushBoundary boundary = this.flushBoundaryProvider.detectBoundary(written);
            this.adjustForMissingBoundaries(boundary);
            this.previousBoundary = boundary;
            switch (boundary) {
                case Start: {
                    this.delegate = this.flushStrategyHolder.currentStrategy().apply(this.flushSender);
                    this.delegate.writeStarted();
                    this.delegate.itemWritten(written);
                    break;
                }
                case InProgress: {
                    this.delegate.itemWritten(written);
                    break;
                }
                case End: {
                    this.delegate.itemWritten(written);
                    this.delegate.writeTerminated();
                    this.delegate = NOOP_LISTENER;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown flush boundary: " + (Object)((Object)boundary));
                }
            }
        }

        private void adjustForMissingBoundaries(FlushBoundaryProvider.FlushBoundary boundary) {
            if (boundary == FlushBoundaryProvider.FlushBoundary.Start && (this.previousBoundary == FlushBoundaryProvider.FlushBoundary.Start || this.previousBoundary == FlushBoundaryProvider.FlushBoundary.InProgress)) {
                this.delegate.writeTerminated();
                this.delegate = NOOP_LISTENER;
            } else if (!(boundary != FlushBoundaryProvider.FlushBoundary.InProgress && boundary != FlushBoundaryProvider.FlushBoundary.End || this.previousBoundary != null && this.previousBoundary != FlushBoundaryProvider.FlushBoundary.End)) {
                this.delegate = this.flushStrategyHolder.currentStrategy().apply(this.flushSender);
                this.delegate.writeStarted();
            }
        }

        @Override
        public void writeTerminated() {
            this.delegate.writeTerminated();
        }

        @Override
        public void writeCancelled() {
            this.delegate.writeCancelled();
        }
    }

    @FunctionalInterface
    public static interface FlushBoundaryProvider {
        public FlushBoundary detectBoundary(@Nullable Object var1);

        public static enum FlushBoundary {
            Start,
            InProgress,
            End;

        }
    }
}

