/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilter;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.http.netty.ConditionalHttpClientFilter;
import io.servicetalk.http.netty.ConditionalHttpConnectionFilter;
import io.servicetalk.http.netty.ConditionalHttpServiceFilter;
import java.util.Objects;
import java.util.function.Predicate;

final class StrategyInfluencerAwareConversions {
    private StrategyInfluencerAwareConversions() {
    }

    static StreamingHttpServiceFilterFactory toConditionalServiceFilterFactory(final Predicate<StreamingHttpRequest> predicate, final StreamingHttpServiceFilterFactory original) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(original);
        return new StreamingHttpServiceFilterFactory(){

            @Override
            public StreamingHttpServiceFilter create(StreamingHttpService service) {
                return new ConditionalHttpServiceFilter(predicate, original.create(service), service);
            }

            @Override
            public HttpExecutionStrategy requiredOffloads() {
                return original.requiredOffloads();
            }
        };
    }

    static StreamingHttpConnectionFilterFactory toConditionalConnectionFilterFactory(final Predicate<StreamingHttpRequest> predicate, final StreamingHttpConnectionFilterFactory original) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(original);
        return new StreamingHttpConnectionFilterFactory(){

            @Override
            public HttpExecutionStrategy requiredOffloads() {
                return original.requiredOffloads();
            }

            @Override
            public StreamingHttpConnectionFilter create(FilterableStreamingHttpConnection connection) {
                return new ConditionalHttpConnectionFilter(predicate, original.create(connection), connection);
            }
        };
    }

    static StreamingHttpClientFilterFactory toConditionalClientFilterFactory(final Predicate<StreamingHttpRequest> predicate, final StreamingHttpClientFilterFactory original) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(original);
        return new StreamingHttpClientFilterFactory(){

            @Override
            public HttpExecutionStrategy requiredOffloads() {
                return original.requiredOffloads();
            }

            @Override
            public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
                return new ConditionalHttpClientFilter(predicate, original.create(client), client);
            }
        };
    }
}

