/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.NoAvailableHostException;
import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.RetryStrategies;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.netty.LoadBalancerReadySubscriber;
import io.servicetalk.transport.api.ExecutionStrategyInfluencer;
import io.servicetalk.transport.api.RetryableException;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class RetryingHttpRequesterFilter
implements StreamingHttpClientFilterFactory,
ExecutionStrategyInfluencer<HttpExecutionStrategy> {
    private static final RetryingHttpRequesterFilter DISABLE_RETRIES = new RetryingHttpRequesterFilter(false, true, 0, null, (__, ___) -> BackOffPolicy.NO_RETRIES);
    private final boolean waitForLb;
    private final boolean ignoreSdErrors;
    private final int maxTotalRetries;
    @Nullable
    private final Function<HttpResponseMetaData, HttpResponseException> responseMapper;
    private final BiFunction<HttpRequestMetaData, Throwable, BackOffPolicy> retryFor;

    RetryingHttpRequesterFilter(boolean waitForLb, boolean ignoreSdErrors, int maxTotalRetries, @Nullable Function<HttpResponseMetaData, HttpResponseException> responseMapper, BiFunction<HttpRequestMetaData, Throwable, BackOffPolicy> retryFor) {
        this.waitForLb = waitForLb;
        this.ignoreSdErrors = ignoreSdErrors;
        this.maxTotalRetries = maxTotalRetries;
        this.responseMapper = responseMapper;
        this.retryFor = retryFor;
    }

    @Override
    public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
        return new ContextAwareRetryingHttpClientFilter(client);
    }

    @Override
    public HttpExecutionStrategy requiredOffloads() {
        return HttpExecutionStrategies.offloadNone();
    }

    public static RetryingHttpRequesterFilter disableAutoRetries() {
        return DISABLE_RETRIES;
    }

    public static final class Builder {
        private boolean waitForLb = true;
        private boolean ignoreSdErrors;
        private int maxRetries = Integer.MAX_VALUE;
        @Nullable
        private Function<HttpResponseMetaData, HttpResponseException> responseMapper;
        private BiFunction<HttpRequestMetaData, RetryableException, BackOffPolicy> retryRetryableExceptions = (requestMetaData, e) -> BackOffPolicy.ofImmediate();
        @Nullable
        private BiFunction<HttpRequestMetaData, IOException, BackOffPolicy> retryIdempotentRequests;
        @Nullable
        private BiFunction<HttpRequestMetaData, DelayedRetry, BackOffPolicy> retryDelayedRetries;
        @Nullable
        private BiFunction<HttpRequestMetaData, HttpResponseException, BackOffPolicy> retryResponses;
        @Nullable
        private BiFunction<HttpRequestMetaData, Throwable, BackOffPolicy> retryOther;

        public Builder waitForLoadBalancer(boolean waitForLb) {
            this.waitForLb = waitForLb;
            return this;
        }

        public Builder ignoreServiceDiscovererErrors(boolean ignoreSdErrors) {
            this.ignoreSdErrors = ignoreSdErrors;
            return this;
        }

        public Builder maxTotalRetries(int maxRetries) {
            if (maxRetries <= 0) {
                throw new IllegalArgumentException("maxRetries: " + maxRetries + " (expected: >0)");
            }
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder responseMapper(Function<HttpResponseMetaData, HttpResponseException> mapper) {
            this.responseMapper = Objects.requireNonNull(mapper);
            return this;
        }

        public Builder retryRetryableExceptions(BiFunction<HttpRequestMetaData, RetryableException, BackOffPolicy> mapper) {
            this.retryRetryableExceptions = Objects.requireNonNull(mapper);
            return this;
        }

        public Builder retryIdempotentRequests(BiFunction<HttpRequestMetaData, IOException, BackOffPolicy> mapper) {
            this.retryIdempotentRequests = Objects.requireNonNull(mapper);
            return this;
        }

        public Builder retryDelayedRetries(BiFunction<HttpRequestMetaData, DelayedRetry, BackOffPolicy> mapper) {
            this.retryDelayedRetries = Objects.requireNonNull(mapper);
            return this;
        }

        public Builder retryResponses(BiFunction<HttpRequestMetaData, HttpResponseException, BackOffPolicy> mapper) {
            this.retryResponses = Objects.requireNonNull(mapper);
            return this;
        }

        public Builder retryOther(BiFunction<HttpRequestMetaData, Throwable, BackOffPolicy> mapper) {
            this.retryOther = Objects.requireNonNull(mapper);
            return this;
        }

        public RetryingHttpRequesterFilter build() {
            BiFunction<HttpRequestMetaData, Throwable, BackOffPolicy> allPredicate = (requestMetaData, throwable) -> {
                BackOffPolicy backOffPolicy;
                if (throwable instanceof RetryableException && (backOffPolicy = this.retryRetryableExceptions.apply((HttpRequestMetaData)requestMetaData, (RetryableException)((Object)throwable))) != BackOffPolicy.NO_RETRIES) {
                    return backOffPolicy;
                }
                if (this.retryIdempotentRequests != null && throwable instanceof IOException && requestMetaData.method().properties().isIdempotent() && (backOffPolicy = this.retryIdempotentRequests.apply((HttpRequestMetaData)requestMetaData, (IOException)throwable)) != BackOffPolicy.NO_RETRIES) {
                    return backOffPolicy;
                }
                if (this.retryDelayedRetries != null && throwable instanceof DelayedRetry && (backOffPolicy = this.retryDelayedRetries.apply((HttpRequestMetaData)requestMetaData, (DelayedRetry)((Object)throwable))) != BackOffPolicy.NO_RETRIES) {
                    return backOffPolicy;
                }
                if (this.retryResponses != null && throwable instanceof HttpResponseException && (backOffPolicy = this.retryResponses.apply((HttpRequestMetaData)requestMetaData, (HttpResponseException)throwable)) != BackOffPolicy.NO_RETRIES) {
                    return backOffPolicy;
                }
                if (this.retryOther != null) {
                    return this.retryOther.apply((HttpRequestMetaData)requestMetaData, (Throwable)throwable);
                }
                return BackOffPolicy.NO_RETRIES;
            };
            return new RetryingHttpRequesterFilter(this.waitForLb, this.ignoreSdErrors, this.maxRetries, this.responseMapper, allPredicate);
        }
    }

    public static interface DelayedRetry {
        public Duration delay();
    }

    public static final class BackOffPolicy {
        private static final Duration FULL_JITTER = Duration.ofDays(1024L);
        public static final BackOffPolicy NO_RETRIES = BackOffPolicy.ofNoRetries();
        @Nullable
        final Duration initialDelay;
        final Duration jitter;
        @Nullable
        final Duration maxDelay;
        @Nullable
        final Executor timerExecutor;
        final boolean exponential;
        final int maxRetries;

        BackOffPolicy(@Nullable Duration initialDelay, Duration jitter, @Nullable Duration maxDelay, @Nullable Executor timerExecutor, boolean exponential, int maxRetries) {
            this.initialDelay = initialDelay;
            this.jitter = jitter;
            this.maxDelay = maxDelay;
            this.timerExecutor = timerExecutor;
            this.exponential = exponential;
            this.maxRetries = maxRetries > 0 ? maxRetries : (exponential ? 2 : 1);
        }

        public static BackOffPolicy ofImmediate() {
            return new BackOffPolicy(null, Duration.ZERO, null, null, false, 3);
        }

        public static BackOffPolicy ofImmediate(int maxRetries) {
            return new BackOffPolicy(null, Duration.ZERO, null, null, false, maxRetries);
        }

        private static BackOffPolicy ofNoRetries() {
            return new BackOffPolicy(null, Duration.ZERO, null, null, false, 0);
        }

        public static BackOffPolicy ofConstantBackoffFullJitter(Duration delay, int maxRetries) {
            return new BackOffPolicy(delay, FULL_JITTER, null, null, false, maxRetries);
        }

        public static BackOffPolicy ofConstantBackoffFullJitter(Duration delay, int maxRetries, Executor timerExecutor) {
            return new BackOffPolicy(delay, FULL_JITTER, null, timerExecutor, false, maxRetries);
        }

        public static BackOffPolicy ofConstantBackoffDeltaJitter(Duration delay, Duration jitter, int maxRetries) {
            return new BackOffPolicy(delay, jitter, null, null, false, maxRetries);
        }

        public static BackOffPolicy ofConstantBackoffDeltaJitter(Duration delay, Duration jitter, Executor timerExecutor, int maxRetries) {
            return new BackOffPolicy(delay, jitter, null, timerExecutor, false, maxRetries);
        }

        public static BackOffPolicy ofExponentialBackoffFullJitter(Duration initialDelay, Duration maxDelay, int maxRetries) {
            return new BackOffPolicy(initialDelay, FULL_JITTER, maxDelay, null, true, maxRetries);
        }

        public static BackOffPolicy ofExponentialBackoffFullJitter(Duration initialDelay, Duration maxDelay, int maxRetries, Executor timerExecutor) {
            return new BackOffPolicy(initialDelay, FULL_JITTER, maxDelay, timerExecutor, true, maxRetries);
        }

        public static BackOffPolicy ofExponentialBackoffDeltaJitter(Duration initialDelay, Duration jitter, Duration maxDelay, int maxRetries) {
            return new BackOffPolicy(initialDelay, jitter, maxDelay, null, true, maxRetries);
        }

        public static BackOffPolicy ofExponentialBackoffDeltaJitter(Duration initialDelay, Duration jitter, Duration maxDelay, int maxRetries, Executor timerExecutor) {
            return new BackOffPolicy(initialDelay, jitter, maxDelay, timerExecutor, true, maxRetries);
        }

        public BiIntFunction<Throwable, Completable> newStrategy(Executor alternativeTimerExecutor) {
            Executor effectiveExecutor;
            if (this.initialDelay == null) {
                return (count, throwable) -> count <= this.maxRetries ? Completable.completed() : Completable.failed(throwable);
            }
            Executor executor = effectiveExecutor = this.timerExecutor == null ? Objects.requireNonNull(alternativeTimerExecutor) : this.timerExecutor;
            if (this.exponential) {
                assert (this.maxDelay != null);
                return this.jitter == FULL_JITTER ? RetryStrategies.retryWithExponentialBackoffFullJitter(this.maxRetries, t -> true, this.initialDelay, this.maxDelay, effectiveExecutor) : RetryStrategies.retryWithExponentialBackoffDeltaJitter(this.maxRetries, t -> true, this.initialDelay, this.jitter, this.maxDelay, effectiveExecutor);
            }
            return this.jitter == FULL_JITTER ? RetryStrategies.retryWithConstantBackoffFullJitter(this.maxRetries, t -> true, this.initialDelay, effectiveExecutor) : RetryStrategies.retryWithConstantBackoffDeltaJitter(this.maxRetries, t -> true, this.initialDelay, this.jitter, effectiveExecutor);
        }
    }

    public static final class HttpResponseException
    extends RuntimeException {
        private static final long serialVersionUID = -7182949760823647710L;
        public final HttpResponseMetaData metaData;
        public final String message;

        public HttpResponseException(String message, HttpResponseMetaData metaData) {
            super(message);
            this.metaData = Objects.requireNonNull(metaData);
            this.message = Objects.requireNonNull(message);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }

        @Override
        public String toString() {
            return super.toString() + ", metaData=" + this.metaData.toString(HeaderUtils.DEFAULT_HEADER_FILTER);
        }
    }

    final class ContextAwareRetryingHttpClientFilter
    extends StreamingHttpClientFilter {
        private final Executor executor;
        @Nullable
        private Completable sdStatus;
        @Nullable
        private AsyncCloseable closeAsync;
        @Nullable
        private LoadBalancerReadySubscriber loadBalancerReadySubscriber;

        private ContextAwareRetryingHttpClientFilter(FilterableStreamingHttpClient delegate) {
            super(delegate);
            this.executor = delegate.executionContext().executor();
        }

        void inject(@Nullable Publisher<Object> lbEventStream, @Nullable Completable sdStatus) {
            assert (lbEventStream != null);
            assert (sdStatus != null);
            Completable completable = this.sdStatus = RetryingHttpRequesterFilter.this.ignoreSdErrors ? null : sdStatus;
            if (RetryingHttpRequesterFilter.this.waitForLb) {
                this.loadBalancerReadySubscriber = new LoadBalancerReadySubscriber();
                this.closeAsync = AsyncCloseables.toAsyncCloseable(__ -> {
                    this.loadBalancerReadySubscriber.cancel();
                    return Completable.completed();
                });
                SourceAdapters.toSource(lbEventStream).subscribe(this.loadBalancerReadySubscriber);
            } else {
                this.loadBalancerReadySubscriber = null;
                this.closeAsync = AsyncCloseables.emptyAsyncCloseable();
            }
        }

        BiIntFunction<Throwable, Completable> retryStrategy(Executor executor, HttpRequestMetaData requestMetaData) {
            return (count, t) -> {
                if (count > RetryingHttpRequesterFilter.this.maxTotalRetries) {
                    return Completable.failed(t);
                }
                if (this.loadBalancerReadySubscriber != null && t instanceof NoAvailableHostException) {
                    Completable onHostsAvailable = this.loadBalancerReadySubscriber.onHostsAvailable();
                    return this.sdStatus == null ? onHostsAvailable : onHostsAvailable.ambWith(this.sdStatus);
                }
                BackOffPolicy backOffPolicy = (BackOffPolicy)RetryingHttpRequesterFilter.this.retryFor.apply(requestMetaData, t);
                if (backOffPolicy != BackOffPolicy.NO_RETRIES) {
                    if (t instanceof DelayedRetry) {
                        Duration constant = ((DelayedRetry)((Object)t)).delay();
                        return backOffPolicy.newStrategy(executor).apply(count, (Throwable)t).concat(executor.timer(constant));
                    }
                    return backOffPolicy.newStrategy(executor).apply(count, (Throwable)t);
                }
                return Completable.failed(t);
            };
        }

        @Override
        public Single<? extends FilterableReservedStreamingHttpConnection> reserveConnection(HttpRequestMetaData metaData) {
            return this.delegate().reserveConnection(metaData).retryWhen(this.retryStrategy(this.executor, metaData));
        }

        @Override
        protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, StreamingHttpRequest request) {
            Single<StreamingHttpResponse> single = delegate.request(request);
            if (RetryingHttpRequesterFilter.this.responseMapper != null) {
                single = single.map(resp -> {
                    HttpResponseException exception = (HttpResponseException)RetryingHttpRequesterFilter.this.responseMapper.apply(resp);
                    if (exception != null) {
                        throw exception;
                    }
                    return resp;
                });
            }
            return single.retryWhen(this.retryStrategy(this.executor, request));
        }

        @Override
        public Completable closeAsync() {
            if (this.closeAsync != null) {
                this.closeAsync.closeAsync();
            }
            return super.closeAsync();
        }

        @Override
        public Completable closeAsyncGracefully() {
            if (this.closeAsync != null) {
                this.closeAsync.closeAsyncGracefully();
            }
            return super.closeAsyncGracefully();
        }
    }
}

