/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.PromiseCombiner;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.buffer.netty.BufferUtils;
import io.servicetalk.http.api.EmptyHttpHeaders;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpMetaData;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.netty.HttpKeepAlive;
import io.servicetalk.transport.netty.internal.CloseHandler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;

abstract class HttpObjectEncoder<T extends HttpMetaData>
extends ChannelOutboundHandlerAdapter {
    static final int CRLF_SHORT = 3338;
    private static final int ZERO_CRLF_MEDIUM = 3149066;
    private static final int COLON_AND_SPACE_SHORT = 14880;
    private static final byte[] ZERO_CRLF_CRLF = new byte[]{48, 13, 10, 13, 10};
    private static final ByteBuf CRLF_BUF = Unpooled.unreleasableBuffer(Unpooled.directBuffer(2).writeByte(13).writeByte(10).asReadOnly());
    private static final ByteBuf ZERO_CRLF_CRLF_BUF = Unpooled.unreleasableBuffer(Unpooled.directBuffer(ZERO_CRLF_CRLF.length).writeBytes(ZERO_CRLF_CRLF).asReadOnly());
    private static final float HEADERS_WEIGHT_NEW = 0.2f;
    private static final float HEADERS_WEIGHT_HISTORICAL = 0.8f;
    private static final float TRAILERS_WEIGHT_NEW = 0.2f;
    private static final float TRAILERS_WEIGHT_HISTORICAL = 0.8f;
    private static final long CONTENT_LEN_INIT = Long.MIN_VALUE;
    private static final long CONTENT_LEN_EMPTY = -9223372036854775807L;
    private static final long CONTENT_LEN_CHUNKED = -9223372036854775806L;
    private static final long CONTENT_LEN_CONSUMED = -9223372036854775805L;
    private static final long CONTENT_LEN_LARGEST_VALUE = -9223372036854775805L;
    private long state = Long.MIN_VALUE;
    private float headersEncodedSizeAccumulator;
    private float trailersEncodedSizeAccumulator;
    private final CloseHandler closeHandler;

    HttpObjectEncoder(int headersEncodedSizeAccumulator, int trailersEncodedSizeAccumulator, CloseHandler closeHandler) {
        this.headersEncodedSizeAccumulator = Math.max(16, headersEncodedSizeAccumulator);
        this.trailersEncodedSizeAccumulator = Math.max(16, trailersEncodedSizeAccumulator);
        this.closeHandler = closeHandler;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof HttpMetaData) {
            if (this.state == -9223372036854775806L) {
                this.encodeAndWriteTrailers(ctx, EmptyHttpHeaders.INSTANCE, promise);
            } else {
                if (this.state > 0L) {
                    this.tryTooLittleContent(ctx, msg, promise);
                    return;
                }
                if (this.state == -1L) {
                    this.unknownContentLengthNewRequest(ctx);
                }
            }
            T metaData = this.castMetaData(msg);
            this.closeHandler.protocolPayloadBeginOutbound(ctx);
            if (HttpKeepAlive.shouldClose(metaData)) {
                this.closeHandler.protocolClosingOutbound(ctx);
            }
            ByteBuf byteBuf = ctx.alloc().directBuffer((int)this.headersEncodedSizeAccumulator);
            try {
                Buffer stBuf = BufferUtils.newBufferFrom(byteBuf);
                this.encodeInitialLine(stBuf, metaData);
                if (this.isContentAlwaysEmpty(metaData)) {
                    this.state = -9223372036854775807L;
                    this.closeHandler.protocolPayloadEndOutbound(ctx, promise);
                } else if (HeaderUtils.isTransferEncodingChunked(metaData.headers())) {
                    this.state = -9223372036854775806L;
                } else {
                    this.state = this.getContentLength(metaData);
                    assert (this.state > -9223372036854775805L);
                    if (this.state == 0L) {
                        this.state = -9223372036854775805L;
                        this.closeHandler.protocolPayloadEndOutbound(ctx, promise);
                    }
                }
                this.sanitizeHeadersBeforeEncode(metaData);
                HttpObjectEncoder.encodeHeaders(metaData.headers(), byteBuf, stBuf);
                ByteBufUtil.writeShortBE(byteBuf, 3338);
                this.headersEncodedSizeAccumulator = 0.2f * (float)HttpObjectEncoder.padSizeForAccumulation(byteBuf.readableBytes()) + 0.8f * this.headersEncodedSizeAccumulator;
            }
            catch (Throwable e) {
                byteBuf.release();
                HttpObjectEncoder.tryIoException(ctx, e, promise);
                return;
            }
            ctx.write(byteBuf, promise);
        } else if (msg instanceof Buffer) {
            Buffer stBuffer = (Buffer)msg;
            int readableBytes = stBuffer.readableBytes();
            if (readableBytes <= 0) {
                ctx.write(Unpooled.EMPTY_BUFFER, promise);
            } else if (this.state == -9223372036854775806L) {
                PromiseCombiner promiseCombiner = new PromiseCombiner(ctx.executor());
                HttpObjectEncoder.encodeChunkedContent(ctx, stBuffer, stBuffer.readableBytes(), promiseCombiner);
                promiseCombiner.finish(promise);
            } else if (this.state <= -9223372036854775805L || this.state >= 0L && (this.state -= (long)readableBytes) < 0L) {
                this.tryTooMuchContent(ctx, readableBytes, promise);
            } else {
                if (this.state == 0L) {
                    this.state = -9223372036854775805L;
                    this.closeHandler.protocolPayloadEndOutbound(ctx, promise);
                }
                ctx.write(HttpObjectEncoder.encodeAndRetain(stBuffer), promise);
            }
        } else if (msg instanceof HttpHeaders) {
            boolean isChunked = this.state == -9223372036854775806L;
            this.state = Long.MIN_VALUE;
            HttpHeaders trailers = (HttpHeaders)msg;
            if (isChunked) {
                this.closeHandler.protocolPayloadEndOutbound(ctx, promise);
                this.encodeAndWriteTrailers(ctx, trailers, promise);
            } else if (!trailers.isEmpty()) {
                HttpObjectEncoder.tryFailNonEmptyTrailers(ctx, trailers, promise);
            } else if (this.state > 0L) {
                this.tryTooLittleContent(ctx, promise);
            } else {
                if (this.state != -9223372036854775805L) {
                    this.closeHandler.protocolPayloadEndOutbound(ctx, promise);
                }
                this.state = Long.MIN_VALUE;
                ctx.write(Unpooled.EMPTY_BUFFER, promise);
            }
        }
    }

    private static void tryFailNonEmptyTrailers(ChannelHandlerContext ctx, HttpHeaders trailers, ChannelPromise promise) {
        promise.tryFailure(new IOException("Trailers are only supported for HTTP/1.x with " + HttpHeaderNames.TRANSFER_ENCODING + ": " + HttpHeaderValues.CHUNKED + ". Channel: " + ctx.channel() + " attempted to write non-empty trailers: " + trailers));
    }

    private void tryTooMuchContent(ChannelHandlerContext ctx, int bytes, ChannelPromise promise) {
        if (this.state == -9223372036854775807L) {
            promise.tryFailure(new IOException("payload body must be empty, but write of: " + bytes + " bytes attempted on channel: " + ctx.channel()));
        } else {
            promise.tryFailure(new IOException("payload body size exceeded content-length header. write of " + bytes + " bytes attempted, " + (this.state <= -9223372036854775805L ? 0L : this.state + (long)bytes) + " bytes remaining on channel: " + ctx.channel()));
        }
    }

    private void tryTooLittleContent(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        assert (this.state > 0L);
        promise.tryFailure(new IOException("Failed to complete encoding. Expected " + this.state + " remaining bytes from content-length but new request/response " + msg + " started on channel: " + ctx.channel()));
    }

    private void tryTooLittleContent(ChannelHandlerContext ctx, ChannelPromise promise) {
        assert (this.state > 0L);
        promise.tryFailure(new IOException("Failed to complete encoding. Expected " + this.state + " remaining bytes from content-length but the request/response terminated on channel: " + ctx.channel()));
    }

    private void unknownContentLengthNewRequest(ChannelHandlerContext ctx) {
        ChannelPromise emptyWritePromise = ctx.newPromise();
        ctx.write(Unpooled.EMPTY_BUFFER, emptyWritePromise);
        this.closeHandler.protocolPayloadEndOutbound(ctx, emptyWritePromise);
    }

    private static void tryIoException(ChannelHandlerContext ctx, Throwable e, ChannelPromise promise) {
        promise.tryFailure(e instanceof IOException ? e : new IOException("unexpected exception while encoding on channel: " + ctx.channel(), e));
    }

    protected boolean isContentAlwaysEmpty(T msg) {
        return false;
    }

    private void sanitizeHeadersBeforeEncode(T msg) {
        if (this.state == -9223372036854775806L && HttpProtocolVersion.HTTP_1_1.equals(msg.version())) {
            msg.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
        }
        this.sanitizeHeadersBeforeEncode(msg, this.state == -9223372036854775807L);
    }

    protected abstract void sanitizeHeadersBeforeEncode(T var1, boolean var2);

    protected abstract T castMetaData(Object var1);

    protected abstract void encodeInitialLine(Buffer var1, T var2);

    protected abstract long getContentLength(T var1);

    private static void encodeHeaders(HttpHeaders headers, ByteBuf byteBuf) {
        HttpObjectEncoder.encodeHeaders(headers, byteBuf, BufferUtils.newBufferFrom(byteBuf));
    }

    private static void encodeHeaders(HttpHeaders headers, ByteBuf byteBuf, Buffer buffer) {
        for (Map.Entry<CharSequence, CharSequence> header : headers) {
            HttpObjectEncoder.encodeHeader(header.getKey(), header.getValue(), byteBuf, buffer);
        }
    }

    private static void encodeChunkedContent(ChannelHandlerContext ctx, Buffer msg, long contentLength, PromiseCombiner promiseCombiner) {
        if (contentLength > 0L) {
            String lengthHex = Long.toHexString(contentLength);
            ByteBuf buf = ctx.alloc().directBuffer(lengthHex.length() + 2);
            try {
                buf.writeCharSequence(lengthHex, StandardCharsets.US_ASCII);
                ByteBufUtil.writeShortBE(buf, 3338);
            }
            catch (Throwable e) {
                buf.release();
                throw e;
            }
            promiseCombiner.add(ctx.write(buf));
            promiseCombiner.add(ctx.write(HttpObjectEncoder.encodeAndRetain(msg)));
            promiseCombiner.add(ctx.write(CRLF_BUF.duplicate()));
        } else {
            assert (contentLength == 0L);
            promiseCombiner.add(ctx.write(HttpObjectEncoder.encodeAndRetain(msg)));
        }
    }

    private void encodeAndWriteTrailers(ChannelHandlerContext ctx, HttpHeaders headers, ChannelPromise promise) {
        if (headers.isEmpty()) {
            ctx.write(ZERO_CRLF_CRLF_BUF.duplicate(), promise);
        } else {
            ByteBuf buf = ctx.alloc().directBuffer((int)this.trailersEncodedSizeAccumulator);
            try {
                ByteBufUtil.writeMediumBE(buf, 3149066);
                HttpObjectEncoder.encodeHeaders(headers, buf);
                ByteBufUtil.writeShortBE(buf, 3338);
                this.trailersEncodedSizeAccumulator = 0.2f * (float)HttpObjectEncoder.padSizeForAccumulation(buf.readableBytes()) + 0.8f * this.trailersEncodedSizeAccumulator;
            }
            catch (Throwable e) {
                buf.release();
                throw e;
            }
            ctx.write(buf, promise);
        }
    }

    private static int padSizeForAccumulation(int readableBytes) {
        return (readableBytes << 2) / 3;
    }

    private static void encodeHeader(CharSequence name, CharSequence value, ByteBuf byteBuf, Buffer buffer) {
        int nameLen = name.length();
        int valueLen = value.length();
        int entryLen = nameLen + valueLen + 4;
        byteBuf.ensureWritable(entryLen);
        int offset = byteBuf.writerIndex();
        HttpObjectEncoder.writeAscii(name, byteBuf, buffer, offset);
        ByteBufUtil.setShortBE(byteBuf, offset += nameLen, 14880);
        HttpObjectEncoder.writeAscii(value, byteBuf, buffer, offset += 2);
        ByteBufUtil.setShortBE(byteBuf, offset += valueLen, 3338);
        byteBuf.writerIndex(offset += 2);
    }

    private static void writeAscii(CharSequence value, ByteBuf dstByteBuf, Buffer dstBuffer, int dstOffset) {
        Buffer valueBuffer = CharSequences.unwrapBuffer(value);
        if (valueBuffer != null) {
            HttpObjectEncoder.writeBufferToByteBuf(valueBuffer, dstByteBuf, dstBuffer, dstOffset);
        } else {
            dstByteBuf.setCharSequence(dstOffset, value, StandardCharsets.US_ASCII);
        }
    }

    private static void writeBufferToByteBuf(Buffer src, ByteBuf dstByteBuf, Buffer dstBuffer, int dstOffset) {
        ByteBuf byteBuf = BufferUtils.toByteBufNoThrow(src);
        if (byteBuf != null) {
            dstByteBuf.setBytes(dstOffset, byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
        } else {
            src.getBytes(src.readerIndex(), dstBuffer, dstOffset, src.readableBytes());
        }
    }

    static ByteBuf encodeAndRetain(Buffer msg) {
        return HttpObjectEncoder.toByteBuf(msg).retain();
    }

    private static ByteBuf toByteBuf(Buffer buffer) {
        ByteBuf byteBuf = BufferUtils.toByteBufNoThrow(buffer);
        return byteBuf != null ? byteBuf : Unpooled.wrappedBuffer(buffer.toNioBuffer());
    }
}

