/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponseMetaDataFactory;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.netty.AbstractH2DuplexHandler;
import io.servicetalk.http.netty.H2ToStH1Utils;
import io.servicetalk.http.netty.HeaderUtils;
import io.servicetalk.http.netty.NettyH2HeadersToHttpHeaders;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.netty.internal.CloseHandler;
import javax.annotation.Nullable;

final class H2ToStH1ClientDuplexHandler
extends AbstractH2DuplexHandler {
    private boolean readHeaders;
    private final HttpScheme scheme;
    @Nullable
    private HttpRequestMethod method;

    H2ToStH1ClientDuplexHandler(boolean sslEnabled, BufferAllocator allocator, HttpHeadersFactory headersFactory, CloseHandler closeHandler, ConnectionObserver.StreamObserver observer) {
        super(allocator, headersFactory, closeHandler, observer);
        this.scheme = sslEnabled ? HttpScheme.HTTPS : HttpScheme.HTTP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof HttpRequestMetaData) {
            this.closeHandler.protocolPayloadBeginOutbound(ctx);
            HttpRequestMetaData metaData = (HttpRequestMetaData)msg;
            HttpHeaders h1Headers = metaData.headers();
            CharSequence host = h1Headers.getAndRemove(HttpHeaderNames.HOST);
            Http2Headers h2Headers = H2ToStH1Utils.h1HeadersToH2Headers(h1Headers);
            if (host == null) {
                host = metaData.host();
                if (host != null) {
                    h2Headers.authority(host);
                }
            } else {
                h2Headers.authority(host);
            }
            this.method = metaData.method();
            h2Headers.method(this.method.name());
            if (!HttpRequestMethod.CONNECT.equals(this.method)) {
                h2Headers.scheme(this.scheme.name());
                h2Headers.path(metaData.requestTarget());
            }
            try {
                this.writeMetaData(ctx, metaData, h2Headers, promise);
            }
            finally {
                Http2StreamChannel streamChannel = (Http2StreamChannel)ctx.channel();
                int streamId = streamChannel.stream().id();
                if (streamId > 0) {
                    this.observer.streamIdAssigned(streamId);
                }
            }
        } else if (msg instanceof Buffer) {
            H2ToStH1ClientDuplexHandler.writeBuffer(ctx, (Buffer)msg, promise);
        } else if (msg instanceof HttpHeaders) {
            this.writeTrailers(ctx, msg, promise);
        } else {
            ctx.write(msg, promise);
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof Http2HeadersFrame) {
            HttpResponseStatus httpStatus;
            Http2HeadersFrame headersFrame = (Http2HeadersFrame)msg;
            Http2Headers h2Headers = headersFrame.headers();
            if (!this.readHeaders) {
                this.closeHandler.protocolPayloadBeginInbound(ctx);
                CharSequence status = (CharSequence)h2Headers.getAndRemove(Http2Headers.PseudoHeaderName.STATUS.value());
                if (status == null) {
                    throw new IllegalArgumentException("a response must have " + (Object)((Object)Http2Headers.PseudoHeaderName.STATUS) + " header");
                }
                httpStatus = HttpResponseStatus.of(status);
                if (httpStatus.statusClass() == HttpResponseStatus.StatusClass.INFORMATIONAL_1XX) {
                    return;
                }
                this.readHeaders = true;
            } else {
                httpStatus = null;
            }
            if (headersFrame.isEndStream()) {
                if (httpStatus != null) {
                    this.fireFullResponse(ctx, h2Headers, httpStatus);
                } else {
                    ctx.fireChannelRead(this.h2HeadersToH1HeadersClient(h2Headers, null, false));
                }
                this.closeHandler.protocolPayloadEndInbound(ctx);
            } else {
                if (httpStatus == null) {
                    throw new IllegalArgumentException("a response must have " + (Object)((Object)Http2Headers.PseudoHeaderName.STATUS) + " header");
                }
                ctx.fireChannelRead(HttpResponseMetaDataFactory.newResponseMetaData(HttpProtocolVersion.HTTP_2_0, httpStatus, this.h2HeadersToH1HeadersClient(h2Headers, httpStatus, false)));
            }
        } else if (msg instanceof Http2DataFrame) {
            this.readDataFrame(ctx, msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private void fireFullResponse(ChannelHandlerContext ctx, Http2Headers h2Headers, HttpResponseStatus httpStatus) {
        assert (this.method != null);
        ctx.fireChannelRead(HttpResponseMetaDataFactory.newResponseMetaData(HttpProtocolVersion.HTTP_2_0, httpStatus, this.h2HeadersToH1HeadersClient(h2Headers, httpStatus, true)));
    }

    private NettyH2HeadersToHttpHeaders h2HeadersToH1HeadersClient(Http2Headers h2Headers, @Nullable HttpResponseStatus httpStatus, boolean fullResponse) {
        assert (this.method != null);
        H2ToStH1Utils.h2HeadersSanitizeForH1(h2Headers);
        if (httpStatus != null) {
            int statusCode = httpStatus.code();
            if (!h2Headers.contains(HttpHeaderNames.CONTENT_LENGTH)) {
                if (HeaderUtils.serverMaySendPayloadBodyFor(statusCode, this.method)) {
                    if (fullResponse) {
                        h2Headers.set(HttpHeaderNames.CONTENT_LENGTH, HttpHeaderValues.ZERO);
                    } else {
                        h2Headers.add(HttpHeaderNames.TRANSFER_ENCODING, HttpHeaderValues.CHUNKED);
                    }
                }
            } else if (!HeaderUtils.responseMayHaveContent(statusCode, this.method)) {
                throw new IllegalArgumentException("content-length (" + h2Headers.get(HttpHeaderNames.CONTENT_LENGTH) + ") header is not expected for status code " + statusCode + " in response to " + this.method.name() + " request");
            }
        }
        return new NettyH2HeadersToHttpHeaders(h2Headers, this.headersFactory.validateCookies(), this.headersFactory.validateValues());
    }
}

