/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpSerializerDeserializer;
import io.servicetalk.serializer.api.SerializerDeserializer;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;

final class DefaultHttpSerializerDeserializer<T>
implements HttpSerializerDeserializer<T> {
    private final SerializerDeserializer<T> serializer;
    private final Consumer<HttpHeaders> headersSerializeConsumer;
    private final Predicate<HttpHeaders> headersDeserializePredicate;

    DefaultHttpSerializerDeserializer(SerializerDeserializer<T> serializer, Consumer<HttpHeaders> headersSerializeConsumer, Predicate<HttpHeaders> headersDeserializePredicate) {
        this.serializer = Objects.requireNonNull(serializer);
        this.headersSerializeConsumer = Objects.requireNonNull(headersSerializeConsumer);
        this.headersDeserializePredicate = Objects.requireNonNull(headersDeserializePredicate);
    }

    @Override
    public T deserialize(HttpHeaders headers, BufferAllocator allocator, Buffer payload) {
        HeaderUtils.deserializeCheckContentType(headers, this.headersDeserializePredicate);
        return this.serializer.deserialize(payload, allocator);
    }

    @Override
    public Buffer serialize(HttpHeaders headers, T value, BufferAllocator allocator) {
        this.headersSerializeConsumer.accept(headers);
        return this.serializer.serialize(value, allocator);
    }
}

