/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractSynchronousSingle;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.concurrent.internal.ThreadInterruptingCancellable;
import java.util.Objects;
import java.util.concurrent.Callable;

final class CallableSingle<T>
extends AbstractSynchronousSingle<T> {
    private final Callable<T> callable;

    CallableSingle(Callable<T> callable) {
        this.callable = Objects.requireNonNull(callable);
    }

    @Override
    void doSubscribe(SingleSource.Subscriber<? super T> subscriber) {
        T value;
        ThreadInterruptingCancellable cancellable = new ThreadInterruptingCancellable(Thread.currentThread());
        try {
            subscriber.onSubscribe(cancellable);
        }
        catch (Throwable cause) {
            SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, cause);
            return;
        }
        try {
            value = this.callable.call();
        }
        catch (Throwable cause) {
            cancellable.setDone(cause);
            SubscriberUtils.safeOnError(subscriber, cause);
            return;
        }
        cancellable.setDone();
        SubscriberUtils.safeOnSuccess(subscriber, value);
    }
}

