/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.buffer.netty;

import io.netty.util.internal.StringUtil;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.ByteProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Objects;

class WrappedBuffer
implements Buffer {
    final Buffer buffer;

    WrappedBuffer(Buffer buffer) {
        this.buffer = Objects.requireNonNull(buffer);
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public Buffer capacity(int newCapacity) {
        this.buffer.capacity(newCapacity);
        return this;
    }

    @Override
    public int maxCapacity() {
        return this.buffer.maxCapacity();
    }

    @Override
    public int readerIndex() {
        return this.buffer.readerIndex();
    }

    @Override
    public Buffer readerIndex(int readerIndex) {
        this.buffer.readerIndex(readerIndex);
        return this;
    }

    @Override
    public int writerIndex() {
        return this.buffer.writerIndex();
    }

    @Override
    public Buffer writerIndex(int writerIndex) {
        this.buffer.writerIndex(writerIndex);
        return this;
    }

    @Override
    public int readableBytes() {
        return this.buffer.readableBytes();
    }

    @Override
    public int writableBytes() {
        return this.buffer.writableBytes();
    }

    @Override
    public int maxWritableBytes() {
        return this.buffer.maxWritableBytes();
    }

    @Override
    public Buffer ensureWritable(int minWritableBytes) {
        this.buffer.ensureWritable(minWritableBytes);
        return this;
    }

    @Override
    public int ensureWritable(int minWritableBytes, boolean force) {
        return this.buffer.ensureWritable(minWritableBytes, force);
    }

    @Override
    public Buffer clear() {
        this.buffer.clear();
        return this;
    }

    @Override
    public boolean getBoolean(int index) {
        return this.buffer.getBoolean(index);
    }

    @Override
    public byte getByte(int index) {
        return this.buffer.getByte(index);
    }

    @Override
    public short getUnsignedByte(int index) {
        return this.buffer.getUnsignedByte(index);
    }

    @Override
    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    @Override
    public short getShortLE(int index) {
        return this.buffer.getShortLE(index);
    }

    @Override
    public int getUnsignedShort(int index) {
        return this.buffer.getUnsignedShort(index);
    }

    @Override
    public int getUnsignedShortLE(int index) {
        return this.buffer.getUnsignedShortLE(index);
    }

    @Override
    public int getMedium(int index) {
        return this.buffer.getMedium(index);
    }

    @Override
    public int getMediumLE(int index) {
        return this.buffer.getMediumLE(index);
    }

    @Override
    public int getUnsignedMedium(int index) {
        return this.buffer.getUnsignedMedium(index);
    }

    @Override
    public int getUnsignedMediumLE(int index) {
        return this.buffer.getUnsignedMediumLE(index);
    }

    @Override
    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    @Override
    public int getIntLE(int index) {
        return this.buffer.getIntLE(index);
    }

    @Override
    public long getUnsignedInt(int index) {
        return this.buffer.getUnsignedInt(index);
    }

    @Override
    public long getUnsignedIntLE(int index) {
        return this.buffer.getUnsignedIntLE(index);
    }

    @Override
    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    @Override
    public long getLongLE(int index) {
        return this.buffer.getLongLE(index);
    }

    @Override
    public char getChar(int index) {
        return this.buffer.getChar(index);
    }

    @Override
    public float getFloat(int index) {
        return this.buffer.getFloat(index);
    }

    @Override
    public double getDouble(int index) {
        return this.buffer.getDouble(index);
    }

    @Override
    public Buffer getBytes(int index, Buffer dst) {
        this.buffer.getBytes(index, dst);
        return this;
    }

    @Override
    public Buffer getBytes(int index, Buffer dst, int length) {
        this.buffer.getBytes(index, dst, length);
        return this;
    }

    @Override
    public Buffer getBytes(int index, Buffer dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst, dstIndex, length);
        return this;
    }

    @Override
    public Buffer getBytes(int index, byte[] dst) {
        this.buffer.getBytes(index, dst);
        return this;
    }

    @Override
    public Buffer getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst, dstIndex, length);
        return this;
    }

    @Override
    public Buffer getBytes(int index, ByteBuffer dst) {
        this.buffer.getBytes(index, dst);
        return this;
    }

    @Override
    public Buffer setBoolean(int index, boolean value) {
        this.buffer.setBoolean(index, value);
        return this;
    }

    @Override
    public Buffer setByte(int index, int value) {
        this.buffer.setByte(index, value);
        return this;
    }

    @Override
    public Buffer setShort(int index, int value) {
        this.buffer.setShort(index, value);
        return this;
    }

    @Override
    public Buffer setShortLE(int index, int value) {
        this.buffer.setShortLE(index, value);
        return this;
    }

    @Override
    public Buffer setMedium(int index, int value) {
        this.buffer.setMedium(index, value);
        return this;
    }

    @Override
    public Buffer setMediumLE(int index, int value) {
        this.buffer.setMediumLE(index, value);
        return this;
    }

    @Override
    public Buffer setInt(int index, int value) {
        this.buffer.setInt(index, value);
        return this;
    }

    @Override
    public Buffer setIntLE(int index, int value) {
        this.buffer.setIntLE(index, value);
        return this;
    }

    @Override
    public Buffer setLong(int index, long value) {
        this.buffer.setLong(index, value);
        return this;
    }

    @Override
    public Buffer setLongLE(int index, long value) {
        this.buffer.setLongLE(index, value);
        return this;
    }

    @Override
    public Buffer setChar(int index, int value) {
        this.buffer.setChar(index, value);
        return this;
    }

    @Override
    public Buffer setFloat(int index, float value) {
        this.buffer.setFloat(index, value);
        return this;
    }

    @Override
    public Buffer setDouble(int index, double value) {
        this.buffer.setDouble(index, value);
        return this;
    }

    @Override
    public Buffer setBytes(int index, Buffer src) {
        this.buffer.setBytes(index, src);
        return this;
    }

    @Override
    public Buffer setBytes(int index, Buffer src, int length) {
        this.buffer.setBytes(index, src, length);
        return this;
    }

    @Override
    public Buffer setBytes(int index, Buffer src, int srcIndex, int length) {
        this.buffer.setBytes(index, src, srcIndex, length);
        return this;
    }

    @Override
    public Buffer setBytes(int index, byte[] src) {
        this.buffer.setBytes(index, src);
        return this;
    }

    @Override
    public Buffer setBytes(int index, byte[] src, int srcIndex, int length) {
        this.buffer.setBytes(index, src, srcIndex, length);
        return this;
    }

    @Override
    public Buffer setBytes(int index, ByteBuffer src) {
        this.buffer.setBytes(index, src);
        return this;
    }

    @Override
    public int setBytes(int index, InputStream src, int length) throws IOException {
        return this.buffer.setBytes(index, src, length);
    }

    @Override
    public int setBytesUntilEndStream(int index, InputStream src, int chunkSize) throws IOException {
        return this.buffer.setBytesUntilEndStream(index, src, chunkSize);
    }

    @Override
    public boolean readBoolean() {
        return this.buffer.readBoolean();
    }

    @Override
    public byte readByte() {
        return this.buffer.readByte();
    }

    @Override
    public short readUnsignedByte() {
        return this.buffer.readUnsignedByte();
    }

    @Override
    public short readShort() {
        return this.buffer.readShort();
    }

    @Override
    public short readShortLE() {
        return this.buffer.readShortLE();
    }

    @Override
    public int readUnsignedShort() {
        return this.buffer.readUnsignedShort();
    }

    @Override
    public int readUnsignedShortLE() {
        return this.buffer.readUnsignedShortLE();
    }

    @Override
    public int readMedium() {
        return this.buffer.readMedium();
    }

    @Override
    public int readMediumLE() {
        return this.buffer.readMediumLE();
    }

    @Override
    public int readUnsignedMedium() {
        return this.buffer.readUnsignedMedium();
    }

    @Override
    public int readUnsignedMediumLE() {
        return this.buffer.readUnsignedMediumLE();
    }

    @Override
    public int readInt() {
        return this.buffer.readInt();
    }

    @Override
    public int readIntLE() {
        return this.buffer.readIntLE();
    }

    @Override
    public long readUnsignedInt() {
        return this.buffer.readUnsignedInt();
    }

    @Override
    public long readUnsignedIntLE() {
        return this.buffer.readUnsignedIntLE();
    }

    @Override
    public long readLong() {
        return this.buffer.readLong();
    }

    @Override
    public long readLongLE() {
        return this.buffer.readLongLE();
    }

    @Override
    public char readChar() {
        return this.buffer.readChar();
    }

    @Override
    public float readFloat() {
        return this.buffer.readFloat();
    }

    @Override
    public double readDouble() {
        return this.buffer.readDouble();
    }

    @Override
    public Buffer readSlice(int length) {
        return this.buffer.readSlice(length);
    }

    @Override
    public Buffer readBytes(int length) {
        return this.buffer.readBytes(length);
    }

    @Override
    public Buffer readBytes(Buffer dst) {
        this.buffer.readBytes(dst);
        return this;
    }

    @Override
    public Buffer readBytes(Buffer dst, int length) {
        this.buffer.readBytes(dst, length);
        return this;
    }

    @Override
    public Buffer readBytes(Buffer dst, int dstIndex, int length) {
        this.buffer.readBytes(dst, dstIndex, length);
        return this;
    }

    @Override
    public Buffer readBytes(byte[] dst) {
        this.buffer.readBytes(dst);
        return this;
    }

    @Override
    public Buffer readBytes(byte[] dst, int dstIndex, int length) {
        this.buffer.readBytes(dst, dstIndex, length);
        return this;
    }

    @Override
    public Buffer readBytes(ByteBuffer dst) {
        this.buffer.readBytes(dst);
        return this;
    }

    @Override
    public Buffer skipBytes(int length) {
        this.buffer.skipBytes(length);
        return this;
    }

    @Override
    public Buffer writeBoolean(boolean value) {
        this.buffer.writeBoolean(value);
        return this;
    }

    @Override
    public Buffer writeByte(int value) {
        this.buffer.writeByte(value);
        return this;
    }

    @Override
    public Buffer writeShort(int value) {
        this.buffer.writeShort(value);
        return this;
    }

    @Override
    public Buffer writeShortLE(int value) {
        this.buffer.writeShortLE(value);
        return this;
    }

    @Override
    public Buffer writeMedium(int value) {
        this.buffer.writeMedium(value);
        return this;
    }

    @Override
    public Buffer writeMediumLE(int value) {
        this.buffer.writeMediumLE(value);
        return this;
    }

    @Override
    public Buffer writeInt(int value) {
        this.buffer.writeInt(value);
        return this;
    }

    @Override
    public Buffer writeIntLE(int value) {
        this.buffer.writeIntLE(value);
        return this;
    }

    @Override
    public Buffer writeLong(long value) {
        this.buffer.writeLong(value);
        return this;
    }

    @Override
    public Buffer writeLongLE(long value) {
        this.buffer.writeLongLE(value);
        return this;
    }

    @Override
    public Buffer writeChar(int value) {
        this.buffer.writeChar(value);
        return this;
    }

    @Override
    public Buffer writeFloat(float value) {
        this.buffer.writeFloat(value);
        return this;
    }

    @Override
    public Buffer writeDouble(double value) {
        this.buffer.writeDouble(value);
        return this;
    }

    @Override
    public Buffer writeBytes(Buffer src) {
        this.buffer.writeBytes(src);
        return this;
    }

    @Override
    public Buffer writeBytes(Buffer src, int length) {
        this.buffer.writeBytes(src, length);
        return this;
    }

    @Override
    public Buffer writeBytes(Buffer src, int srcIndex, int length) {
        this.buffer.writeBytes(src, srcIndex, length);
        return this;
    }

    @Override
    public Buffer writeBytes(byte[] src) {
        this.buffer.writeBytes(src);
        return this;
    }

    @Override
    public Buffer writeBytes(byte[] src, int srcIndex, int length) {
        this.buffer.writeBytes(src, srcIndex, length);
        return this;
    }

    @Override
    public Buffer writeBytes(ByteBuffer src) {
        this.buffer.writeBytes(src);
        return this;
    }

    @Override
    public int writeBytes(InputStream src, int length) throws IOException {
        return this.buffer.writeBytes(src, length);
    }

    @Override
    public int writeBytesUntilEndStream(InputStream src, int chunkSize) throws IOException {
        return this.buffer.writeBytesUntilEndStream(src, chunkSize);
    }

    @Override
    public Buffer writeAscii(CharSequence seq) {
        this.buffer.writeAscii(seq);
        return this;
    }

    @Override
    public Buffer writeUtf8(CharSequence seq) {
        this.buffer.writeUtf8(seq);
        return this;
    }

    @Override
    public Buffer writeUtf8(CharSequence seq, int ensureWritable) {
        this.buffer.writeUtf8(seq, ensureWritable);
        return this;
    }

    @Override
    public Buffer writeCharSequence(CharSequence seq, Charset charset) {
        this.buffer.writeCharSequence(seq, charset);
        return this;
    }

    @Override
    public int indexOf(int fromIndex, int toIndex, byte value) {
        return this.buffer.indexOf(fromIndex, toIndex, value);
    }

    @Override
    public int bytesBefore(byte value) {
        return this.buffer.bytesBefore(value);
    }

    @Override
    public int bytesBefore(int length, byte value) {
        return this.buffer.bytesBefore(length, value);
    }

    @Override
    public int bytesBefore(int index, int length, byte value) {
        return this.buffer.bytesBefore(index, length, value);
    }

    @Override
    public Buffer copy() {
        return this.buffer.copy();
    }

    @Override
    public Buffer copy(int index, int length) {
        return this.buffer.copy(index, length);
    }

    @Override
    public Buffer slice() {
        return this.buffer.slice();
    }

    @Override
    public Buffer slice(int index, int length) {
        return this.buffer.slice(index, length);
    }

    @Override
    public Buffer duplicate() {
        return this.buffer.duplicate();
    }

    @Override
    public int nioBufferCount() {
        return this.buffer.nioBufferCount();
    }

    @Override
    public ByteBuffer toNioBuffer() {
        return this.buffer.toNioBuffer();
    }

    @Override
    public ByteBuffer toNioBuffer(int index, int length) {
        return this.buffer.toNioBuffer(index, length);
    }

    @Override
    public ByteBuffer[] toNioBuffers() {
        return this.buffer.toNioBuffers();
    }

    @Override
    public ByteBuffer[] toNioBuffers(int index, int length) {
        return this.buffer.toNioBuffers(index, length);
    }

    @Override
    public boolean isReadOnly() {
        return this.buffer.isReadOnly();
    }

    @Override
    public Buffer asReadOnly() {
        return this.buffer.asReadOnly();
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    @Override
    public String toString(Charset charset) {
        return this.buffer.toString(charset);
    }

    @Override
    public String toString(int index, int length, Charset charset) {
        return this.buffer.toString(index, length, charset);
    }

    @Override
    public String toString() {
        return StringUtil.simpleClassName(this) + '(' + this.buffer.toString() + ')';
    }

    @Override
    public int forEachByte(ByteProcessor processor) {
        return this.buffer.forEachByte(processor);
    }

    @Override
    public int forEachByte(int index, int length, ByteProcessor processor) {
        return this.buffer.forEachByte(index, length, processor);
    }

    @Override
    public int forEachByteDesc(ByteProcessor processor) {
        return this.buffer.forEachByteDesc(processor);
    }

    @Override
    public int forEachByteDesc(int index, int length, ByteProcessor processor) {
        return this.buffer.forEachByteDesc(index, length, processor);
    }

    @Override
    public boolean equals(Object o) {
        return this.buffer.equals(o);
    }

    @Override
    public int hashCode() {
        return this.buffer.hashCode();
    }
}

