/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.channel.uring;

import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.PeerCredentials;
import io.netty.channel.unix.Unix;
import io.netty.incubator.channel.uring.IOUringCompletionQueue;
import io.netty.incubator.channel.uring.IOUringSubmissionQueue;
import io.netty.incubator.channel.uring.NativeStaticallyReferencedJniMethods;
import io.netty.incubator.channel.uring.RingBuffer;
import io.netty.util.internal.ClassInitializerUtil;
import io.netty.util.internal.NativeLibraryLoader;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.nio.channels.Selector;
import java.util.Arrays;
import java.util.Locale;

final class Native {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Native.class);
    static final int DEFAULT_RING_SIZE = Math.max(64, SystemPropertyUtil.getInt("io.netty.uring.ringSize", 4096));
    static final int DEFAULT_IOSEQ_ASYNC_THRESHOLD = Math.max(0, SystemPropertyUtil.getInt("io.netty.uring.iosqeAsyncThreshold", 25));
    static final int SOCK_NONBLOCK;
    static final int SOCK_CLOEXEC;
    static final short AF_INET;
    static final short AF_INET6;
    static final int SIZEOF_SOCKADDR_STORAGE;
    static final int SIZEOF_SOCKADDR_IN;
    static final int SIZEOF_SOCKADDR_IN6;
    static final int SOCKADDR_IN_OFFSETOF_SIN_FAMILY;
    static final int SOCKADDR_IN_OFFSETOF_SIN_PORT;
    static final int SOCKADDR_IN_OFFSETOF_SIN_ADDR;
    static final int IN_ADDRESS_OFFSETOF_S_ADDR;
    static final int SOCKADDR_IN6_OFFSETOF_SIN6_FAMILY;
    static final int SOCKADDR_IN6_OFFSETOF_SIN6_PORT;
    static final int SOCKADDR_IN6_OFFSETOF_SIN6_FLOWINFO;
    static final int SOCKADDR_IN6_OFFSETOF_SIN6_ADDR;
    static final int SOCKADDR_IN6_OFFSETOF_SIN6_SCOPE_ID;
    static final int IN6_ADDRESS_OFFSETOF_S6_ADDR;
    static final int SIZEOF_SIZE_T;
    static final int SIZEOF_IOVEC;
    static final int CMSG_SPACE;
    static final int CMSG_LEN;
    static final int CMSG_OFFSETOF_CMSG_LEN;
    static final int CMSG_OFFSETOF_CMSG_LEVEL;
    static final int CMSG_OFFSETOF_CMSG_TYPE;
    static final int IOVEC_OFFSETOF_IOV_BASE;
    static final int IOVEC_OFFSETOF_IOV_LEN;
    static final int SIZEOF_MSGHDR;
    static final int MSGHDR_OFFSETOF_MSG_NAME;
    static final int MSGHDR_OFFSETOF_MSG_NAMELEN;
    static final int MSGHDR_OFFSETOF_MSG_IOV;
    static final int MSGHDR_OFFSETOF_MSG_IOVLEN;
    static final int MSGHDR_OFFSETOF_MSG_CONTROL;
    static final int MSGHDR_OFFSETOF_MSG_CONTROLLEN;
    static final int MSGHDR_OFFSETOF_MSG_FLAGS;
    static final int POLLIN;
    static final int POLLOUT;
    static final int POLLRDHUP;
    static final int ERRNO_ECANCELED_NEGATIVE;
    static final int ERRNO_ETIME_NEGATIVE;
    static final byte IORING_OP_POLL_ADD;
    static final byte IORING_OP_TIMEOUT;
    static final byte IORING_OP_ACCEPT;
    static final byte IORING_OP_READ;
    static final byte IORING_OP_WRITE;
    static final byte IORING_OP_POLL_REMOVE;
    static final byte IORING_OP_CONNECT;
    static final byte IORING_OP_CLOSE;
    static final byte IORING_OP_WRITEV;
    static final byte IORING_OP_SENDMSG;
    static final byte IORING_OP_RECVMSG;
    static final int IORING_ENTER_GETEVENTS;
    static final int IOSQE_ASYNC;
    static final int MSG_DONTWAIT;
    static final int SOL_UDP;
    static final int UDP_SEGMENT;
    private static final int[] REQUIRED_IORING_OPS;

    static RingBuffer createRingBuffer(int ringSize) {
        return Native.createRingBuffer(ringSize, DEFAULT_IOSEQ_ASYNC_THRESHOLD);
    }

    static RingBuffer createRingBuffer(int ringSize, int iosqeAsyncThreshold) {
        long[][] values = Native.ioUringSetup(ringSize);
        assert (values.length == 2);
        long[] submissionQueueArgs = values[0];
        assert (submissionQueueArgs.length == 11);
        IOUringSubmissionQueue submissionQueue = new IOUringSubmissionQueue(submissionQueueArgs[0], submissionQueueArgs[1], submissionQueueArgs[2], submissionQueueArgs[3], submissionQueueArgs[4], submissionQueueArgs[5], submissionQueueArgs[6], submissionQueueArgs[7], (int)submissionQueueArgs[8], submissionQueueArgs[9], (int)submissionQueueArgs[10], iosqeAsyncThreshold);
        long[] completionQueueArgs = values[1];
        assert (completionQueueArgs.length == 9);
        IOUringCompletionQueue completionQueue = new IOUringCompletionQueue(completionQueueArgs[0], completionQueueArgs[1], completionQueueArgs[2], completionQueueArgs[3], completionQueueArgs[4], completionQueueArgs[5], (int)completionQueueArgs[6], completionQueueArgs[7], (int)completionQueueArgs[8]);
        return new RingBuffer(submissionQueue, completionQueue);
    }

    static RingBuffer createRingBuffer() {
        return Native.createRingBuffer(DEFAULT_RING_SIZE, DEFAULT_IOSEQ_ASYNC_THRESHOLD);
    }

    static void checkAllIOSupported(int ringFd) {
        if (!Native.ioUringProbe(ringFd, REQUIRED_IORING_OPS)) {
            throw new UnsupportedOperationException("Not all operations are supported: " + Arrays.toString(REQUIRED_IORING_OPS));
        }
    }

    static boolean checkKernelVersion(String kernelVersion) {
        int minor;
        int major;
        String[] versionComponents = kernelVersion.split("\\.");
        if (versionComponents.length < 3) {
            return false;
        }
        try {
            major = Integer.parseInt(versionComponents[0]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (major <= 4) {
            return false;
        }
        if (major > 5) {
            return true;
        }
        try {
            minor = Integer.parseInt(versionComponents[1]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return minor >= 9;
    }

    private static native boolean ioUringProbe(int var0, int[] var1);

    private static native long[][] ioUringSetup(int var0);

    public static native int ioUringEnter(int var0, int var1, int var2, int var3);

    public static native void eventFdWrite(int var0, long var1);

    public static FileDescriptor newBlockingEventFd() {
        return new FileDescriptor(Native.blockingEventFd());
    }

    public static native void ioUringExit(long var0, int var2, long var3, int var5, long var6, int var8, int var9);

    private static native int blockingEventFd();

    public static native int createFile();

    private static native int registerUnix();

    static native long cmsghdrData(long var0);

    static native String kernelVersion();

    private Native() {
    }

    private static void loadNativeLibrary() {
        String name = PlatformDependent.normalizedOs().toLowerCase(Locale.UK).trim();
        if (!name.startsWith("linux")) {
            throw new IllegalStateException("Only supported on Linux");
        }
        String staticLibName = "netty_transport_native_io_uring";
        String sharedLibName = staticLibName + '_' + PlatformDependent.normalizedArch();
        ClassLoader cl = PlatformDependent.getClassLoader(Native.class);
        try {
            NativeLibraryLoader.load(sharedLibName, cl);
        }
        catch (UnsatisfiedLinkError e1) {
            try {
                NativeLibraryLoader.load(staticLibName, cl);
                logger.info("Failed to load io_uring");
            }
            catch (UnsatisfiedLinkError e2) {
                ThrowableUtil.addSuppressed((Throwable)e1, e2);
                throw e1;
            }
        }
    }

    static {
        Selector selector = null;
        try {
            selector = Selector.open();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ClassInitializerUtil.tryLoadClasses(Native.class, PeerCredentials.class, java.io.FileDescriptor.class);
        try {
            Native.createFile();
        }
        catch (UnsatisfiedLinkError ignore) {
            Native.loadNativeLibrary();
        }
        finally {
            try {
                if (selector != null) {
                    selector.close();
                }
            }
            catch (IOException iOException) {}
        }
        Unix.registerInternal(new Runnable(){

            @Override
            public void run() {
                Native.registerUnix();
            }
        });
        SOCK_NONBLOCK = NativeStaticallyReferencedJniMethods.sockNonblock();
        SOCK_CLOEXEC = NativeStaticallyReferencedJniMethods.sockCloexec();
        AF_INET = (short)NativeStaticallyReferencedJniMethods.afInet();
        AF_INET6 = (short)NativeStaticallyReferencedJniMethods.afInet6();
        SIZEOF_SOCKADDR_STORAGE = NativeStaticallyReferencedJniMethods.sizeofSockaddrStorage();
        SIZEOF_SOCKADDR_IN = NativeStaticallyReferencedJniMethods.sizeofSockaddrIn();
        SIZEOF_SOCKADDR_IN6 = NativeStaticallyReferencedJniMethods.sizeofSockaddrIn6();
        SOCKADDR_IN_OFFSETOF_SIN_FAMILY = NativeStaticallyReferencedJniMethods.sockaddrInOffsetofSinFamily();
        SOCKADDR_IN_OFFSETOF_SIN_PORT = NativeStaticallyReferencedJniMethods.sockaddrInOffsetofSinPort();
        SOCKADDR_IN_OFFSETOF_SIN_ADDR = NativeStaticallyReferencedJniMethods.sockaddrInOffsetofSinAddr();
        IN_ADDRESS_OFFSETOF_S_ADDR = NativeStaticallyReferencedJniMethods.inAddressOffsetofSAddr();
        SOCKADDR_IN6_OFFSETOF_SIN6_FAMILY = NativeStaticallyReferencedJniMethods.sockaddrIn6OffsetofSin6Family();
        SOCKADDR_IN6_OFFSETOF_SIN6_PORT = NativeStaticallyReferencedJniMethods.sockaddrIn6OffsetofSin6Port();
        SOCKADDR_IN6_OFFSETOF_SIN6_FLOWINFO = NativeStaticallyReferencedJniMethods.sockaddrIn6OffsetofSin6Flowinfo();
        SOCKADDR_IN6_OFFSETOF_SIN6_ADDR = NativeStaticallyReferencedJniMethods.sockaddrIn6OffsetofSin6Addr();
        SOCKADDR_IN6_OFFSETOF_SIN6_SCOPE_ID = NativeStaticallyReferencedJniMethods.sockaddrIn6OffsetofSin6ScopeId();
        IN6_ADDRESS_OFFSETOF_S6_ADDR = NativeStaticallyReferencedJniMethods.in6AddressOffsetofS6Addr();
        SIZEOF_SIZE_T = NativeStaticallyReferencedJniMethods.sizeofSizeT();
        SIZEOF_IOVEC = NativeStaticallyReferencedJniMethods.sizeofIovec();
        CMSG_SPACE = NativeStaticallyReferencedJniMethods.cmsgSpace();
        CMSG_LEN = NativeStaticallyReferencedJniMethods.cmsgLen();
        CMSG_OFFSETOF_CMSG_LEN = NativeStaticallyReferencedJniMethods.cmsghdrOffsetofCmsgLen();
        CMSG_OFFSETOF_CMSG_LEVEL = NativeStaticallyReferencedJniMethods.cmsghdrOffsetofCmsgLevel();
        CMSG_OFFSETOF_CMSG_TYPE = NativeStaticallyReferencedJniMethods.cmsghdrOffsetofCmsgType();
        IOVEC_OFFSETOF_IOV_BASE = NativeStaticallyReferencedJniMethods.iovecOffsetofIovBase();
        IOVEC_OFFSETOF_IOV_LEN = NativeStaticallyReferencedJniMethods.iovecOffsetofIovLen();
        SIZEOF_MSGHDR = NativeStaticallyReferencedJniMethods.sizeofMsghdr();
        MSGHDR_OFFSETOF_MSG_NAME = NativeStaticallyReferencedJniMethods.msghdrOffsetofMsgName();
        MSGHDR_OFFSETOF_MSG_NAMELEN = NativeStaticallyReferencedJniMethods.msghdrOffsetofMsgNamelen();
        MSGHDR_OFFSETOF_MSG_IOV = NativeStaticallyReferencedJniMethods.msghdrOffsetofMsgIov();
        MSGHDR_OFFSETOF_MSG_IOVLEN = NativeStaticallyReferencedJniMethods.msghdrOffsetofMsgIovlen();
        MSGHDR_OFFSETOF_MSG_CONTROL = NativeStaticallyReferencedJniMethods.msghdrOffsetofMsgControl();
        MSGHDR_OFFSETOF_MSG_CONTROLLEN = NativeStaticallyReferencedJniMethods.msghdrOffsetofMsgControllen();
        MSGHDR_OFFSETOF_MSG_FLAGS = NativeStaticallyReferencedJniMethods.msghdrOffsetofMsgFlags();
        POLLIN = NativeStaticallyReferencedJniMethods.pollin();
        POLLOUT = NativeStaticallyReferencedJniMethods.pollout();
        POLLRDHUP = NativeStaticallyReferencedJniMethods.pollrdhup();
        ERRNO_ECANCELED_NEGATIVE = -NativeStaticallyReferencedJniMethods.ecanceled();
        ERRNO_ETIME_NEGATIVE = -NativeStaticallyReferencedJniMethods.etime();
        IORING_OP_POLL_ADD = NativeStaticallyReferencedJniMethods.ioringOpPollAdd();
        IORING_OP_TIMEOUT = NativeStaticallyReferencedJniMethods.ioringOpTimeout();
        IORING_OP_ACCEPT = NativeStaticallyReferencedJniMethods.ioringOpAccept();
        IORING_OP_READ = NativeStaticallyReferencedJniMethods.ioringOpRead();
        IORING_OP_WRITE = NativeStaticallyReferencedJniMethods.ioringOpWrite();
        IORING_OP_POLL_REMOVE = NativeStaticallyReferencedJniMethods.ioringOpPollRemove();
        IORING_OP_CONNECT = NativeStaticallyReferencedJniMethods.ioringOpConnect();
        IORING_OP_CLOSE = NativeStaticallyReferencedJniMethods.ioringOpClose();
        IORING_OP_WRITEV = NativeStaticallyReferencedJniMethods.ioringOpWritev();
        IORING_OP_SENDMSG = NativeStaticallyReferencedJniMethods.ioringOpSendmsg();
        IORING_OP_RECVMSG = NativeStaticallyReferencedJniMethods.ioringOpRecvmsg();
        IORING_ENTER_GETEVENTS = NativeStaticallyReferencedJniMethods.ioringEnterGetevents();
        IOSQE_ASYNC = NativeStaticallyReferencedJniMethods.iosqeAsync();
        MSG_DONTWAIT = NativeStaticallyReferencedJniMethods.msgDontwait();
        SOL_UDP = NativeStaticallyReferencedJniMethods.solUdp();
        UDP_SEGMENT = NativeStaticallyReferencedJniMethods.udpSegment();
        REQUIRED_IORING_OPS = new int[]{IORING_OP_POLL_ADD, IORING_OP_TIMEOUT, IORING_OP_ACCEPT, IORING_OP_READ, IORING_OP_WRITE, IORING_OP_POLL_REMOVE, IORING_OP_CONNECT, IORING_OP_CLOSE, IORING_OP_WRITEV, IORING_OP_SENDMSG, IORING_OP_RECVMSG};
    }
}

