/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.util.NetUtil;
import io.netty.util.ReferenceCountUtil;
import io.servicetalk.transport.api.SecurityConfigurator;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

final class SslUtils {
    private SslUtils() {
    }

    static SslHandler newHandler(SslContext context, ByteBufAllocator allocator, @Nullable String hostnameVerificationAlgorithm, @Nullable String hostnameVerificationHost, int hostnameVerificationPort) {
        if (hostnameVerificationHost == null) {
            return SslUtils.newHandler(context, allocator);
        }
        SslHandler handler = context.newHandler(allocator, hostnameVerificationHost, hostnameVerificationPort);
        SSLEngine engine = handler.engine();
        try {
            SSLParameters parameters = engine.getSSLParameters();
            parameters.setEndpointIdentificationAlgorithm(hostnameVerificationAlgorithm);
            if (!NetUtil.isValidIpV4Address(hostnameVerificationHost) && !NetUtil.isValidIpV6Address(hostnameVerificationHost)) {
                parameters.setServerNames(Collections.singletonList(new SNIHostName(hostnameVerificationHost)));
            }
            engine.setSSLParameters(parameters);
        }
        catch (Throwable cause) {
            ReferenceCountUtil.release(engine);
            throw cause;
        }
        return handler;
    }

    static SslHandler newHandler(SslContext context, ByteBufAllocator allocator) {
        return context.newHandler(allocator);
    }

    static ApplicationProtocolConfig nettyApplicationProtocol(List<String> supportedAlpnProtocols) {
        if (supportedAlpnProtocols.isEmpty()) {
            return ApplicationProtocolConfig.DISABLED;
        }
        return new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, (Iterable<String>)supportedAlpnProtocols);
    }

    @Nullable
    static SslProvider toNettySslProvider(SecurityConfigurator.SslProvider provider, boolean alpn) {
        switch (provider) {
            case AUTO: {
                if (alpn) {
                    if (SslProvider.isAlpnSupported(SslProvider.OPENSSL)) {
                        return SslProvider.OPENSSL;
                    }
                    if (SslProvider.isAlpnSupported(SslProvider.JDK)) {
                        return SslProvider.JDK;
                    }
                    throw new IllegalStateException("ALPN configured but not supported by the current classpath: add OPENSSL support (https://netty.io/wiki/forked-tomcat-native.html) or configure ALPN for JDK (https://www.eclipse.org/jetty/documentation/current/alpn-chapter.html)");
                }
                return null;
            }
            case JDK: {
                if (alpn && !SslProvider.isAlpnSupported(SslProvider.JDK)) {
                    throw new IllegalStateException("ALPN configured but not supported by the current classpath. For more information, see https://www.eclipse.org/jetty/documentation/current/alpn-chapter.html");
                }
                return SslProvider.JDK;
            }
            case OPENSSL: {
                OpenSsl.ensureAvailability();
                if (alpn && !SslProvider.isAlpnSupported(SslProvider.OPENSSL)) {
                    throw new IllegalStateException("ALPN configured but not supported by installed version of OpenSSL");
                }
                return SslProvider.OPENSSL;
            }
        }
        throw new Error("Unknown SSL provider specified: " + (Object)((Object)provider));
    }
}

