/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.DomainNameMapping;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import io.servicetalk.transport.netty.internal.CopyByteBufHandlerChannelInitializer;
import io.servicetalk.transport.netty.internal.SslUtils;
import java.util.Objects;
import javax.annotation.Nullable;

public class SslServerChannelInitializer
implements ChannelInitializer {
    @Nullable
    private final DomainNameMapping<SslContext> domainNameMapping;
    @Nullable
    private final SslContext sslContext;

    public SslServerChannelInitializer(SslContext sslContext) {
        this.sslContext = Objects.requireNonNull(sslContext);
        this.domainNameMapping = null;
    }

    public SslServerChannelInitializer(DomainNameMapping<SslContext> domainNameMapping) {
        this.domainNameMapping = Objects.requireNonNull(domainNameMapping);
        this.sslContext = null;
    }

    @Override
    public void init(Channel channel) {
        if (this.sslContext != null) {
            SslHandler sslHandler = SslUtils.newHandler(this.sslContext, CopyByteBufHandlerChannelInitializer.POOLED_ALLOCATOR);
            channel.pipeline().addLast(sslHandler);
        } else {
            assert (this.domainNameMapping != null);
            channel.pipeline().addLast(new SniHandlerWithPooledAllocator(this.domainNameMapping));
        }
    }

    private static final class SniHandlerWithPooledAllocator
    extends SniHandler {
        SniHandlerWithPooledAllocator(DomainNameMapping<SslContext> domainNameMapping) {
            super(domainNameMapping);
        }

        @Override
        protected SslHandler newSslHandler(SslContext context, ByteBufAllocator ignore) {
            return super.newSslHandler(context, CopyByteBufHandlerChannelInitializer.POOLED_ALLOCATOR);
        }
    }
}

