/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DuplexChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.servicetalk.transport.netty.internal.CloseHandler;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestResponseCloseHandler
extends CloseHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestResponseCloseHandler.class);
    private final boolean isClient;
    private byte state;
    private int pending;
    @Nullable
    private CloseHandler.CloseEvent closeEvent;
    private Consumer<CloseHandler.CloseEvent> eventHandler = __ -> {};

    RequestResponseCloseHandler(boolean client) {
        this.isClient = client;
    }

    int state() {
        return this.state;
    }

    int pending() {
        return this.pending;
    }

    @Override
    void registerEventHandler(Channel channel, Consumer<CloseHandler.CloseEvent> eventHandler) {
        assert (channel.eventLoop().inEventLoop());
        assert (channel instanceof DuplexChannel) : "Channel does not implement DuplexChannel";
        assert (Boolean.TRUE.equals(channel.config().getOption(ChannelOption.ALLOW_HALF_CLOSURE))) : "Half-Closure DISABLED, this may violate some protocols";
        this.eventHandler = Objects.requireNonNull(eventHandler);
    }

    private void storeCloseRequestAndEmit(CloseHandler.CloseEvent event) {
        if (this.closeEvent == null) {
            this.closeEvent = event;
        }
        this.eventHandler.accept(event);
    }

    @Override
    public void protocolPayloadBeginInbound(ChannelHandlerContext ctx) {
        assert (ctx.executor().inEventLoop());
        int n = this.pending = this.isClient ? this.pending - 1 : this.pending + 1;
        assert (this.pending >= 0) : "Negative pending counter";
        this.state = State.set(this.state, (byte)1);
    }

    @Override
    public void protocolPayloadEndInbound(ChannelHandlerContext ctx) {
        assert (ctx.executor().inEventLoop());
        this.state = State.unset(this.state, (byte)1);
        CloseHandler.CloseEvent evt = this.closeEvent;
        if (evt != null) {
            this.closeChannelHalfOrFullyOnPayloadEnd(ctx.channel(), evt, true);
        }
    }

    @Override
    public void protocolPayloadBeginOutbound(ChannelHandlerContext ctx) {
        assert (ctx.executor().inEventLoop());
        int n = this.pending = this.isClient ? this.pending + 1 : this.pending - 1;
        assert (this.pending >= 0) : "Negative pending counter";
        this.state = State.set(this.state, (byte)2);
    }

    @Override
    public void protocolPayloadEndOutbound(ChannelHandlerContext ctx, ChannelPromise promise) {
        if (this.isClient || this.closeEvent != null && this.pending == 0) {
            ctx.pipeline().fireUserEventTriggered(CloseHandler.OutboundDataEndEvent.INSTANCE);
        }
        promise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            this.state = State.unset(this.state, (byte)2);
            CloseHandler.CloseEvent evt = this.closeEvent;
            if (evt != null) {
                this.closeChannelHalfOrFullyOnPayloadEnd(ctx.channel(), evt, false);
            }
        }));
    }

    @Override
    public void protocolClosingInbound(ChannelHandlerContext ctx) {
        assert (ctx.executor().inEventLoop());
        this.storeCloseRequestAndEmit(CloseHandler.CloseEvent.PROTOCOL_CLOSING_INBOUND);
        this.maybeCloseChannelHalfOrFullyOnClosing(ctx.channel(), CloseHandler.CloseEvent.PROTOCOL_CLOSING_INBOUND);
    }

    @Override
    public void protocolClosingOutbound(ChannelHandlerContext ctx) {
        assert (ctx.executor().inEventLoop());
        this.storeCloseRequestAndEmit(CloseHandler.CloseEvent.PROTOCOL_CLOSING_OUTBOUND);
        this.maybeCloseChannelHalfOrFullyOnClosing(ctx.channel(), CloseHandler.CloseEvent.PROTOCOL_CLOSING_OUTBOUND);
    }

    @Override
    void channelClosedInbound(ChannelHandlerContext ctx) {
        CloseHandler.CloseEvent evt;
        assert (ctx.executor().inEventLoop());
        this.state = State.set(this.state, (byte)16);
        CloseHandler.CloseEvent closeEvent = evt = State.has(this.state, (byte)8) ? this.closeEvent : CloseHandler.CloseEvent.CHANNEL_CLOSED_INBOUND;
        assert (evt != null);
        this.storeCloseRequestAndEmit(evt);
        this.maybeCloseChannelOnHalfClosed(ctx.channel(), evt);
        this.state = State.unset(this.state, (byte)1);
    }

    @Override
    void channelClosedOutbound(ChannelHandlerContext ctx) {
        assert (ctx.executor().inEventLoop());
        this.state = State.set(this.state, (byte)32);
        this.storeCloseRequestAndEmit(CloseHandler.CloseEvent.CHANNEL_CLOSED_OUTBOUND);
        if (!State.has(this.state, (byte)8)) {
            this.maybeCloseChannelOnHalfClosed(ctx.channel(), CloseHandler.CloseEvent.CHANNEL_CLOSED_OUTBOUND);
        }
        this.state = State.unset(this.state, (byte)2);
    }

    @Override
    void closeChannelInbound(Channel channel) {
        if (!State.hasAny(this.state, (byte)16, (byte)8)) {
            LOGGER.debug("{} Half-Closing INBOUND (reset)", (Object)channel);
            this.setSocketResetOnClose(channel);
            ((DuplexChannel)channel).shutdownInput().addListener(this::onHalfClosed);
        }
    }

    @Override
    void closeChannelOutbound(Channel channel) {
        if (!State.has(this.state, (byte)32)) {
            LOGGER.debug("{} Half-Closing OUTBOUND (reset)", (Object)channel);
            this.setSocketResetOnClose(channel);
            this.halfCloseOutbound(channel, true);
        }
    }

    @Override
    void gracefulUserClosing(Channel channel) {
        assert (channel.eventLoop().inEventLoop());
        this.storeCloseRequestAndEmit(CloseHandler.CloseEvent.GRACEFUL_USER_CLOSING);
        this.maybeCloseChannelHalfOrFullyOnClosing(channel, CloseHandler.CloseEvent.GRACEFUL_USER_CLOSING);
    }

    private void closeChannelHalfOrFullyOnPayloadEnd(Channel channel, CloseHandler.CloseEvent evt, boolean endInbound) {
        if (State.idle(this.pending, this.state)) {
            if (this.isClient || State.has(this.state, (byte)16) || evt != CloseHandler.CloseEvent.GRACEFUL_USER_CLOSING && evt != CloseHandler.CloseEvent.PROTOCOL_CLOSING_OUTBOUND) {
                this.closeChannel(channel, evt);
            } else {
                this.serverCloseGracefully(channel);
            }
        } else if (!this.isClient && endInbound) {
            this.serverHalfCloseInbound(channel);
        }
    }

    private void maybeCloseChannelHalfOrFullyOnClosing(Channel channel, CloseHandler.CloseEvent evt) {
        if (State.idle(this.pending, this.state)) {
            assert (evt == CloseHandler.CloseEvent.GRACEFUL_USER_CLOSING);
            if (this.isClient) {
                this.closeChannel(channel, evt);
            } else {
                this.serverCloseGracefully(channel);
            }
        } else if (this.isClient) {
            if (evt == CloseHandler.CloseEvent.PROTOCOL_CLOSING_INBOUND && this.pending != 0) {
                if (State.has(this.state, (byte)2)) {
                    channel.pipeline().fireUserEventTriggered(CloseHandler.AbortWritesEvent.INSTANCE);
                    this.state = State.unset(this.state, (byte)2);
                }
                this.pending = 0;
            }
        } else if (evt == CloseHandler.CloseEvent.PROTOCOL_CLOSING_OUTBOUND) {
            if (this.pending != 0 || !State.has(this.state, (byte)1)) {
                this.serverHalfCloseInbound(channel);
            }
            this.pending = 0;
        } else if (!State.has(this.state, (byte)1)) {
            assert (evt == CloseHandler.CloseEvent.GRACEFUL_USER_CLOSING);
            this.serverHalfCloseInbound(channel);
        }
    }

    private void maybeCloseChannelOnHalfClosed(Channel channel, CloseHandler.CloseEvent evt) {
        if (State.idle(this.pending, this.state)) {
            this.closeChannel(channel, evt);
        } else if (this.isClient) {
            if (evt == CloseHandler.CloseEvent.CHANNEL_CLOSED_INBOUND) {
                if (this.pending != 0) {
                    if (State.has(this.state, (byte)2)) {
                        this.closeAndResetChannel(channel, evt);
                    } else {
                        this.closeChannel(channel, evt);
                    }
                } else {
                    this.state = State.unset(this.state, (byte)1);
                    if (State.idle(this.pending, this.state)) {
                        this.closeChannel(channel, evt);
                    }
                }
            } else if (State.has(this.state, (byte)2)) {
                assert (evt == CloseHandler.CloseEvent.CHANNEL_CLOSED_OUTBOUND);
                this.setSocketResetOnClose(channel);
                if (this.pending <= 1 && !State.has(this.state, (byte)1)) {
                    this.closeChannel(channel, evt);
                } else if (this.pending != 0) {
                    --this.pending;
                }
            }
        } else if (evt == CloseHandler.CloseEvent.CHANNEL_CLOSED_INBOUND) {
            if (State.has(this.state, (byte)1)) {
                this.state = State.unset(this.state, (byte)1);
                this.setSocketResetOnClose(channel);
                if (State.idle(this.pending, this.state)) {
                    this.closeChannel(channel, evt);
                }
            }
        } else if (this.pending != 0) {
            assert (evt == CloseHandler.CloseEvent.CHANNEL_CLOSED_OUTBOUND);
            this.closeAndResetChannel(channel, evt);
        } else if (!State.has(this.state, (byte)1)) {
            assert (evt == CloseHandler.CloseEvent.CHANNEL_CLOSED_OUTBOUND);
            this.closeChannel(channel, evt);
        }
    }

    private void closeChannel(Channel channel, @Nullable CloseHandler.CloseEvent evt) {
        if (!State.has(this.state, (byte)64)) {
            this.state = State.set(this.state, (byte)112);
            LOGGER.debug("{} Closing channel \u2013 evt: {}", (Object)channel, evt == null ? "FullCloseAfterHalfClose" : evt);
            channel.close();
        }
    }

    private void closeAndResetChannel(Channel channel, @Nullable CloseHandler.CloseEvent evt) {
        if (!State.has(this.state, (byte)64)) {
            LOGGER.debug("{} Closing channel \u2013 evt: {} - reset", (Object)channel, evt == null ? "FullCloseAfterHalfClose" : evt);
            this.setSocketResetOnClose(channel);
            this.state = State.set(this.state, (byte)112);
            channel.close();
        }
    }

    private void setSocketResetOnClose(Channel channel) {
        if (channel instanceof SocketChannel && !State.has(this.state, (byte)48)) {
            try {
                ((SocketChannel)channel).config().setSoLinger(0);
            }
            catch (Exception e) {
                LOGGER.trace("{} set SO_LINGER=0 failed (expected when IN+OUT or IN+RST closed channel): {}", (Object)channel, (Object)e.getMessage());
            }
        }
    }

    private void serverCloseGracefully(Channel channel) {
        this.serverHalfCloseInbound(channel);
        this.serverHalfCloseOutbound(channel);
    }

    private void serverHalfCloseInbound(Channel channel) {
        assert (!this.isClient);
        if (!State.hasAny(this.state, (byte)4, (byte)16)) {
            LOGGER.debug("{} Discarding further INBOUND", (Object)channel);
            this.state = State.unset(this.state, (byte)1);
            channel.pipeline().fireUserEventTriggered(CloseHandler.DiscardFurtherInboundEvent.INSTANCE);
            this.state = State.set(this.state, (byte)4);
        }
    }

    private void serverHalfCloseOutbound(Channel channel) {
        assert (!this.isClient && State.idle(this.pending, this.state));
        if (!State.has(this.state, (byte)32)) {
            this.state = State.set(this.state, (byte)8);
            LOGGER.debug("{} Half-Closing OUTBOUND", (Object)channel);
            this.halfCloseOutbound(channel, false);
        }
    }

    private void halfCloseOutbound(Channel channel, boolean registerOnHalfClosed) {
        SslHandler sslHandler = channel.pipeline().get(SslHandler.class);
        if (sslHandler != null) {
            sslHandler.closeOutbound().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
                ChannelFuture cf = ((DuplexChannel)channel).shutdownOutput();
                if (registerOnHalfClosed) {
                    cf.addListener(this::onHalfClosed);
                }
            }));
        } else {
            ChannelFuture cf = ((DuplexChannel)channel).shutdownOutput();
            if (registerOnHalfClosed) {
                cf.addListener(this::onHalfClosed);
            }
        }
    }

    private void onHalfClosed(ChannelFuture future) {
        DuplexChannel dplxChannel = (DuplexChannel)future.channel();
        if (dplxChannel.isInputShutdown() && dplxChannel.isOutputShutdown()) {
            LOGGER.debug("{} Fully closing socket channel, both input and output shutdown", (Object)dplxChannel);
            this.closeChannel(dplxChannel, null);
        }
    }

    protected static interface State {
        public static final byte READ = 1;
        public static final byte WRITE = 2;
        public static final byte DISCARDING_SERVER_INPUT = 4;
        public static final byte CLOSING_SERVER_GRACEFULLY = 8;
        public static final byte IN_CLOSED = 16;
        public static final byte OUT_CLOSED = 32;
        public static final byte CLOSED = 64;
        public static final byte ALL_CLOSED = 112;
        public static final byte IN_OUT_CLOSED = 48;
        public static final byte MASK_IDLE = 3;

        public static boolean idle(int pending, byte state) {
            return pending == 0 && (state & 3) == 0;
        }

        public static boolean has(byte state, byte mask) {
            return (state & mask) == mask;
        }

        public static boolean hasAny(byte state, byte flag1, byte flag2) {
            return (state & (flag1 | flag2)) != 0;
        }

        public static byte set(byte state, byte flags) {
            return (byte)(state | flags);
        }

        public static byte unset(byte state, byte flags) {
            return (byte)(state & ~flags);
        }
    }
}

