/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.netty.internal.EventLoopAwareNettyIoExecutor;
import io.servicetalk.transport.netty.internal.EventLoopGroupIoExecutor;
import io.servicetalk.transport.netty.internal.EventLoopIoExecutor;
import io.servicetalk.transport.netty.internal.NettyIoExecutor;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;

public final class NettyIoExecutors {
    private NettyIoExecutors() {
    }

    public static EventLoopAwareNettyIoExecutor createIoExecutor(ThreadFactory threadFactory) {
        return NettyIoExecutors.createIoExecutor(Runtime.getRuntime().availableProcessors() * 2, threadFactory);
    }

    public static EventLoopAwareNettyIoExecutor createIoExecutor(int ioThreads, ThreadFactory threadFactory) {
        NettyIoExecutors.validateIoThreads(ioThreads);
        return new EventLoopGroupIoExecutor(NettyIoExecutors.createEventLoopGroup(ioThreads, threadFactory), true);
    }

    public static EventLoopGroup createEventLoopGroup(int ioThreads, ThreadFactory threadFactory) {
        NettyIoExecutors.validateIoThreads(ioThreads);
        return Epoll.isAvailable() ? new EpollEventLoopGroup(ioThreads, threadFactory) : (KQueue.isAvailable() ? new KQueueEventLoopGroup(ioThreads, threadFactory) : new NioEventLoopGroup(ioThreads, threadFactory));
    }

    public static NettyIoExecutor toNettyIoExecutor(IoExecutor ioExecutor) {
        Objects.requireNonNull(ioExecutor);
        if (ioExecutor instanceof NettyIoExecutor) {
            return (NettyIoExecutor)ioExecutor;
        }
        throw new IllegalArgumentException("Incompatible IoExecutor: " + ioExecutor + ". Not a netty based IoExecutor.");
    }

    public static NettyIoExecutor fromNettyEventLoop(EventLoop eventLoop) {
        return new EventLoopIoExecutor(eventLoop, true);
    }

    public static NettyIoExecutor fromNettyEventLoopGroup(EventLoopGroup eventLoopGroup) {
        return new EventLoopGroupIoExecutor(eventLoopGroup, true);
    }

    private static void validateIoThreads(int ioThreads) {
        if (ioThreads <= 0) {
            throw new IllegalArgumentException("ioThreads: " + ioThreads + " (expected >0)");
        }
    }
}

