/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.Channel;
import io.netty.util.concurrent.EventExecutor;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.netty.internal.FlushStrategy;
import java.util.Objects;

final class Flush {
    private Flush() {
    }

    static <T> Publisher<T> composeFlushes(Channel channel, Publisher<T> source, FlushStrategy flushStrategy, ConnectionObserver.WriteObserver observer) {
        Objects.requireNonNull(channel);
        Objects.requireNonNull(flushStrategy);
        return source.liftSync(subscriber -> new FlushSubscriber(flushStrategy, subscriber, channel, observer));
    }

    private static final class FlushSubscriber<T>
    implements PublisherSource.Subscriber<T> {
        private final EventExecutor eventLoop;
        private final PublisherSource.Subscriber<? super T> subscriber;
        private final ConnectionObserver.WriteObserver observer;
        private final FlushStrategy.WriteEventsListener writeEventsListener;
        private volatile boolean enqueueFlush;

        FlushSubscriber(FlushStrategy flushStrategy, PublisherSource.Subscriber<? super T> subscriber, Channel channel, ConnectionObserver.WriteObserver observer) {
            this.eventLoop = Objects.requireNonNull(channel.eventLoop());
            this.subscriber = Objects.requireNonNull(subscriber);
            this.observer = observer;
            this.writeEventsListener = flushStrategy.apply(() -> {
                observer.onFlushRequest();
                if (this.enqueueFlush) {
                    this.eventLoop.execute(channel::flush);
                } else {
                    channel.flush();
                }
            });
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription subscription) {
            try {
                this.writeEventsListener.writeStarted();
                this.subscriber.onSubscribe(new PublisherSource.Subscription(this, subscription){
                    final /* synthetic */ PublisherSource.Subscription val$subscription;
                    final /* synthetic */ FlushSubscriber this$0;
                    {
                        this.this$0 = this$0;
                        this.val$subscription = subscription;
                    }

                    @Override
                    public void request(long n) {
                        this.this$0.observer.requestedToWrite(n);
                        this.val$subscription.request(n);
                    }

                    @Override
                    public void cancel() {
                        this.this$0.observer.writeCancelled();
                        this.val$subscription.cancel();
                        this.this$0.writeEventsListener.writeCancelled();
                    }
                });
            }
            catch (Throwable throwable) {
                this.subscriber.onSubscribe(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.eventLoop.inEventLoop() && !this.enqueueFlush) {
                this.enqueueFlush = true;
            }
            this.observer.itemReceived();
            this.subscriber.onNext(t);
            this.writeEventsListener.itemWritten(t);
        }

        @Override
        public void onError(Throwable t) {
            try {
                this.writeEventsListener.writeTerminated();
            }
            catch (Throwable t1) {
                t.addSuppressed(t1);
            }
            this.subscriber.onError(t);
        }

        @Override
        public void onComplete() {
            try {
                this.writeEventsListener.writeTerminated();
            }
            catch (Throwable t) {
                this.subscriber.onError(t);
                return;
            }
            this.subscriber.onComplete();
        }
    }
}

