/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.transport.api.DefaultExecutionContext;
import io.servicetalk.transport.api.ExecutionContext;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.netty.internal.GlobalExecutionContext;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ExecutionContextBuilder {
    @Nullable
    private IoExecutor ioExecutor;
    @Nullable
    private Executor executor;
    @Nullable
    private BufferAllocator allocator;
    @Nullable
    private ExecutionStrategy strategy;

    public ExecutionContextBuilder() {
    }

    public ExecutionContextBuilder(ExecutionContextBuilder other) {
        this.ioExecutor = other.ioExecutor;
        this.executor = other.executor;
        this.allocator = other.allocator;
        this.strategy = other.strategy;
    }

    public ExecutionContextBuilder ioExecutor(IoExecutor ioExecutor) {
        this.ioExecutor = Objects.requireNonNull(ioExecutor);
        return this;
    }

    public ExecutionContextBuilder executor(Executor executor) {
        this.executor = Objects.requireNonNull(executor);
        return this;
    }

    public ExecutionContextBuilder bufferAllocator(BufferAllocator allocator) {
        this.allocator = Objects.requireNonNull(allocator);
        return this;
    }

    public ExecutionContextBuilder executionStrategy(ExecutionStrategy strategy) {
        this.strategy = Objects.requireNonNull(strategy);
        return this;
    }

    public ExecutionContext build() {
        if (this.ioExecutor == null && this.executor == null && this.allocator == null && this.strategy == null) {
            return GlobalExecutionContext.globalExecutionContext();
        }
        Executor executor = this.executor == null ? (this.strategy != null ? this.strategy.executor() : null) : this.executor;
        return new DefaultExecutionContext(this.allocator == null ? GlobalExecutionContext.globalExecutionContext().bufferAllocator() : this.allocator, this.ioExecutor == null ? GlobalExecutionContext.globalExecutionContext().ioExecutor() : this.ioExecutor, executor == null ? GlobalExecutionContext.globalExecutionContext().executor() : executor, this.strategy == null ? GlobalExecutionContext.globalExecutionContext().executionStrategy() : this.strategy);
    }
}

