/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ScheduledFuture;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.transport.netty.internal.NativeTransportUtils;
import io.servicetalk.transport.netty.internal.NettyFutureCompletable;
import io.servicetalk.transport.netty.internal.NettyIoExecutor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

abstract class AbstractNettyIoExecutor<T extends EventLoopGroup>
implements NettyIoExecutor,
Executor {
    protected final T eventLoop;
    protected final boolean interruptOnCancel;

    AbstractNettyIoExecutor(T eventLoop, boolean interruptOnCancel) {
        this.eventLoop = eventLoop;
        this.interruptOnCancel = interruptOnCancel;
    }

    @Override
    public Completable closeAsync() {
        return new NettyFutureCompletable(() -> this.eventLoop.shutdownGracefully(0L, 0L, TimeUnit.NANOSECONDS));
    }

    @Override
    public Completable closeAsyncGracefully() {
        return new NettyFutureCompletable(() -> this.eventLoop.shutdownGracefully());
    }

    @Override
    public final Completable onClose() {
        return new NettyFutureCompletable(() -> this.eventLoop.terminationFuture());
    }

    @Override
    public final boolean isUnixDomainSocketSupported() {
        return NativeTransportUtils.isUnixDomainSocketSupported(this.eventLoop);
    }

    @Override
    public boolean isFileDescriptorSocketAddressSupported() {
        return NativeTransportUtils.isFileDescriptorSocketAddressSupported(this.eventLoop);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractNettyIoExecutor that = (AbstractNettyIoExecutor)o;
        return this.interruptOnCancel == that.interruptOnCancel && this.eventLoop.equals(that.eventLoop);
    }

    public int hashCode() {
        int result = this.eventLoop.hashCode();
        result = 31 * result + (this.interruptOnCancel ? 1 : 0);
        return result;
    }

    @Override
    public Executor asExecutor() {
        return this;
    }

    @Override
    public Cancellable execute(Runnable task) throws RejectedExecutionException {
        Future<?> future = this.eventLoop.submit(task);
        return () -> future.cancel(this.interruptOnCancel);
    }

    @Override
    public Cancellable schedule(Runnable task, long delay, TimeUnit unit) throws RejectedExecutionException {
        ScheduledFuture<?> future = this.eventLoop.schedule(task, delay, unit);
        return () -> future.cancel(this.interruptOnCancel);
    }
}

