/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.tcp.netty.internal;

import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContext;
import io.servicetalk.logging.api.UserDataLoggerConfig;
import io.servicetalk.tcp.netty.internal.AbstractTcpConfig;
import io.servicetalk.transport.netty.internal.FlushStrategy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

abstract class AbstractReadOnlyTcpConfig<SecurityConfig, ReadOnlyView> {
    private final Map<ChannelOption, Object> options;
    @Nullable
    private final Long idleTimeoutMs;
    private final FlushStrategy flushStrategy;
    @Nullable
    private final UserDataLoggerConfig wireLoggerConfig;
    @Nullable
    private final String preferredAlpnProtocol;

    protected AbstractReadOnlyTcpConfig(AbstractTcpConfig<SecurityConfig, ReadOnlyView> from, @Nullable String preferredAlpnProtocol) {
        this.options = from.options() == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<ChannelOption, Object>(from.options()));
        this.idleTimeoutMs = from.idleTimeoutMs();
        this.flushStrategy = from.flushStrategy();
        this.wireLoggerConfig = from.wireLoggerConfig();
        this.preferredAlpnProtocol = preferredAlpnProtocol;
    }

    public final Map<ChannelOption, Object> options() {
        return this.options;
    }

    @Nullable
    public final Long idleTimeoutMs() {
        return this.idleTimeoutMs;
    }

    public final FlushStrategy flushStrategy() {
        return this.flushStrategy;
    }

    @Nullable
    public final UserDataLoggerConfig wireLoggerConfig() {
        return this.wireLoggerConfig;
    }

    public boolean isAlpnConfigured() {
        return this.preferredAlpnProtocol != null;
    }

    @Nullable
    public String preferredAlpnProtocol() {
        return this.preferredAlpnProtocol;
    }

    @Nullable
    public abstract SslContext sslContext();
}

