/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.serialization.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.GracefulAutoCloseable;
import io.servicetalk.serialization.api.BlockingIterableFlatMap;
import java.util.ArrayList;

public interface StreamingDeserializer<T>
extends GracefulAutoCloseable {
    public Iterable<T> deserialize(Buffer var1);

    default public Iterable<T> deserialize(Iterable<Buffer> toDeserialize) {
        ArrayList<T> deserialized = new ArrayList<T>(2);
        for (Buffer buffer : toDeserialize) {
            for (T t : this.deserialize(buffer)) {
                deserialized.add(t);
            }
        }
        return deserialized;
    }

    default public BlockingIterable<T> deserialize(BlockingIterable<Buffer> toDeserialize) {
        return new BlockingIterableFlatMap(toDeserialize, this::deserialize);
    }

    public boolean hasData();

    @Override
    public void close();
}

