/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.serialization.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.BlockingIterator;
import io.servicetalk.concurrent.CloseableIterable;
import io.servicetalk.concurrent.CloseableIterator;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.api.internal.SubscribablePublisher;
import io.servicetalk.concurrent.internal.AbstractCloseableIterable;
import io.servicetalk.serialization.api.SerializationException;
import io.servicetalk.serialization.api.SerializationProvider;
import io.servicetalk.serialization.api.Serializer;
import io.servicetalk.serialization.api.StreamingDeserializer;
import io.servicetalk.serialization.api.StreamingSerializer;
import io.servicetalk.serialization.api.TypeHolder;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class DefaultSerializer
implements Serializer {
    private static final int MAX_READABLE_BYTES_TO_ADJUST = 524287;
    private static final int DEFAULT_SERIALIZATION_SIZE_BYTES_ESTIMATE = 512;
    private static final IntUnaryOperator DEFAULT_SIZE_ESTIMATOR = lastSize -> Math.max(512, (Math.min(524287, lastSize) << 2) / 3);
    private final SerializationProvider serializationProvider;

    public DefaultSerializer(SerializationProvider serializationProvider) {
        this.serializationProvider = Objects.requireNonNull(serializationProvider);
    }

    @Override
    public <T> Publisher<Buffer> serialize(Publisher<T> source, BufferAllocator allocator, Class<T> type) {
        return this.serialize(source, allocator, type, DEFAULT_SIZE_ESTIMATOR);
    }

    @Override
    public <T> Iterable<Buffer> serialize(Iterable<T> source, BufferAllocator allocator, Class<T> type) {
        return this.serialize(source, allocator, type, DEFAULT_SIZE_ESTIMATOR);
    }

    @Override
    public <T> BlockingIterable<Buffer> serialize(BlockingIterable<T> source, BufferAllocator allocator, Class<T> type) {
        return this.serialize(source, allocator, type, DEFAULT_SIZE_ESTIMATOR);
    }

    @Override
    public <T> Publisher<Buffer> serialize(final Publisher<T> source, final BufferAllocator allocator, final Class<T> type, final IntUnaryOperator bytesEstimator) {
        return new SubscribablePublisher<Buffer>(){

            @Override
            protected void handleSubscribe(PublisherSource.Subscriber<? super Buffer> subscriber) {
                DefaultSerializer.applySerializer0(subscriber, allocator, bytesEstimator, DefaultSerializer.this.serializationProvider.getSerializer(type), source);
            }
        };
    }

    @Override
    public <T> Iterable<Buffer> serialize(Iterable<T> source, BufferAllocator allocator, Class<T> type, IntUnaryOperator bytesEstimator) {
        return DefaultSerializer.applySerializer0(allocator, bytesEstimator, source, this.serializationProvider.getSerializer(type));
    }

    @Override
    public <T> BlockingIterable<Buffer> serialize(BlockingIterable<T> source, BufferAllocator allocator, Class<T> type, IntUnaryOperator bytesEstimator) {
        return DefaultSerializer.applySerializer0(allocator, bytesEstimator, source, this.serializationProvider.getSerializer(type));
    }

    @Override
    public <T> Publisher<Buffer> serialize(Publisher<T> source, BufferAllocator allocator, TypeHolder<T> typeHolder) {
        return this.serialize(source, allocator, typeHolder, DEFAULT_SIZE_ESTIMATOR);
    }

    @Override
    public <T> Iterable<Buffer> serialize(Iterable<T> source, BufferAllocator allocator, TypeHolder<T> typeHolder) {
        return this.serialize(source, allocator, typeHolder, DEFAULT_SIZE_ESTIMATOR);
    }

    @Override
    public <T> BlockingIterable<Buffer> serialize(BlockingIterable<T> source, BufferAllocator allocator, TypeHolder<T> typeHolder) {
        return this.serialize(source, allocator, typeHolder, DEFAULT_SIZE_ESTIMATOR);
    }

    @Override
    public <T> Publisher<Buffer> serialize(final Publisher<T> source, final BufferAllocator allocator, final TypeHolder<T> typeHolder, final IntUnaryOperator bytesEstimator) {
        return new SubscribablePublisher<Buffer>(){

            @Override
            protected void handleSubscribe(PublisherSource.Subscriber<? super Buffer> subscriber) {
                DefaultSerializer.applySerializer0(subscriber, allocator, bytesEstimator, DefaultSerializer.this.serializationProvider.getSerializer(typeHolder), source);
            }
        };
    }

    @Override
    public <T> Iterable<Buffer> serialize(Iterable<T> source, BufferAllocator allocator, TypeHolder<T> typeHolder, IntUnaryOperator bytesEstimator) {
        StreamingSerializer serializer = this.serializationProvider.getSerializer(typeHolder);
        return DefaultSerializer.applySerializer0(allocator, bytesEstimator, source, serializer);
    }

    @Override
    public <T> BlockingIterable<Buffer> serialize(BlockingIterable<T> source, BufferAllocator allocator, TypeHolder<T> typeHolder, IntUnaryOperator bytesEstimator) {
        return DefaultSerializer.applySerializer0(allocator, bytesEstimator, source, this.serializationProvider.getSerializer(typeHolder));
    }

    @Override
    public <T> Buffer serialize(T toSerialize, BufferAllocator allocator) {
        return this.serialize(toSerialize, allocator, 512);
    }

    @Override
    public <T> Buffer serialize(T toSerialize, BufferAllocator allocator, int bytesEstimate) {
        Buffer destination = allocator.newBuffer(bytesEstimate);
        this.serializationProvider.serialize(toSerialize, destination);
        return destination;
    }

    @Override
    public <T> void serialize(T toSerialize, Buffer destination) {
        this.serializationProvider.serialize(toSerialize, destination);
    }

    @Override
    public <T> Publisher<T> deserialize(final Publisher<Buffer> source, final TypeHolder<T> typeHolder) {
        return new SubscribablePublisher<T>(){

            @Override
            protected void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber) {
                DefaultSerializer.applyDeserializer0(source, subscriber, DefaultSerializer.this.serializationProvider.getDeserializer(typeHolder));
            }
        };
    }

    @Override
    public <T> CloseableIterable<T> deserialize(Iterable<Buffer> source, TypeHolder<T> typeHolder) {
        return DefaultSerializer.applyDeserializer0(source, this.serializationProvider.getDeserializer(typeHolder));
    }

    @Override
    public <T> BlockingIterable<T> deserialize(BlockingIterable<Buffer> source, TypeHolder<T> typeHolder) {
        return this.serializationProvider.getDeserializer(typeHolder).deserialize(source);
    }

    @Override
    public <T> Publisher<T> deserialize(final Publisher<Buffer> source, final Class<T> type) {
        return new SubscribablePublisher<T>(){

            @Override
            protected void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber) {
                DefaultSerializer.applyDeserializer0(source, subscriber, DefaultSerializer.this.serializationProvider.getDeserializer(type));
            }
        };
    }

    @Override
    public <T> CloseableIterable<T> deserialize(Iterable<Buffer> source, Class<T> type) {
        return DefaultSerializer.applyDeserializer0(source, this.serializationProvider.getDeserializer(type));
    }

    @Override
    public <T> BlockingIterable<T> deserialize(BlockingIterable<Buffer> source, Class<T> type) {
        return this.serializationProvider.getDeserializer(type).deserialize(source);
    }

    @Override
    public <T> CloseableIterable<T> deserializeAggregated(Buffer serializedData, Class<T> type) {
        return DefaultSerializer.deserializeAggregated0(serializedData, this.serializationProvider.getDeserializer(type));
    }

    @Override
    public <T> CloseableIterable<T> deserializeAggregated(Buffer serializedData, TypeHolder<T> typeHolder) {
        return DefaultSerializer.deserializeAggregated0(serializedData, this.serializationProvider.getDeserializer(typeHolder));
    }

    @Override
    public <T> T deserializeAggregatedSingle(Buffer serializedData, Class<T> type) {
        return DefaultSerializer.getSingleValueOnly(this.deserializeAggregated(serializedData, type));
    }

    @Override
    public <T> T deserializeAggregatedSingle(Buffer serializedData, TypeHolder<T> typeHolder) {
        return DefaultSerializer.getSingleValueOnly(this.deserializeAggregated(serializedData, typeHolder));
    }

    private static <T> void applySerializer0(PublisherSource.Subscriber<? super Buffer> subscriber, BufferAllocator allocator, IntUnaryOperator bytesEstimator, StreamingSerializer serializer, Publisher<T> source) {
        SourceAdapters.toSource(source.map(new SerializerFunction(bytesEstimator, allocator, serializer))).subscribe(subscriber);
    }

    private static <T> Iterable<Buffer> applySerializer0(BufferAllocator allocator, IntUnaryOperator bytesEstimator, Iterable<T> source, StreamingSerializer serializer) {
        return StreamSupport.stream(source.spliterator(), false).map(new SerializerFunction(bytesEstimator, allocator, serializer)).collect(Collectors.toList());
    }

    @Nonnull
    private static <T> BlockingIterable<Buffer> applySerializer0(BufferAllocator allocator, IntUnaryOperator bytesEstimator, BlockingIterable<T> source, StreamingSerializer serializer) {
        SerializerFunction serializerFunction = new SerializerFunction(bytesEstimator, allocator, serializer);
        return () -> {
            CloseableIterator iterator = source.iterator();
            return new BlockingIterator<Buffer>((BlockingIterator)iterator, serializerFunction){
                final /* synthetic */ BlockingIterator val$iterator;
                final /* synthetic */ SerializerFunction val$serializerFunction;
                {
                    this.val$iterator = blockingIterator;
                    this.val$serializerFunction = serializerFunction;
                }

                @Override
                public boolean hasNext(long timeout, TimeUnit unit) throws TimeoutException {
                    return this.val$iterator.hasNext(timeout, unit);
                }

                @Override
                public Buffer next(long timeout, TimeUnit unit) throws TimeoutException {
                    return this.val$serializerFunction.apply(this.val$iterator.next(timeout, unit));
                }

                @Override
                public void close() throws Exception {
                    this.val$iterator.close();
                }

                @Override
                public boolean hasNext() {
                    return this.val$iterator.hasNext();
                }

                @Override
                public Buffer next() {
                    return this.val$serializerFunction.apply(this.val$iterator.next());
                }
            };
        };
    }

    private static <T> void applyDeserializer0(Publisher<Buffer> source, PublisherSource.Subscriber<? super T> subscriber, StreamingDeserializer<T> deSerializer) {
        SourceAdapters.toSource(source.flatMapConcatIterable(deSerializer::deserialize).beforeOnComplete(deSerializer::close)).subscribe(subscriber);
    }

    @Nonnull
    private static <T> CloseableIterable<T> applyDeserializer0(Iterable<Buffer> source, StreamingDeserializer<T> deSerializer) {
        return DefaultSerializer.deserializeAndClose(source, deSerializer::deserialize, deSerializer);
    }

    @Nonnull
    private static <T> CloseableIterable<T> deserializeAggregated0(Buffer serializedData, StreamingDeserializer<T> deSerializer) {
        return DefaultSerializer.deserializeAndClose(serializedData, deSerializer::deserialize, deSerializer);
    }

    private static <S, T> CloseableIterable<T> deserializeAndClose(S source, Function<S, Iterable<T>> doDeserialize, final StreamingDeserializer<T> deSerializer) {
        Iterable<T> deserialized;
        try {
            deserialized = doDeserialize.apply(source);
        }
        catch (Throwable throwable) {
            try {
                deSerializer.close();
            }
            catch (SerializationException e) {
                throwable.addSuppressed(e);
            }
            throw throwable;
        }
        return new AbstractCloseableIterable<T>(deserialized){

            @Override
            protected void closeIterator(Iterator<T> iterator) {
                deSerializer.close();
            }
        };
    }

    private static <T> T getSingleValueOnly(CloseableIterable<T> iterable) {
        Iterator iterator = iterable.iterator();
        Object value = iterator.next();
        DefaultSerializer.closeIterator(iterator, iterator.hasNext() ? new SerializationException("More than one value was deserialized.") : null);
        return (T)value;
    }

    private static void closeIterator(CloseableIterator<?> iterator, @Nullable SerializationException cause) {
        try {
            iterator.close();
        }
        catch (Exception e) {
            if (cause != null) {
                cause.addSuppressed(e);
                throw cause;
            }
            if (e instanceof SerializationException) {
                throw (SerializationException)e;
            }
            throw new SerializationException("Failed to close iterator", e);
        }
        if (cause != null) {
            throw cause;
        }
    }

    private static class SerializerFunction<T>
    implements Function<T, Buffer> {
        private final IntUnaryOperator bytesEstimator;
        private final BufferAllocator allocator;
        private final StreamingSerializer serializer;
        private int lastSize;

        SerializerFunction(IntUnaryOperator bytesEstimator, BufferAllocator allocator, StreamingSerializer serializer) {
            this.bytesEstimator = bytesEstimator;
            this.allocator = allocator;
            this.serializer = serializer;
        }

        @Override
        public Buffer apply(T t) {
            this.lastSize = this.bytesEstimator.applyAsInt(this.lastSize);
            Buffer destination = this.allocator.newBuffer(this.lastSize);
            this.serializer.serialize(t, destination);
            return destination;
        }
    }
}

