/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils;

import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.ReservedStreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.utils.RedirectSingle;

public final class RedirectingHttpRequesterFilter
implements StreamingHttpClientFilterFactory,
StreamingHttpConnectionFilterFactory,
HttpExecutionStrategyInfluencer {
    private static final int DEFAULT_MAX_REDIRECTS = 5;
    private final int maxRedirects;
    private final boolean onlyRelativeClient;
    private final boolean onlyRelativeConnection;

    public RedirectingHttpRequesterFilter() {
        this(true, true);
    }

    public RedirectingHttpRequesterFilter(int maxRedirects) {
        this(true, true, maxRedirects);
    }

    public RedirectingHttpRequesterFilter(boolean onlyRelativeClient) {
        this(onlyRelativeClient, true, 5);
    }

    public RedirectingHttpRequesterFilter(boolean onlyRelativeClient, int maxRedirects) {
        this(onlyRelativeClient, true, maxRedirects);
    }

    public RedirectingHttpRequesterFilter(boolean onlyRelativeClient, boolean onlyRelativeConnection) {
        this(onlyRelativeClient, onlyRelativeConnection, 5);
    }

    public RedirectingHttpRequesterFilter(boolean onlyRelativeClient, boolean onlyRelativeConnection, int maxRedirects) {
        this.onlyRelativeClient = onlyRelativeClient;
        this.onlyRelativeConnection = onlyRelativeConnection;
        this.maxRedirects = maxRedirects;
    }

    @Override
    public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
        return new StreamingHttpClientFilter(client){

            @Override
            protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                return RedirectingHttpRequesterFilter.this.request(delegate, strategy, request, RedirectingHttpRequesterFilter.this.onlyRelativeClient);
            }

            @Override
            public Single<? extends FilterableReservedStreamingHttpConnection> reserveConnection(HttpExecutionStrategy strategy, HttpRequestMetaData metaData) {
                return this.delegate().reserveConnection(strategy, metaData).map(r -> new ReservedStreamingHttpConnectionFilter((FilterableReservedStreamingHttpConnection)r){

                    @Override
                    protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                        return RedirectingHttpRequesterFilter.this.request(delegate, strategy, request, RedirectingHttpRequesterFilter.this.onlyRelativeConnection);
                    }
                });
            }
        };
    }

    @Override
    public StreamingHttpConnectionFilter create(FilterableStreamingHttpConnection connection) {
        return new StreamingHttpConnectionFilter(connection){

            @Override
            public Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                return RedirectingHttpRequesterFilter.this.request(this.delegate(), strategy, request, RedirectingHttpRequesterFilter.this.onlyRelativeConnection);
            }
        };
    }

    private Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request, boolean onlyRelative) {
        Single<StreamingHttpResponse> response = delegate.request(strategy, request);
        if (this.maxRedirects <= 0) {
            return response;
        }
        return new RedirectSingle(strategy, response, request, this.maxRedirects, delegate, onlyRelative);
    }

    @Override
    public HttpExecutionStrategy influenceStrategy(HttpExecutionStrategy strategy) {
        return strategy;
    }
}

