/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.client.api.internal.ReservableRequestConcurrencyController;
import io.servicetalk.client.api.internal.ReservableRequestConcurrencyControllers;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpLoadBalancedConnection;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.netty.AbstractLBHttpConnectionFactory;
import io.servicetalk.http.netty.PipelinedStreamingHttpConnection;
import io.servicetalk.http.netty.ReadOnlyHttpClientConfig;
import io.servicetalk.http.netty.StreamingConnectionFactory;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.netty.internal.NettyConnection;
import java.util.function.Function;
import javax.annotation.Nullable;

final class PipelinedLBHttpConnectionFactory<ResolvedAddress>
extends AbstractLBHttpConnectionFactory<ResolvedAddress> {
    PipelinedLBHttpConnectionFactory(ReadOnlyHttpClientConfig config, HttpExecutionContext executionContext, @Nullable StreamingHttpConnectionFilterFactory connectionFilterFunction, StreamingHttpRequestResponseFactory reqRespFactory, HttpExecutionStrategyInfluencer strategyInfluencer, ConnectionFactoryFilter<ResolvedAddress, FilterableStreamingHttpConnection> connectionFactoryFilter, Function<FilterableStreamingHttpConnection, FilterableStreamingHttpLoadBalancedConnection> protocolBinding) {
        super(config, executionContext, connectionFilterFunction, (HttpProtocolVersion version) -> reqRespFactory, strategyInfluencer, connectionFactoryFilter, protocolBinding);
    }

    @Override
    Single<FilterableStreamingHttpConnection> newFilterableConnection(ResolvedAddress resolvedAddress, TransportObserver observer) {
        assert (this.config.h1Config() != null);
        return StreamingConnectionFactory.buildStreaming(this.executionContext, resolvedAddress, this.config, observer).map(conn -> new PipelinedStreamingHttpConnection((NettyConnection<Object, Object>)conn, this.config.h1Config(), this.executionContext, (StreamingHttpRequestResponseFactory)this.reqRespFactoryFunc.apply(HttpProtocolVersion.HTTP_1_1), this.config.allowDropTrailersReadFromTransport()));
    }

    @Override
    ReservableRequestConcurrencyController newConcurrencyController(FilterableStreamingHttpConnection connection, Completable onClosing) {
        assert (this.config.h1Config() != null);
        return ReservableRequestConcurrencyControllers.newController(connection.transportEventStream(HttpEventKey.MAX_CONCURRENCY), onClosing, this.config.h1Config().maxPipelinedRequests());
    }
}

