/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http2.Http2Headers;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.http.api.DefaultHttpSetCookie;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpCookiePair;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpSetCookie;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;

final class NettyH2HeadersToHttpHeaders
implements HttpHeaders {
    private final boolean validateCookies;
    private final Http2Headers nettyHeaders;

    NettyH2HeadersToHttpHeaders(Http2Headers nettyHeaders, boolean validateCookies) {
        this.nettyHeaders = nettyHeaders;
        this.validateCookies = validateCookies;
    }

    Http2Headers nettyHeaders() {
        return this.nettyHeaders;
    }

    @Override
    @Nullable
    public CharSequence get(CharSequence name) {
        return (CharSequence)this.nettyHeaders.get(name);
    }

    @Override
    @Nullable
    public CharSequence getAndRemove(CharSequence name) {
        return (CharSequence)this.nettyHeaders.getAndRemove(name);
    }

    @Override
    public Iterator<? extends CharSequence> valuesIterator(CharSequence name) {
        return this.nettyHeaders.valueIterator(name);
    }

    @Override
    public boolean contains(CharSequence name, CharSequence value) {
        return this.nettyHeaders.contains(name, value);
    }

    @Override
    public boolean containsIgnoreCase(CharSequence name, CharSequence value) {
        return this.nettyHeaders.contains(name, value, true);
    }

    @Override
    public int size() {
        return this.nettyHeaders.size();
    }

    @Override
    public boolean isEmpty() {
        return this.nettyHeaders.isEmpty();
    }

    @Override
    public Set<? extends CharSequence> names() {
        return this.nettyHeaders.names();
    }

    @Override
    public HttpHeaders add(CharSequence name, CharSequence value) {
        this.nettyHeaders.add(name, value);
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence name, Iterable<? extends CharSequence> values) {
        this.nettyHeaders.add(name, values);
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence name, CharSequence ... values) {
        this.nettyHeaders.add(name, (V[])values);
        return this;
    }

    @Override
    public HttpHeaders add(HttpHeaders headers) {
        for (Map.Entry<CharSequence, CharSequence> entry : headers) {
            this.nettyHeaders.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence name, CharSequence value) {
        this.nettyHeaders.set(name, value);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence name, Iterable<? extends CharSequence> values) {
        this.nettyHeaders.set(name, values);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence name, CharSequence ... values) {
        this.nettyHeaders.set(name, (V[])values);
        return this;
    }

    @Override
    public boolean remove(CharSequence name) {
        return this.nettyHeaders.remove(name);
    }

    @Override
    public boolean remove(CharSequence name, CharSequence value) {
        int sizeBefore = this.size();
        Iterator<CharSequence> valuesItr = this.nettyHeaders.valueIterator(name);
        while (valuesItr.hasNext()) {
            CharSequence next = valuesItr.next();
            if (!CharSequences.contentEquals(next, value)) continue;
            valuesItr.remove();
        }
        return sizeBefore != this.size();
    }

    @Override
    public boolean removeIgnoreCase(CharSequence name, CharSequence value) {
        int sizeBefore = this.size();
        Iterator<CharSequence> valuesItr = this.nettyHeaders.valueIterator(name);
        while (valuesItr.hasNext()) {
            CharSequence next = valuesItr.next();
            if (!CharSequences.contentEqualsIgnoreCase(next, value)) continue;
            valuesItr.remove();
        }
        return sizeBefore != this.size();
    }

    @Override
    public HttpHeaders clear() {
        this.nettyHeaders.clear();
        return this;
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iterator() {
        return this.nettyHeaders.iterator();
    }

    @Override
    public String toString() {
        return this.toString(HeaderUtils.DEFAULT_HEADER_FILTER);
    }

    @Override
    @Nullable
    public HttpCookiePair getCookie(CharSequence name) {
        Iterator<CharSequence> valueItr = this.nettyHeaders.valueIterator(HttpHeaderNames.COOKIE);
        while (valueItr.hasNext()) {
            HttpCookiePair cookiePair = HeaderUtils.parseCookiePair(valueItr.next(), name);
            if (cookiePair == null) continue;
            return cookiePair;
        }
        return null;
    }

    @Override
    @Nullable
    public HttpSetCookie getSetCookie(CharSequence name) {
        Iterator<CharSequence> valueItr = this.nettyHeaders.valueIterator(HttpHeaderNames.SET_COOKIE);
        while (valueItr.hasNext()) {
            HttpSetCookie setCookie = HeaderUtils.parseSetCookie(valueItr.next(), name, this.validateCookies);
            if (setCookie == null) continue;
            return setCookie;
        }
        return null;
    }

    @Override
    public Iterator<? extends HttpCookiePair> getCookiesIterator() {
        Iterator<CharSequence> valueItr = this.nettyHeaders.valueIterator(HttpHeaderNames.COOKIE);
        return valueItr.hasNext() ? new CookiesIterator(valueItr) : Collections.emptyIterator();
    }

    @Override
    public Iterator<? extends HttpCookiePair> getCookiesIterator(CharSequence name) {
        return new CookiesByNameIterator(this.nettyHeaders.valueIterator(HttpHeaderNames.COOKIE), name);
    }

    @Override
    public Iterator<? extends HttpSetCookie> getSetCookiesIterator() {
        Iterator<CharSequence> valueItr = this.nettyHeaders.valueIterator(HttpHeaderNames.SET_COOKIE);
        return valueItr.hasNext() ? new SetCookiesIterator(valueItr) : Collections.emptyIterator();
    }

    @Override
    public Iterator<? extends HttpSetCookie> getSetCookiesIterator(CharSequence name) {
        Iterator<CharSequence> valueItr = this.nettyHeaders.valueIterator(HttpHeaderNames.SET_COOKIE);
        while (valueItr.hasNext()) {
            HttpSetCookie setCookie = HeaderUtils.parseSetCookie(valueItr.next(), name, this.validateCookies);
            if (setCookie == null) continue;
            return new SetCookiesByNameIterator(valueItr, setCookie);
        }
        return Collections.emptyIterator();
    }

    @Override
    public Iterator<? extends HttpSetCookie> getSetCookiesIterator(CharSequence name, CharSequence domain, CharSequence path) {
        Iterator<CharSequence> valueItr = this.nettyHeaders.valueIterator(HttpHeaderNames.SET_COOKIE);
        while (valueItr.hasNext()) {
            HttpSetCookie setCookie = HeaderUtils.parseSetCookie(valueItr.next(), name, this.validateCookies);
            if (setCookie == null || !HeaderUtils.domainMatches(domain, setCookie.domain()) || !HeaderUtils.pathMatches(path, setCookie.path())) continue;
            return new SetCookiesByNameDomainPathIterator(valueItr, setCookie, domain, path);
        }
        return Collections.emptyIterator();
    }

    @Override
    public HttpHeaders addCookie(HttpCookiePair cookie) {
        this.add(io.servicetalk.http.api.HttpHeaderNames.COOKIE, cookie.encoded());
        return this;
    }

    @Override
    public HttpHeaders addSetCookie(HttpSetCookie cookie) {
        this.add(io.servicetalk.http.api.HttpHeaderNames.SET_COOKIE, cookie.encoded());
        return this;
    }

    @Override
    public boolean removeCookies(CharSequence name) {
        Iterator<CharSequence> valuesItr = this.nettyHeaders.valueIterator(HttpHeaderNames.COOKIE);
        ArrayList<CharSequence> cookiesToAdd = null;
        int sizeBefore = this.size();
        while (valuesItr.hasNext()) {
            CharSequence newHeaderValue = HeaderUtils.removeCookiePairs(valuesItr.next(), name);
            if (newHeaderValue == null) continue;
            if (newHeaderValue.length() != 0) {
                if (cookiesToAdd == null) {
                    cookiesToAdd = new ArrayList<CharSequence>(4);
                }
                cookiesToAdd.add(newHeaderValue);
            }
            valuesItr.remove();
        }
        if (cookiesToAdd != null) {
            for (CharSequence cookies : cookiesToAdd) {
                this.nettyHeaders.add(HttpHeaderNames.COOKIE, cookies);
            }
            return true;
        }
        return sizeBefore != this.size();
    }

    @Override
    public boolean removeSetCookies(CharSequence name) {
        int sizeBefore = this.size();
        Iterator<CharSequence> valueItr = this.nettyHeaders.valueIterator(HttpHeaderNames.SET_COOKIE);
        while (valueItr.hasNext()) {
            if (!HeaderUtils.isSetCookieNameMatches(valueItr.next(), name)) continue;
            valueItr.remove();
        }
        return sizeBefore != this.size();
    }

    @Override
    public boolean removeSetCookies(CharSequence name, CharSequence domain, CharSequence path) {
        int sizeBefore = this.size();
        Iterator<CharSequence> valueItr = this.nettyHeaders.valueIterator(HttpHeaderNames.SET_COOKIE);
        while (valueItr.hasNext()) {
            HttpSetCookie setCookie = HeaderUtils.parseSetCookie(valueItr.next(), name, false);
            if (setCookie == null || !HeaderUtils.domainMatches(domain, setCookie.domain()) || !HeaderUtils.pathMatches(path, setCookie.path())) continue;
            valueItr.remove();
        }
        return sizeBefore != this.size();
    }

    private final class SetCookiesByNameDomainPathIterator
    implements Iterator<HttpSetCookie> {
        private final Iterator<CharSequence> valueItr;
        private final CharSequence domain;
        private final CharSequence path;
        @Nullable
        private HttpSetCookie next;

        SetCookiesByNameDomainPathIterator(Iterator<CharSequence> valueItr, HttpSetCookie next, CharSequence domain, CharSequence path) {
            this.valueItr = valueItr;
            this.domain = domain;
            this.path = path;
            this.next = next;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public HttpSetCookie next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            HttpSetCookie currentCookie = this.next;
            this.next = null;
            while (this.valueItr.hasNext()) {
                HttpSetCookie setCookie = HeaderUtils.parseSetCookie(this.valueItr.next(), currentCookie.name(), NettyH2HeadersToHttpHeaders.this.validateCookies);
                if (setCookie == null || !HeaderUtils.domainMatches(this.domain, setCookie.domain()) || !HeaderUtils.pathMatches(this.path, setCookie.path())) continue;
                this.next = setCookie;
                break;
            }
            return currentCookie;
        }

        @Override
        public void remove() {
            this.valueItr.remove();
        }
    }

    private final class SetCookiesByNameIterator
    implements Iterator<HttpSetCookie> {
        private final Iterator<CharSequence> valueItr;
        @Nullable
        private HttpSetCookie next;

        SetCookiesByNameIterator(Iterator<CharSequence> valueItr, HttpSetCookie next) {
            this.valueItr = valueItr;
            this.next = next;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public HttpSetCookie next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            HttpSetCookie currentCookie = this.next;
            this.next = null;
            while (this.valueItr.hasNext()) {
                this.next = HeaderUtils.parseSetCookie(this.valueItr.next(), currentCookie.name(), NettyH2HeadersToHttpHeaders.this.validateCookies);
                if (this.next == null) continue;
                break;
            }
            return currentCookie;
        }

        @Override
        public void remove() {
            this.valueItr.remove();
        }
    }

    private final class SetCookiesIterator
    implements Iterator<HttpSetCookie> {
        private final Iterator<CharSequence> valueItr;

        SetCookiesIterator(Iterator<CharSequence> valueItr) {
            this.valueItr = valueItr;
        }

        @Override
        public boolean hasNext() {
            return this.valueItr.hasNext();
        }

        @Override
        public HttpSetCookie next() {
            return DefaultHttpSetCookie.parseSetCookie(this.valueItr.next(), NettyH2HeadersToHttpHeaders.this.validateCookies);
        }

        @Override
        public void remove() {
            this.valueItr.remove();
        }
    }

    private static final class CookiesByNameIterator
    extends HeaderUtils.CookiesByNameIterator {
        private final Iterator<CharSequence> valueItr;
        @Nullable
        private CharSequence headerValue;

        CookiesByNameIterator(Iterator<CharSequence> valueItr, CharSequence name) {
            super(name);
            this.valueItr = valueItr;
            if (valueItr.hasNext()) {
                this.headerValue = valueItr.next();
                this.initNext(this.headerValue);
            }
        }

        @Override
        @Nullable
        protected CharSequence cookieHeaderValue() {
            return this.headerValue;
        }

        @Override
        protected void advanceCookieHeaderValue() {
            this.headerValue = this.valueItr.hasNext() ? this.valueItr.next() : null;
        }
    }

    private static final class CookiesIterator
    extends HeaderUtils.CookiesIterator {
        private final Iterator<CharSequence> valueItr;
        @Nullable
        private CharSequence headerValue;

        CookiesIterator(Iterator<CharSequence> valueItr) {
            this.valueItr = valueItr;
            if (valueItr.hasNext()) {
                this.headerValue = valueItr.next();
                this.initNext(this.headerValue);
            }
        }

        @Override
        @Nullable
        protected CharSequence cookieHeaderValue() {
            return this.headerValue;
        }

        @Override
        protected void advanceCookieHeaderValue() {
            this.headerValue = this.valueItr.hasNext() ? this.valueItr.next() : null;
        }
    }
}

