/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.netty.HttpObjectEncoder;
import io.servicetalk.transport.netty.internal.CloseHandler;
import java.util.Objects;
import java.util.Queue;

final class HttpResponseEncoder
extends HttpObjectEncoder<HttpResponseMetaData> {
    private final Queue<HttpRequestMethod> methodQueue;

    HttpResponseEncoder(Queue<HttpRequestMethod> methodQueue, int headersEncodedSizeAccumulator, int trailersEncodedSizeAccumulator, CloseHandler closeHandler) {
        super(headersEncodedSizeAccumulator, trailersEncodedSizeAccumulator, closeHandler);
        this.methodQueue = Objects.requireNonNull(methodQueue);
    }

    HttpResponseEncoder(Queue<HttpRequestMethod> methodQueue, int headersEncodedSizeAccumulator, int trailersEncodedSizeAccumulator) {
        this(methodQueue, headersEncodedSizeAccumulator, trailersEncodedSizeAccumulator, CloseHandler.UNSUPPORTED_PROTOCOL_CLOSE_HANDLER);
    }

    @Override
    protected HttpResponseMetaData castMetaData(Object msg) {
        return (HttpResponseMetaData)msg;
    }

    @Override
    protected void encodeInitialLine(Buffer stBuffer, HttpResponseMetaData message) {
        message.version().writeTo(stBuffer);
        stBuffer.writeByte(32);
        message.status().writeTo(stBuffer);
        stBuffer.writeShort(3338);
    }

    @Override
    protected void sanitizeHeadersBeforeEncode(HttpResponseMetaData msg, boolean isAlwaysEmpty) {
        HttpRequestMethod method = this.methodQueue.poll();
        HttpHeaders headers = msg.headers();
        if (isAlwaysEmpty) {
            HttpResponseStatus status = msg.status();
            if (status.statusClass() == HttpResponseStatus.StatusClass.INFORMATIONAL_1XX || status.code() == HttpResponseStatus.NO_CONTENT.code()) {
                headers.remove(HttpHeaderNames.CONTENT_LENGTH);
                headers.remove(HttpHeaderNames.TRANSFER_ENCODING);
            }
        } else if (HttpRequestMethod.CONNECT.equals(method) && msg.status().statusClass() == HttpResponseStatus.StatusClass.SUCCESSFUL_2XX) {
            headers.remove(HttpHeaderNames.CONTENT_LENGTH);
            headers.remove(HttpHeaderNames.TRANSFER_ENCODING);
        }
    }

    @Override
    protected boolean isContentAlwaysEmpty(HttpResponseMetaData msg) {
        HttpResponseStatus status = msg.status();
        if (status.statusClass() == HttpResponseStatus.StatusClass.INFORMATIONAL_1XX) {
            if (status.code() == HttpResponseStatus.SWITCHING_PROTOCOLS.code()) {
                return msg.headers().contains(HttpHeaderNames.SEC_WEBSOCKET_VERSION);
            }
            return true;
        }
        return status.code() == HttpResponseStatus.NO_CONTENT.code() || status.code() == HttpResponseStatus.NOT_MODIFIED.code();
    }
}

