/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.util.ByteProcessor;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMetaDataFactory;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.netty.HttpObjectDecoder;
import io.servicetalk.transport.netty.internal.CloseHandler;
import io.servicetalk.utils.internal.IllegalCharacterException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Queue;

final class HttpRequestDecoder
extends HttpObjectDecoder<HttpRequestMetaData> {
    private static final ByteProcessor FIND_WS_AFTER_METHOD_NAME = value -> {
        if (HttpRequestDecoder.isWS(value)) {
            return false;
        }
        HttpRequestDecoder.ensureUpperCase(value);
        return true;
    };
    private static final ByteProcessor ENSURE_UPPER_CASE = value -> {
        HttpRequestDecoder.ensureUpperCase(value);
        return true;
    };
    private final Queue<HttpRequestMethod> methodQueue;

    HttpRequestDecoder(Queue<HttpRequestMethod> methodQueue, ByteBufAllocator alloc, HttpHeadersFactory headersFactory, int maxStartLineLength, int maxHeaderFieldLength) {
        this(methodQueue, alloc, headersFactory, maxStartLineLength, maxHeaderFieldLength, false, CloseHandler.UNSUPPORTED_PROTOCOL_CLOSE_HANDLER);
    }

    HttpRequestDecoder(Queue<HttpRequestMethod> methodQueue, ByteBufAllocator alloc, HttpHeadersFactory headersFactory, int maxStartLineLength, int maxHeaderFieldLength, boolean allowPrematureClosureBeforePayloadBody, CloseHandler closeHandler) {
        super(alloc, headersFactory, maxStartLineLength, maxHeaderFieldLength, allowPrematureClosureBeforePayloadBody, closeHandler);
        this.methodQueue = Objects.requireNonNull(methodQueue);
    }

    @Override
    protected boolean isDecodingRequest() {
        return true;
    }

    @Override
    protected void handlePartialInitialLine(ChannelHandlerContext ctx, ByteBuf buffer) {
        try {
            buffer.forEachByte(FIND_WS_AFTER_METHOD_NAME);
        }
        catch (IllegalCharacterException cause) {
            throw HttpRequestDecoder.newInvalidMethodException(cause);
        }
    }

    private static DecoderException newInvalidMethodException(IllegalCharacterException cause) {
        return new HttpObjectDecoder.StacklessDecoderException("Invalid start-line: HTTP request method must contain only upper case letters", cause);
    }

    private static void ensureUpperCase(byte value) {
        if (value < 65 || value > 90) {
            throw new IllegalCharacterException(value, "A-Z (0x41-0x5a)");
        }
    }

    @Override
    protected HttpRequestMetaData createMessage(ByteBuf buffer, int firstStart, int firstLength, int secondStart, int secondLength, int thirdStart, int thirdLength) {
        return HttpRequestMetaDataFactory.newRequestMetaData(HttpRequestDecoder.nettyBufferToHttpVersion(buffer, thirdStart, thirdLength), HttpRequestDecoder.decodeHttpMethod(buffer, firstStart, firstLength), buffer.toString(secondStart, secondLength, StandardCharsets.US_ASCII), this.headersFactory().newHeaders());
    }

    private static HttpRequestMethod decodeHttpMethod(ByteBuf buffer, int start, int length) {
        String methodName = buffer.toString(start, length, StandardCharsets.US_ASCII);
        HttpRequestMethod method = HttpRequestMethod.of(methodName);
        if (method != null) {
            return method;
        }
        try {
            buffer.forEachByte(start, length, ENSURE_UPPER_CASE);
        }
        catch (IllegalCharacterException cause) {
            throw HttpRequestDecoder.newInvalidMethodException(cause);
        }
        return HttpRequestMethod.of(methodName, HttpRequestMethod.Properties.NONE);
    }

    @Override
    protected boolean isContentAlwaysEmpty(HttpRequestMetaData msg) {
        this.methodQueue.add(msg.method());
        return false;
    }
}

