/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http2.Http2SettingsAckFrame;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.client.api.ConsumableEvent;
import io.servicetalk.client.api.internal.IgnoreConsumedEvent;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Processors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.api.internal.SubscribableSingle;
import io.servicetalk.concurrent.internal.DelayedCancellable;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.netty.H2ParentConnectionContext;
import io.servicetalk.http.netty.H2ProtocolConfig;
import io.servicetalk.http.netty.H2ToStH1ClientDuplexHandler;
import io.servicetalk.http.netty.HeaderUtils;
import io.servicetalk.http.netty.Http2Exception;
import io.servicetalk.http.netty.HttpDebugUtils;
import io.servicetalk.http.netty.KeepAliveManager;
import io.servicetalk.http.netty.NonPipelinedStreamingHttpConnection;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.netty.internal.ChannelCloseUtils;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import io.servicetalk.transport.netty.internal.ChannelSet;
import io.servicetalk.transport.netty.internal.CloseHandler;
import io.servicetalk.transport.netty.internal.DefaultNettyConnection;
import io.servicetalk.transport.netty.internal.FlushStrategy;
import io.servicetalk.transport.netty.internal.NettyConnectionContext;
import io.servicetalk.transport.netty.internal.NettyPipelineSslUtils;
import io.servicetalk.transport.netty.internal.NoopTransportObserver;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class H2ClientParentConnectionContext
extends H2ParentConnectionContext {
    private H2ClientParentConnectionContext(Channel channel, BufferAllocator allocator, Executor executor, FlushStrategy flushStrategy, @Nullable Long idleTimeoutMs, HttpExecutionStrategy executionStrategy, KeepAliveManager keepAliveManager) {
        super(channel, allocator, executor, flushStrategy, idleTimeoutMs, executionStrategy, keepAliveManager);
    }

    static Single<H2ClientParentConnection> initChannel(final Channel channel, final BufferAllocator allocator, final Executor executor, final H2ProtocolConfig config, final StreamingHttpRequestResponseFactory reqRespFactory, final FlushStrategy parentFlushStrategy, final @Nullable Long idleTimeoutMs, final HttpExecutionStrategy executionStrategy, final ChannelInitializer initializer, final ConnectionObserver observer, final boolean allowDropTrailersReadFromTransport) {
        return HttpDebugUtils.showPipeline(new SubscribableSingle<H2ClientParentConnection>(){

            @Override
            protected void handleSubscribe(SingleSource.Subscriber<? super H2ClientParentConnection> subscriber) {
                DefaultH2ClientParentConnection parentChannelInitializer;
                ChannelPipeline pipeline;
                DelayedCancellable delayedCancellable;
                try {
                    delayedCancellable = new DelayedCancellable();
                    KeepAliveManager keepAliveManager = new KeepAliveManager(channel, config.keepAlivePolicy());
                    H2ClientParentConnectionContext connection = new H2ClientParentConnectionContext(channel, allocator, executor, parentFlushStrategy, idleTimeoutMs, executionStrategy, keepAliveManager);
                    channel.attr(ChannelSet.CHANNEL_CLOSEABLE_KEY).set(connection);
                    initializer.init(channel);
                    pipeline = channel.pipeline();
                    parentChannelInitializer = new DefaultH2ClientParentConnection(connection, subscriber, delayedCancellable, NettyPipelineSslUtils.isSslEnabled(pipeline), allowDropTrailersReadFromTransport, config.headersFactory(), reqRespFactory, observer);
                }
                catch (Throwable cause) {
                    ChannelCloseUtils.close(channel, cause);
                    SubscriberUtils.deliverErrorFromSource(subscriber, cause);
                    return;
                }
                subscriber.onSubscribe(delayedCancellable);
                pipeline.addLast(parentChannelInitializer);
            }
        }, HttpProtocolVersion.HTTP_2_0, channel);
    }

    private static final class MaxConcurrencyConsumableEvent
    implements ConsumableEvent<Integer> {
        private static final AtomicIntegerFieldUpdater<MaxConcurrencyConsumableEvent> completedUpdater = AtomicIntegerFieldUpdater.newUpdater(MaxConcurrencyConsumableEvent.class, "completed");
        private volatile int completed;
        private final int maxConcurrentStreams;
        private final Channel channel;

        MaxConcurrencyConsumableEvent(int maxConcurrentStreams, Channel channel) {
            this.maxConcurrentStreams = maxConcurrentStreams;
            this.channel = channel;
        }

        @Override
        public Integer event() {
            return this.maxConcurrentStreams;
        }

        @Override
        public void eventConsumed() {
            if (completedUpdater.compareAndSet(this, 0, 1)) {
                this.channel.writeAndFlush(Http2SettingsAckFrame.INSTANCE);
            }
        }
    }

    private static final class DefaultH2ClientParentConnection
    extends H2ParentConnectionContext.AbstractH2ParentConnection
    implements H2ClientParentConnection {
        private static final Logger LOGGER = LoggerFactory.getLogger(DefaultH2ClientParentConnection.class);
        private static final IgnoreConsumedEvent<Integer> DEFAULT_H2_MAX_CONCURRENCY_EVENT = new IgnoreConsumedEvent<Integer>(100);
        private final Http2StreamChannelBootstrap bs;
        private final HttpHeadersFactory headersFactory;
        private final StreamingHttpRequestResponseFactory reqRespFactory;
        private final PublisherSource.Processor<ConsumableEvent<Integer>, ConsumableEvent<Integer>> maxConcurrencyProcessor;
        private final boolean allowDropTrailersReadFromTransport;
        @Nullable
        private SingleSource.Subscriber<? super H2ClientParentConnection> subscriber;
        private ConnectionObserver.MultiplexedObserver multiplexedObserver = NoopTransportObserver.NoopMultiplexedObserver.INSTANCE;

        DefaultH2ClientParentConnection(H2ClientParentConnectionContext connection, SingleSource.Subscriber<? super H2ClientParentConnection> subscriber, DelayedCancellable delayedCancellable, boolean waitForSslHandshake, boolean allowDropTrailersReadFromTransport, HttpHeadersFactory headersFactory, StreamingHttpRequestResponseFactory reqRespFactory, ConnectionObserver observer) {
            super(connection, delayedCancellable, waitForSslHandshake, observer);
            this.subscriber = Objects.requireNonNull(subscriber);
            this.headersFactory = Objects.requireNonNull(headersFactory);
            this.reqRespFactory = Objects.requireNonNull(reqRespFactory);
            this.allowDropTrailersReadFromTransport = allowDropTrailersReadFromTransport;
            this.maxConcurrencyProcessor = Processors.newPublisherProcessor(16);
            this.maxConcurrencyProcessor.onNext(DEFAULT_H2_MAX_CONCURRENCY_EVENT);
            this.bs = new Http2StreamChannelBootstrap(connection.channel());
        }

        @Override
        boolean hasSubscriber() {
            return this.subscriber != null;
        }

        @Override
        void tryCompleteSubscriber() {
            if (this.subscriber != null) {
                SingleSource.Subscriber<? super H2ClientParentConnection> subscriberCopy = this.subscriber;
                this.subscriber = null;
                this.multiplexedObserver = this.observer.multiplexedConnectionEstablished(this);
                subscriberCopy.onSuccess(this);
            }
        }

        @Override
        void tryFailSubscriber(Throwable cause) {
            if (this.subscriber != null) {
                ChannelCloseUtils.close(this.parentContext.nettyChannel(), cause);
                SingleSource.Subscriber<? super H2ClientParentConnection> subscriberCopy = this.subscriber;
                this.subscriber = null;
                subscriberCopy.onError(cause);
            }
        }

        @Override
        boolean ackSettings(ChannelHandlerContext ctx, Http2SettingsFrame settingsFrame) {
            Long maxConcurrentStreams = settingsFrame.settings().maxConcurrentStreams();
            if (maxConcurrentStreams == null) {
                return true;
            }
            this.maxConcurrencyProcessor.onNext(new MaxConcurrencyConsumableEvent(maxConcurrentStreams.intValue(), ctx.channel()));
            return false;
        }

        @Override
        public HttpConnectionContext connectionContext() {
            return this.parentContext;
        }

        @Override
        public <T> Publisher<? extends T> transportEventStream(HttpEventKey<T> eventKey) {
            Publisher maxConcurrencyStream = SourceAdapters.fromSource(this.maxConcurrencyProcessor);
            return eventKey == HttpEventKey.MAX_CONCURRENCY ? maxConcurrencyStream : Publisher.failed(new IllegalArgumentException("Unknown key: " + eventKey));
        }

        @Override
        public Single<StreamingHttpResponse> request(final HttpExecutionStrategy strategy, final StreamingHttpRequest request) {
            return new SubscribableSingle<StreamingHttpResponse>(){

                @Override
                protected void handleSubscribe(SingleSource.Subscriber<? super StreamingHttpResponse> subscriber) {
                    SequentialCancellable sequentialCancellable;
                    Promise<Http2StreamChannel> promise;
                    ConnectionObserver.StreamObserver observer = multiplexedObserver.onNewStream();
                    try {
                        EventLoop e = parentContext.nettyChannel().eventLoop();
                        promise = e.newPromise();
                        bs.open(promise);
                        sequentialCancellable = new SequentialCancellable(() -> promise.cancel(true));
                    }
                    catch (Throwable cause) {
                        observer.streamClosed(cause);
                        SubscriberUtils.deliverErrorFromSource(subscriber, cause);
                        return;
                    }
                    subscriber.onSubscribe(sequentialCancellable);
                    if (promise.isDone()) {
                        this.childChannelActive(promise, subscriber, sequentialCancellable, strategy, request, observer, allowDropTrailersReadFromTransport);
                    } else {
                        promise.addListener(future -> this.childChannelActive(future, subscriber, sequentialCancellable, strategy, request, observer, allowDropTrailersReadFromTransport));
                    }
                }
            };
        }

        private void childChannelActive(Future<Http2StreamChannel> future, final SingleSource.Subscriber<? super StreamingHttpResponse> subscriber, final SequentialCancellable sequentialCancellable, HttpExecutionStrategy strategy, StreamingHttpRequest request, ConnectionObserver.StreamObserver streamObserver, boolean allowDropTrailersReadFromTransport) {
            Throwable futureCause = future.cause();
            if (futureCause == null) {
                SingleSource<StreamingHttpResponse> responseSingle;
                Http2StreamChannel streamChannel = null;
                try {
                    streamChannel = future.getNow();
                    this.parentContext.trackActiveStream(streamChannel);
                    CloseHandler closeHandler = CloseHandler.forNonPipelined(true, streamChannel.config());
                    streamChannel.pipeline().addLast(new H2ToStH1ClientDuplexHandler(this.waitForSslHandshake, this.parentContext.executionContext().bufferAllocator(), this.headersFactory, closeHandler, streamObserver));
                    DefaultNettyConnection<Object, Object> nettyConnection = DefaultNettyConnection.initChildChannel(streamChannel, this.parentContext.executionContext().bufferAllocator(), this.parentContext.executionContext().executor(), HeaderUtils.LAST_CHUNK_PREDICATE, closeHandler, this.parentContext.flushStrategyHolder.currentStrategy(), this.parentContext.idleTimeoutMs, this.parentContext.executionContext().executionStrategy(), HttpProtocolVersion.HTTP_2_0, this.parentContext.sslSession(), this.parentContext.nettyChannel().config(), streamObserver, true, Http2Exception::wrapIfNecessary);
                    responseSingle = SourceAdapters.toSource(new NonPipelinedStreamingHttpConnection(nettyConnection, this.executionContext(), this.reqRespFactory, this.headersFactory, allowDropTrailersReadFromTransport).request(strategy, request));
                }
                catch (Throwable cause) {
                    if (streamChannel != null) {
                        try {
                            ChannelCloseUtils.close(streamChannel, cause);
                        }
                        catch (Throwable unexpected) {
                            unexpected.addSuppressed(cause);
                            LOGGER.warn("Unexpected exception while handling the original cause", unexpected);
                        }
                    }
                    subscriber.onError(cause);
                    return;
                }
                responseSingle.subscribe(new SingleSource.Subscriber<StreamingHttpResponse>(){

                    @Override
                    public void onSubscribe(Cancellable cancellable) {
                        sequentialCancellable.nextCancellable(cancellable);
                    }

                    @Override
                    public void onSuccess(@Nullable StreamingHttpResponse result) {
                        subscriber.onSuccess(result);
                    }

                    @Override
                    public void onError(Throwable t) {
                        subscriber.onError(t);
                    }
                });
            } else {
                subscriber.onError(futureCause);
            }
        }

        @Override
        public SocketAddress localAddress() {
            return this.parentContext.localAddress();
        }

        @Override
        public SocketAddress remoteAddress() {
            return this.parentContext.remoteAddress();
        }

        @Override
        @Nullable
        public SSLSession sslSession() {
            return this.parentContext.sslSession();
        }

        @Override
        public HttpExecutionContext executionContext() {
            return this.parentContext.executionContext();
        }

        @Override
        @Nullable
        public <T> T socketOption(SocketOption<T> option) {
            return this.parentContext.socketOption(option);
        }

        @Override
        public HttpProtocolVersion protocol() {
            return this.parentContext.protocol();
        }

        @Override
        public StreamingHttpResponseFactory httpResponseFactory() {
            return this.reqRespFactory;
        }

        @Override
        public Completable onClose() {
            return this.parentContext.onClose();
        }

        @Override
        public Completable closeAsync() {
            return this.parentContext.closeAsync();
        }

        @Override
        public Completable closeAsyncGracefully() {
            return this.parentContext.closeAsyncGracefully();
        }

        @Override
        public Channel nettyChannel() {
            return this.parentContext.nettyChannel();
        }

        public String toString() {
            return this.parentContext.toString();
        }

        @Override
        public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
            return this.reqRespFactory.newRequest(method, requestTarget);
        }

        @Override
        public Cancellable updateFlushStrategy(NettyConnectionContext.FlushStrategyProvider strategyProvider) {
            return this.parentContext.updateFlushStrategy(strategyProvider);
        }

        @Override
        public FlushStrategy defaultFlushStrategy() {
            return this.parentContext.defaultFlushStrategy();
        }

        @Override
        public Single<Throwable> transportError() {
            return this.parentContext.transportError();
        }

        @Override
        public Completable onClosing() {
            return this.parentContext.onClosing();
        }
    }

    static interface H2ClientParentConnection
    extends FilterableStreamingHttpConnection,
    NettyConnectionContext {
    }
}

