/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.handler.ssl.SslContext;
import io.netty.util.NetUtil;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.client.api.AutoRetryStrategyProvider;
import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.client.api.DefaultAutoRetryStrategyProvider;
import io.servicetalk.client.api.DefaultServiceDiscovererEvent;
import io.servicetalk.client.api.LoadBalancer;
import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompositeCloseable;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Processors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.api.DefaultServiceDiscoveryRetryStrategy;
import io.servicetalk.http.api.DefaultStreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpLoadBalancerFactory;
import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.MultiAddressHttpClientFilterFactory;
import io.servicetalk.http.api.ServiceDiscoveryRetryStrategy;
import io.servicetalk.http.api.SingleAddressHttpClientBuilder;
import io.servicetalk.http.api.SingleAddressHttpClientSecurityConfigurator;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.netty.AbsoluteAddressHttpRequesterFilter;
import io.servicetalk.http.netty.AbstractLBHttpConnectionFactory;
import io.servicetalk.http.netty.AlpnLBHttpConnectionFactory;
import io.servicetalk.http.netty.AutoRetryFilter;
import io.servicetalk.http.netty.ClientStrategyInfluencerChainBuilder;
import io.servicetalk.http.netty.DefaultHttpLoadBalancerFactory;
import io.servicetalk.http.netty.DefaultSingleAddressHttpClientSecurityConfigurator;
import io.servicetalk.http.netty.FilterableClientToClient;
import io.servicetalk.http.netty.GlobalDnsServiceDiscoverer;
import io.servicetalk.http.netty.H1ProtocolConfig;
import io.servicetalk.http.netty.H2LBHttpConnectionFactory;
import io.servicetalk.http.netty.H2ProtocolConfig;
import io.servicetalk.http.netty.HostHeaderHttpRequesterFilter;
import io.servicetalk.http.netty.HttpClientConfig;
import io.servicetalk.http.netty.HttpExecutionContextBuilder;
import io.servicetalk.http.netty.LoadBalancedStreamingHttpClient;
import io.servicetalk.http.netty.LoadBalancedStreamingHttpConnection;
import io.servicetalk.http.netty.PipelinedLBHttpConnectionFactory;
import io.servicetalk.http.netty.ProxyConnectConnectionFactoryFilter;
import io.servicetalk.http.netty.ReadOnlyHttpClientConfig;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.transport.api.HostAndPort;
import io.servicetalk.transport.api.IoExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;

final class DefaultSingleAddressHttpClientBuilder<U, R>
extends SingleAddressHttpClientBuilder<U, R> {
    static final Duration SD_RETRY_STRATEGY_INIT_DURATION = Duration.ofSeconds(10L);
    static final Duration SD_RETRY_STRATEGY_JITTER = Duration.ofSeconds(5L);
    @Nullable
    private final U address;
    @Nullable
    private U proxyAddress;
    private final HttpClientConfig config;
    private final HttpExecutionContextBuilder executionContextBuilder;
    private final ClientStrategyInfluencerChainBuilder influencerChainBuilder;
    private HttpLoadBalancerFactory<R> loadBalancerFactory;
    private ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> serviceDiscoverer;
    private Function<U, CharSequence> hostToCharSequenceFunction = this::toAuthorityForm;
    private boolean addHostHeaderFallbackFilter = true;
    @Nullable
    private ServiceDiscoveryRetryStrategy<R, ServiceDiscovererEvent<R>> serviceDiscovererRetryStrategy;
    @Nullable
    private StreamingHttpConnectionFilterFactory connectionFilterFactory;
    @Nullable
    private StreamingHttpClientFilterFactory clientFilterFactory;
    @Nullable
    private AutoRetryStrategyProvider autoRetry = new DefaultAutoRetryStrategyProvider.Builder().build();
    private ConnectionFactoryFilter<R, FilterableStreamingHttpConnection> connectionFactoryFilter = ConnectionFactoryFilter.identity();

    DefaultSingleAddressHttpClientBuilder(U address, U proxyAddress, Function<U, CharSequence> hostToCharSequenceFunction, ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> serviceDiscoverer) {
        this(address, serviceDiscoverer);
        this.proxyAddress = proxyAddress;
        this.hostToCharSequenceFunction = Objects.requireNonNull(hostToCharSequenceFunction);
        this.config.connectAddress(hostToCharSequenceFunction.apply(address));
    }

    DefaultSingleAddressHttpClientBuilder(U address, ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> serviceDiscoverer) {
        this.address = Objects.requireNonNull(address);
        this.config = new HttpClientConfig();
        this.executionContextBuilder = new HttpExecutionContextBuilder();
        this.influencerChainBuilder = new ClientStrategyInfluencerChainBuilder();
        this.loadBalancerFactory = DefaultHttpLoadBalancerFactory.Builder.fromDefaults().build();
        this.serviceDiscoverer = Objects.requireNonNull(serviceDiscoverer);
    }

    DefaultSingleAddressHttpClientBuilder(ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> serviceDiscoverer) {
        this.address = null;
        this.config = new HttpClientConfig();
        this.executionContextBuilder = new HttpExecutionContextBuilder();
        this.influencerChainBuilder = new ClientStrategyInfluencerChainBuilder();
        this.loadBalancerFactory = DefaultHttpLoadBalancerFactory.Builder.fromDefaults().build();
        this.serviceDiscoverer = Objects.requireNonNull(serviceDiscoverer);
    }

    private DefaultSingleAddressHttpClientBuilder(@Nullable U address, DefaultSingleAddressHttpClientBuilder<U, R> from) {
        this.address = address;
        this.proxyAddress = from.proxyAddress;
        this.config = new HttpClientConfig(from.config);
        this.executionContextBuilder = new HttpExecutionContextBuilder(from.executionContextBuilder);
        this.influencerChainBuilder = from.influencerChainBuilder.copy();
        this.loadBalancerFactory = from.loadBalancerFactory;
        this.serviceDiscoverer = from.serviceDiscoverer;
        this.serviceDiscovererRetryStrategy = from.serviceDiscovererRetryStrategy;
        this.clientFilterFactory = from.clientFilterFactory;
        this.connectionFilterFactory = from.connectionFilterFactory;
        this.hostToCharSequenceFunction = from.hostToCharSequenceFunction;
        this.addHostHeaderFallbackFilter = from.addHostHeaderFallbackFilter;
        this.autoRetry = from.autoRetry;
        this.connectionFactoryFilter = from.connectionFactoryFilter;
    }

    private DefaultSingleAddressHttpClientBuilder<U, R> copy() {
        return new DefaultSingleAddressHttpClientBuilder<U, R>(this.address, this);
    }

    private DefaultSingleAddressHttpClientBuilder<U, R> copy(U address) {
        return new DefaultSingleAddressHttpClientBuilder<U, R>(Objects.requireNonNull(address), this);
    }

    static DefaultSingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forHostAndPort(HostAndPort address) {
        return new DefaultSingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress>(address, GlobalDnsServiceDiscoverer.globalDnsServiceDiscoverer());
    }

    static DefaultSingleAddressHttpClientBuilder<String, InetSocketAddress> forServiceAddress(String serviceName) {
        return new DefaultSingleAddressHttpClientBuilder<String, InetSocketAddress>(serviceName, GlobalDnsServiceDiscoverer.globalSrvDnsServiceDiscoverer());
    }

    static DefaultSingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forHostAndPortViaProxy(HostAndPort address, HostAndPort proxyAddress) {
        return new DefaultSingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress>(address, proxyAddress, hostAndPort -> NetUtil.toSocketAddressString(hostAndPort.hostName(), hostAndPort.port()), GlobalDnsServiceDiscoverer.globalDnsServiceDiscoverer());
    }

    static <U, R extends SocketAddress> DefaultSingleAddressHttpClientBuilder<U, R> forResolvedAddress(U u, R address) {
        NoopServiceDiscoverer sd = new NoopServiceDiscoverer(u, address);
        return new DefaultSingleAddressHttpClientBuilder<U, R>(u, sd);
    }

    static DefaultSingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forResolvedAddressViaProxy(HostAndPort u, InetSocketAddress address, HostAndPort proxyAddress) {
        NoopServiceDiscoverer sd = new NoopServiceDiscoverer(u, address);
        return new DefaultSingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress>(u, proxyAddress, hostAndPort -> NetUtil.toSocketAddressString(hostAndPort.hostName(), hostAndPort.port()), sd);
    }

    static DefaultSingleAddressHttpClientBuilder<InetSocketAddress, InetSocketAddress> forResolvedAddressViaProxy(InetSocketAddress u, InetSocketAddress address, InetSocketAddress proxyAddress) {
        NoopServiceDiscoverer sd = new NoopServiceDiscoverer(u, address);
        return new DefaultSingleAddressHttpClientBuilder<InetSocketAddress, InetSocketAddress>(u, proxyAddress, NetUtil::toSocketAddressString, sd);
    }

    static DefaultSingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forUnknownHostAndPort() {
        return new DefaultSingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress>(GlobalDnsServiceDiscoverer.globalDnsServiceDiscoverer());
    }

    @Override
    public StreamingHttpClient buildStreaming() {
        return DefaultSingleAddressHttpClientBuilder.buildStreaming(this.copyBuildCtx());
    }

    private static <U, R> StreamingHttpClient buildStreaming(HttpClientBuildContext<U, R> ctx) {
        ReadOnlyHttpClientConfig roConfig = ctx.httpConfig().asReadOnly();
        if (roConfig.h2Config() != null && roConfig.hasProxy()) {
            throw new IllegalStateException("Proxying is not yet supported with HTTP/2");
        }
        CompositeCloseable closeOnException = AsyncCloseables.newCompositeCloseable();
        try {
            H1ProtocolConfig h1Config;
            AbstractLBHttpConnectionFactory connectionFactory;
            Publisher sdEvents = ((HttpClientBuildContext)ctx).serviceDiscoverer.discover(ctx.address()).flatMapConcatIterable(Function.identity());
            ConnectionFactoryFilter<R, FilterableStreamingHttpConnection> connectionFactoryFilter = ctx.builder.connectionFactoryFilter;
            SslContext sslContext = roConfig.tcpConfig().sslContext();
            if (roConfig.hasProxy() && sslContext != null) {
                assert (roConfig.connectAddress() != null);
                connectionFactoryFilter = new ProxyConnectConnectionFactoryFilter<R, FilterableStreamingHttpConnection>(roConfig.connectAddress()).append(connectionFactoryFilter);
            }
            HttpExecutionStrategy executionStrategy = ctx.executionContext.executionStrategy();
            StreamingHttpRequestResponseFactory reqRespFactory = DefaultSingleAddressHttpClientBuilder.defaultReqRespFactory(roConfig, ctx.executionContext.bufferAllocator());
            if (roConfig.isH2PriorKnowledge()) {
                H2ProtocolConfig h2Config = roConfig.h2Config();
                assert (h2Config != null);
                connectionFactory = new H2LBHttpConnectionFactory<R>(roConfig, ctx.executionContext, ctx.builder.connectionFilterFactory, reqRespFactory, ctx.builder.influencerChainBuilder.buildForConnectionFactory(executionStrategy), connectionFactoryFilter, ctx.builder.loadBalancerFactory::toLoadBalancedConnection);
            } else if (roConfig.tcpConfig().isAlpnConfigured()) {
                h1Config = roConfig.h1Config();
                H2ProtocolConfig h2Config = roConfig.h2Config();
                connectionFactory = new AlpnLBHttpConnectionFactory<R>(roConfig, ctx.executionContext, ctx.builder.connectionFilterFactory, new AlpnReqRespFactoryFunc(ctx.executionContext.bufferAllocator(), h1Config == null ? null : h1Config.headersFactory(), h2Config == null ? null : h2Config.headersFactory()), ctx.builder.influencerChainBuilder.buildForConnectionFactory(executionStrategy), connectionFactoryFilter, ctx.builder.loadBalancerFactory::toLoadBalancedConnection);
            } else {
                h1Config = roConfig.h1Config();
                assert (h1Config != null);
                connectionFactory = new PipelinedLBHttpConnectionFactory<R>(roConfig, ctx.executionContext, ctx.builder.connectionFilterFactory, reqRespFactory, ctx.builder.influencerChainBuilder.buildForConnectionFactory(executionStrategy), connectionFactoryFilter, ctx.builder.loadBalancerFactory::toLoadBalancedConnection);
            }
            LoadBalancer<LoadBalancedStreamingHttpConnection> lb = closeOnException.prepend(ctx.builder.loadBalancerFactory.newLoadBalancer(sdEvents, connectionFactory));
            StreamingHttpClientFilterFactory currClientFilterFactory = ctx.builder.clientFilterFactory;
            if (roConfig.hasProxy() && sslContext == null) {
                currClientFilterFactory = DefaultSingleAddressHttpClientBuilder.appendFilter(currClientFilterFactory, super.proxyAbsoluteAddressFilterFactory());
            }
            if (ctx.builder.addHostHeaderFallbackFilter) {
                currClientFilterFactory = DefaultSingleAddressHttpClientBuilder.appendFilter(currClientFilterFactory, new HostHeaderHttpRequesterFilter(ctx.builder.hostToCharSequenceFunction.apply(ctx.builder.address)));
            }
            FilterableStreamingHttpClient lbClient = closeOnException.prepend(new LoadBalancedStreamingHttpClient(ctx.executionContext, lb, reqRespFactory));
            if (ctx.builder.autoRetry != null) {
                lbClient = new AutoRetryFilter(lbClient, ctx.builder.autoRetry.newStrategy(lb.eventStream(), ((HttpClientBuildContext)ctx).sdStatus));
            }
            return new FilterableClientToClient(currClientFilterFactory != null ? currClientFilterFactory.create(lbClient) : lbClient, executionStrategy, ctx.builder.influencerChainBuilder.buildForClient(executionStrategy));
        }
        catch (Throwable t) {
            closeOnException.closeAsync().subscribe();
            throw t;
        }
    }

    static StreamingHttpRequestResponseFactory defaultReqRespFactory(ReadOnlyHttpClientConfig roConfig, BufferAllocator allocator) {
        if (roConfig.isH2PriorKnowledge()) {
            H2ProtocolConfig h2Config = roConfig.h2Config();
            assert (h2Config != null);
            return new DefaultStreamingHttpRequestResponseFactory(allocator, h2Config.headersFactory(), HttpProtocolVersion.HTTP_2_0);
        }
        if (roConfig.tcpConfig().isAlpnConfigured()) {
            H1ProtocolConfig h1Config = roConfig.h1Config();
            H2ProtocolConfig h2Config = roConfig.h2Config();
            String preferredAlpnProtocol = roConfig.tcpConfig().preferredAlpnProtocol();
            if ("h2".equals(preferredAlpnProtocol)) {
                assert (h2Config != null);
                return new DefaultStreamingHttpRequestResponseFactory(allocator, h2Config.headersFactory(), HttpProtocolVersion.HTTP_2_0);
            }
            if (h1Config == null) {
                throw new IllegalStateException(preferredAlpnProtocol + " is preferred ALPN protocol, falling back to " + HttpProtocolVersion.HTTP_1_1 + " but the " + HttpProtocolVersion.HTTP_1_1 + " protocol was not configured.");
            }
            return new DefaultStreamingHttpRequestResponseFactory(allocator, h1Config.headersFactory(), HttpProtocolVersion.HTTP_1_1);
        }
        H1ProtocolConfig h1Config = roConfig.h1Config();
        assert (h1Config != null);
        return new DefaultStreamingHttpRequestResponseFactory(allocator, h1Config.headersFactory(), HttpProtocolVersion.HTTP_1_1);
    }

    private static StreamingHttpClientFilterFactory appendFilter(@Nullable StreamingHttpClientFilterFactory currClientFilterFactory, StreamingHttpClientFilterFactory appendClientFilterFactory) {
        if (currClientFilterFactory == null) {
            return appendClientFilterFactory;
        }
        return currClientFilterFactory.append(appendClientFilterFactory);
    }

    HttpClientBuildContext<U, R> copyBuildCtx() {
        return this.buildContext0(null);
    }

    HttpClientBuildContext<U, R> copyBuildCtx(U address) {
        assert (this.address == null) : "Not intended to change the address, only to supply lazily";
        return this.buildContext0(address);
    }

    private HttpClientBuildContext<U, R> buildContext0(@Nullable U address) {
        DefaultSingleAddressHttpClientBuilder<U, R> clonedBuilder = address == null ? this.copy() : this.copy(address);
        HttpExecutionContext exec = clonedBuilder.executionContextBuilder.build();
        SdStatusCompletable sdStatus = new SdStatusCompletable();
        RetryingServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> sd = new RetryingServiceDiscoverer<U, R, ServiceDiscovererEvent<R>>(new StatusAwareServiceDiscoverer<U, R, ServiceDiscovererEvent<R>>(this.serviceDiscoverer, sdStatus), this.serviceDiscovererRetryStrategy == null ? DefaultServiceDiscoveryRetryStrategy.Builder.withDefaults(exec.executor(), SD_RETRY_STRATEGY_INIT_DURATION, SD_RETRY_STRATEGY_JITTER).build() : this.serviceDiscovererRetryStrategy);
        return new HttpClientBuildContext<U, R>(clonedBuilder, exec, sd, sdStatus, this.proxyAddress);
    }

    private AbsoluteAddressHttpRequesterFilter proxyAbsoluteAddressFilterFactory() {
        assert (this.address != null) : "address should have been set in constructor";
        return new AbsoluteAddressHttpRequesterFilter("http", this.hostToCharSequenceFunction.apply(this.address));
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> ioExecutor(IoExecutor ioExecutor) {
        this.executionContextBuilder.ioExecutor(ioExecutor);
        return this;
    }

    @Override
    public SingleAddressHttpClientBuilder<U, R> executionStrategy(HttpExecutionStrategy strategy) {
        this.executionContextBuilder.executionStrategy(strategy);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> bufferAllocator(BufferAllocator allocator) {
        this.executionContextBuilder.bufferAllocator(allocator);
        return this;
    }

    @Override
    public <T> DefaultSingleAddressHttpClientBuilder<U, R> socketOption(SocketOption<T> option, T value) {
        this.config.tcpConfig().socketOption(option, value);
        return this;
    }

    @Override
    @Deprecated
    public DefaultSingleAddressHttpClientBuilder<U, R> enableWireLogging(String loggerName) {
        this.config.tcpConfig().enableWireLogging(loggerName);
        return this;
    }

    @Override
    public SingleAddressHttpClientBuilder<U, R> enableWireLogging(String loggerName, LogLevel logLevel, BooleanSupplier logUserData) {
        this.config.tcpConfig().enableWireLogging(loggerName, logLevel, logUserData);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> protocols(HttpProtocolConfig ... protocols) {
        this.config.protocolConfigs().protocols(protocols);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> appendConnectionFilter(StreamingHttpConnectionFilterFactory factory) {
        this.connectionFilterFactory = this.connectionFilterFactory == null ? Objects.requireNonNull(factory) : this.connectionFilterFactory.append(factory);
        this.influencerChainBuilder.add(factory);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> appendConnectionFactoryFilter(ConnectionFactoryFilter<R, FilterableStreamingHttpConnection> factory) {
        this.connectionFactoryFilter = this.connectionFactoryFilter.append(factory);
        this.influencerChainBuilder.add(factory);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> disableHostHeaderFallback() {
        this.addHostHeaderFallbackFilter = false;
        return this;
    }

    @Override
    public SingleAddressHttpClientBuilder<U, R> allowDropResponseTrailers(boolean allowDrop) {
        this.config.protocolConfigs().allowDropTrailersReadFromTransport(allowDrop);
        return this;
    }

    @Override
    public SingleAddressHttpClientBuilder<U, R> autoRetryStrategy(AutoRetryStrategyProvider autoRetryStrategyProvider) {
        this.autoRetry = autoRetryStrategyProvider == AutoRetryStrategyProvider.DISABLE_AUTO_RETRIES ? null : Objects.requireNonNull(autoRetryStrategyProvider);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> unresolvedAddressToHost(Function<U, CharSequence> unresolvedAddressToHostFunction) {
        this.hostToCharSequenceFunction = Objects.requireNonNull(unresolvedAddressToHostFunction);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> appendClientFilter(StreamingHttpClientFilterFactory factory) {
        this.clientFilterFactory = this.clientFilterFactory == null ? Objects.requireNonNull(factory) : this.clientFilterFactory.append(factory);
        this.influencerChainBuilder.add(factory);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> serviceDiscoverer(ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> serviceDiscoverer) {
        this.serviceDiscoverer = Objects.requireNonNull(serviceDiscoverer);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> retryServiceDiscoveryErrors(ServiceDiscoveryRetryStrategy<R, ServiceDiscovererEvent<R>> retryStrategy) {
        this.serviceDiscovererRetryStrategy = Objects.requireNonNull(retryStrategy);
        return this;
    }

    @Override
    public DefaultSingleAddressHttpClientBuilder<U, R> loadBalancerFactory(HttpLoadBalancerFactory<R> loadBalancerFactory) {
        this.loadBalancerFactory = Objects.requireNonNull(loadBalancerFactory);
        this.influencerChainBuilder.add(loadBalancerFactory);
        return this;
    }

    @Override
    public SingleAddressHttpClientSecurityConfigurator<U, R> secure() {
        assert (this.address != null);
        return new DefaultSingleAddressHttpClientSecurityConfigurator(this.unresolvedHostFunction(this.address).toString(), this.unresolvedPortFunction(this.address), securityConfig -> {
            this.config.tcpConfig().secure(securityConfig);
            return this;
        });
    }

    void appendToStrategyInfluencer(MultiAddressHttpClientFilterFactory<U> multiAddressHttpClientFilterFactory) {
        this.influencerChainBuilder.add(multiAddressHttpClientFilterFactory);
    }

    HttpExecutionStrategyInfluencer buildStrategyInfluencerForClient(HttpExecutionStrategy strategy) {
        return this.influencerChainBuilder.buildForClient(strategy);
    }

    private CharSequence toAuthorityForm(U address) {
        if (address instanceof CharSequence) {
            return (CharSequence)address;
        }
        if (address instanceof HostAndPort) {
            HostAndPort hostAndPort = (HostAndPort)address;
            return NetUtil.toSocketAddressString(hostAndPort.hostName(), hostAndPort.port());
        }
        if (address instanceof InetSocketAddress) {
            return NetUtil.toSocketAddressString((InetSocketAddress)address);
        }
        return address.toString();
    }

    private CharSequence unresolvedHostFunction(U address) {
        if (address instanceof HostAndPort) {
            return ((HostAndPort)address).hostName();
        }
        if (address instanceof InetSocketAddress) {
            return ((InetSocketAddress)address).getHostString();
        }
        CharSequence cs = this.hostToCharSequenceFunction.apply(address);
        int colon = CharSequences.indexOf(cs, ':', 0);
        if (colon < 0) {
            return cs;
        }
        return cs.subSequence(0, colon);
    }

    private int unresolvedPortFunction(U address) {
        if (address instanceof HostAndPort) {
            return ((HostAndPort)address).port();
        }
        if (address instanceof InetSocketAddress) {
            return ((InetSocketAddress)address).getPort();
        }
        CharSequence cs = this.hostToCharSequenceFunction.apply(address);
        int colon = CharSequences.indexOf(cs, ':', 0);
        if (colon < 0) {
            return -1;
        }
        return Integer.parseInt(cs.subSequence(colon + 1, cs.length() - 1).toString());
    }

    private static final class AlpnReqRespFactoryFunc
    implements Function<HttpProtocolVersion, StreamingHttpRequestResponseFactory> {
        private final BufferAllocator allocator;
        @Nullable
        private final HttpHeadersFactory h1HeadersFactory;
        @Nullable
        private final HttpHeadersFactory h2HeadersFactory;
        @Nullable
        private StreamingHttpRequestResponseFactory h1Factory;
        @Nullable
        private StreamingHttpRequestResponseFactory h2Factory;

        AlpnReqRespFactoryFunc(BufferAllocator allocator, @Nullable HttpHeadersFactory h1HeadersFactory, @Nullable HttpHeadersFactory h2HeadersFactory) {
            this.allocator = allocator;
            this.h1HeadersFactory = h1HeadersFactory;
            this.h2HeadersFactory = h2HeadersFactory;
        }

        @Override
        public StreamingHttpRequestResponseFactory apply(HttpProtocolVersion version) {
            if (version == HttpProtocolVersion.HTTP_1_1) {
                if (this.h1Factory == null) {
                    this.h1Factory = new DefaultStreamingHttpRequestResponseFactory(this.allocator, AlpnReqRespFactoryFunc.headersFactory(this.h1HeadersFactory, HttpProtocolVersion.HTTP_1_1), HttpProtocolVersion.HTTP_1_1);
                }
                return this.h1Factory;
            }
            if (version == HttpProtocolVersion.HTTP_2_0) {
                if (this.h2Factory == null) {
                    this.h2Factory = new DefaultStreamingHttpRequestResponseFactory(this.allocator, AlpnReqRespFactoryFunc.headersFactory(this.h2HeadersFactory, HttpProtocolVersion.HTTP_2_0), HttpProtocolVersion.HTTP_2_0);
                }
                return this.h2Factory;
            }
            if (version.major() <= 1) {
                return new DefaultStreamingHttpRequestResponseFactory(this.allocator, AlpnReqRespFactoryFunc.headersFactory(this.h1HeadersFactory, version), version);
            }
            if (version.major() == 2) {
                return new DefaultStreamingHttpRequestResponseFactory(this.allocator, AlpnReqRespFactoryFunc.headersFactory(this.h2HeadersFactory, version), version);
            }
            throw new IllegalArgumentException("unsupported protocol: " + version);
        }

        private static HttpHeadersFactory headersFactory(@Nullable HttpHeadersFactory factory, HttpProtocolVersion version) {
            if (factory == null) {
                throw new IllegalStateException("HeadersFactory config not found for selected protocol: " + version);
            }
            return factory;
        }
    }

    private static abstract class DelegatingServiceDiscoverer<U, R, E extends ServiceDiscovererEvent<R>>
    implements ServiceDiscoverer<U, R, E> {
        private final ServiceDiscoverer<U, R, E> delegate;

        DelegatingServiceDiscoverer(ServiceDiscoverer<U, R, E> delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        ServiceDiscoverer<U, R, E> delegate() {
            return this.delegate;
        }

        @Override
        public Completable onClose() {
            return this.delegate.onClose();
        }

        @Override
        public Completable closeAsync() {
            return this.delegate.closeAsync();
        }

        @Override
        public Completable closeAsyncGracefully() {
            return this.delegate.closeAsyncGracefully();
        }
    }

    static final class RetryingServiceDiscoverer<U, R, E extends ServiceDiscovererEvent<R>>
    extends DelegatingServiceDiscoverer<U, R, E> {
        private final ServiceDiscoveryRetryStrategy<R, E> retryStrategy;

        RetryingServiceDiscoverer(ServiceDiscoverer<U, R, E> delegate, ServiceDiscoveryRetryStrategy<R, E> retryStrategy) {
            super(delegate);
            this.retryStrategy = Objects.requireNonNull(retryStrategy);
        }

        @Override
        public Publisher<Collection<E>> discover(U u) {
            return this.retryStrategy.apply(this.delegate().discover(u));
        }
    }

    private static final class StatusAwareServiceDiscoverer<U, R, E extends ServiceDiscovererEvent<R>>
    extends DelegatingServiceDiscoverer<U, R, E> {
        private final SdStatusCompletable status;

        StatusAwareServiceDiscoverer(ServiceDiscoverer<U, R, E> delegate, SdStatusCompletable status) {
            super(delegate);
            this.status = status;
        }

        @Override
        public Publisher<Collection<E>> discover(U u) {
            return this.delegate().discover(u).beforeOnError(this.status::nextError).beforeOnNext(__ -> this.status.resetError());
        }
    }

    private static final class SdStatusCompletable
    extends Completable {
        private volatile CompletableSource.Processor processor = Processors.newCompletableProcessor();
        private boolean seenError;

        private SdStatusCompletable() {
        }

        @Override
        protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
            this.processor.subscribe(subscriber);
        }

        void nextError(Throwable t) {
            this.seenError = true;
            CompletableSource.Processor oldProcessor = this.processor;
            oldProcessor.onError(t);
            CompletableSource.Processor newProcessor = Processors.newCompletableProcessor();
            newProcessor.onError(t);
            this.processor = newProcessor;
        }

        void resetError() {
            if (this.seenError) {
                this.processor = Processors.newCompletableProcessor();
                this.seenError = false;
            }
        }
    }

    private static final class NoopServiceDiscoverer<OriginalAddress, ResolvedAddress>
    implements ServiceDiscoverer<OriginalAddress, ResolvedAddress, ServiceDiscovererEvent<ResolvedAddress>> {
        private final ListenableAsyncCloseable closeable = AsyncCloseables.emptyAsyncCloseable();
        private final Publisher<Collection<ServiceDiscovererEvent<ResolvedAddress>>> resolution;
        private final OriginalAddress originalAddress;

        private NoopServiceDiscoverer(OriginalAddress originalAddress, ResolvedAddress address) {
            this.originalAddress = Objects.requireNonNull(originalAddress);
            this.resolution = Publisher.from(Collections.singletonList(new DefaultServiceDiscovererEvent<ResolvedAddress>(Objects.requireNonNull(address), true))).concat(Publisher.never());
        }

        @Override
        public Publisher<Collection<ServiceDiscovererEvent<ResolvedAddress>>> discover(OriginalAddress address) {
            if (!this.originalAddress.equals(address)) {
                return Publisher.failed(new IllegalArgumentException("Unexpected address resolution request: " + address));
            }
            return this.resolution;
        }

        @Override
        public Completable onClose() {
            return this.closeable.onClose();
        }

        @Override
        public Completable closeAsync() {
            return this.closeable.closeAsync();
        }

        @Override
        public Completable closeAsyncGracefully() {
            return this.closeable.closeAsyncGracefully();
        }
    }

    static final class HttpClientBuildContext<U, R> {
        final DefaultSingleAddressHttpClientBuilder<U, R> builder;
        final HttpExecutionContext executionContext;
        private final ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> serviceDiscoverer;
        private final SdStatusCompletable sdStatus;
        @Nullable
        private final U proxyAddress;

        HttpClientBuildContext(DefaultSingleAddressHttpClientBuilder<U, R> builder, HttpExecutionContext executionContext, ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> sd, SdStatusCompletable sdStatus, @Nullable U proxyAddress) {
            this.builder = builder;
            this.executionContext = executionContext;
            this.serviceDiscoverer = sd;
            this.sdStatus = sdStatus;
            this.proxyAddress = proxyAddress;
        }

        U address() {
            assert (((DefaultSingleAddressHttpClientBuilder)this.builder).address != null) : "Attempted to buildStreaming with an unknown address";
            return (U)(this.proxyAddress != null ? this.proxyAddress : ((DefaultSingleAddressHttpClientBuilder)this.builder).address);
        }

        HttpClientConfig httpConfig() {
            return ((DefaultSingleAddressHttpClientBuilder)this.builder).config;
        }

        StreamingHttpClient build() {
            return DefaultSingleAddressHttpClientBuilder.buildStreaming(this);
        }
    }
}

